/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={IOTests.class, MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestForceCacheImportantBlocks {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestForceCacheImportantBlocks.class);
    private final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private static final String TABLE = "myTable";
    private static final String CF = "myCF";
    private static final byte[] CF_BYTES = Bytes.toBytes((String)"myCF");
    private static final int MAX_VERSIONS = 3;
    private static final int NUM_HFILES = 5;
    private static final int ROWS_PER_HFILE = 100;
    private static final int NUM_ROWS = 500;
    private static final int NUM_COLS_PER_ROW = 50;
    private static final int NUM_TIMESTAMPS_PER_COL = 50;
    private static final int BLOCK_SIZE = 256;
    private static final Compression.Algorithm COMPRESSION_ALGORITHM = Compression.Algorithm.GZ;
    private static final BloomType BLOOM_TYPE = BloomType.ROW;
    private final int hfileVersion;
    private final boolean cfCacheEnabled;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({3, true}, {3, false});
    }

    public TestForceCacheImportantBlocks(int hfileVersion, boolean cfCacheEnabled) {
        this.hfileVersion = hfileVersion;
        this.cfCacheEnabled = cfCacheEnabled;
        this.TEST_UTIL.getConfiguration().setInt("hfile.format.version", hfileVersion);
    }

    @Before
    public void setup() {
        CacheConfig.clearGlobalInstances();
        HFile.DATABLOCK_READ_COUNT.reset();
        CacheConfig.instantiateBlockCache((Configuration)this.TEST_UTIL.getConfiguration());
    }

    @Test
    public void testCacheBlocks() throws IOException {
        this.TEST_UTIL.getConfiguration().setInt("hfile.index.block.max.size", 256);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toBytes((String)CF)).setMaxVersions(3).setCompressionType(COMPRESSION_ALGORITHM).setBloomFilterType(BLOOM_TYPE);
        hcd.setBlocksize(256);
        hcd.setBlockCacheEnabled(this.cfCacheEnabled);
        HRegion region = this.TEST_UTIL.createTestRegion(TABLE, (ColumnFamilyDescriptor)hcd);
        BlockCache cache = region.getStore(hcd.getName()).getCacheConfig().getBlockCache();
        CacheStats stats = cache.getStats();
        this.writeTestData(region);
        Assert.assertEquals((long)0L, (long)stats.getHitCount());
        Assert.assertEquals((long)0L, (long)HFile.DATABLOCK_READ_COUNT.sum());
        region.get(new Get(Bytes.toBytes((String)"row0")));
        Assert.assertTrue((stats.getHitCount() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((HFile.DATABLOCK_READ_COUNT.sum() > 0L ? 1 : 0) != 0);
        long missCount = stats.getMissCount();
        region.get(new Get(Bytes.toBytes((String)"row0")));
        if (this.cfCacheEnabled) {
            Assert.assertEquals((long)missCount, (long)stats.getMissCount());
        } else {
            Assert.assertTrue((stats.getMissCount() > missCount ? 1 : 0) != 0);
        }
    }

    private void writeTestData(HRegion region) throws IOException {
        for (int i = 0; i < 500; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + i)));
            for (int j = 0; j < 50; ++j) {
                for (long ts = 1L; ts < 50L; ++ts) {
                    put.addColumn(CF_BYTES, Bytes.toBytes((String)("col" + j)), ts, Bytes.toBytes((String)("value" + i + "_" + j + "_" + ts)));
                }
            }
            region.put(put);
            if ((i + 1) % 100 != 0) continue;
            region.flush(true);
        }
    }
}

