/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.favored;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.favored.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Triple;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={MasterTests.class, SmallTests.class})
public class TestFavoredNodeAssignmentHelper {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFavoredNodeAssignmentHelper.class);
    private static List<ServerName> servers = new ArrayList<ServerName>();
    private static Map<String, List<ServerName>> rackToServers = new HashMap<String, List<ServerName>>();
    private static RackManager rackManager = (RackManager)Mockito.mock(RackManager.class);
    private static final int MAX_ATTEMPTS = 100;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        for (int i = 0; i < 40; ++i) {
            ArrayList servers;
            ServerName server = ServerName.valueOf((String)("foo" + i + ":1234"), (long)-1L);
            if (i < 10) {
                Mockito.when((Object)rackManager.getRack(server)).thenReturn((Object)"rack1");
                if (rackToServers.get("rack1") == null) {
                    servers = new ArrayList();
                    rackToServers.put("rack1", servers);
                }
                rackToServers.get("rack1").add(server);
            }
            if (i >= 10 && i < 20) {
                Mockito.when((Object)rackManager.getRack(server)).thenReturn((Object)"rack2");
                if (rackToServers.get("rack2") == null) {
                    servers = new ArrayList();
                    rackToServers.put("rack2", servers);
                }
                rackToServers.get("rack2").add(server);
            }
            if (i >= 20 && i < 30) {
                Mockito.when((Object)rackManager.getRack(server)).thenReturn((Object)"rack3");
                if (rackToServers.get("rack3") == null) {
                    servers = new ArrayList();
                    rackToServers.put("rack3", servers);
                }
                rackToServers.get("rack3").add(server);
            }
            TestFavoredNodeAssignmentHelper.servers.add(server);
        }
    }

    private static List<ServerName> getServersFromRack(Map<String, Integer> rackToServerCount) {
        ArrayList<ServerName> chosenServers = new ArrayList<ServerName>();
        for (Map.Entry<String, Integer> entry : rackToServerCount.entrySet()) {
            List<ServerName> servers = rackToServers.get(entry.getKey());
            for (int i = 0; i < entry.getValue(); ++i) {
                chosenServers.add(servers.get(i));
            }
        }
        return chosenServers;
    }

    @Test
    public void testSmallCluster() {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", 2);
        List<ServerName> servers = TestFavoredNodeAssignmentHelper.getServersFromRack(rackToServerCount);
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, new Configuration());
        helper.initialize();
        Assert.assertFalse((boolean)helper.canPlaceFavoredNodes());
    }

    @Test
    public void testPlacePrimaryRSAsRoundRobin() {
        this.primaryRSPlacement(6, null, 10, 10, 10);
        this.primaryRSPlacement(600, null, 10, 10, 10);
    }

    @Test
    public void testRoundRobinAssignmentsWithUnevenSizedRacks() {
        this.primaryRSPlacement(6, null, 10, 10, 10);
        this.primaryRSPlacement(600, null, 10, 10, 5);
        this.primaryRSPlacement(600, null, 10, 5, 10);
        this.primaryRSPlacement(600, null, 5, 10, 10);
        this.primaryRSPlacement(500, null, 10, 10, 5);
        this.primaryRSPlacement(500, null, 10, 5, 10);
        this.primaryRSPlacement(500, null, 5, 10, 10);
        this.primaryRSPlacement(500, null, 9, 7, 8);
        this.primaryRSPlacement(500, null, 8, 7, 9);
        this.primaryRSPlacement(500, null, 7, 9, 8);
        this.primaryRSPlacement(459, null, 7, 9, 8);
    }

    @Test
    public void testSecondaryAndTertiaryPlacementWithSingleRack() {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", 10);
        Triple<Map<RegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<RegionInfo>> primaryRSMapAndHelper = this.secondaryAndTertiaryRSPlacementHelper(60000, rackToServerCount);
        FavoredNodeAssignmentHelper helper = (FavoredNodeAssignmentHelper)primaryRSMapAndHelper.getSecond();
        Map primaryRSMap = (Map)primaryRSMapAndHelper.getFirst();
        List regions = (List)primaryRSMapAndHelper.getThird();
        Map secondaryAndTertiaryMap = helper.placeSecondaryAndTertiaryRS(primaryRSMap);
        for (RegionInfo region : regions) {
            ServerName[] secondaryAndTertiaryServers = (ServerName[])secondaryAndTertiaryMap.get(region);
            Assert.assertNotNull((Object)secondaryAndTertiaryServers);
            Assert.assertTrue((boolean)primaryRSMap.containsKey(region));
            Assert.assertTrue((!secondaryAndTertiaryServers[0].equals(primaryRSMap.get(region)) ? 1 : 0) != 0);
            Assert.assertTrue((!secondaryAndTertiaryServers[1].equals(primaryRSMap.get(region)) ? 1 : 0) != 0);
            Assert.assertTrue((!secondaryAndTertiaryServers[0].equals((Object)secondaryAndTertiaryServers[1]) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSecondaryAndTertiaryPlacementWithSingleServer() {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", 1);
        Triple<Map<RegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<RegionInfo>> primaryRSMapAndHelper = this.secondaryAndTertiaryRSPlacementHelper(1, rackToServerCount);
        FavoredNodeAssignmentHelper helper = (FavoredNodeAssignmentHelper)primaryRSMapAndHelper.getSecond();
        Map primaryRSMap = (Map)primaryRSMapAndHelper.getFirst();
        List regions = (List)primaryRSMapAndHelper.getThird();
        Map secondaryAndTertiaryMap = helper.placeSecondaryAndTertiaryRS(primaryRSMap);
        Assert.assertTrue((secondaryAndTertiaryMap.get(regions.get(0)) == null ? 1 : 0) != 0);
    }

    @Test
    public void testSecondaryAndTertiaryPlacementWithMultipleRacks() {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", 10);
        rackToServerCount.put("rack2", 10);
        Triple<Map<RegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<RegionInfo>> primaryRSMapAndHelper = this.secondaryAndTertiaryRSPlacementHelper(60000, rackToServerCount);
        FavoredNodeAssignmentHelper helper = (FavoredNodeAssignmentHelper)primaryRSMapAndHelper.getSecond();
        Map primaryRSMap = (Map)primaryRSMapAndHelper.getFirst();
        Assert.assertTrue((primaryRSMap.size() == 60000 ? 1 : 0) != 0);
        Map secondaryAndTertiaryMap = helper.placeSecondaryAndTertiaryRS(primaryRSMap);
        Assert.assertTrue((secondaryAndTertiaryMap.size() == 60000 ? 1 : 0) != 0);
        for (Map.Entry entry : secondaryAndTertiaryMap.entrySet()) {
            ServerName[] allServersForRegion = (ServerName[])entry.getValue();
            String primaryRSRack = rackManager.getRack((ServerName)primaryRSMap.get(entry.getKey()));
            String secondaryRSRack = rackManager.getRack(allServersForRegion[0]);
            String tertiaryRSRack = rackManager.getRack(allServersForRegion[1]);
            HashSet racks = Sets.newHashSet((Object[])new String[]{primaryRSRack});
            racks.add(secondaryRSRack);
            racks.add(tertiaryRSRack);
            Assert.assertTrue((racks.size() >= 2 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSecondaryAndTertiaryPlacementWithLessThanTwoServersInRacks() {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", 1);
        rackToServerCount.put("rack2", 1);
        Triple<Map<RegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<RegionInfo>> primaryRSMapAndHelper = this.secondaryAndTertiaryRSPlacementHelper(6, rackToServerCount);
        FavoredNodeAssignmentHelper helper = (FavoredNodeAssignmentHelper)primaryRSMapAndHelper.getSecond();
        Map primaryRSMap = (Map)primaryRSMapAndHelper.getFirst();
        List regions = (List)primaryRSMapAndHelper.getThird();
        Assert.assertTrue((primaryRSMap.size() == 6 ? 1 : 0) != 0);
        Map secondaryAndTertiaryMap = helper.placeSecondaryAndTertiaryRS(primaryRSMap);
        for (RegionInfo region : regions) {
            Assert.assertTrue((secondaryAndTertiaryMap.get(region) == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSecondaryAndTertiaryPlacementWithMoreThanOneServerInPrimaryRack() {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", 2);
        rackToServerCount.put("rack2", 1);
        Triple<Map<RegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<RegionInfo>> primaryRSMapAndHelper = this.secondaryAndTertiaryRSPlacementHelper(6, rackToServerCount);
        FavoredNodeAssignmentHelper helper = (FavoredNodeAssignmentHelper)primaryRSMapAndHelper.getSecond();
        Map primaryRSMap = (Map)primaryRSMapAndHelper.getFirst();
        List regions = (List)primaryRSMapAndHelper.getThird();
        Assert.assertTrue((primaryRSMap.size() == 6 ? 1 : 0) != 0);
        Map secondaryAndTertiaryMap = helper.placeSecondaryAndTertiaryRS(primaryRSMap);
        Assert.assertTrue((secondaryAndTertiaryMap.size() == regions.size() ? 1 : 0) != 0);
        for (RegionInfo region : regions) {
            ServerName s = (ServerName)primaryRSMap.get(region);
            ServerName secondaryRS = ((ServerName[])secondaryAndTertiaryMap.get(region))[0];
            ServerName tertiaryRS = ((ServerName[])secondaryAndTertiaryMap.get(region))[1];
            HashSet racks = Sets.newHashSet((Object[])new String[]{rackManager.getRack(s)});
            racks.add(rackManager.getRack(secondaryRS));
            racks.add(rackManager.getRack(tertiaryRS));
            Assert.assertTrue((racks.size() >= 2 ? 1 : 0) != 0);
        }
    }

    private Triple<Map<RegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<RegionInfo>> secondaryAndTertiaryRSPlacementHelper(int regionCount, Map<String, Integer> rackToServerCount) {
        HashMap primaryRSMap = new HashMap();
        List<ServerName> servers = TestFavoredNodeAssignmentHelper.getServersFromRack(rackToServerCount);
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, rackManager);
        HashMap assignmentMap = new HashMap();
        helper.initialize();
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(regionCount);
        for (int i = 0; i < regionCount; ++i) {
            regions.add(RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(Bytes.toBytes((int)i)).setEndKey(Bytes.toBytes((int)(i + 1))).build());
        }
        helper.placePrimaryRSAsRoundRobin(assignmentMap, primaryRSMap, regions);
        return new Triple(primaryRSMap, (Object)helper, regions);
    }

    private void primaryRSPlacement(int regionCount, Map<RegionInfo, ServerName> primaryRSMap, int firstRackSize, int secondRackSize, int thirdRackSize) {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", firstRackSize);
        rackToServerCount.put("rack2", secondRackSize);
        rackToServerCount.put("rack3", thirdRackSize);
        List<ServerName> servers = TestFavoredNodeAssignmentHelper.getServersFromRack(rackToServerCount);
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, rackManager);
        helper.initialize();
        Assert.assertTrue((boolean)helper.canPlaceFavoredNodes());
        HashMap<ServerName, List<RegionInfo>> assignmentMap = new HashMap<ServerName, List<RegionInfo>>();
        if (primaryRSMap == null) {
            primaryRSMap = new HashMap<RegionInfo, ServerName>();
        }
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(regionCount);
        for (int i = 0; i < regionCount; ++i) {
            regions.add(RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"foobar")).setStartKey(Bytes.toBytes((int)i)).setEndKey(Bytes.toBytes((int)(i + 1))).build());
        }
        helper.placePrimaryRSAsRoundRobin(assignmentMap, primaryRSMap, regions);
        int regionsOnRack1 = 0;
        int regionsOnRack2 = 0;
        int regionsOnRack3 = 0;
        for (RegionInfo region : regions) {
            if (rackManager.getRack(primaryRSMap.get(region)).equals("rack1")) {
                ++regionsOnRack1;
                continue;
            }
            if (rackManager.getRack(primaryRSMap.get(region)).equals("rack2")) {
                ++regionsOnRack2;
                continue;
            }
            if (!rackManager.getRack(primaryRSMap.get(region)).equals("rack3")) continue;
            ++regionsOnRack3;
        }
        this.checkNumRegions(regionCount, firstRackSize, secondRackSize, thirdRackSize, regionsOnRack1, regionsOnRack2, regionsOnRack3, assignmentMap);
    }

    private void checkNumRegions(int regionCount, int firstRackSize, int secondRackSize, int thirdRackSize, int regionsOnRack1, int regionsOnRack2, int regionsOnRack3, Map<ServerName, List<RegionInfo>> assignmentMap) {
        TreeMap<Integer, Integer> rackMap = new TreeMap<Integer, Integer>();
        rackMap.put(firstRackSize, 1);
        rackMap.put(secondRackSize, 2);
        rackMap.put(thirdRackSize, 3);
        TreeMap<Integer, Integer> regionMap = new TreeMap<Integer, Integer>();
        regionMap.put(regionsOnRack1, 1);
        regionMap.put(regionsOnRack2, 2);
        regionMap.put(regionsOnRack3, 3);
        Assert.assertTrue((String)this.printProportions(firstRackSize, secondRackSize, thirdRackSize, regionsOnRack1, regionsOnRack2, regionsOnRack3), (rackMap.get(firstRackSize) == regionMap.get(regionsOnRack1) ? 1 : 0) != 0);
        Assert.assertTrue((String)this.printProportions(firstRackSize, secondRackSize, thirdRackSize, regionsOnRack1, regionsOnRack2, regionsOnRack3), (rackMap.get(secondRackSize) == regionMap.get(regionsOnRack2) ? 1 : 0) != 0);
        Assert.assertTrue((String)this.printProportions(firstRackSize, secondRackSize, thirdRackSize, regionsOnRack1, regionsOnRack2, regionsOnRack3), (rackMap.get(thirdRackSize) == regionMap.get(regionsOnRack3) ? 1 : 0) != 0);
    }

    private String printProportions(int firstRackSize, int secondRackSize, int thirdRackSize, int regionsOnRack1, int regionsOnRack2, int regionsOnRack3) {
        return "The rack sizes " + firstRackSize + " " + secondRackSize + " " + thirdRackSize + " " + regionsOnRack1 + " " + regionsOnRack2 + " " + regionsOnRack3;
    }

    @Test
    public void testConstrainedPlacement() throws Exception {
        ArrayList servers = Lists.newArrayList();
        servers.add(ServerName.valueOf((String)"foo1:1234", (long)-1L));
        servers.add(ServerName.valueOf((String)"foo2:1234", (long)-1L));
        servers.add(ServerName.valueOf((String)"foo15:1234", (long)-1L));
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper((List)servers, rackManager);
        helper.initialize();
        Assert.assertTrue((boolean)helper.canPlaceFavoredNodes());
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(20);
        for (int i = 0; i < 20; ++i) {
            regions.add(RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(Bytes.toBytes((int)i)).setEndKey(Bytes.toBytes((int)(i + 1))).build());
        }
        HashMap assignmentMap = new HashMap();
        HashMap primaryRSMap = new HashMap();
        helper.placePrimaryRSAsRoundRobin(assignmentMap, primaryRSMap, regions);
        Assert.assertTrue((primaryRSMap.size() == regions.size() ? 1 : 0) != 0);
        Map secondaryAndTertiary = helper.placeSecondaryAndTertiaryRS(primaryRSMap);
        Assert.assertEquals((long)regions.size(), (long)secondaryAndTertiary.size());
    }

    @Test
    public void testGetOneRandomRack() throws IOException {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        HashSet rackList = Sets.newHashSet((Object[])new String[]{"rack1", "rack2", "rack3"});
        for (String rack : rackList) {
            rackToServerCount.put(rack, 2);
        }
        List<ServerName> servers = TestFavoredNodeAssignmentHelper.getServersFromRack(rackToServerCount);
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, rackManager);
        helper.initialize();
        Assert.assertTrue((boolean)helper.canPlaceFavoredNodes());
        for (int attempts = 0; attempts < 100; ++attempts) {
            Assert.assertTrue((boolean)rackList.contains(helper.getOneRandomRack((Set)Sets.newHashSet())));
        }
        HashSet skipRacks = Sets.newHashSet((Object[])new String[]{"rack"});
        for (int attempts = 0; attempts < 100; ++attempts) {
            Assert.assertTrue((boolean)rackList.contains(helper.getOneRandomRack((Set)skipRacks)));
        }
        skipRacks = Sets.newHashSet((Object[])new String[]{"rack1"});
        HashSet validRacks = Sets.newHashSet((Object[])new String[]{"rack2", "rack3"});
        for (int attempts = 0; attempts < 100; ++attempts) {
            Assert.assertTrue((boolean)validRacks.contains(helper.getOneRandomRack((Set)skipRacks)));
        }
    }

    @Test
    public void testGetRandomServerSingleRack() throws IOException {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        String rack = "rack1";
        rackToServerCount.put("rack1", 4);
        List<ServerName> servers = TestFavoredNodeAssignmentHelper.getServersFromRack(rackToServerCount);
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, rackManager);
        helper.initialize();
        Assert.assertTrue((boolean)helper.canPlaceFavoredNodes());
        for (int attempts = 0; attempts < 100; ++attempts) {
            ServerName sn = helper.getOneRandomServer("rack1", (Set)Sets.newHashSet());
            Assert.assertTrue((String)("Server:" + sn + " does not belong to list: " + servers), (boolean)servers.contains(sn));
        }
        HashSet skipServers = Sets.newHashSet((Object[])new ServerName[]{ServerName.valueOf((String)"invalidnode:1234", (long)-1L)});
        for (int attempts = 0; attempts < 100; ++attempts) {
            ServerName sn = helper.getOneRandomServer("rack1", (Set)skipServers);
            Assert.assertTrue((String)("Server:" + sn + " does not belong to list: " + servers), (boolean)servers.contains(sn));
        }
        ServerName skipSN = ServerName.valueOf((String)"foo1:1234", (long)-1L);
        skipServers = Sets.newHashSet((Object[])new ServerName[]{skipSN});
        for (int attempts = 0; attempts < 100; ++attempts) {
            ServerName sn = helper.getOneRandomServer("rack1", (Set)skipServers);
            Assert.assertNotEquals((String)"Skip server should not be selected ", (Object)skipSN.getHostAndPort(), (Object)sn.getHostAndPort());
            Assert.assertTrue((String)("Server:" + sn + " does not belong to list: " + servers), (boolean)servers.contains(sn));
        }
    }

    @Test
    public void testGetRandomServerMultiRack() throws IOException {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        HashSet rackList = Sets.newHashSet((Object[])new String[]{"rack1", "rack2", "rack3"});
        for (String rack : rackList) {
            rackToServerCount.put(rack, 4);
        }
        List<ServerName> servers = TestFavoredNodeAssignmentHelper.getServersFromRack(rackToServerCount);
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, rackManager);
        helper.initialize();
        Assert.assertTrue((boolean)helper.canPlaceFavoredNodes());
        for (int attempts = 0; attempts < 100; ++attempts) {
            for (Object rack : rackList) {
                ServerName sn = helper.getOneRandomServer((String)rack, (Set)Sets.newHashSet());
                Assert.assertTrue((String)("Server:" + sn + " does not belong to rack servers: " + rackToServers.get(rack)), (boolean)rackToServers.get(rack).contains(sn));
            }
        }
        HashSet skipServers = Sets.newHashSet((Object[])new ServerName[]{ServerName.valueOf((String)"invalidnode:1234", (long)-1L)});
        for (int attempts = 0; attempts < 100; ++attempts) {
            for (String rack : rackList) {
                ServerName sn = helper.getOneRandomServer(rack, (Set)skipServers);
                Assert.assertTrue((String)("Server:" + sn + " does not belong to rack servers: " + rackToServers.get(rack)), (boolean)rackToServers.get(rack).contains(sn));
            }
        }
        ServerName skipSN1 = ServerName.valueOf((String)"foo1:1234", (long)-1L);
        ServerName skipSN2 = ServerName.valueOf((String)"foo10:1234", (long)-1L);
        ServerName skipSN3 = ServerName.valueOf((String)"foo20:1234", (long)-1L);
        skipServers = Sets.newHashSet((Object[])new ServerName[]{skipSN1, skipSN2, skipSN3});
        for (int attempts = 0; attempts < 100; ++attempts) {
            for (String rack : rackList) {
                ServerName sn = helper.getOneRandomServer(rack, (Set)skipServers);
                Assert.assertFalse((String)"Skip server should not be selected ", (boolean)skipServers.contains(sn));
                Assert.assertTrue((String)("Server:" + sn + " does not belong to rack servers: " + rackToServers.get(rack)), (boolean)rackToServers.get(rack).contains(sn));
            }
        }
    }

    @Test
    public void testGetFavoredNodes() throws IOException {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        HashSet rackList = Sets.newHashSet((Object[])new String[]{"rack1", "rack2", "rack3"});
        for (String rack : rackList) {
            rackToServerCount.put(rack, 4);
        }
        List<ServerName> servers = TestFavoredNodeAssignmentHelper.getServersFromRack(rackToServerCount);
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, rackManager);
        helper.initialize();
        Assert.assertTrue((boolean)helper.canPlaceFavoredNodes());
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).build();
        for (int maxattempts = 0; maxattempts < 100; ++maxattempts) {
            List fn = helper.generateFavoredNodes(region);
            this.checkDuplicateFN(fn);
            this.checkFNRacks(fn);
        }
    }

    @Test
    public void testGenMissingFavoredNodeOneRack() throws IOException {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        String rack = "rack1";
        rackToServerCount.put("rack1", 6);
        List<ServerName> servers = TestFavoredNodeAssignmentHelper.getServersFromRack(rackToServerCount);
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, rackManager);
        helper.initialize();
        Assert.assertTrue((boolean)helper.canPlaceFavoredNodes());
        ServerName snRack1SN1 = ServerName.valueOf((String)"foo1:1234", (long)-1L);
        ServerName snRack1SN2 = ServerName.valueOf((String)"foo2:1234", (long)-1L);
        ServerName snRack1SN3 = ServerName.valueOf((String)"foo3:1234", (long)-1L);
        ArrayList fn = Lists.newArrayList((Object[])new ServerName[]{snRack1SN1, snRack1SN2});
        for (int attempts = 0; attempts < 100; ++attempts) {
            this.checkDuplicateFN(fn, helper.generateMissingFavoredNode((List)fn));
        }
        fn = Lists.newArrayList((Object[])new ServerName[]{snRack1SN1, snRack1SN2});
        ArrayList skipServers = Lists.newArrayList((Object[])new ServerName[]{snRack1SN3});
        for (int attempts = 0; attempts < 100; ++attempts) {
            ServerName genSN = helper.generateMissingFavoredNode((List)fn, (List)skipServers);
            this.checkDuplicateFN(fn, genSN);
            Assert.assertNotEquals((String)"Generated FN should not match excluded one", (Object)snRack1SN3, (Object)genSN);
        }
    }

    @Test
    public void testGenMissingFavoredNodeMultiRack() throws IOException {
        ServerName genSN;
        int attempts;
        ServerName snRack1SN1 = ServerName.valueOf((String)"foo1:1234", (long)-1L);
        ServerName snRack1SN2 = ServerName.valueOf((String)"foo2:1234", (long)-1L);
        ServerName snRack2SN1 = ServerName.valueOf((String)"foo10:1234", (long)-1L);
        ServerName snRack2SN2 = ServerName.valueOf((String)"foo11:1234", (long)-1L);
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        HashSet rackList = Sets.newHashSet((Object[])new String[]{"rack1", "rack2"});
        for (String rack : rackList) {
            rackToServerCount.put(rack, 4);
        }
        List<ServerName> servers = TestFavoredNodeAssignmentHelper.getServersFromRack(rackToServerCount);
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, rackManager);
        helper.initialize();
        Assert.assertTrue((boolean)helper.canPlaceFavoredNodes());
        ArrayList fn = Lists.newArrayList((Object[])new ServerName[]{snRack1SN1, snRack1SN2});
        for (attempts = 0; attempts < 100; ++attempts) {
            genSN = helper.generateMissingFavoredNode((List)fn);
            this.checkDuplicateFN(fn, genSN);
            this.checkFNRacks(fn, genSN);
        }
        fn = Lists.newArrayList((Object[])new ServerName[]{snRack1SN1, snRack2SN1});
        for (attempts = 0; attempts < 100; ++attempts) {
            genSN = helper.generateMissingFavoredNode((List)fn);
            this.checkDuplicateFN(fn, genSN);
            this.checkFNRacks(fn, genSN);
        }
        fn = Lists.newArrayList((Object[])new ServerName[]{snRack1SN1, snRack2SN1});
        ArrayList skipServers = Lists.newArrayList((Object[])new ServerName[]{snRack2SN2});
        for (int attempts2 = 0; attempts2 < 100; ++attempts2) {
            ServerName genSN2 = helper.generateMissingFavoredNode((List)fn, (List)skipServers);
            this.checkDuplicateFN(fn, genSN2);
            this.checkFNRacks(fn, genSN2);
            Assert.assertNotEquals((String)"Generated FN should not match excluded one", (Object)snRack2SN2, (Object)genSN2);
        }
    }

    private void checkDuplicateFN(List<ServerName> fnList, ServerName genFN) {
        HashSet favoredNodes = Sets.newHashSet(fnList);
        Assert.assertNotNull((String)"Generated FN can't be null", (Object)genFN);
        favoredNodes.add(genFN);
        Assert.assertEquals((String)"Did not find expected number of favored nodes", (long)3L, (long)favoredNodes.size());
    }

    private void checkDuplicateFN(List<ServerName> fnList) {
        HashSet favoredNodes = Sets.newHashSet(fnList);
        Assert.assertEquals((String)"Did not find expected number of favored nodes", (long)3L, (long)favoredNodes.size());
    }

    private void checkFNRacks(List<ServerName> fnList, ServerName genFN) {
        HashSet favoredNodes = Sets.newHashSet(fnList);
        favoredNodes.add(genFN);
        HashSet racks = Sets.newHashSet();
        for (ServerName sn : favoredNodes) {
            racks.add(rackManager.getRack(sn));
        }
        Assert.assertTrue((String)"FN should be spread atleast across 2 racks", (racks.size() >= 2 ? 1 : 0) != 0);
    }

    private void checkFNRacks(List<ServerName> fnList) {
        HashSet favoredNodes = Sets.newHashSet(fnList);
        HashSet racks = Sets.newHashSet();
        for (ServerName sn : favoredNodes) {
            racks.add(rackManager.getRack(sn));
        }
        Assert.assertTrue((String)"FN should be spread atleast across 2 racks", (racks.size() >= 2 ? 1 : 0) != 0);
    }
}

