/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.JMXListener;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MetaTableMetrics;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestMetaTableMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaTableMetrics.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaTableMetrics.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName NAME1 = TableName.valueOf((String)"TestExampleMetaTableMetricsOne");
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final ColumnFamilyDescriptor CFD = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).build();
    private static final int NUM_ROWS = 5;
    private static final String value = "foo";
    private static Configuration conf = null;
    private static int connectorPort = 61120;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = UTIL.getConfiguration();
        UTIL.getConfiguration().set("hbase.coprocessor.region.classes", MetaTableMetrics.class.getName());
        conf.set("hbase.coprocessor.regionserver.classes", JMXListener.class.getName());
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            int sign;
            while (!HBaseTestingUtility.available(connectorPort += (sign = i % 2 == 0 ? 1 : -1) * rand.nextInt(100))) {
            }
            try {
                conf.setInt("regionserver.rmi.registry.port", connectorPort);
                UTIL.startMiniCluster(1);
                break;
            }
            catch (Exception e) {
                LOG.debug("Encountered exception when starting cluster. Trying port " + connectorPort, (Throwable)e);
                try {
                    UTIL.shutdownMiniCluster();
                }
                catch (Exception ex) {
                    LOG.debug("Encountered exception shutting down cluster", (Throwable)ex);
                }
                continue;
            }
        }
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)NAME1).setColumnFamily(CFD).build());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private void writeData(Table t) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>(5);
        for (int i = 0; i < 5; ++i) {
            Put p = new Put(Bytes.toBytes((int)(i + 1)));
            p.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((String)value));
            puts.add(p);
        }
        t.put(puts);
    }

    private Set<String> readJmxMetricsWithRetry() throws IOException {
        boolean count = false;
        for (int i = 0; i < 10; ++i) {
            Set<String> metrics = this.readJmxMetrics();
            if (metrics != null) {
                return metrics;
            }
            LOG.warn("Failed to get jmxmetrics... sleeping, retrying; " + i + " of " + 0 + " times");
            Threads.sleep((long)1000L);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> readJmxMetrics() throws IOException {
        JMXConnector connector = null;
        ObjectName target = null;
        MBeanServerConnection mb = null;
        try {
            connector = JMXConnectorFactory.connect(JMXListener.buildJMXServiceURL((int)connectorPort, (int)connectorPort));
            mb = connector.getMBeanServerConnection();
            Hashtable<String, String> pairs = new Hashtable<String, String>();
            pairs.put("service", "HBase");
            pairs.put("name", "RegionServer");
            pairs.put("sub", "Coprocessor.Region.CP_org.apache.hadoop.hbase.coprocessor.MetaTableMetrics");
            target = new ObjectName("Hadoop", pairs);
            MBeanInfo beanInfo = mb.getMBeanInfo(target);
            HashSet<String> existingAttrs = new HashSet<String>();
            for (MBeanAttributeInfo attrInfo : beanInfo.getAttributes()) {
                existingAttrs.add(attrInfo.getName());
            }
            HashSet<String> hashSet = existingAttrs;
            return hashSet;
        }
        catch (Exception e) {
            LOG.warn("Failed to get bean." + target, (Throwable)e);
            if (mb != null) {
                Set<ObjectInstance> instances = mb.queryMBeans(null, null);
                Iterator<ObjectInstance> iterator = instances.iterator();
                LOG.warn("MBean Found:");
                while (iterator.hasNext()) {
                    ObjectInstance objectInstance = iterator.next();
                    LOG.warn("Class Name: " + objectInstance.getClassName());
                    LOG.warn("Object Name: " + objectInstance.getObjectName());
                }
            }
        }
        finally {
            if (connector != null) {
                try {
                    connector.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Test
    public void test() throws IOException, InterruptedException {
        try (Table t = UTIL.getConnection().getTable(NAME1);){
            this.writeData(t);
            UTIL.flush(NAME1);
            UTIL.compact(NAME1, true);
            Thread.sleep(2000L);
        }
        Set<String> jmxMetrics = this.readJmxMetricsWithRetry();
        Assert.assertNotNull(jmxMetrics);
        long name1TableMetricsCount = jmxMetrics.stream().filter(metric -> metric.contains("MetaTable_table_" + NAME1)).count();
        Assert.assertEquals((long)5L, (long)name1TableMetricsCount);
        String putWithClientMetricNameRegex = "MetaTable_client_.+_put_request.*";
        long putWithClientMetricsCount = jmxMetrics.stream().filter(metric -> metric.matches(putWithClientMetricNameRegex)).count();
        Assert.assertEquals((long)5L, (long)putWithClientMetricsCount);
    }
}

