/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.AsyncRegistryFactory;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableNoncedRetry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableNoncedRetry.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"cq");
    private static byte[] VALUE = Bytes.toBytes((String)"value");
    private static AsyncConnection ASYNC_CONN;
    private static long NONCE;
    private static NonceGenerator NONCE_GENERATOR;
    @Rule
    public TestName testName = new TestName();
    private byte[] row;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        AsyncRegistry registry = AsyncRegistryFactory.getRegistry((Configuration)TEST_UTIL.getConfiguration());
        ASYNC_CONN = new AsyncConnectionImpl(TEST_UTIL.getConfiguration(), registry, (String)registry.getClusterId().get(), User.getCurrent()){

            public NonceGenerator getNonceGenerator() {
                return NONCE_GENERATOR;
            }
        };
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        IOUtils.closeQuietly((Closeable)ASYNC_CONN);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.row = Bytes.toBytes((String)this.testName.getMethodName().replaceAll("[^0-9A-Za-z]", "_"));
        ++NONCE;
    }

    @Test
    public void testAppend() throws InterruptedException, ExecutionException {
        AsyncTable table = ASYNC_CONN.getTable(TABLE_NAME);
        Result result = (Result)table.append(new Append(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).get();
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER));
        result = (Result)table.append(new Append(this.row).addColumn(FAMILY, QUALIFIER, VALUE)).get();
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER));
        result = (Result)table.get(new Get(this.row)).get();
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER));
    }

    @Test
    public void testIncrement() throws InterruptedException, ExecutionException {
        AsyncTable table = ASYNC_CONN.getTable(TABLE_NAME);
        Assert.assertEquals((long)1L, (long)((Long)table.incrementColumnValue(this.row, FAMILY, QUALIFIER, 1L).get()));
        Assert.assertEquals((long)1L, (long)((Long)table.incrementColumnValue(this.row, FAMILY, QUALIFIER, 1L).get()));
        Result result = (Result)table.get(new Get(this.row)).get();
        Assert.assertEquals((long)1L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, QUALIFIER)));
    }

    static {
        NONCE = 1L;
        NONCE_GENERATOR = new NonceGenerator(){

            public long newNonce() {
                return NONCE;
            }

            public long getNonceGroup() {
                return 1L;
            }
        };
    }
}

