/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestClientClusterMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientClusterMetrics.class);
    private static HBaseTestingUtility UTIL;
    private static Admin ADMIN;
    private static final int SLAVES = 5;
    private static final int MASTERS = 3;
    private static MiniHBaseCluster CLUSTER;
    private static HRegionServer DEAD;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.coprocessor.master.classes", MyObserver.class.getName());
        UTIL = new HBaseTestingUtility(conf);
        UTIL.startMiniCluster(3, 5);
        CLUSTER = UTIL.getHBaseCluster();
        CLUSTER.waitForActiveAndReadyMaster();
        ADMIN = UTIL.getAdmin();
        List<JVMClusterUtil.RegionServerThread> rsts = CLUSTER.getLiveRegionServerThreads();
        JVMClusterUtil.RegionServerThread rst = rsts.get(rsts.size() - 1);
        DEAD = rst.getRegionServer();
        DEAD.stop("Test dead servers metrics");
        while (rst.isAlive()) {
            Thread.sleep(500L);
        }
    }

    @Test
    public void testDefaults() throws Exception {
        ClusterMetrics origin = ADMIN.getClusterMetrics();
        ClusterMetrics defaults = ADMIN.getClusterMetrics(EnumSet.allOf(ClusterMetrics.Option.class));
        Assert.assertEquals((Object)origin.getHBaseVersion(), (Object)defaults.getHBaseVersion());
        Assert.assertEquals((Object)origin.getClusterId(), (Object)defaults.getClusterId());
        Assert.assertEquals((double)origin.getAverageLoad(), (double)defaults.getAverageLoad(), (double)0.0);
        Assert.assertEquals((long)origin.getBackupMasterNames().size(), (long)defaults.getBackupMasterNames().size());
        Assert.assertEquals((long)origin.getDeadServerNames().size(), (long)defaults.getDeadServerNames().size());
        Assert.assertEquals((long)origin.getRegionCount(), (long)defaults.getRegionCount());
        Assert.assertEquals((long)origin.getLiveServerMetrics().size(), (long)defaults.getLiveServerMetrics().size());
        Assert.assertEquals((long)origin.getMasterInfoPort(), (long)defaults.getMasterInfoPort());
    }

    @Test
    public void testAsyncClient() throws Exception {
        try (AsyncConnection asyncConnect = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();){
            AsyncAdmin asyncAdmin = asyncConnect.getAdmin();
            CompletableFuture originFuture = asyncAdmin.getClusterMetrics();
            CompletableFuture defaultsFuture = asyncAdmin.getClusterMetrics(EnumSet.allOf(ClusterMetrics.Option.class));
            ClusterMetrics origin = (ClusterMetrics)originFuture.get();
            ClusterMetrics defaults = (ClusterMetrics)defaultsFuture.get();
            Assert.assertEquals((Object)origin.getHBaseVersion(), (Object)defaults.getHBaseVersion());
            Assert.assertEquals((Object)origin.getClusterId(), (Object)defaults.getClusterId());
            Assert.assertEquals((Object)origin.getHBaseVersion(), (Object)defaults.getHBaseVersion());
            Assert.assertEquals((Object)origin.getClusterId(), (Object)defaults.getClusterId());
            Assert.assertEquals((double)origin.getAverageLoad(), (double)defaults.getAverageLoad(), (double)0.0);
            Assert.assertEquals((long)origin.getBackupMasterNames().size(), (long)defaults.getBackupMasterNames().size());
            Assert.assertEquals((long)origin.getDeadServerNames().size(), (long)defaults.getDeadServerNames().size());
            Assert.assertEquals((long)origin.getRegionCount(), (long)defaults.getRegionCount());
            Assert.assertEquals((long)origin.getLiveServerMetrics().size(), (long)defaults.getLiveServerMetrics().size());
            Assert.assertEquals((long)origin.getMasterInfoPort(), (long)defaults.getMasterInfoPort());
        }
    }

    @Test
    public void testLiveAndDeadServersStatus() throws Exception {
        List<JVMClusterUtil.RegionServerThread> regionserverThreads = CLUSTER.getLiveRegionServerThreads();
        int numRs = 0;
        int len = regionserverThreads.size();
        for (int i = 0; i < len; ++i) {
            if (!regionserverThreads.get(i).isAlive()) continue;
            ++numRs;
        }
        Waiter.waitFor((Configuration)CLUSTER.getConfiguration(), (long)10000L, (long)100L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ClusterMetrics metrics = ADMIN.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS));
                Assert.assertNotNull((Object)metrics);
                return metrics.getRegionCount() > 0;
            }
        });
        EnumSet<ClusterMetrics.Option> options = EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS, ClusterMetrics.Option.DEAD_SERVERS);
        ClusterMetrics metrics = ADMIN.getClusterMetrics(options);
        Assert.assertNotNull((Object)metrics);
        Assert.assertEquals((long)4L, (long)numRs);
        Assert.assertEquals((long)numRs, (long)metrics.getLiveServerMetrics().size());
        Assert.assertTrue((metrics.getRegionCount() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)metrics.getDeadServerNames());
        Assert.assertEquals((long)1L, (long)metrics.getDeadServerNames().size());
        ServerName deadServerName = (ServerName)metrics.getDeadServerNames().iterator().next();
        Assert.assertEquals((Object)DEAD.getServerName(), (Object)deadServerName);
    }

    @Test
    public void testMasterAndBackupMastersStatus() throws Exception {
        List<JVMClusterUtil.MasterThread> masterThreads = CLUSTER.getMasterThreads();
        int numActive = 0;
        int activeIndex = 0;
        ServerName activeName = null;
        HMaster active = null;
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            ++numActive;
            activeIndex = i;
            active = masterThreads.get(activeIndex).getMaster();
            activeName = active.getServerName();
        }
        Assert.assertNotNull(active);
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)3L, (long)masterThreads.size());
        EnumSet<ClusterMetrics.Option> options = EnumSet.of(ClusterMetrics.Option.MASTER, ClusterMetrics.Option.BACKUP_MASTERS);
        ClusterMetrics metrics = ADMIN.getClusterMetrics(options);
        Assert.assertTrue((boolean)metrics.getMasterName().equals((Object)activeName));
        Assert.assertEquals((long)2L, (long)metrics.getBackupMasterNames().size());
    }

    @Test
    public void testOtherStatusInfos() throws Exception {
        EnumSet<ClusterMetrics.Option> options = EnumSet.of(ClusterMetrics.Option.MASTER_COPROCESSORS, ClusterMetrics.Option.HBASE_VERSION, ClusterMetrics.Option.CLUSTER_ID, ClusterMetrics.Option.BALANCER_ON);
        ClusterMetrics metrics = ADMIN.getClusterMetrics(options);
        Assert.assertEquals((long)1L, (long)metrics.getMasterCoprocessorNames().size());
        Assert.assertNotNull((Object)metrics.getHBaseVersion());
        Assert.assertNotNull((Object)metrics.getClusterId());
        Assert.assertTrue((metrics.getAverageLoad() == 0.0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)metrics.getBalancerOn());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (ADMIN != null) {
            ADMIN.close();
        }
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testObserver() throws IOException {
        int preCount = MyObserver.PRE_COUNT.get();
        int postCount = MyObserver.POST_COUNT.get();
        Assert.assertTrue((boolean)ADMIN.getClusterMetrics().getMasterCoprocessorNames().stream().anyMatch(s -> s.equals(MyObserver.class.getSimpleName())));
        Assert.assertEquals((long)(preCount + 1), (long)MyObserver.PRE_COUNT.get());
        Assert.assertEquals((long)(postCount + 1), (long)MyObserver.POST_COUNT.get());
    }

    public static class MyObserver
    implements MasterCoprocessor,
    MasterObserver {
        private static final AtomicInteger PRE_COUNT = new AtomicInteger(0);
        private static final AtomicInteger POST_COUNT = new AtomicInteger(0);

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preGetClusterMetrics(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
            PRE_COUNT.incrementAndGet();
        }

        public void postGetClusterMetrics(ObserverContext<MasterCoprocessorEnvironment> ctx, ClusterMetrics metrics) throws IOException {
            POST_COUNT.incrementAndGet();
        }
    }
}

