/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.example.hbasecontext;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class HBaseStreamingBulkPutExample$ {
    public static final HBaseStreamingBulkPutExample$ MODULE$;

    static {
        new HBaseStreamingBulkPutExample$();
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        if (args.length < 4) {
            Predef$.MODULE$.println((Object)"HBaseStreamingBulkPutExample {host} {port} {tableName} {columnFamily} are missing an argument");
            return;
        }
        String host = args[0];
        String port = args[1];
        String tableName = args[2];
        String columnFamily = args[3];
        SparkConf sparkConf = new SparkConf().setAppName(new StringBuilder().append((Object)"HBaseStreamingBulkPutExample ").append((Object)tableName).append((Object)" ").append((Object)columnFamily).toString());
        SparkContext sc = new SparkContext(sparkConf);
        try {
            StreamingContext ssc = new StreamingContext(sc, Seconds$.MODULE$.apply(1L));
            ReceiverInputDStream lines = ssc.socketTextStream(host, new StringOps(Predef$.MODULE$.augmentString(port)).toInt(), ssc.socketTextStream$default$3());
            Configuration conf = HBaseConfiguration.create();
            HBaseContext hbaseContext = new HBaseContext(sc, conf, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            hbaseContext.streamBulkPut(lines, TableName.valueOf((String)tableName), new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final Put apply(String putRecord) {
                    Put put;
                    if (putRecord.length() > 0) {
                        void var2_2;
                        Put put2 = new Put(Bytes.toBytes((String)putRecord));
                        put2.addColumn(Bytes.toBytes((String)"c"), Bytes.toBytes((String)"foo"), Bytes.toBytes((String)"bar"));
                        put = var2_2;
                    } else {
                        put = null;
                    }
                    return put;
                }
            });
            ssc.start();
            ssc.awaitTerminationOrTimeout(60000L);
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.stop();
            throw throwable;
        }
        sc.stop();
    }

    private HBaseStreamingBulkPutExample$() {
        MODULE$ = this;
    }
}

