/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@InterfaceAudience.Private
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u00015\u0011\u0011bU2b]J\u000bgnZ3\u000b\u0005\r!\u0011!B:qCJ\\'BA\u0003\u0007\u0003\u0015A'-Y:f\u0015\t9\u0001\"\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fUI!A\u0006\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011a\u0001!\u00111A\u0005\u0002e\t!\"\u001e9qKJ\u0014u.\u001e8e+\u0005Q\u0002cA\b\u001c;%\u0011A\u0004\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u001fyI!a\b\t\u0003\t\tKH/\u001a\u0005\tC\u0001\u0011\t\u0019!C\u0001E\u0005qQ\u000f\u001d9fe\n{WO\u001c3`I\u0015\fHCA\u0012'!\tyA%\u0003\u0002&!\t!QK\\5u\u0011\u001d9\u0003%!AA\u0002i\t1\u0001\u001f\u00132\u0011!I\u0003A!A!B\u0013Q\u0012aC;qa\u0016\u0014(i\\;oI\u0002B\u0001b\u000b\u0001\u0003\u0002\u0004%\t\u0001L\u0001\u0014SN,\u0006\u000f]3s\u0005>,h\u000eZ#rk\u0006dGk\\\u000b\u0002[A\u0011qBL\u0005\u0003_A\u0011qAQ8pY\u0016\fg\u000e\u0003\u00052\u0001\t\u0005\r\u0011\"\u00013\u0003]I7/\u00169qKJ\u0014u.\u001e8e\u000bF,\u0018\r\u001c+p?\u0012*\u0017\u000f\u0006\u0002$g!9q\u0005MA\u0001\u0002\u0004i\u0003\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0015B\u0017\u0002)%\u001cX\u000b\u001d9fe\n{WO\u001c3FcV\fG\u000eV8!\u0011!9\u0004A!a\u0001\n\u0003I\u0012A\u00037po\u0016\u0014(i\\;oI\"A\u0011\b\u0001BA\u0002\u0013\u0005!(\u0001\bm_^,'OQ8v]\u0012|F%Z9\u0015\u0005\rZ\u0004bB\u00149\u0003\u0003\u0005\rA\u0007\u0005\t{\u0001\u0011\t\u0011)Q\u00055\u0005YAn\\<fe\n{WO\u001c3!\u0011!y\u0004A!a\u0001\n\u0003a\u0013aE5t\u0019><XM\u001d\"pk:$W)];bYR{\u0007\u0002C!\u0001\u0005\u0003\u0007I\u0011\u0001\"\u0002/%\u001cHj\\<fe\n{WO\u001c3FcV\fG\u000eV8`I\u0015\fHCA\u0012D\u0011\u001d9\u0003)!AA\u00025B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006K!L\u0001\u0015SNdun^3s\u0005>,h\u000eZ#rk\u0006dGk\u001c\u0011\t\u000b\u001d\u0003A\u0011\u0001%\u0002\rqJg.\u001b;?)\u0015I5\nT'O!\tQ\u0005!D\u0001\u0003\u0011\u0015Ab\t1\u0001\u001b\u0011\u0015Yc\t1\u0001.\u0011\u00159d\t1\u0001\u001b\u0011\u0015yd\t1\u0001.\u0011\u0015\u0001\u0006\u0001\"\u0001R\u00039iWM]4f\u0013:$XM]:fGR$\"a\t*\t\u000bM{\u0005\u0019A%\u0002\u000b=$\b.\u001a:\t\u000bU\u0003A\u0011\u0001,\u0002\u00155,'oZ3V]&|g\u000e\u0006\u0002$/\")1\u000b\u0016a\u0001\u0013\")\u0011\f\u0001C\u00015\u0006\u0019r-\u001a;Pm\u0016\u0014H*\u00199TG\u0006t'+\u00198hKR\u0011\u0011j\u0017\u0005\u0006'b\u0003\r!\u0013\u0005\u0006;\u0002!\tAX\u0001\u000bQ\u0006\u001cxJ^3sY\u0006\u0004HcA\u0017`C\")\u0001\r\u0018a\u0001\u0013\u0006!A.\u001a4u\u0011\u0015\u0011G\f1\u0001J\u0003\u0015\u0011\u0018n\u001a5u\u0011\u0015!\u0007\u0001\"\u0001f\u00031\u0019w.\u001c9be\u0016\u0014\u0016M\\4f)\r1\u0017N\u001b\t\u0003\u001f\u001dL!\u0001\u001b\t\u0003\u0007%sG\u000fC\u0003aG\u0002\u0007!\u0004C\u0003cG\u0002\u0007!\u0004C\u0003m\u0001\u0011\u0005Q.A\u0007d_:$\u0018-\u001b8t!>Lg\u000e\u001e\u000b\u0003[9DQa\\6A\u0002i\tQ\u0001]8j]RDQ!\u001d\u0001\u0005BI\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002gB\u0011Ao\u001e\b\u0003\u001fUL!A\u001e\t\u0002\rA\u0013X\rZ3g\u0013\tA\u0018P\u0001\u0004TiJLgn\u001a\u0006\u0003mBA#\u0001A>\u0011\u0007q\fIAD\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001C1vI&,gnY3\u000b\u0007\u0005\r\u0001\"A\u0003zKR,8/C\u0002\u0002\by\f\u0011#\u00138uKJ4\u0017mY3Bk\u0012LWM\\2f\u0013\u0011\tY!!\u0004\u0003\u000fA\u0013\u0018N^1uK*\u0019\u0011q\u0001@")
public class ScanRange
implements Serializable {
    private byte[] upperBound;
    private boolean isUpperBoundEqualTo;
    private byte[] lowerBound;
    private boolean isLowerBoundEqualTo;

    public byte[] upperBound() {
        return this.upperBound;
    }

    public void upperBound_$eq(byte[] x$1) {
        this.upperBound = x$1;
    }

    public boolean isUpperBoundEqualTo() {
        return this.isUpperBoundEqualTo;
    }

    public void isUpperBoundEqualTo_$eq(boolean x$1) {
        this.isUpperBoundEqualTo = x$1;
    }

    public byte[] lowerBound() {
        return this.lowerBound;
    }

    public void lowerBound_$eq(byte[] x$1) {
        this.lowerBound = x$1;
    }

    public boolean isLowerBoundEqualTo() {
        return this.isLowerBoundEqualTo;
    }

    public void isLowerBoundEqualTo_$eq(boolean x$1) {
        this.isLowerBoundEqualTo = x$1;
    }

    public void mergeIntersect(ScanRange other) {
        int upperBoundCompare = this.compareRange(this.upperBound(), other.upperBound());
        int lowerBoundCompare = this.compareRange(this.lowerBound(), other.lowerBound());
        this.upperBound_$eq(upperBoundCompare < 0 ? this.upperBound() : other.upperBound());
        this.lowerBound_$eq(lowerBoundCompare > 0 ? this.lowerBound() : other.lowerBound());
        this.isLowerBoundEqualTo_$eq(lowerBoundCompare == 0 ? this.isLowerBoundEqualTo() && other.isLowerBoundEqualTo() : this.isLowerBoundEqualTo());
        this.isUpperBoundEqualTo_$eq(upperBoundCompare == 0 ? this.isUpperBoundEqualTo() && other.isUpperBoundEqualTo() : this.isUpperBoundEqualTo());
    }

    public void mergeUnion(ScanRange other) {
        int upperBoundCompare = this.compareRange(this.upperBound(), other.upperBound());
        int lowerBoundCompare = this.compareRange(this.lowerBound(), other.lowerBound());
        this.upperBound_$eq(upperBoundCompare > 0 ? this.upperBound() : other.upperBound());
        this.lowerBound_$eq(lowerBoundCompare < 0 ? this.lowerBound() : other.lowerBound());
        this.isLowerBoundEqualTo_$eq(lowerBoundCompare == 0 ? this.isLowerBoundEqualTo() || other.isLowerBoundEqualTo() : (lowerBoundCompare < 0 ? this.isLowerBoundEqualTo() : other.isLowerBoundEqualTo()));
        this.isUpperBoundEqualTo_$eq(upperBoundCompare == 0 ? this.isUpperBoundEqualTo() || other.isUpperBoundEqualTo() : (upperBoundCompare < 0 ? other.isUpperBoundEqualTo() : this.isUpperBoundEqualTo()));
    }

    public ScanRange getOverLapScanRange(ScanRange other) {
        ScanRange leftRange = null;
        ScanRange rightRange = null;
        if (this.compareRange(this.lowerBound(), other.lowerBound()) < 0 || this.compareRange(this.upperBound(), other.upperBound()) < 0) {
            leftRange = this;
            rightRange = other;
        } else {
            leftRange = other;
            rightRange = this;
        }
        return this.hasOverlap(leftRange, rightRange) ? (this.compareRange(leftRange.upperBound(), rightRange.upperBound()) >= 0 ? new ScanRange(rightRange.upperBound(), rightRange.isUpperBoundEqualTo(), rightRange.lowerBound(), rightRange.isLowerBoundEqualTo()) : new ScanRange(leftRange.upperBound(), leftRange.isUpperBoundEqualTo(), rightRange.lowerBound(), rightRange.isLowerBoundEqualTo())) : null;
    }

    public boolean hasOverlap(ScanRange left, ScanRange right) {
        return this.compareRange(left.upperBound(), right.lowerBound()) >= 0;
    }

    public int compareRange(byte[] left, byte[] right) {
        return left == null && right == null ? 0 : (left == null && right != null ? 1 : (left != null && right == null ? -1 : Bytes.compareTo((byte[])left, (byte[])right)));
    }

    public boolean containsPoint(byte[] point) {
        int lowerCompare = this.compareRange(point, this.lowerBound());
        int upperCompare = this.compareRange(point, this.upperBound());
        return (this.isLowerBoundEqualTo() && lowerCompare >= 0 || !this.isLowerBoundEqualTo() && lowerCompare > 0) && (this.isUpperBoundEqualTo() && upperCompare <= 0 || !this.isUpperBoundEqualTo() && upperCompare < 0);
    }

    public String toString() {
        return new StringBuilder().append((Object)"ScanRange:(upperBound:").append((Object)Bytes.toString((byte[])this.upperBound())).append((Object)",isUpperBoundEqualTo:").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isUpperBoundEqualTo())).append((Object)",lowerBound:").append((Object)Bytes.toString((byte[])this.lowerBound())).append((Object)",isLowerBoundEqualTo:").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isLowerBoundEqualTo())).append((Object)")").toString();
    }

    public ScanRange(byte[] upperBound, boolean isUpperBoundEqualTo, byte[] lowerBound, boolean isLowerBoundEqualTo) {
        this.upperBound = upperBound;
        this.isUpperBoundEqualTo = isUpperBoundEqualTo;
        this.lowerBound = lowerBound;
        this.isLowerBoundEqualTo = isLowerBoundEqualTo;
    }
}

