/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hbase.spark.AndLogicExpression;
import org.apache.hadoop.hbase.spark.DefaultSourceStaticUtils$;
import org.apache.hadoop.hbase.spark.DynamicLogicExpression;
import org.apache.hadoop.hbase.spark.EqualLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.spark.HBaseRelation$;
import org.apache.hadoop.hbase.spark.IsNullLogicExpression;
import org.apache.hadoop.hbase.spark.LatestHBaseContextCache$;
import org.apache.hadoop.hbase.spark.LessThanLogicExpression;
import org.apache.hadoop.hbase.spark.LessThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.Logging;
import org.apache.hadoop.hbase.spark.Logging$class;
import org.apache.hadoop.hbase.spark.OrLogicExpression;
import org.apache.hadoop.hbase.spark.PassThroughLogicExpression;
import org.apache.hadoop.hbase.spark.RowKeyFilter;
import org.apache.hadoop.hbase.spark.RowKeyFilter$;
import org.apache.hadoop.hbase.spark.ScanRange;
import org.apache.hadoop.hbase.spark.SparkSQLPushDownFilter;
import org.apache.hadoop.hbase.spark.datasources.BoundRange;
import org.apache.hadoop.hbase.spark.datasources.BoundRanges;
import org.apache.hadoop.hbase.spark.datasources.BytesEncoder;
import org.apache.hadoop.hbase.spark.datasources.HBaseSparkConf$;
import org.apache.hadoop.hbase.spark.datasources.HBaseTableScanRDD;
import org.apache.hadoop.hbase.spark.datasources.JavaBytesEncoder$;
import org.apache.hadoop.hbase.spark.datasources.SerializableConfiguration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.datasources.hbase.Field;
import org.apache.spark.sql.datasources.hbase.HBaseTableCatalog;
import org.apache.spark.sql.datasources.hbase.HBaseTableCatalog$;
import org.apache.spark.sql.datasources.hbase.Utils$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@InterfaceAudience.Private
@ScalaSignature(bytes="\u0006\u0001\r%e\u0001B\u0001\u0003\u00016\u0011Q\u0002\u0013\"bg\u0016\u0014V\r\\1uS>t'BA\u0002\u0005\u0003\u0015\u0019\b/\u0019:l\u0015\t)a!A\u0003iE\u0006\u001cXM\u0003\u0002\b\u0011\u00051\u0001.\u00193p_BT!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0002\u0001\u000f/ii\u0012e\n\t\u0003\u001fUi\u0011\u0001\u0005\u0006\u0003#I\tqa]8ve\u000e,7O\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005\rA\u0011B\u0001\f\u0011\u00051\u0011\u0015m]3SK2\fG/[8o!\ty\u0001$\u0003\u0002\u001a!\t\u0011\u0002K];oK\u00124\u0015\u000e\u001c;fe\u0016$7kY1o!\ty1$\u0003\u0002\u001d!\t\u0011\u0012J\\:feR\f'\r\\3SK2\fG/[8o!\tqr$D\u0001\u0003\u0013\t\u0001#AA\u0004M_\u001e<\u0017N\\4\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\u000fA\u0013x\u000eZ;diB\u0011!\u0005K\u0005\u0003S\r\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001b\u000b\u0001\u0003\u0016\u0004%\t\u0001L\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cX#A\u0017\u0011\t9\nD\u0007\u000e\b\u0003E=J!\u0001M\u0012\u0002\rA\u0013X\rZ3g\u0013\t\u00114GA\u0002NCBT!\u0001M\u0012\u0011\u00059*\u0014B\u0001\u001c4\u0005\u0019\u0019FO]5oO\"A\u0001\b\u0001B\tB\u0003%Q&A\u0006qCJ\fW.\u001a;feN\u0004\u0003FA\u001c;!\t\u00113(\u0003\u0002=G\tIAO]1og&,g\u000e\u001e\u0005\t}\u0001\u0011)\u001a!C\u0001\u007f\u0005\u0019Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nCV\t\u0001\tE\u0002#\u0003\u000eK!AQ\u0012\u0003\r=\u0003H/[8o!\t!u)D\u0001F\u0015\t1%#A\u0003usB,7/\u0003\u0002I\u000b\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011)\u0003!\u0011#Q\u0001\n\u0001\u000bA#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006\u0004\u0003\u0002\u0003'\u0001\u0005\u000b\u0007I\u0011A'\u0002\u0015M\fHnQ8oi\u0016DH/F\u0001O!\ty\u0005+D\u0001\u0013\u0013\t\t&C\u0001\u0006T#2\u001buN\u001c;fqRD\u0001b\u0015\u0001\u0003\u0002\u0003\u0006IAT\u0001\fgFd7i\u001c8uKb$\b\u0005\u000b\u0002Su!)a\u000b\u0001C\u0001/\u00061A(\u001b8jiz\"2\u0001W.])\tI&\f\u0005\u0002\u001f\u0001!)A*\u0016a\u0001\u001d\")1&\u0016a\u0001[!)a(\u0016a\u0001\u0001\"9a\f\u0001b\u0001\n\u0003y\u0016!\u0003;j[\u0016\u001cH/Y7q+\u0005\u0001\u0007c\u0001\u0012BCB\u0011!EY\u0005\u0003G\u000e\u0012A\u0001T8oO\"1Q\r\u0001Q\u0001\n\u0001\f!\u0002^5nKN$\u0018-\u001c9!\u0011\u001d9\u0007A1A\u0005\u0002}\u000bA\"\\5o)&lWm\u001d;b[BDa!\u001b\u0001!\u0002\u0013\u0001\u0017!D7j]RKW.Z:uC6\u0004\b\u0005C\u0004l\u0001\t\u0007I\u0011A0\u0002\u00195\f\u0007\u0010V5nKN$\u0018-\u001c9\t\r5\u0004\u0001\u0015!\u0003a\u00035i\u0017\r\u001f+j[\u0016\u001cH/Y7qA!9q\u000e\u0001b\u0001\n\u0003\u0001\u0018aC7bqZ+'o]5p]N,\u0012!\u001d\t\u0004E\u0005\u0013\bC\u0001\u0012t\u0013\t!8EA\u0002J]RDaA\u001e\u0001!\u0002\u0013\t\u0018\u0001D7bqZ+'o]5p]N\u0004\u0003b\u0002=\u0001\u0005\u0004%\t!_\u0001\u000fK:\u001cw\u000eZ3s\u00072\u001ch*Y7f+\u0005!\u0004BB>\u0001A\u0003%A'A\bf]\u000e|G-\u001a:DYNt\u0015-\\3!\u0011\u001di\bA1A\u0005\u0002y\fq!\u001a8d_\u0012,'/F\u0001\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003\u0005\u0005YA-\u0019;bg>,(oY3t\u0013\u0011\tI!a\u0001\u0003\u0019\tKH/Z:F]\u000e|G-\u001a:\t\u000f\u00055\u0001\u0001)A\u0005\u007f\u0006AQM\\2pI\u0016\u0014\b\u0005K\u0002\u0002\fiB\u0011\"a\u0005\u0001\u0005\u0004%\t!!\u0006\u0002\u000f\r\fG/\u00197pOV\u0011\u0011q\u0003\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019Q!!\b\u000b\u0007\u0005\u0015!#\u0003\u0003\u0002\"\u0005m!!\u0005%CCN,G+\u00192mK\u000e\u000bG/\u00197pO\"A\u0011Q\u0005\u0001!\u0002\u0013\t9\"\u0001\u0005dCR\fGn\\4!\u0011\u0019\tI\u0003\u0001C\u0001s\u0006IA/\u00192mK:\u000bW.\u001a\u0005\t\u0003[\u0001!\u0019!C\u0001s\u0006y1m\u001c8gS\u001e\u0014Vm]8ve\u000e,7\u000fC\u0004\u00022\u0001\u0001\u000b\u0011\u0002\u001b\u0002!\r|gNZ5h%\u0016\u001cx.\u001e:dKN\u0004\u0003\"CA\u001b\u0001\t\u0007I\u0011AA\u001c\u0003=)8/\u001a%CCN,7i\u001c8uKb$XCAA\u001d!\r\u0011\u00131H\u0005\u0004\u0003{\u0019#a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002:\u0005\u0001Ro]3I\u0005\u0006\u001cXmQ8oi\u0016DH\u000f\t\u0005\n\u0003\u000b\u0002!\u0019!C\u0001\u0003o\tq#^:f!V\u001c\b\u000eR8x]\u000e{G.^7o\r&dG/\u001a:\t\u0011\u0005%\u0003\u0001)A\u0005\u0003s\t\u0001$^:f!V\u001c\b\u000eR8x]\u000e{G.^7o\r&dG/\u001a:!\u0011%\ti\u0005\u0001b\u0001\n\u0003\t9$\u0001\tcY>\u001c7nQ1dQ\u0016,e.\u00192mK\"A\u0011\u0011\u000b\u0001!\u0002\u0013\tI$A\tcY>\u001c7nQ1dQ\u0016,e.\u00192mK\u0002B\u0011\"!\u0016\u0001\u0005\u0004%\t!a\u0016\u0002\u0013\r\f7\r[3TSj,W#\u0001:\t\u000f\u0005m\u0003\u0001)A\u0005e\u0006Q1-Y2iKNK'0\u001a\u0011\t\u0013\u0005}\u0003A1A\u0005\u0002\u0005]\u0013\u0001\u00032bi\u000eDg*^7\t\u000f\u0005\r\u0004\u0001)A\u0005e\u0006I!-\u0019;dQ:+X\u000e\t\u0005\n\u0003O\u0002!\u0019!C\u0001\u0003/\n1BY;mW\u001e+GoU5{K\"9\u00111\u000e\u0001!\u0002\u0013\u0011\u0018\u0001\u00042vY.<U\r^*ju\u0016\u0004\u0003\"CA8\u0001\t\u0007I\u0011AA9\u00031A'-Y:f\u0007>tG/\u001a=u+\t\t\u0019\bE\u0002\u001f\u0003kJ1!a\u001e\u0003\u00051A%)Y:f\u0007>tG/\u001a=u\u0011!\tY\b\u0001Q\u0001\n\u0005M\u0014!\u00045cCN,7i\u001c8uKb$\b\u0005C\u0005\u0002\u0000\u0001\u0011\r\u0011\"\u0001\u0002\u0002\u0006YqO]1qa\u0016$7i\u001c8g+\t\t\u0019\t\u0005\u0003\u0002\u0002\u0005\u0015\u0015\u0002BAD\u0003\u0007\u0011\u0011dU3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"A\u00111\u0012\u0001!\u0002\u0013\t\u0019)\u0001\u0007xe\u0006\u0004\b/\u001a3D_:4\u0007\u0005C\u0004\u0002\u0010\u0002!\t!!%\u0002\u0013!\u0014\u0017m]3D_:4WCAAJ!\u0011\t)*a'\u000e\u0005\u0005]%bAAM\r\u0005!1m\u001c8g\u0013\u0011\ti*a&\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011%\t\t\u000b\u0001b\u0001\n\u0003\n\u0019+\u0001\u0004tG\",W.Y\u000b\u0002\u0007\"9\u0011q\u0015\u0001!\u0002\u0013\u0019\u0015aB:dQ\u0016l\u0017\r\t\u0005\b\u0003W\u0003A\u0011AAW\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\u0005\u0005=\u0006c\u0001\u0012\u00022&\u0019\u00111W\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003o\u0003A\u0011IA]\u0003\u0019Ign]3siR1\u0011qVA^\u0003GD\u0001\"!0\u00026\u0002\u0007\u0011qX\u0001\u0005I\u0006$\u0018\r\u0005\u0003\u0002B\u0006ug\u0002BAb\u00033tA!!2\u0002X:!\u0011qYAk\u001d\u0011\tI-a5\u000f\t\u0005-\u0017\u0011[\u0007\u0003\u0003\u001bT1!a4\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u00111\u0001C\u0005\u0003'QI1!a7\u0013\u0003\u001d\u0001\u0018mY6bO\u0016LA!a8\u0002b\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u00037\u0014\u0002\u0002CAs\u0003k\u0003\r!!\u000f\u0002\u0013=4XM]<sSR,\u0007bBAu\u0001\u0011\u0005\u00111^\u0001\u0016O\u0016$\u0018J\u001c3fq\u0016$\u0007K]8kK\u000e$\u0018n\u001c8t)\u0011\tiO!\u0003\u0011\r\u0005=\u0018q_A\u007f\u001d\u0011\t\t0!>\u000f\t\u0005-\u00171_\u0005\u0002I%\u0019\u00111\\\u0012\n\t\u0005e\u00181 \u0002\u0004'\u0016\f(bAAnGA1!%a@\u0003\u0004IL1A!\u0001$\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011\u0004B\u0003\u0013\u0011\u00119!a\u0007\u0003\u000b\u0019KW\r\u001c3\t\u0011\t-\u0011q\u001da\u0001\u0005\u001b\tqB]3rk&\u0014X\rZ\"pYVlgn\u001d\t\u0005E\t=A'C\u0002\u0003\u0012\r\u0012Q!\u0011:sCfDqA!\u0006\u0001\t\u0003\u00119\"A\u0006qCJ\u001cXMU8x\u0017\u0016LHC\u0002B\r\u0005C\u0011i\u0003\u0005\u0004/c\t\r!1\u0004\t\u0004E\tu\u0011b\u0001B\u0010G\t\u0019\u0011I\\=\t\u0011\t\r\"1\u0003a\u0001\u0005K\t1A]8x!\u0015\u0011#q\u0002B\u0014!\r\u0011#\u0011F\u0005\u0004\u0005W\u0019#\u0001\u0002\"zi\u0016D\u0001Ba\f\u0003\u0014\u0001\u0007!\u0011G\u0001\nW\u0016Lh)[3mIN\u0004b!a<\u0002x\n\r\u0001b\u0002B\u001b\u0001\u0011\u0005!qG\u0001\tEVLG\u000e\u001a*poR1!\u0011\bB \u0005\u0007\u00022a\u0014B\u001e\u0013\r\u0011iD\u0005\u0002\u0004%><\b\u0002\u0003B!\u0005g\u0001\rA!\r\u0002\r\u0019LW\r\u001c3t\u0011!\u0011)Ea\rA\u0002\t\u001d\u0013A\u0002:fgVdG\u000f\u0005\u0003\u0003J\t=SB\u0001B&\u0015\r\u0011i\u0005B\u0001\u0007G2LWM\u001c;\n\t\tE#1\n\u0002\u0007%\u0016\u001cX\u000f\u001c;\t\u000f\tU\u0003\u0001\"\u0011\u0003X\u0005I!-^5mIN\u001b\u0017M\u001c\u000b\u0007\u00053\u0012)Ga\u001a\u0011\r\tm#\u0011\rB\u001d\u001b\t\u0011iFC\u0002\u0003`Q\t1A\u001d3e\u0013\u0011\u0011\u0019G!\u0018\u0003\u0007I#E\t\u0003\u0005\u0003\f\tM\u0003\u0019\u0001B\u0007\u0011!\u0011IGa\u0015A\u0002\t-\u0014a\u00024jYR,'o\u001d\t\u0006E\t=!Q\u000e\t\u0004\u001f\t=\u0014b\u0001B9!\t1a)\u001b7uKJDqA!\u001e\u0001\t\u0003\u00119(A\u0010ck&dG\rU;tQ\u0012{wO\u001c)sK\u0012L7-\u0019;fgJ+7o\\;sG\u0016$BA!\u001f\u0003\u000eBI!Ea\u001f\u0003\u0000\t\u0015%1R\u0005\u0004\u0005{\u001a#A\u0002+va2,7\u0007E\u0002\u001f\u0005\u0003K1Aa!\u0003\u00051\u0011vn^&fs\u001aKG\u000e^3s!\rq\"qQ\u0005\u0004\u0005\u0013\u0013!A\u0006#z]\u0006l\u0017n\u0019'pO&\u001cW\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u000b\t\u0012yA!\n\t\u0011\t%$1\u000fa\u0001\u0005WBqA!%\u0001\t\u0003\u0011\u0019*\u0001\u000bue\u0006t7O^3sg\u00164\u0015\u000e\u001c;feR\u0013X-\u001a\u000b\t\u0005\u000b\u0013)J!'\u0003.\"A!q\u0013BH\u0001\u0004\u0011y(\u0001\nqCJ,g\u000e\u001e*po.+\u0017PR5mi\u0016\u0014\b\u0002\u0003BN\u0005\u001f\u0003\rA!(\u0002\u0015Y\fG.^3BeJ\f\u0017\u0010\u0005\u0004\u0003 \n%&QE\u0007\u0003\u0005CSAAa)\u0003&\u00069Q.\u001e;bE2,'b\u0001BTG\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t-&\u0011\u0015\u0002\f\u001bV$\u0018M\u00197f\u0019&\u001cH\u000f\u0003\u0005\u00030\n=\u0005\u0019\u0001B7\u0003\u00191\u0017\u000e\u001c;fe\"I!1\u0017\u0001\u0002\u0002\u0013\u0005!QW\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u00038\nm&Q\u0018\u000b\u00043\ne\u0006B\u0002'\u00032\u0002\u0007a\n\u0003\u0005,\u0005c\u0003\n\u00111\u0001.\u0011!q$\u0011\u0017I\u0001\u0002\u0004\u0001\u0005\"\u0003Ba\u0001E\u0005I\u0011\u0001Bb\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!2+\u00075\u00129m\u000b\u0002\u0003JB!!1\u001aBk\u001b\t\u0011iM\u0003\u0003\u0003P\nE\u0017!C;oG\",7m[3e\u0015\r\u0011\u0019nI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bl\u0005\u001b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011Y\u000eAI\u0001\n\u0003\u0011i.\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t}'f\u0001!\u0003H\"I!1\u001d\u0001\u0002\u0002\u0013\u0005#Q]\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u001d\b\u0003\u0002Bu\u0005gl!Aa;\u000b\t\t5(q^\u0001\u0005Y\u0006twM\u0003\u0002\u0003r\u0006!!.\u0019<b\u0013\r1$1\u001e\u0005\n\u0005o\u0004\u0011\u0011!C\u0001\u0003/\nA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011Ba?\u0001\u0003\u0003%\tA!@\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0004B\u0000\u0011%\u0019\tA!?\u0002\u0002\u0003\u0007!/A\u0002yIEB\u0011b!\u0002\u0001\u0003\u0003%\tea\u0002\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0003\u0011\r\r-1Q\u0002B\u000e\u001b\t\u0011)+\u0003\u0003\u0004\u0010\t\u0015&\u0001C%uKJ\fGo\u001c:\t\u0013\rM\u0001!!A\u0005\u0002\rU\u0011\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e2q\u0003\u0005\u000b\u0007\u0003\u0019\t\"!AA\u0002\tm\u0001\"CB\u000e\u0001\u0005\u0005I\u0011IB\u000f\u0003!A\u0017m\u001d5D_\u0012,G#\u0001:\t\u0013\r\u0005\u0002!!A\u0005B\r\r\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\u001d\b\"CB\u0014\u0001\u0005\u0005I\u0011IB\u0015\u0003\u0019)\u0017/^1mgR!\u0011\u0011HB\u0016\u0011)\u0019\ta!\n\u0002\u0002\u0003\u0007!1\u0004\u0015\u0004\u0001\r=\u0002\u0003BB\u0019\u0007\u0003rAaa\r\u0004>5\u00111Q\u0007\u0006\u0005\u0007o\u0019I$\u0001\u0005bk\u0012LWM\\2f\u0015\r\u0019Y\u0004C\u0001\u0006s\u0016$Xo]\u0005\u0005\u0007\u007f\u0019)$A\tJ]R,'OZ1dK\u0006+H-[3oG\u0016LAaa\u0011\u0004F\t9\u0001K]5wCR,'\u0002BB \u0007k9\u0011b!\u0013\u0003\u0003\u0003E\taa\u0013\u0002\u001b!\u0013\u0015m]3SK2\fG/[8o!\rq2Q\n\u0004\t\u0003\t\t\t\u0011#\u0001\u0004PM)1QJB)OA\u0019!ea\u0015\n\u0007\rU3E\u0001\u0004B]f\u0014VM\u001a\u0005\b-\u000e5C\u0011AB-)\t\u0019Y\u0005\u0003\u0006\u0004\"\r5\u0013\u0011!C#\u0007GA!ba\u0018\u0004N\u0005\u0005I\u0011QB1\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0019\u0019g!\u001b\u0004nQ\u0019\u0011l!\u001a\t\r1\u001bi\u00061\u0001OQ\r\u0019)G\u000f\u0005\u0007W\ru\u0003\u0019A\u0017)\u0007\r%$\b\u0003\u0004?\u0007;\u0002\r\u0001\u0011\u0005\u000b\u0007c\u001ai%!A\u0005\u0002\u000eM\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0007k\u001aI\b\u0005\u0003#\u0003\u000e]\u0004#\u0002\u0012\u0002\u00006\u0002\u0005\"CB>\u0007_\n\t\u00111\u0001Z\u0003\rAH\u0005\r\u0005\u000b\u0007\u007f\u001ai%!A\u0005\n\r\u0005\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa!\u0011\t\t%8QQ\u0005\u0005\u0007\u000f\u0013YO\u0001\u0004PE*,7\r\u001e")
public class HBaseRelation
extends BaseRelation
implements PrunedFilteredScan,
InsertableRelation,
Logging,
Product,
Serializable {
    private final transient Map<String, String> parameters;
    private final Option<StructType> userSpecifiedSchema;
    private final transient SQLContext sqlContext;
    private final Option<Object> timestamp;
    private final Option<Object> minTimestamp;
    private final Option<Object> maxTimestamp;
    private final Option<Object> maxVersions;
    private final String encoderClsName;
    private final transient BytesEncoder encoder;
    private final HBaseTableCatalog catalog;
    private final String configResources;
    private final boolean useHBaseContext;
    private final boolean usePushDownColumnFilter;
    private final boolean blockCacheEnable;
    private final int cacheSize;
    private final int batchNum;
    private final int bulkGetSize;
    private final HBaseContext hbaseContext;
    private final SerializableConfiguration wrappedConf;
    private final StructType schema;
    private transient Logger org$apache$hadoop$hbase$spark$Logging$$log_;

    public static Option<Tuple2<Map<String, String>, Option<StructType>>> unapply(HBaseRelation hBaseRelation) {
        return HBaseRelation$.MODULE$.unapply(hBaseRelation);
    }

    public static HBaseRelation apply(Map<String, String> map, Option<StructType> option, SQLContext sQLContext) {
        return HBaseRelation$.MODULE$.apply(map, option, sQLContext);
    }

    @Override
    public Logger org$apache$hadoop$hbase$spark$Logging$$log_() {
        return this.org$apache$hadoop$hbase$spark$Logging$$log_;
    }

    @Override
    public void org$apache$hadoop$hbase$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$hadoop$hbase$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public void initializeLogging(boolean isInterpreter) {
        Logging$class.initializeLogging(this, isInterpreter);
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Option<Object> timestamp() {
        return this.timestamp;
    }

    public Option<Object> minTimestamp() {
        return this.minTimestamp;
    }

    public Option<Object> maxTimestamp() {
        return this.maxTimestamp;
    }

    public Option<Object> maxVersions() {
        return this.maxVersions;
    }

    public String encoderClsName() {
        return this.encoderClsName;
    }

    public BytesEncoder encoder() {
        return this.encoder;
    }

    public HBaseTableCatalog catalog() {
        return this.catalog;
    }

    public String tableName() {
        return this.catalog().name();
    }

    public String configResources() {
        return this.configResources;
    }

    public boolean useHBaseContext() {
        return this.useHBaseContext;
    }

    public boolean usePushDownColumnFilter() {
        return this.usePushDownColumnFilter;
    }

    public boolean blockCacheEnable() {
        return this.blockCacheEnable;
    }

    public int cacheSize() {
        return this.cacheSize;
    }

    public int batchNum() {
        return this.batchNum;
    }

    public int bulkGetSize() {
        return this.bulkGetSize;
    }

    public HBaseContext hbaseContext() {
        return this.hbaseContext;
    }

    public SerializableConfiguration wrappedConf() {
        return this.wrappedConf;
    }

    public Configuration hbaseConf() {
        return this.wrappedConf().value();
    }

    public StructType schema() {
        return this.schema;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createTable() {
        int numReg = BoxesRunTime.unboxToInt((Object)this.parameters().get((Object)HBaseTableCatalog$.MODULE$.newTable()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x) {
                return new StringOps(Predef$.MODULE$.augmentString(x)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
        byte[] startKey = Bytes.toBytes((String)((String)this.parameters().get((Object)HBaseTableCatalog$.MODULE$.regionStart()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return HBaseTableCatalog$.MODULE$.defaultRegionStart();
            }
        })));
        byte[] endKey = Bytes.toBytes((String)((String)this.parameters().get((Object)HBaseTableCatalog$.MODULE$.regionEnd()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return HBaseTableCatalog$.MODULE$.defaultRegionEnd();
            }
        })));
        if (numReg <= 3) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\n           |is not defined or no larger than 3, skip the create table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HBaseTableCatalog$.MODULE$.newTable()})))).stripMargin();
                }
            });
            return;
        }
        TableName tName = TableName.valueOf((String)this.catalog().name());
        Seq<String> cfs = this.catalog().getColumnFamilies();
        Connection connection = ConnectionFactory.createConnection((Configuration)this.hbaseConf());
        Admin admin = connection.getAdmin();
        try {
            if (!admin.isTableAvailable(tName)) {
                HTableDescriptor tableDesc = new HTableDescriptor(tName);
                cfs.foreach((Function1)new Serializable(this, tableDesc){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseRelation $outer;
                    private final HTableDescriptor tableDesc$1;

                    public final HTableDescriptor apply(String x) {
                        HColumnDescriptor cf = new HColumnDescriptor(x.getBytes());
                        this.$outer.logDebug((Function0<String>)new Serializable(this, x){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$createTable$1 $outer;
                            private final String x$29;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"add family ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x$29, this.$outer.org$apache$hadoop$hbase$spark$HBaseRelation$$anonfun$$$outer().catalog().name()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.x$29 = x$29;
                            }
                        });
                        return this.tableDesc$1.addFamily(cf);
                    }

                    public /* synthetic */ HBaseRelation org$apache$hadoop$hbase$spark$HBaseRelation$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tableDesc$1 = tableDesc$1;
                    }
                });
                byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)numReg);
                admin.createTable((TableDescriptor)tableDesc, splitKeys);
            }
        }
        catch (Throwable throwable) {
            void var6_6;
            void var7_7;
            var7_7.close();
            var6_6.close();
            throw throwable;
        }
        admin.close();
        connection.close();
    }

    public void insert(Dataset<Row> data, boolean overwrite) {
        JobConf jobConfig = new JobConf(this.hbaseConf(), this.getClass());
        jobConfig.setOutputFormat(TableOutputFormat.class);
        jobConfig.set("hbase.mapred.outputtable", this.catalog().name());
        IntRef count = IntRef.create((int)0);
        Seq<Field> rkFields = this.catalog().getRowKey();
        Seq rkIdxedFields = (Seq)rkFields.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final Tuple2<Object, Field> apply(Field x0$1) {
                Field field = x0$1;
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.$outer.schema().fieldIndex(field.colName())), (Object)field);
                return tuple2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2[] colsIdxedFields = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.schema().fieldNames()).partition((Function1)new Serializable(this, rkFields){
            public static final long serialVersionUID = 0L;
            private final Seq rkFields$1;

            public final boolean apply(String x) {
                return ((SeqLike)this.rkFields$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Field x$11) {
                        return x$11.colName();
                    }
                }, Seq$.MODULE$.canBuildFrom())).contains((Object)x);
            }
            {
                this.rkFields$1 = rkFields$1;
            }
        })._2()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final Tuple2<Object, Field> apply(String x) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.$outer.schema().fieldIndex(x)), (Object)this.$outer.catalog().getField(x));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        RDD rdd = data.rdd();
        RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1)new Serializable(this, count, rkIdxedFields, colsIdxedFields){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;
            private final IntRef count$1;
            private final Seq rkIdxedFields$1;
            private final Tuple2[] colsIdxedFields$1;

            public final Tuple2<ImmutableBytesWritable, Put> apply(Row x$13) {
                return this.$outer.org$apache$hadoop$hbase$spark$HBaseRelation$$convertToPut$1(x$13, this.count$1, this.rkIdxedFields$1, this.colsIdxedFields$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.count$1 = count$1;
                this.rkIdxedFields$1 = rkIdxedFields$1;
                this.colsIdxedFields$1 = colsIdxedFields$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(ImmutableBytesWritable.class), ClassTag$.MODULE$.apply(Put.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).saveAsHadoopDataset(jobConfig);
    }

    public Seq<Tuple2<Field, Object>> getIndexedProjections(String[] requiredColumns) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final Field apply(String x$14) {
                return this.$outer.catalog().sMap().getField(x$14);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class)))).zipWithIndex(Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Map<Field, Object> parseRowKey(byte[] row, Seq<Field> keyFields) {
        return ((TraversableOnce)((Tuple2)keyFields.foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Function2)new Serializable(this, row){
            public static final long serialVersionUID = 0L;
            private final byte[] row$2;

            public final Tuple2<Object, Seq<Tuple2<Field, Object>>> apply(Tuple2<Object, Seq<Tuple2<Field, Object>>> state, Field field) {
                Tuple2 tuple2;
                int idx = state._1$mcI$sp();
                Seq parsed = (Seq)state._2();
                if (field.length() != -1) {
                    Object value = Utils$.MODULE$.hbaseFieldToScalaType(field, this.row$2, idx, field.length());
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(idx + field.length())), parsed.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)field, value)})), Seq$.MODULE$.canBuildFrom()));
                } else {
                    Tuple2 tuple22;
                    DataType dataType = field.dt();
                    if (StringType$.MODULE$.equals(dataType)) {
                        Tuple2 tuple23;
                        int pos = Predef$.MODULE$.byteArrayOps(this.row$2).indexOf((Object)BoxesRunTime.boxToByte((byte)HBaseTableCatalog$.MODULE$.delimiter()), idx);
                        if (pos == -1 || pos > this.row$2.length) {
                            Object value = Utils$.MODULE$.hbaseFieldToScalaType(field, this.row$2, idx, this.row$2.length);
                            tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(this.row$2.length + 1)), parsed.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)field, value)})), Seq$.MODULE$.canBuildFrom()));
                        } else {
                            Object value = Utils$.MODULE$.hbaseFieldToScalaType(field, this.row$2, idx, pos - idx);
                            tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)pos), parsed.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)field, value)})), Seq$.MODULE$.canBuildFrom()));
                        }
                        tuple22 = tuple23;
                    } else {
                        tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(this.row$2.length + 1)), parsed.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)field, Utils$.MODULE$.hbaseFieldToScalaType(field, this.row$2, idx, this.row$2.length))})), Seq$.MODULE$.canBuildFrom()));
                    }
                    tuple2 = tuple22;
                }
                return tuple2;
            }
            {
                this.row$2 = row$2;
            }
        }))._2()).toMap(Predef$.MODULE$.$conforms());
    }

    public Row buildRow(Seq<Field> fields, Result result) {
        byte[] r = result.getRow();
        Map<Field, Object> keySeq = this.parseRowKey(r, this.catalog().getRowKey());
        Map valueSeq = ((TraversableOnce)((TraversableLike)fields.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Field x$15) {
                return !x$15.isRowKey();
            }
        })).map((Function1)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final Result result$1;

            public final Tuple2<Field, Object> apply(Field x) {
                Tuple2 tuple2;
                Cell kv = this.result$1.getColumnLatestCell(Bytes.toBytes((String)x.cf()), Bytes.toBytes((String)x.col()));
                if (kv == null || kv.getValueLength() == 0) {
                    tuple2 = new Tuple2((Object)x, null);
                } else {
                    byte[] v = CellUtil.cloneValue((Cell)kv);
                    DataType dataType = x.dt();
                    Object object = BinaryType$.MODULE$.equals(dataType) ? v : (Object)Utils$.MODULE$.hbaseFieldToScalaType(x, v, 0, v.length);
                    Tuple2 tuple22 = new Tuple2((Object)x, object);
                    tuple2 = tuple22;
                }
                return tuple2;
            }
            {
                this.result$1 = result$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map unionedRow = keySeq.$plus$plus((GenTraversableOnce)valueSeq);
        return Row$.MODULE$.fromSeq((Seq)fields.map((Function1)new Serializable(this, unionedRow){
            public static final long serialVersionUID = 0L;
            private final Map unionedRow$1;

            public final Object apply(Field x$16) {
                return this.unionedRow$1.get((Object)x$16).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
            }
            {
                this.unionedRow$1 = unionedRow$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        RDD resultRDD;
        Tuple3<RowKeyFilter, DynamicLogicExpression, byte[][]> pushDownTuple = this.buildPushDownPredicatesResource(filters);
        RowKeyFilter pushDownRowKeyFilter = (RowKeyFilter)pushDownTuple._1();
        ObjectRef pushDownDynamicLogicExpression = ObjectRef.create((Object)((DynamicLogicExpression)pushDownTuple._2()));
        byte[][] valueArray = (byte[][])pushDownTuple._3();
        if (!this.usePushDownColumnFilter()) {
            pushDownDynamicLogicExpression.elem = null;
        }
        this.logDebug((Function0<String>)new Serializable(this, pushDownRowKeyFilter){
            public static final long serialVersionUID = 0L;
            private final RowKeyFilter pushDownRowKeyFilter$1;

            public final String apply() {
                return new StringBuilder().append((Object)"pushDownRowKeyFilter:           ").append(this.pushDownRowKeyFilter$1.ranges()).toString();
            }
            {
                this.pushDownRowKeyFilter$1 = pushDownRowKeyFilter$1;
            }
        });
        if ((DynamicLogicExpression)pushDownDynamicLogicExpression.elem != null) {
            this.logDebug((Function0<String>)new Serializable(this, pushDownDynamicLogicExpression){
                public static final long serialVersionUID = 0L;
                private final ObjectRef pushDownDynamicLogicExpression$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"pushDownDynamicLogicExpression: ").append((Object)((DynamicLogicExpression)this.pushDownDynamicLogicExpression$1.elem).toExpressionString()).toString();
                }
                {
                    this.pushDownDynamicLogicExpression$1 = pushDownDynamicLogicExpression$1;
                }
            });
        }
        this.logDebug((Function0<String>)new Serializable(this, valueArray){
            public static final long serialVersionUID = 0L;
            private final byte[][] valueArray$1;

            public final String apply() {
                return new StringBuilder().append((Object)"valueArray:                     ").append((Object)BoxesRunTime.boxToInteger((int)this.valueArray$1.length)).toString();
            }
            {
                this.valueArray$1 = valueArray$1;
            }
        });
        MutableList requiredQualifierDefinitionList = new MutableList();
        Predef$.MODULE$.refArrayOps((Object[])requiredColumns).foreach((Function1)new Serializable(this, requiredQualifierDefinitionList){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;
            private final MutableList requiredQualifierDefinitionList$1;

            public final MutableList<Field> apply(String c) {
                Field field = this.$outer.catalog().getField(c);
                return this.requiredQualifierDefinitionList$1.$plus$eq((Object)field);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requiredQualifierDefinitionList$1 = requiredQualifierDefinitionList$1;
            }
        });
        DefaultSourceStaticUtils$.MODULE$.populateLatestExecutionRules(pushDownRowKeyFilter, (DynamicLogicExpression)pushDownDynamicLogicExpression.elem);
        ArrayList getList = new ArrayList();
        ArrayList rddList = new ArrayList();
        pushDownRowKeyFilter.points().foreach((Function1)new Serializable(this, requiredQualifierDefinitionList, getList){
            public static final long serialVersionUID = 0L;
            private final MutableList requiredQualifierDefinitionList$1;
            private final ArrayList getList$1;

            public final boolean apply(byte[] p) {
                Get get2 = new Get(p);
                this.requiredQualifierDefinitionList$1.foreach((Function1)new Serializable(this, get2){
                    public static final long serialVersionUID = 0L;
                    private final Get get$1;

                    public final Object apply(Field d) {
                        return d.isRowKey() ? this.get$1.addColumn(d.cfBytes(), d.colBytes()) : BoxedUnit.UNIT;
                    }
                    {
                        this.get$1 = get$1;
                    }
                });
                return this.getList$1.add(get2);
            }
            {
                this.requiredQualifierDefinitionList$1 = requiredQualifierDefinitionList$1;
                this.getList$1 = getList$1;
            }
        });
        None$ pushDownFilterJava = this.usePushDownColumnFilter() && (DynamicLogicExpression)pushDownDynamicLogicExpression.elem != null ? new Some((Object)new SparkSQLPushDownFilter((DynamicLogicExpression)pushDownDynamicLogicExpression.elem, valueArray, (MutableList<Field>)requiredQualifierDefinitionList, this.encoderClsName())) : None$.MODULE$;
        HBaseTableScanRDD hRdd = new HBaseTableScanRDD(this, this.hbaseContext(), (Option<SparkSQLPushDownFilter>)pushDownFilterJava, (Seq<Field>)requiredQualifierDefinitionList.seq());
        pushDownRowKeyFilter.points().foreach((Function1)new Serializable(this, hRdd){
            public static final long serialVersionUID = 0L;
            private final HBaseTableScanRDD hRdd$1;

            public final void apply(byte[] x$17) {
                this.hRdd$1.addPoint(x$17);
            }
            {
                this.hRdd$1 = hRdd$1;
            }
        });
        pushDownRowKeyFilter.ranges().foreach((Function1)new Serializable(this, hRdd){
            public static final long serialVersionUID = 0L;
            private final HBaseTableScanRDD hRdd$1;

            public final void apply(ScanRange x$18) {
                this.hRdd$1.addRange(x$18);
            }
            {
                this.hRdd$1 = hRdd$1;
            }
        });
        RDD tmp = hRdd.map((Function1)new Serializable(this, requiredColumns){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;
            private final String[] requiredColumns$1;

            public final Row apply(Result r) {
                Seq indexedFields = (Seq)this.$outer.getIndexedProjections(this.requiredColumns$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Field apply(Tuple2<Field, Object> x$19) {
                        return (Field)x$19._1();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                return this.$outer.buildRow((Seq<Field>)indexedFields, r);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requiredColumns$1 = requiredColumns$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        Object object = resultRDD = Predef$.MODULE$.refArrayOps((Object[])tmp.partitions()).size() > 0 ? tmp : null;
        if (resultRDD == null) {
            RDD rdd;
            Scan scan = new Scan();
            scan.setCacheBlocks(this.blockCacheEnable());
            scan.setBatch(this.batchNum());
            scan.setCaching(this.cacheSize());
            requiredQualifierDefinitionList.foreach((Function1)new Serializable(this, scan){
                public static final long serialVersionUID = 0L;
                private final Scan scan$1;

                public final Scan apply(Field d) {
                    return this.scan$1.addColumn(d.cfBytes(), d.colBytes());
                }
                {
                    this.scan$1 = scan$1;
                }
            });
            resultRDD = rdd = this.hbaseContext().hbaseRDD(TableName.valueOf((String)this.tableName()), scan).map((Function1)new Serializable(this, requiredColumns){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HBaseRelation $outer;
                private final String[] requiredColumns$1;

                public final Row apply(Tuple2<ImmutableBytesWritable, Result> r) {
                    Seq indexedFields = (Seq)this.$outer.getIndexedProjections(this.requiredColumns$1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Field apply(Tuple2<Field, Object> x$20) {
                            return (Field)x$20._1();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return this.$outer.buildRow((Seq<Field>)indexedFields, (Result)r._2());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.requiredColumns$1 = requiredColumns$1;
                }
            }, ClassTag$.MODULE$.apply(Row.class));
        }
        return resultRDD;
    }

    public Tuple3<RowKeyFilter, DynamicLogicExpression, byte[][]> buildPushDownPredicatesResource(Filter[] filters) {
        ObjectRef superRowKeyFilter = ObjectRef.create(null);
        MutableList queryValueList = new MutableList();
        ObjectRef superDynamicLogicExpression = ObjectRef.create(null);
        Predef$.MODULE$.refArrayOps((Object[])filters).foreach((Function1)new Serializable(this, superRowKeyFilter, queryValueList, superDynamicLogicExpression){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;
            private final ObjectRef superRowKeyFilter$1;
            private final MutableList queryValueList$1;
            private final ObjectRef superDynamicLogicExpression$1;

            public final Object apply(Filter f) {
                Object object;
                RowKeyFilter rowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                DynamicLogicExpression logicExpression = this.$outer.transverseFilterTree(rowKeyFilter, (MutableList<byte[]>)this.queryValueList$1, f);
                if ((DynamicLogicExpression)this.superDynamicLogicExpression$1.elem == null) {
                    this.superDynamicLogicExpression$1.elem = logicExpression;
                    this.superRowKeyFilter$1.elem = rowKeyFilter;
                    object = BoxedUnit.UNIT;
                } else {
                    this.superDynamicLogicExpression$1.elem = new AndLogicExpression((DynamicLogicExpression)this.superDynamicLogicExpression$1.elem, logicExpression);
                    object = ((RowKeyFilter)this.superRowKeyFilter$1.elem).mergeIntersect(rowKeyFilter);
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.superRowKeyFilter$1 = superRowKeyFilter$1;
                this.queryValueList$1 = queryValueList$1;
                this.superDynamicLogicExpression$1 = superDynamicLogicExpression$1;
            }
        });
        byte[][] queryValueArray = (byte[][])queryValueList.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        if ((RowKeyFilter)superRowKeyFilter.elem == null) {
            superRowKeyFilter.elem = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
        }
        return new Tuple3((Object)((RowKeyFilter)superRowKeyFilter.elem), (Object)((DynamicLogicExpression)superDynamicLogicExpression.elem), (Object)queryValueArray);
    }

    public DynamicLogicExpression transverseFilterTree(RowKeyFilter parentRowKeyFilter, MutableList<byte[]> valueArray, Filter filter) {
        DynamicLogicExpression dynamicLogicExpression;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            BoxedUnit boxedUnit;
            EqualTo equalTo = (EqualTo)filter2;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Object object = field.isRowKey() ? parentRowKeyFilter.mergeIntersect(new RowKeyFilter(DefaultSourceStaticUtils$.MODULE$.getByteValue(field, value.toString()), null, RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4())) : BoxedUnit.UNIT;
                byte[] byteValue = DefaultSourceStaticUtils$.MODULE$.getByteValue(field, value.toString());
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new EqualLogicExpression(attr, valueArray.length() - 1, false);
        } else if (filter2 instanceof LessThan) {
            BoxedUnit boxedUnit;
            LessThan lessThan = (LessThan)filter2;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit2;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    BooleanRef inc = BooleanRef.create((boolean)false);
                    boxedUnit2 = b.map((Function1)new Serializable(this, inc){
                        public static final long serialVersionUID = 0L;
                        public final BooleanRef inc$1;

                        public final RowKeyFilter[] apply(BoundRanges x$21) {
                            return (RowKeyFilter[])Predef$.MODULE$.refArrayOps((Object[])x$21.less()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$transverseFilterTree$1 $outer;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final RowKeyFilter apply(BoundRange x) {
                                    void var2_2;
                                    RowKeyFilter r = new RowKeyFilter(null, new ScanRange(x.upper(), this.$outer.inc$1.elem, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                                    this.$outer.inc$1.elem = true;
                                    return var2_2;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)));
                        }
                        {
                            this.inc$1 = inc$1;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter apply(RowKeyFilter[] x) {
                            return (RowKeyFilter)Predef$.MODULE$.refArrayOps((Object[])x).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(RowKeyFilter i, RowKeyFilter j) {
                                    return i.mergeUnion(j);
                                }
                            });
                        }
                    }).map((Function1)new Serializable(this, parentRowKeyFilter){
                        public static final long serialVersionUID = 0L;
                        private final RowKeyFilter parentRowKeyFilter$1;

                        public final RowKeyFilter apply(RowKeyFilter x$22) {
                            return this.parentRowKeyFilter$1.mergeIntersect(x$22);
                        }
                        {
                            this.parentRowKeyFilter$1 = parentRowKeyFilter$1;
                        }
                    });
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new LessThanLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof GreaterThan) {
            BoxedUnit boxedUnit;
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit3;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    BooleanRef inc = BooleanRef.create((boolean)false);
                    boxedUnit3 = b.map((Function1)new Serializable(this, inc){
                        public static final long serialVersionUID = 0L;
                        public final BooleanRef inc$2;

                        public final RowKeyFilter[] apply(BoundRanges x$23) {
                            return (RowKeyFilter[])Predef$.MODULE$.refArrayOps((Object[])x$23.greater()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$transverseFilterTree$4 $outer;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final RowKeyFilter apply(BoundRange x) {
                                    void var2_2;
                                    RowKeyFilter r = new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), this.$outer.inc$2.elem), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                                    this.$outer.inc$2.elem = true;
                                    return var2_2;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)));
                        }
                        {
                            this.inc$2 = inc$2;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter apply(RowKeyFilter[] x) {
                            return (RowKeyFilter)Predef$.MODULE$.refArrayOps((Object[])x).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(RowKeyFilter i, RowKeyFilter j) {
                                    return i.mergeUnion(j);
                                }
                            });
                        }
                    }).map((Function1)new Serializable(this, parentRowKeyFilter){
                        public static final long serialVersionUID = 0L;
                        private final RowKeyFilter parentRowKeyFilter$1;

                        public final RowKeyFilter apply(RowKeyFilter x$24) {
                            return this.parentRowKeyFilter$1.mergeIntersect(x$24);
                        }
                        {
                            this.parentRowKeyFilter$1 = parentRowKeyFilter$1;
                        }
                    });
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new GreaterThanLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof LessThanOrEqual) {
            BoxedUnit boxedUnit;
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit4;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    boxedUnit4 = b.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter[] apply(BoundRanges x$25) {
                            return (RowKeyFilter[])Predef$.MODULE$.refArrayOps((Object[])x$25.less()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(BoundRange x) {
                                    return new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)));
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter apply(RowKeyFilter[] x) {
                            return (RowKeyFilter)Predef$.MODULE$.refArrayOps((Object[])x).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(RowKeyFilter i, RowKeyFilter j) {
                                    return i.mergeUnion(j);
                                }
                            });
                        }
                    }).map((Function1)new Serializable(this, parentRowKeyFilter){
                        public static final long serialVersionUID = 0L;
                        private final RowKeyFilter parentRowKeyFilter$1;

                        public final RowKeyFilter apply(RowKeyFilter x$26) {
                            return this.parentRowKeyFilter$1.mergeIntersect(x$26);
                        }
                        {
                            this.parentRowKeyFilter$1 = parentRowKeyFilter$1;
                        }
                    });
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new LessThanOrEqualLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof GreaterThanOrEqual) {
            BoxedUnit boxedUnit;
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit5;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    boxedUnit5 = b.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter[] apply(BoundRanges x$27) {
                            return (RowKeyFilter[])Predef$.MODULE$.refArrayOps((Object[])x$27.greater()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(BoundRange x) {
                                    return new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)));
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter apply(RowKeyFilter[] x) {
                            return (RowKeyFilter)Predef$.MODULE$.refArrayOps((Object[])x).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(RowKeyFilter i, RowKeyFilter j) {
                                    return i.mergeUnion(j);
                                }
                            });
                        }
                    }).map((Function1)new Serializable(this, parentRowKeyFilter){
                        public static final long serialVersionUID = 0L;
                        private final RowKeyFilter parentRowKeyFilter$1;

                        public final RowKeyFilter apply(RowKeyFilter x$28) {
                            return this.parentRowKeyFilter$1.mergeIntersect(x$28);
                        }
                        {
                            this.parentRowKeyFilter$1 = parentRowKeyFilter$1;
                        }
                    });
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new GreaterThanOrEqualLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            DynamicLogicExpression leftExpression = this.transverseFilterTree(parentRowKeyFilter, valueArray, left);
            RowKeyFilter rightSideRowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
            DynamicLogicExpression rightExpression = this.transverseFilterTree(rightSideRowKeyFilter, valueArray, right);
            parentRowKeyFilter.mergeUnion(rightSideRowKeyFilter);
            dynamicLogicExpression = new OrLogicExpression(leftExpression, rightExpression);
        } else if (filter2 instanceof And) {
            And and2 = (And)filter2;
            Filter left = and2.left();
            Filter right = and2.right();
            DynamicLogicExpression leftExpression = this.transverseFilterTree(parentRowKeyFilter, valueArray, left);
            RowKeyFilter rightSideRowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
            DynamicLogicExpression rightExpression = this.transverseFilterTree(rightSideRowKeyFilter, valueArray, right);
            parentRowKeyFilter.mergeIntersect(rightSideRowKeyFilter);
            dynamicLogicExpression = new AndLogicExpression(leftExpression, rightExpression);
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attr = isNull.attribute();
            dynamicLogicExpression = new IsNullLogicExpression(attr, false);
        } else if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attr = isNotNull.attribute();
            dynamicLogicExpression = new IsNullLogicExpression(attr, true);
        } else {
            dynamicLogicExpression = new PassThroughLogicExpression();
        }
        return dynamicLogicExpression;
    }

    public HBaseRelation copy(Map<String, String> parameters, Option<StructType> userSpecifiedSchema, SQLContext sqlContext) {
        return new HBaseRelation(parameters, userSpecifiedSchema, sqlContext);
    }

    public Map<String, String> copy$default$1() {
        return this.parameters();
    }

    public Option<StructType> copy$default$2() {
        return this.userSpecifiedSchema();
    }

    public String productPrefix() {
        return "HBaseRelation";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<StructType> option;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                option = this.userSpecifiedSchema();
                break;
            }
            case 0: {
                option = this.parameters();
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HBaseRelation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HBaseRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        HBaseRelation hBaseRelation = (HBaseRelation)x$1;
        Map<String, String> map = this.parameters();
        Map<String, String> map2 = hBaseRelation.parameters();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<StructType> option = this.userSpecifiedSchema();
        Option<StructType> option2 = hBaseRelation.userSpecifiedSchema();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!hBaseRelation.canEqual(this)) return false;
        return true;
    }

    public final Tuple2 org$apache$hadoop$hbase$spark$HBaseRelation$$convertToPut$1(Row row, IntRef count$1, Seq rkIdxedFields$1, Tuple2[] colsIdxedFields$1) {
        Seq rowBytes = (Seq)rkIdxedFields$1.map((Function1)new Serializable(this, row){
            public static final long serialVersionUID = 0L;
            private final Row row$1;

            public final byte[] apply(Tuple2<Object, Field> x0$2) {
                Tuple2<Object, Field> tuple2 = x0$2;
                if (tuple2 != null) {
                    int x = tuple2._1$mcI$sp();
                    Field y = (Field)tuple2._2();
                    byte[] byArray = Utils$.MODULE$.toBytes(this.row$1.apply(x), y);
                    return byArray;
                }
                throw new MatchError(tuple2);
            }
            {
                this.row$1 = row$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        int rLen = BoxesRunTime.unboxToInt((Object)rowBytes.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x0$3, byte[] x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$3), (Object)x1$1);
                if (tuple2 != null) {
                    int x = tuple2._1$mcI$sp();
                    byte[] y = (byte[])tuple2._2();
                    int n = x + y.length;
                    return n;
                }
                throw new MatchError((Object)tuple2);
            }
        }));
        byte[] rBytes = new byte[rLen];
        IntRef offset = IntRef.create((int)0);
        rowBytes.foreach((Function1)new Serializable(this, rBytes, offset){
            public static final long serialVersionUID = 0L;
            private final byte[] rBytes$1;
            private final IntRef offset$1;

            public final void apply(byte[] x) {
                System.arraycopy(x, 0, this.rBytes$1, this.offset$1.elem, x.length);
                this.offset$1.elem += x.length;
            }
            {
                this.rBytes$1 = rBytes$1;
                this.offset$1 = offset$1;
            }
        });
        Put put = (Put)this.timestamp().fold((Function0)new Serializable(this, rBytes){
            public static final long serialVersionUID = 0L;
            private final byte[] rBytes$1;

            public final Put apply() {
                return new Put(this.rBytes$1);
            }
            {
                this.rBytes$1 = rBytes$1;
            }
        }, (Function1)new Serializable(this, rBytes){
            public static final long serialVersionUID = 0L;
            private final byte[] rBytes$1;

            public final Put apply(long x$12) {
                return new Put(this.rBytes$1, x$12);
            }
            {
                this.rBytes$1 = rBytes$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])colsIdxedFields$1).foreach((Function1)new Serializable(this, row, put){
            public static final long serialVersionUID = 0L;
            private final Row row$1;
            private final Put put$1;

            public final Put apply(Tuple2<Object, Field> x0$4) {
                Tuple2<Object, Field> tuple2 = x0$4;
                if (tuple2 != null) {
                    int x = tuple2._1$mcI$sp();
                    Field y = (Field)tuple2._2();
                    byte[] b = Utils$.MODULE$.toBytes(this.row$1.apply(x), y);
                    Put put = this.put$1.addColumn(Bytes.toBytes((String)y.cf()), Bytes.toBytes((String)y.col()), b);
                    return put;
                }
                throw new MatchError(tuple2);
            }
            {
                this.row$1 = row$1;
                this.put$1 = put$1;
            }
        });
        ++count$1.elem;
        return new Tuple2((Object)new ImmutableBytesWritable(), (Object)put);
    }

    public HBaseRelation(Map<String, String> parameters, Option<StructType> userSpecifiedSchema, SQLContext sqlContext) {
        HBaseContext hBaseContext;
        this.parameters = parameters;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.sqlContext = sqlContext;
        Logging$class.$init$(this);
        Product.class.$init$((Product)this);
        this.timestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.TIMESTAMP()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
            }
        });
        this.minTimestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.MIN_TIMESTAMP()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
            }
        });
        this.maxTimestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.MAX_TIMESTAMP()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
            }
        });
        this.maxVersions = parameters.get((Object)HBaseSparkConf$.MODULE$.MAX_VERSIONS()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
            }
        });
        this.encoderClsName = (String)parameters.get((Object)HBaseSparkConf$.MODULE$.ENCODER()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return HBaseSparkConf$.MODULE$.defaultEncoder();
            }
        });
        this.encoder = JavaBytesEncoder$.MODULE$.create(this.encoderClsName());
        this.catalog = HBaseTableCatalog$.MODULE$.apply(parameters);
        this.configResources = (String)parameters.getOrElse((Object)HBaseSparkConf$.MODULE$.HBASE_CONFIG_RESOURCES_LOCATIONS(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        this.useHBaseContext = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.USE_HBASE_CONTEXT()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
        this.usePushDownColumnFilter = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.PUSH_DOWN_COLUMN_FILTER()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
        this.blockCacheEnable = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.BLOCK_CACHE_ENABLE()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return new StringOps(Predef$.MODULE$.augmentString(x$7)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.sqlContext().sparkContext().getConf().getBoolean(HBaseSparkConf$.MODULE$.BLOCK_CACHE_ENABLE(), HBaseSparkConf$.MODULE$.defaultBlockCacheEnable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.cacheSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.CACHE_SIZE()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$8) {
                return new StringOps(Predef$.MODULE$.augmentString(x$8)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.sqlContext().sparkContext().getConf().getInt(HBaseSparkConf$.MODULE$.CACHE_SIZE(), HBaseSparkConf$.MODULE$.defaultCachingSize());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.batchNum = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.BATCH_NUM()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$9) {
                return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.sqlContext().sparkContext().getConf().getInt(HBaseSparkConf$.MODULE$.BATCH_NUM(), HBaseSparkConf$.MODULE$.defaultBatchNum());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.bulkGetSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.BULKGET_SIZE()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$10) {
                return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.sqlContext().sparkContext().getConf().getInt(HBaseSparkConf$.MODULE$.BULKGET_SIZE(), HBaseSparkConf$.MODULE$.defaultBulkGetSize());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        if (this.useHBaseContext()) {
            hBaseContext = LatestHBaseContextCache$.MODULE$.latest();
        } else {
            Configuration config = HBaseConfiguration.create();
            Predef$.MODULE$.refArrayOps((Object[])this.configResources().split(",")).foreach((Function1)new Serializable(this, config){
                public static final long serialVersionUID = 0L;
                private final Configuration config$1;

                public final void apply(String r) {
                    this.config$1.addResource(r);
                }
                {
                    this.config$1 = config$1;
                }
            });
            hBaseContext = new HBaseContext(sqlContext.sparkContext(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
        }
        this.hbaseContext = hBaseContext;
        this.wrappedConf = new SerializableConfiguration(this.hbaseContext().config());
        this.schema = (StructType)userSpecifiedSchema.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final StructType apply() {
                return this.$outer.catalog().toDataType();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

