/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestVerifyReplication
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVerifyReplication.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestVerifyReplication.class);
    private static final String PEER_ID = "2";
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        this.cleanUp();
    }

    private void runVerifyReplication(String[] args, int expectedGoodRows, int expectedBadRows) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = new VerifyReplication().createSubmittableJob(new Configuration(conf1), args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)expectedGoodRows, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)expectedBadRows, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
    }

    @Test
    public void testVerifyRepJob() throws Exception {
        TestVerifyReplication.runSmallBatchTest();
        String[] args = new String[]{PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 100, 0);
        Scan scan = new Scan();
        ResultScanner rs = htable2.getScanner(scan);
        Put put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            Cell firstVal = result.rawCells()[0];
            put.addColumn(CellUtil.cloneFamily((Cell)firstVal), CellUtil.cloneQualifier((Cell)firstVal), Bytes.toBytes((String)"diff data"));
            htable2.put(put);
        }
        Delete delete = new Delete(put.getRow());
        htable2.delete(delete);
        this.runVerifyReplication(args, 0, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVerifyRepJobWithRawOptions() throws Exception {
        LOG.info(this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] familyname = Bytes.toBytes((String)"fam_raw");
        byte[] row = Bytes.toBytes((String)"row_raw");
        Table lHtable1 = null;
        Table lHtable2 = null;
        try {
            ColumnFamilyDescriptor fam = ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyname).setMaxVersions(100).setScope(1).build();
            TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(fam).build();
            scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
            for (ColumnFamilyDescriptor columnFamilyDescriptor : table.getColumnFamilies()) {
                scopes.put(columnFamilyDescriptor.getName(), columnFamilyDescriptor.getScope());
            }
            Connection connection1 = ConnectionFactory.createConnection((Configuration)conf1);
            Connection connection2 = ConnectionFactory.createConnection((Configuration)conf2);
            Throwable throwable = null;
            try (Admin admin1 = connection1.getAdmin();){
                admin1.createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            Throwable throwable4 = null;
            try (Admin admin2 = connection2.getAdmin();){
                admin2.createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                throw throwable5;
            }
            utility1.waitUntilAllRegionsAssigned(tableName);
            utility2.waitUntilAllRegionsAssigned(tableName);
            lHtable1 = utility1.getConnection().getTable(tableName);
            lHtable2 = utility2.getConnection().getTable(tableName);
            Put put = new Put(row);
            put.addColumn(familyname, row, row);
            lHtable1.put(put);
            Get get = new Get(row);
            for (int i = 0; i < 50; ++i) {
                Result res;
                if (i == 49) {
                    Assert.fail((String)"Waited too much time for put replication");
                }
                if (!(res = lHtable2.get(get)).isEmpty()) {
                    Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                    break;
                }
                LOG.info("Row not available");
                Thread.sleep(500L);
            }
            Delete del = new Delete(row);
            lHtable1.delete(del);
            Get get2 = new Get(row);
            for (int i = 0; i < 50; ++i) {
                Result res;
                if (i == 49) {
                    Assert.fail((String)"Waited too much time for del replication");
                }
                if ((res = lHtable2.get(get2)).size() < 1) break;
                LOG.info("Row not deleted");
                Thread.sleep(500L);
            }
            String[] argsWithoutRaw = new String[]{PEER_ID, tableName.getNameAsString()};
            this.runVerifyReplication(argsWithoutRaw, 0, 0);
            String[] argsWithRawAsTrue = new String[]{"--raw", PEER_ID, tableName.getNameAsString()};
            this.runVerifyReplication(argsWithRawAsTrue, 1, 0);
        }
        finally {
            if (lHtable1 != null) {
                lHtable1.close();
            }
            if (lHtable2 != null) {
                lHtable2.close();
            }
        }
    }

    @Test
    public void testHBase14905() throws Exception {
        byte[] qualifierName = Bytes.toBytes((String)"f1");
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1002"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1001"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1112"));
        htable1.put(put);
        Scan scan = new Scan();
        scan.readVersions(100);
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(1);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        for (int i = 0; i < 50; ++i) {
            scan = new Scan();
            scan.readVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(1);
            scanner1.close();
            if (res1.length != 1) {
                LOG.info("Only got " + res1.length + " rows");
                Thread.sleep(500L);
            } else {
                int cellNumber = res1[0].getColumnCells(famName, Bytes.toBytes((String)"f1")).size();
                if (cellNumber == 3) break;
                LOG.info("Only got " + cellNumber + " cells");
                Thread.sleep(500L);
            }
            if (i != 49) continue;
            Assert.fail((String)"Waited too much time for normal batch replication");
        }
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1111"));
        htable2.put(put);
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1112"));
        htable2.put(put);
        scan = new Scan();
        scan.readVersions(100);
        scanner1 = htable2.getScanner(scan);
        res1 = scanner1.next(100);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)5L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        String[] args = new String[]{"--versions=100", PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVersionMismatchHBase14905() throws Exception {
        byte[] qualifierName = Bytes.toBytes((String)"f1");
        Put put = new Put(Bytes.toBytes((String)"r1"));
        long ts = System.currentTimeMillis();
        put.addColumn(famName, qualifierName, ts + 1L, Bytes.toBytes((String)"v1"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 2L, Bytes.toBytes((String)"v2"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 3L, Bytes.toBytes((String)"v3"));
        htable1.put(put);
        Scan scan = new Scan();
        scan.readVersions(100);
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(1);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        for (int i = 0; i < 50; ++i) {
            scan = new Scan();
            scan.readVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(1);
            scanner1.close();
            if (res1.length != 1) {
                LOG.info("Only got " + res1.length + " rows");
                Thread.sleep(500L);
            } else {
                int cellNumber = res1[0].getColumnCells(famName, Bytes.toBytes((String)"f1")).size();
                if (cellNumber == 3) break;
                LOG.info("Only got " + cellNumber + " cells");
                Thread.sleep(500L);
            }
            if (i != 49) continue;
            Assert.fail((String)"Waited too much time for normal batch replication");
        }
        try {
            hbaseAdmin.disableReplicationPeer(PEER_ID);
            Put put2 = new Put(Bytes.toBytes((String)"r1"));
            put2.addColumn(famName, qualifierName, ts + 2L, Bytes.toBytes((String)"v99"));
            htable2.put(put2);
            scan = new Scan();
            scan.readVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(100);
            scanner1.close();
            Assert.assertEquals((long)1L, (long)res1.length);
            Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
            String[] args = new String[]{"--versions=100", PEER_ID, tableName.getNameAsString()};
            this.runVerifyReplication(args, 0, 1);
        }
        finally {
            hbaseAdmin.enableReplicationPeer(PEER_ID);
        }
    }

    @Test
    public void testVerifyReplicationPrefixFiltering() throws Exception {
        byte[] prefixRow = Bytes.toBytes((String)"prefixrow");
        byte[] prefixRow2 = Bytes.toBytes((String)"secondrow");
        TestVerifyReplication.loadData((String)"prefixrow", (byte[])prefixRow);
        TestVerifyReplication.loadData((String)"secondrow", (byte[])prefixRow2);
        TestVerifyReplication.loadData((String)"aaa", (byte[])row);
        TestVerifyReplication.loadData((String)"zzz", (byte[])row);
        TestVerifyReplication.waitForReplication((int)400, (int)200);
        String[] args = new String[]{"--row-prefixes=prefixrow,secondrow", PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 200, 0);
    }

    @Test
    public void testVerifyReplicationSnapshotArguments() {
        Object[] args = new String[]{"--sourceSnapshotName=snapshot1", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--sourceSnapshotTmpDir=tmp", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--sourceSnapshotName=snapshot1", "--sourceSnapshotTmpDir=tmp", PEER_ID, tableName.getNameAsString()};
        Assert.assertTrue((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--peerSnapshotName=snapshot1", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--peerSnapshotTmpDir=/tmp/", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--peerSnapshotName=snapshot1", "--peerSnapshotTmpDir=/tmp/", "--peerFSAddress=tempfs", "--peerHBaseRootAddress=hdfs://tempfs:50070/hbase/", PEER_ID, tableName.getNameAsString()};
        Assert.assertTrue((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--sourceSnapshotName=snapshot1", "--sourceSnapshotTmpDir=/tmp/", "--peerSnapshotName=snapshot2", "--peerSnapshotTmpDir=/tmp/", "--peerFSAddress=tempfs", "--peerHBaseRootAddress=hdfs://tempfs:50070/hbase/", PEER_ID, tableName.getNameAsString()};
        Assert.assertTrue((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
    }

    private void checkRestoreTmpDir(Configuration conf, String restoreTmpDir, int expectedCount) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] subDirectories = fs.listStatus(new Path(restoreTmpDir));
        Assert.assertNotNull((Object)subDirectories);
        Assert.assertEquals((long)subDirectories.length, (long)expectedCount);
        for (int i = 0; i < expectedCount; ++i) {
            Assert.assertTrue((boolean)subDirectories[i].isDirectory());
        }
    }

    @Test
    public void testVerifyReplicationWithSnapshotSupport() throws Exception {
        TestVerifyReplication.runSmallBatchTest();
        Path rootDir = FSUtils.getRootDir((Configuration)conf1);
        FileSystem fs = rootDir.getFileSystem(conf1);
        String sourceSnapshotName = "sourceSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)utility1.getAdmin(), (TableName)tableName, (String)new String(famName), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        Path peerRootDir = FSUtils.getRootDir((Configuration)conf2);
        FileSystem peerFs = peerRootDir.getFileSystem(conf2);
        String peerSnapshotName = "peerSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)utility2.getAdmin(), (TableName)tableName, (String)new String(famName), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        String peerFSAddress = peerFs.getUri().toString();
        String temPath1 = utility1.getRandomDir().toString();
        String temPath2 = "/tmp2";
        String[] args = new String[]{"--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + temPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + temPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + FSUtils.getRootDir((Configuration)conf2), PEER_ID, tableName.getNameAsString()};
        Job job = new VerifyReplication().createSubmittableJob(conf1, args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)100L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)0L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
        this.checkRestoreTmpDir(conf1, temPath1, 1);
        this.checkRestoreTmpDir(conf2, temPath2, 1);
        Scan scan = new Scan();
        ResultScanner rs = htable2.getScanner(scan);
        Put put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            Cell firstVal = result.rawCells()[0];
            put.addColumn(CellUtil.cloneFamily((Cell)firstVal), CellUtil.cloneQualifier((Cell)firstVal), Bytes.toBytes((String)"diff data"));
            htable2.put(put);
        }
        Delete delete = new Delete(put.getRow());
        htable2.delete(delete);
        sourceSnapshotName = "sourceSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)utility1.getAdmin(), (TableName)tableName, (String)new String(famName), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        peerSnapshotName = "peerSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)utility2.getAdmin(), (TableName)tableName, (String)new String(famName), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        args = new String[]{"--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + temPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + temPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + FSUtils.getRootDir((Configuration)conf2), PEER_ID, tableName.getNameAsString()};
        job = new VerifyReplication().createSubmittableJob(conf1, args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)0L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)100L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
        this.checkRestoreTmpDir(conf1, temPath1, 2);
        this.checkRestoreTmpDir(conf2, temPath2, 2);
    }
}

