/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.HashTable;
import org.apache.hadoop.hbase.mapreduce.SyncTable;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestSyncTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncTable.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSyncTable.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static byte[][] generateSplits(int numRows, int numRegions) {
        byte[][] splitRows = new byte[numRegions - 1][];
        for (int i = 1; i < numRegions; ++i) {
            splitRows[i - 1] = Bytes.toBytes((int)(numRows * i / numRegions));
        }
        return splitRows;
    }

    @Test
    public void testSyncTable() throws Exception {
        TableName sourceTableName = TableName.valueOf((String)(this.name.getMethodName() + "_source"));
        TableName targetTableName = TableName.valueOf((String)(this.name.getMethodName() + "_target"));
        Path testDir = TEST_UTIL.getDataTestDirOnTestFS("testSyncTable");
        this.writeTestData(sourceTableName, targetTableName);
        this.hashSourceTable(sourceTableName, testDir);
        Counters syncCounters = this.syncTables(sourceTableName, targetTableName, testDir);
        this.assertEqualTables(90, sourceTableName, targetTableName);
        Assert.assertEquals((long)60L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.ROWSWITHDIFFS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGROWS).getValue());
        Assert.assertEquals((long)10L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGROWS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.SOURCEMISSINGCELLS).getValue());
        Assert.assertEquals((long)50L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.TARGETMISSINGCELLS).getValue());
        Assert.assertEquals((long)20L, (long)syncCounters.findCounter((Enum)SyncTable.SyncMapper.Counter.DIFFERENTCELLVALUES).getValue());
        TEST_UTIL.deleteTable(sourceTableName);
        TEST_UTIL.deleteTable(targetTableName);
        TEST_UTIL.cleanupDataTestDirOnTestFS();
    }

    private void assertEqualTables(int expectedRows, TableName sourceTableName, TableName targetTableName) throws Exception {
        Result targetRow;
        Table sourceTable = TEST_UTIL.getConnection().getTable(sourceTableName);
        Table targetTable = TEST_UTIL.getConnection().getTable(targetTableName);
        ResultScanner sourceScanner = sourceTable.getScanner(new Scan());
        ResultScanner targetScanner = targetTable.getScanner(new Scan());
        for (int i = 0; i < expectedRows; ++i) {
            Object[] targetCells;
            Object[] sourceCells;
            Result sourceRow = sourceScanner.next();
            Result targetRow2 = targetScanner.next();
            LOG.debug("SOURCE row: " + (sourceRow == null ? "null" : Integer.valueOf(Bytes.toInt((byte[])sourceRow.getRow()))) + " cells:" + sourceRow);
            LOG.debug("TARGET row: " + (targetRow2 == null ? "null" : Integer.valueOf(Bytes.toInt((byte[])targetRow2.getRow()))) + " cells:" + targetRow2);
            if (sourceRow == null) {
                Assert.fail((String)("Expected " + expectedRows + " source rows but only found " + i));
            }
            if (targetRow2 == null) {
                Assert.fail((String)("Expected " + expectedRows + " target rows but only found " + i));
            }
            if ((sourceCells = sourceRow.rawCells()).length != (targetCells = targetRow2.rawCells()).length) {
                LOG.debug("Source cells: " + Arrays.toString(sourceCells));
                LOG.debug("Target cells: " + Arrays.toString(targetCells));
                Assert.fail((String)("Row " + Bytes.toInt((byte[])sourceRow.getRow()) + " has " + sourceCells.length + " cells in source table but " + targetCells.length + " cells in target table"));
            }
            for (int j = 0; j < sourceCells.length; ++j) {
                Object sourceCell = sourceCells[j];
                Cell targetCell = targetCells[j];
                try {
                    if (!CellUtil.matchingRows((Cell)sourceCell, (Cell)targetCell)) {
                        Assert.fail((String)"Rows don't match");
                    }
                    if (!CellUtil.matchingFamily((Cell)sourceCell, (Cell)targetCell)) {
                        Assert.fail((String)"Families don't match");
                    }
                    if (!CellUtil.matchingQualifier((Cell)sourceCell, (Cell)targetCell)) {
                        Assert.fail((String)"Qualifiers don't match");
                    }
                    if (!CellUtil.matchingTimestamp((Cell)sourceCell, (Cell)targetCell)) {
                        Assert.fail((String)"Timestamps don't match");
                    }
                    if (CellUtil.matchingValue((Cell)sourceCell, (Cell)targetCell)) continue;
                    Assert.fail((String)"Values don't match");
                    continue;
                }
                catch (Throwable t) {
                    LOG.debug("Source cell: " + sourceCell + " target cell: " + targetCell);
                    Throwables.propagate((Throwable)t);
                }
            }
        }
        Result sourceRow = sourceScanner.next();
        if (sourceRow != null) {
            Assert.fail((String)("Source table has more than " + expectedRows + " rows.  Next row: " + Bytes.toInt((byte[])sourceRow.getRow())));
        }
        if ((targetRow = targetScanner.next()) != null) {
            Assert.fail((String)("Target table has more than " + expectedRows + " rows.  Next row: " + Bytes.toInt((byte[])targetRow.getRow())));
        }
        sourceScanner.close();
        targetScanner.close();
        sourceTable.close();
        targetTable.close();
    }

    private Counters syncTables(TableName sourceTableName, TableName targetTableName, Path testDir) throws Exception {
        SyncTable syncTable = new SyncTable(TEST_UTIL.getConfiguration());
        int code = syncTable.run(new String[]{testDir.toString(), sourceTableName.getNameAsString(), targetTableName.getNameAsString()});
        Assert.assertEquals((String)"sync table job failed", (long)0L, (long)code);
        LOG.info("Sync tables completed");
        return syncTable.counters;
    }

    private void hashSourceTable(TableName sourceTableName, Path testDir) throws Exception, IOException {
        int numHashFiles = 3;
        long batchSize = 100L;
        int scanBatch = 1;
        HashTable hashTable = new HashTable(TEST_UTIL.getConfiguration());
        int code = hashTable.run(new String[]{"--batchsize=" + batchSize, "--numhashfiles=" + numHashFiles, "--scanbatch=" + scanBatch, sourceTableName.getNameAsString(), testDir.toString()});
        Assert.assertEquals((String)"hash table job failed", (long)0L, (long)code);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        HashTable.TableHash tableHash = HashTable.TableHash.read((Configuration)fs.getConf(), (Path)testDir);
        Assert.assertEquals((Object)sourceTableName.getNameAsString(), (Object)tableHash.tableName);
        Assert.assertEquals((long)batchSize, (long)tableHash.batchSize);
        Assert.assertEquals((long)numHashFiles, (long)tableHash.numHashFiles);
        Assert.assertEquals((long)(numHashFiles - 1), (long)tableHash.partitions.size());
        LOG.info("Hash table completed");
    }

    private void writeTestData(TableName sourceTableName, TableName targetTableName) throws Exception {
        Put put;
        Put targetPut;
        Put sourcePut;
        int rowIndex;
        byte[] family = Bytes.toBytes((String)"family");
        byte[] column1 = Bytes.toBytes((String)"c1");
        byte[] column2 = Bytes.toBytes((String)"c2");
        byte[] value1 = Bytes.toBytes((String)"val1");
        byte[] value2 = Bytes.toBytes((String)"val2");
        byte[] value3 = Bytes.toBytes((String)"val3");
        int numRows = 100;
        int sourceRegions = 10;
        int targetRegions = 6;
        Table sourceTable = TEST_UTIL.createTable(sourceTableName, family, TestSyncTable.generateSplits(numRows, sourceRegions));
        Table targetTable = TEST_UTIL.createTable(targetTableName, family, TestSyncTable.generateSplits(numRows, targetRegions));
        long timestamp = 1430764183454L;
        for (rowIndex = 0; rowIndex < 40; ++rowIndex) {
            sourcePut = new Put(Bytes.toBytes((int)rowIndex));
            sourcePut.addColumn(family, column1, timestamp, value1);
            sourcePut.addColumn(family, column2, timestamp, value2);
            sourceTable.put(sourcePut);
            targetPut = new Put(Bytes.toBytes((int)rowIndex));
            targetPut.addColumn(family, column1, timestamp, value1);
            targetPut.addColumn(family, column2, timestamp, value2);
            targetTable.put(targetPut);
        }
        while (rowIndex < 50) {
            put = new Put(Bytes.toBytes((int)rowIndex));
            put.addColumn(family, column1, timestamp, value1);
            put.addColumn(family, column2, timestamp, value2);
            sourceTable.put(put);
            ++rowIndex;
        }
        while (rowIndex < 60) {
            put = new Put(Bytes.toBytes((int)rowIndex));
            put.addColumn(family, column1, timestamp, value1);
            put.addColumn(family, column2, timestamp, value2);
            targetTable.put(put);
            ++rowIndex;
        }
        while (rowIndex < 70) {
            sourcePut = new Put(Bytes.toBytes((int)rowIndex));
            sourcePut.addColumn(family, column1, timestamp, value1);
            sourcePut.addColumn(family, column2, timestamp, value2);
            sourceTable.put(sourcePut);
            targetPut = new Put(Bytes.toBytes((int)rowIndex));
            targetPut.addColumn(family, column1, timestamp, value1);
            targetTable.put(targetPut);
            ++rowIndex;
        }
        while (rowIndex < 80) {
            sourcePut = new Put(Bytes.toBytes((int)rowIndex));
            sourcePut.addColumn(family, column1, timestamp, value1);
            sourceTable.put(sourcePut);
            targetPut = new Put(Bytes.toBytes((int)rowIndex));
            targetPut.addColumn(family, column1, timestamp, value1);
            targetPut.addColumn(family, column2, timestamp, value2);
            targetTable.put(targetPut);
            ++rowIndex;
        }
        while (rowIndex < 90) {
            sourcePut = new Put(Bytes.toBytes((int)rowIndex));
            sourcePut.addColumn(family, column1, timestamp, column1);
            sourcePut.addColumn(family, column2, timestamp, value2);
            sourceTable.put(sourcePut);
            targetPut = new Put(Bytes.toBytes((int)rowIndex));
            targetPut.addColumn(family, column1, timestamp + 1L, column1);
            targetPut.addColumn(family, column2, timestamp - 1L, value2);
            targetTable.put(targetPut);
            ++rowIndex;
        }
        while (rowIndex < numRows) {
            sourcePut = new Put(Bytes.toBytes((int)rowIndex));
            sourcePut.addColumn(family, column1, timestamp, value1);
            sourcePut.addColumn(family, column2, timestamp, value2);
            sourceTable.put(sourcePut);
            targetPut = new Put(Bytes.toBytes((int)rowIndex));
            targetPut.addColumn(family, column1, timestamp, value3);
            targetPut.addColumn(family, column2, timestamp, value3);
            targetTable.put(targetPut);
            ++rowIndex;
        }
        sourceTable.close();
        targetTable.close();
    }
}

