/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver.impl;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.metrics.StateStoreMetrics;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreSerializer;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreBaseImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;

public abstract class StateStoreSerializableImpl
extends StateStoreBaseImpl {
    protected static final String SLASH_MARK = "0SLASH0";
    protected static final String COLON_MARK = "_";
    private StateStoreSerializer serializer;

    @Override
    public boolean init(Configuration config, String id, Collection<Class<? extends BaseRecord>> records, StateStoreMetrics metrics) {
        boolean ret = super.init(config, id, records, metrics);
        this.serializer = StateStoreSerializer.getSerializer(config);
        return ret;
    }

    protected <T extends BaseRecord> byte[] serialize(T record) {
        return this.serializer.serialize(record);
    }

    protected <T extends BaseRecord> String serializeString(T record) {
        return this.serializer.serializeString(record);
    }

    protected <T extends BaseRecord> T newRecord(String data, Class<T> clazz, boolean includeDates) throws IOException {
        return this.serializer.deserialize(data, clazz);
    }

    protected static String getPrimaryKey(BaseRecord record) {
        String primaryKey = record.getPrimaryKey();
        primaryKey = primaryKey.replaceAll("/", SLASH_MARK);
        primaryKey = primaryKey.replaceAll(":", COLON_MARK);
        return primaryKey;
    }
}

