/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class Client {
    public static final Header[] EMPTY_HEADER_ARRAY = new Header[0];
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private HttpClient httpClient;
    private Cluster cluster;
    private boolean sslEnabled;
    private HttpResponse resp;
    private HttpGet httpGet = null;
    private Map<String, String> extraHeaders;
    private static final String AUTH_COOKIE = "hadoop.auth";
    private static final String AUTH_COOKIE_EQ = "hadoop.auth=";
    private static final String COOKIE = "Cookie";

    public Client() {
        this(null);
    }

    private void initialize(Cluster cluster, boolean sslEnabled) {
        this.cluster = cluster;
        this.sslEnabled = sslEnabled;
        this.extraHeaders = new ConcurrentHashMap<String, String>();
        String clspath = System.getProperty("java.class.path");
        LOG.debug("classpath " + clspath);
        this.httpClient = new DefaultHttpClient();
        this.httpClient.getParams().setIntParameter("http.connection.timeout", 2000);
    }

    public Client(Cluster cluster) {
        this.initialize(cluster, false);
    }

    public Client(Cluster cluster, boolean sslEnabled) {
        this.initialize(cluster, sslEnabled);
    }

    public void shutdown() {
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void addExtraHeader(String name, String value) {
        this.extraHeaders.put(name, value);
    }

    public String getExtraHeader(String name) {
        return this.extraHeaders.get(name);
    }

    public Map<String, String> getExtraHeaders() {
        return Collections.unmodifiableMap(this.extraHeaders);
    }

    public void removeExtraHeader(String name) {
        this.extraHeaders.remove(name);
    }

    public HttpResponse executePathOnly(Cluster cluster, HttpUriRequest method, Header[] headers, String path) throws IOException {
        IOException lastException;
        int start;
        if (cluster.nodes.size() < 1) {
            throw new IOException("Cluster is empty");
        }
        int i = start = (int)Math.round((double)(cluster.nodes.size() - 1) * Math.random());
        do {
            cluster.lastHost = cluster.nodes.get(i);
            try {
                StringBuilder sb = new StringBuilder();
                if (this.sslEnabled) {
                    sb.append("https://");
                } else {
                    sb.append("http://");
                }
                sb.append(cluster.lastHost);
                sb.append(path);
                URI uri = new URI(sb.toString());
                if (method instanceof HttpPut) {
                    HttpPut put = new HttpPut(uri);
                    put.setEntity(((HttpPut)method).getEntity());
                    put.setHeaders(method.getAllHeaders());
                    method = put;
                } else if (method instanceof HttpGet) {
                    method = new HttpGet(uri);
                } else if (method instanceof HttpHead) {
                    method = new HttpHead(uri);
                } else if (method instanceof HttpDelete) {
                    method = new HttpDelete(uri);
                } else if (method instanceof HttpPost) {
                    HttpPost post = new HttpPost(uri);
                    post.setEntity(((HttpPost)method).getEntity());
                    post.setHeaders(method.getAllHeaders());
                    method = post;
                }
                return this.executeURI(method, headers, uri.toString());
            }
            catch (IOException e) {
                lastException = e;
            }
            catch (URISyntaxException use) {
                lastException = new IOException(use);
            }
        } while (++i != start && i < cluster.nodes.size());
        throw lastException;
    }

    public HttpResponse executeURI(HttpUriRequest method, Header[] headers, String uri) throws IOException {
        for (Map.Entry<String, String> e : this.extraHeaders.entrySet()) {
            method.addHeader(e.getKey(), e.getValue());
        }
        if (headers != null) {
            for (Header header : headers) {
                method.addHeader(header);
            }
        }
        long startTime = System.currentTimeMillis();
        if (this.resp != null) {
            EntityUtils.consumeQuietly((HttpEntity)this.resp.getEntity());
        }
        this.resp = this.httpClient.execute(method);
        if (this.resp.getStatusLine().getStatusCode() == 401) {
            LOG.debug("Performing negotiation with the server.");
            this.negotiate(method, uri);
            this.resp = this.httpClient.execute(method);
        }
        long endTime = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace(method.getMethod() + " " + uri + " " + this.resp.getStatusLine().getStatusCode() + " " + this.resp.getStatusLine().getReasonPhrase() + " in " + (endTime - startTime) + " ms");
        }
        return this.resp;
    }

    public HttpResponse execute(Cluster cluster, HttpUriRequest method, Header[] headers, String path) throws IOException {
        if (path.startsWith("/")) {
            return this.executePathOnly(cluster, method, headers, path);
        }
        return this.executeURI(method, headers, path);
    }

    private void negotiate(HttpUriRequest method, String uri) throws IOException {
        try {
            AuthenticatedURL.Token token = new AuthenticatedURL.Token();
            KerberosAuthenticator authenticator = new KerberosAuthenticator();
            authenticator.authenticate(new URL(uri), token);
            this.injectToken(method, token);
        }
        catch (AuthenticationException e) {
            LOG.error("Failed to negotiate with the server.", (Throwable)e);
            throw new IOException(e);
        }
    }

    private void injectToken(HttpUriRequest method, AuthenticatedURL.Token token) {
        String t = token.toString();
        if (t != null) {
            if (!t.startsWith("\"")) {
                t = "\"" + t + "\"";
            }
            method.addHeader(COOKIE, AUTH_COOKIE_EQ + t);
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Response head(String path) throws IOException {
        return this.head(this.cluster, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response head(Cluster cluster, String path, Header[] headers) throws IOException {
        HttpHead method = new HttpHead(path);
        try {
            HttpResponse resp = this.execute(cluster, (HttpUriRequest)method, null, path);
            Response response = new Response(resp.getStatusLine().getStatusCode(), resp.getAllHeaders(), null);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response get(String path) throws IOException {
        return this.get(this.cluster, path);
    }

    public Response get(Cluster cluster, String path) throws IOException {
        return this.get(cluster, path, EMPTY_HEADER_ARRAY);
    }

    public Response get(String path, String accept) throws IOException {
        return this.get(this.cluster, path, accept);
    }

    public Response get(Cluster cluster, String path, String accept) throws IOException {
        Header[] headers = new Header[]{new BasicHeader("Accept", accept)};
        return this.get(cluster, path, headers);
    }

    public Response get(String path, Header[] headers) throws IOException {
        return this.get(this.cluster, path, headers);
    }

    @SuppressWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="null is possible return value")
    public static byte[] getResponseBody(HttpResponse resp) throws IOException {
        if (resp.getEntity() == null) {
            return null;
        }
        try (InputStream instream = resp.getEntity().getContent();){
            if (instream != null) {
                int len;
                long contentLength = resp.getEntity().getContentLength();
                if (contentLength > Integer.MAX_VALUE) {
                    throw new IOException("Content too large to be buffered: " + contentLength + " bytes");
                }
                ByteArrayOutputStream outstream = new ByteArrayOutputStream(contentLength > 0L ? (int)contentLength : 4096);
                byte[] buffer = new byte[4096];
                while ((len = instream.read(buffer)) > 0) {
                    outstream.write(buffer, 0, len);
                }
                outstream.close();
                byte[] byArray = outstream.toByteArray();
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
    }

    public Response get(Cluster c, String path, Header[] headers) throws IOException {
        if (this.httpGet != null) {
            this.httpGet.releaseConnection();
        }
        this.httpGet = new HttpGet(path);
        HttpResponse resp = this.execute(c, (HttpUriRequest)this.httpGet, headers, path);
        return new Response(resp.getStatusLine().getStatusCode(), resp.getAllHeaders(), resp, resp.getEntity() == null ? null : resp.getEntity().getContent());
    }

    public Response put(String path, String contentType, byte[] content) throws IOException {
        return this.put(this.cluster, path, contentType, content);
    }

    public Response put(String path, String contentType, byte[] content, Header extraHdr) throws IOException {
        return this.put(this.cluster, path, contentType, content, extraHdr);
    }

    public Response put(Cluster cluster, String path, String contentType, byte[] content) throws IOException {
        Header[] headers = new Header[]{new BasicHeader("Content-Type", contentType)};
        return this.put(cluster, path, headers, content);
    }

    public Response put(Cluster cluster, String path, String contentType, byte[] content, Header extraHdr) throws IOException {
        int cnt = extraHdr == null ? 1 : 2;
        Header[] headers = new Header[cnt];
        headers[0] = new BasicHeader("Content-Type", contentType);
        if (extraHdr != null) {
            headers[1] = extraHdr;
        }
        return this.put(cluster, path, headers, content);
    }

    public Response put(String path, Header[] headers, byte[] content) throws IOException {
        return this.put(this.cluster, path, headers, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response put(Cluster cluster, String path, Header[] headers, byte[] content) throws IOException {
        HttpPut method = new HttpPut(path);
        try {
            method.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(content), (long)content.length));
            HttpResponse resp = this.execute(cluster, (HttpUriRequest)method, headers, path);
            headers = resp.getAllHeaders();
            content = Client.getResponseBody(resp);
            Response response = new Response(resp.getStatusLine().getStatusCode(), headers, content);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response post(String path, String contentType, byte[] content) throws IOException {
        return this.post(this.cluster, path, contentType, content);
    }

    public Response post(String path, String contentType, byte[] content, Header extraHdr) throws IOException {
        return this.post(this.cluster, path, contentType, content, extraHdr);
    }

    public Response post(Cluster cluster, String path, String contentType, byte[] content) throws IOException {
        Header[] headers = new Header[]{new BasicHeader("Content-Type", contentType)};
        return this.post(cluster, path, headers, content);
    }

    public Response post(Cluster cluster, String path, String contentType, byte[] content, Header extraHdr) throws IOException {
        int cnt = extraHdr == null ? 1 : 2;
        Header[] headers = new Header[cnt];
        headers[0] = new BasicHeader("Content-Type", contentType);
        if (extraHdr != null) {
            headers[1] = extraHdr;
        }
        return this.post(cluster, path, headers, content);
    }

    public Response post(String path, Header[] headers, byte[] content) throws IOException {
        return this.post(this.cluster, path, headers, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response post(Cluster cluster, String path, Header[] headers, byte[] content) throws IOException {
        HttpPost method = new HttpPost(path);
        try {
            method.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(content), (long)content.length));
            HttpResponse resp = this.execute(cluster, (HttpUriRequest)method, headers, path);
            headers = resp.getAllHeaders();
            content = Client.getResponseBody(resp);
            Response response = new Response(resp.getStatusLine().getStatusCode(), headers, content);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response delete(String path) throws IOException {
        return this.delete(this.cluster, path);
    }

    public Response delete(String path, Header extraHdr) throws IOException {
        return this.delete(this.cluster, path, extraHdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response delete(Cluster cluster, String path) throws IOException {
        HttpDelete method = new HttpDelete(path);
        try {
            HttpResponse resp = this.execute(cluster, (HttpUriRequest)method, null, path);
            Header[] headers = resp.getAllHeaders();
            byte[] content = Client.getResponseBody(resp);
            Response response = new Response(resp.getStatusLine().getStatusCode(), headers, content);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response delete(Cluster cluster, String path, Header extraHdr) throws IOException {
        HttpDelete method = new HttpDelete(path);
        try {
            Header[] headers = new Header[]{extraHdr};
            HttpResponse resp = this.execute(cluster, (HttpUriRequest)method, headers, path);
            headers = resp.getAllHeaders();
            byte[] content = Client.getResponseBody(resp);
            Response response = new Response(resp.getStatusLine().getStatusCode(), headers, content);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }
}

