/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.RSGroupProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdmin;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupProtobufUtil;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;

@InterfaceAudience.Private
public class VerifyingRSGroupAdminClient
implements RSGroupAdmin {
    private Table table;
    private ZKWatcher zkw;
    private RSGroupAdmin wrapped;

    public VerifyingRSGroupAdminClient(RSGroupAdmin RSGroupAdmin2, Configuration conf) throws IOException {
        this.wrapped = RSGroupAdmin2;
        this.table = ConnectionFactory.createConnection((Configuration)conf).getTable(RSGroupInfoManager.RSGROUP_TABLE_NAME);
        this.zkw = new ZKWatcher(conf, this.getClass().getSimpleName(), null);
    }

    public void addRSGroup(String groupName) throws IOException {
        this.wrapped.addRSGroup(groupName);
        this.verify();
    }

    public RSGroupInfo getRSGroupInfo(String groupName) throws IOException {
        return this.wrapped.getRSGroupInfo(groupName);
    }

    public RSGroupInfo getRSGroupInfoOfTable(TableName tableName) throws IOException {
        return this.wrapped.getRSGroupInfoOfTable(tableName);
    }

    public void moveServers(Set<Address> servers, String targetGroup) throws IOException {
        this.wrapped.moveServers(servers, targetGroup);
        this.verify();
    }

    public void moveTables(Set<TableName> tables, String targetGroup) throws IOException {
        this.wrapped.moveTables(tables, targetGroup);
        this.verify();
    }

    public void removeRSGroup(String name) throws IOException {
        this.wrapped.removeRSGroup(name);
        this.verify();
    }

    public boolean balanceRSGroup(String groupName) throws IOException {
        return this.wrapped.balanceRSGroup(groupName);
    }

    public List<RSGroupInfo> listRSGroups() throws IOException {
        return this.wrapped.listRSGroups();
    }

    public RSGroupInfo getRSGroupOfServer(Address hostPort) throws IOException {
        return this.wrapped.getRSGroupOfServer(hostPort);
    }

    public void moveServersAndTables(Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
        this.wrapped.moveServersAndTables(servers, tables, targetGroup);
        this.verify();
    }

    public void removeServers(Set<Address> servers) throws IOException {
        this.wrapped.removeServers(servers);
        this.verify();
    }

    public void verify() throws IOException {
        HashMap groupMap = Maps.newHashMap();
        HashSet zList = Sets.newHashSet();
        for (Result result : this.table.getScanner(new Scan())) {
            RSGroupProtos.RSGroupInfo proto = RSGroupProtos.RSGroupInfo.parseFrom((byte[])result.getValue(RSGroupInfoManager.META_FAMILY_BYTES, RSGroupInfoManager.META_QUALIFIER_BYTES));
            groupMap.put(proto.getName(), RSGroupProtobufUtil.toGroupInfo((RSGroupProtos.RSGroupInfo)proto));
        }
        Assert.assertEquals((Object)Sets.newHashSet(groupMap.values()), (Object)Sets.newHashSet((Iterable)this.wrapped.listRSGroups()));
        try {
            String groupBasePath = ZNodePaths.joinZNode((String)this.zkw.getZNodePaths().baseZNode, (String)"rsgroup");
            for (String znode : ZKUtil.listChildrenNoWatch((ZKWatcher)this.zkw, (String)groupBasePath)) {
                byte[] data = ZKUtil.getData((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)groupBasePath, (String)znode));
                if (data.length <= 0) continue;
                ProtobufUtil.expectPBMagicPrefix((byte[])data);
                ByteArrayInputStream bis = new ByteArrayInputStream(data, ProtobufUtil.lengthOfPBMagic(), data.length);
                zList.add(RSGroupProtobufUtil.toGroupInfo((RSGroupProtos.RSGroupInfo)RSGroupProtos.RSGroupInfo.parseFrom((InputStream)bis)));
            }
            Assert.assertEquals((long)zList.size(), (long)groupMap.size());
            for (RSGroupInfo RSGroupInfo2 : zList) {
                Assert.assertTrue((boolean)((RSGroupInfo)groupMap.get(RSGroupInfo2.getName())).equals((Object)RSGroupInfo2));
            }
        }
        catch (KeeperException e) {
            throw new IOException("ZK verification failed", e);
        }
        catch (DeserializationException e) {
            throw new IOException("ZK verification failed", e);
        }
        catch (InterruptedException e) {
            throw new IOException("ZK verification failed", e);
        }
    }
}

