/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdmin;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminClient;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestRSGroupsBase {
    protected static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsBase.class);
    @Rule
    public TestName name = new TestName();
    protected static final String groupPrefix = "Group";
    protected static final String tablePrefix = "Group";
    protected static final SecureRandom rand = new SecureRandom();
    protected static HBaseTestingUtility TEST_UTIL;
    protected static Admin admin;
    protected static HBaseCluster cluster;
    protected static RSGroupAdmin rsGroupAdmin;
    protected static HMaster master;
    public static final long WAIT_TIMEOUT = 300000L;
    public static final int NUM_SLAVES_BASE = 4;
    public static int NUM_DEAD_SERVERS;
    TableName tableName;

    @Before
    public void setup() {
        LOG.info(this.name.getMethodName());
        this.tableName = TableName.valueOf((String)("Group_" + this.name.getMethodName()));
    }

    protected RSGroupInfo addGroup(String groupName, int serverCount) throws IOException, InterruptedException {
        RSGroupInfo defaultInfo = rsGroupAdmin.getRSGroupInfo("default");
        Assert.assertTrue((defaultInfo != null ? 1 : 0) != 0);
        Assert.assertTrue((defaultInfo.getServers().size() >= serverCount ? 1 : 0) != 0);
        rsGroupAdmin.addRSGroup(groupName);
        HashSet<Address> set = new HashSet<Address>();
        for (Address server : defaultInfo.getServers()) {
            if (set.size() == serverCount) break;
            set.add(server);
        }
        rsGroupAdmin.moveServers(set, groupName);
        RSGroupInfo result = rsGroupAdmin.getRSGroupInfo(groupName);
        Assert.assertTrue((result.getServers().size() >= serverCount ? 1 : 0) != 0);
        return result;
    }

    void removeGroup(String groupName) throws IOException {
        RSGroupInfo RSGroupInfo2 = rsGroupAdmin.getRSGroupInfo(groupName);
        rsGroupAdmin.moveTables((Set)RSGroupInfo2.getTables(), "default");
        rsGroupAdmin.moveServers(RSGroupInfo2.getServers(), "default");
        rsGroupAdmin.removeRSGroup(groupName);
    }

    protected void deleteTableIfNecessary() throws IOException {
        for (HTableDescriptor desc : TEST_UTIL.getAdmin().listTables("Group.*")) {
            TEST_UTIL.deleteTable(desc.getTableName());
        }
    }

    protected void deleteNamespaceIfNecessary() throws IOException {
        for (NamespaceDescriptor desc : TEST_UTIL.getAdmin().listNamespaceDescriptors()) {
            if (!desc.getName().startsWith("Group")) continue;
            admin.deleteNamespace(desc.getName());
        }
    }

    protected void deleteGroups() throws IOException {
        RSGroupAdminClient groupAdmin = new RSGroupAdminClient(TEST_UTIL.getConnection());
        for (RSGroupInfo group : groupAdmin.listRSGroups()) {
            if (group.getName().equals("default")) continue;
            groupAdmin.moveTables((Set)group.getTables(), "default");
            groupAdmin.moveServers(group.getServers(), "default");
            groupAdmin.removeRSGroup(group.getName());
        }
    }

    public Map<TableName, List<String>> getTableRegionMap() throws IOException {
        TreeMap map = Maps.newTreeMap();
        Map<TableName, Map<ServerName, List<String>>> tableServerRegionMap = this.getTableServerRegionMap();
        for (TableName tableName : tableServerRegionMap.keySet()) {
            if (!map.containsKey(tableName)) {
                map.put(tableName, new LinkedList());
            }
            for (List<String> subset : tableServerRegionMap.get(tableName).values()) {
                ((List)map.get(tableName)).addAll(subset);
            }
        }
        return map;
    }

    public Map<TableName, Map<ServerName, List<String>>> getTableServerRegionMap() throws IOException {
        TreeMap map = Maps.newTreeMap();
        ClusterMetrics status = TEST_UTIL.getHBaseClusterInterface().getClusterMetrics();
        for (Map.Entry entry : status.getLiveServerMetrics().entrySet()) {
            ServerName serverName = (ServerName)entry.getKey();
            for (RegionMetrics rl : ((ServerMetrics)entry.getValue()).getRegionMetrics().values()) {
                TableName tableName = null;
                try {
                    tableName = RegionInfo.getTable((byte[])rl.getRegionName());
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Failed parse a table name from regionname=" + Bytes.toStringBinary((byte[])rl.getRegionName()));
                    continue;
                }
                if (!map.containsKey(tableName)) {
                    map.put(tableName, new TreeMap());
                }
                if (!((Map)map.get(tableName)).containsKey(serverName)) {
                    ((Map)map.get(tableName)).put(serverName, new LinkedList());
                }
                ((List)((Map)map.get(tableName)).get(serverName)).add(rl.getNameAsString());
            }
        }
        return map;
    }

    @Test
    public void testBogusArgs() throws Exception {
        Assert.assertNull((Object)rsGroupAdmin.getRSGroupInfoOfTable(TableName.valueOf((String)"nonexistent")));
        Assert.assertNull((Object)rsGroupAdmin.getRSGroupOfServer(Address.fromParts((String)"bogus", (int)123)));
        Assert.assertNull((Object)rsGroupAdmin.getRSGroupInfo("bogus"));
        try {
            rsGroupAdmin.removeRSGroup("bogus");
            Assert.fail((String)"Expected removing bogus group to fail");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
        try {
            rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{TableName.valueOf((String)"bogustable")}), "bogus");
            Assert.fail((String)"Expected move with bogus group to fail");
        }
        catch (TableNotFoundException | ConstraintException throwable) {
            // empty catch block
        }
        try {
            rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{Address.fromParts((String)"bogus", (int)123)}), "bogus");
            Assert.fail((String)"Expected move with bogus group to fail");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
        try {
            admin.setBalancerRunning(true, true);
            rsGroupAdmin.balanceRSGroup("bogus");
            admin.setBalancerRunning(false, true);
            Assert.fail((String)"Expected move with bogus group to fail");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateMultiRegion() throws IOException {
        byte[] end = new byte[]{1, 3, 5, 7, 9};
        byte[] start = new byte[]{0, 2, 4, 6, 8};
        byte[][] f = new byte[][]{Bytes.toBytes((String)"f")};
        TEST_UTIL.createTable(this.tableName, (byte[][])f, 1, start, end, 10);
    }

    @Test
    public void testCreateAndDrop() throws Exception {
        TEST_UTIL.createTable(this.tableName, Bytes.toBytes((String)"cf"));
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName) != null;
            }
        });
        TEST_UTIL.deleteTable(this.tableName);
    }

    @Test
    public void testSimpleRegionServerMove() throws IOException, InterruptedException {
        int initNumGroups = rsGroupAdmin.listRSGroups().size();
        RSGroupInfo appInfo = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        RSGroupInfo adminInfo = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        RSGroupInfo dInfo = rsGroupAdmin.getRSGroupInfo("default");
        Assert.assertEquals((long)(initNumGroups + 2), (long)rsGroupAdmin.listRSGroups().size());
        Assert.assertEquals((long)1L, (long)adminInfo.getServers().size());
        Assert.assertEquals((long)1L, (long)appInfo.getServers().size());
        Assert.assertEquals((long)(this.getNumServers() - 2), (long)dInfo.getServers().size());
        rsGroupAdmin.moveServers(appInfo.getServers(), "default");
        rsGroupAdmin.removeRSGroup(appInfo.getName());
        rsGroupAdmin.moveServers(adminInfo.getServers(), "default");
        rsGroupAdmin.removeRSGroup(adminInfo.getName());
        Assert.assertEquals((long)rsGroupAdmin.listRSGroups().size(), (long)initNumGroups);
    }

    public int getNumServers() throws IOException {
        ClusterMetrics status = admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.MASTER, ClusterMetrics.Option.LIVE_SERVERS));
        ServerName masterName = status.getMasterName();
        int count = 0;
        for (ServerName sn : status.getLiveServerMetrics().keySet()) {
            if (sn.equals((Object)masterName)) continue;
            ++count;
        }
        return count;
    }

    @Test
    public void testMoveServers() throws Exception {
        this.addGroup("bar", 3);
        rsGroupAdmin.addRSGroup("foo");
        RSGroupInfo barGroup = rsGroupAdmin.getRSGroupInfo("bar");
        RSGroupInfo fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)3L, (long)barGroup.getServers().size());
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        try {
            rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{Address.fromString((String)"foo:9999")}), "foo");
            Assert.fail((String)"Bogus servers shouldn't have been successfully moved.");
        }
        catch (IOException ex) {
            String exp = "Source RSGroup for server foo:9999 does not exist.";
            String msg = "Expected '" + exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        LOG.info("moving servers " + barGroup.getServers() + " to group foo");
        rsGroupAdmin.moveServers(barGroup.getServers(), fooGroup.getName());
        barGroup = rsGroupAdmin.getRSGroupInfo("bar");
        fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)0L, (long)barGroup.getServers().size());
        Assert.assertEquals((long)3L, (long)fooGroup.getServers().size());
        LOG.info("moving servers " + fooGroup.getServers() + " to group default");
        rsGroupAdmin.moveServers(fooGroup.getServers(), "default");
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.this.getNumServers() == rsGroupAdmin.getRSGroupInfo("default").getServers().size();
            }
        });
        fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        LOG.info("Remove group " + barGroup.getName());
        rsGroupAdmin.removeRSGroup(barGroup.getName());
        Assert.assertEquals(null, (Object)rsGroupAdmin.getRSGroupInfo(barGroup.getName()));
        LOG.info("Remove group " + fooGroup.getName());
        rsGroupAdmin.removeRSGroup(fooGroup.getName());
        Assert.assertEquals(null, (Object)rsGroupAdmin.getRSGroupInfo(fooGroup.getName()));
    }

    @Test
    public void testMoveServersFromDefaultGroup() throws Exception {
        rsGroupAdmin.addRSGroup("foo");
        RSGroupInfo fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        RSGroupInfo defaultGroup = rsGroupAdmin.getRSGroupInfo("default");
        try {
            rsGroupAdmin.moveServers(defaultGroup.getServers(), fooGroup.getName());
            Assert.fail((String)"should keep at least one server in 'default' RSGroup.");
        }
        catch (ConstraintException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("should keep at least one server in 'default' RSGroup."));
        }
        if (defaultGroup.getServers().size() > 1) {
            Address serverInDefaultGroup = (Address)defaultGroup.getServers().iterator().next();
            LOG.info("moving server " + serverInDefaultGroup + " from group default to group " + fooGroup.getName());
            rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{serverInDefaultGroup}), fooGroup.getName());
        }
        fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        LOG.info("moving servers " + fooGroup.getServers() + " to group default");
        rsGroupAdmin.moveServers(fooGroup.getServers(), "default");
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.this.getNumServers() == rsGroupAdmin.getRSGroupInfo("default").getServers().size();
            }
        });
        fooGroup = rsGroupAdmin.getRSGroupInfo("foo");
        Assert.assertEquals((long)0L, (long)fooGroup.getServers().size());
        LOG.info("Remove group " + fooGroup.getName());
        rsGroupAdmin.removeRSGroup(fooGroup.getName());
        Assert.assertEquals(null, (Object)rsGroupAdmin.getRSGroupInfo(fooGroup.getName()));
    }

    @Test
    public void testTableMoveTruncateAndDrop() throws Exception {
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        String newGroupName = this.getGroupName(this.name.getMethodName());
        final RSGroupInfo newGroup = this.addGroup(newGroupName, 2);
        TEST_UTIL.createMultiRegionTable(this.tableName, familyNameBytes, 5);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName).size() >= 5;
            }
        });
        RSGroupInfo tableGrp = rsGroupAdmin.getRSGroupInfoOfTable(this.tableName);
        Assert.assertTrue((boolean)tableGrp.getName().equals("default"));
        LOG.info("Moving table " + this.tableName + " to " + newGroup.getName());
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)rsGroupAdmin.getRSGroupInfoOfTable(this.tableName).getName());
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Map<ServerName, List<String>> serverMap = TestRSGroupsBase.this.getTableServerRegionMap().get(TestRSGroupsBase.this.tableName);
                int count = 0;
                if (serverMap != null) {
                    for (ServerName rs : serverMap.keySet()) {
                        if (!newGroup.containsServer(rs.getAddress())) continue;
                        count += serverMap.get(rs).size();
                    }
                }
                return count == 5;
            }
        });
        admin.disableTable(this.tableName);
        admin.truncateTable(this.tableName, true);
        Assert.assertEquals((long)1L, (long)rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getTables().size());
        Assert.assertEquals((Object)this.tableName, rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getTables().first());
        TEST_UTIL.deleteTable(this.tableName);
        Assert.assertEquals((long)0L, (long)rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getTables().size());
    }

    @Test
    public void testGroupBalance() throws Exception {
        LOG.info(this.name.getMethodName());
        String newGroupName = this.getGroupName(this.name.getMethodName());
        RSGroupInfo newGroup = this.addGroup(newGroupName, 3);
        final TableName tableName = TableName.valueOf((String)"Group_ns", (String)this.name.getMethodName());
        admin.createNamespace(NamespaceDescriptor.create((String)tableName.getNamespaceAsString()).addConfiguration("hbase.rsgroup.name", newGroupName).build());
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        admin.createTable((TableDescriptor)desc, startKey, endKey, 6);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsBase.this.getTableRegionMap().get(tableName);
                if (regions == null) {
                    return false;
                }
                return regions.size() >= 6;
            }
        });
        Map<ServerName, List<String>> assignMap = this.getTableServerRegionMap().get(tableName);
        final ServerName first = assignMap.entrySet().iterator().next().getKey();
        for (RegionInfo region : admin.getTableRegions(tableName)) {
            if (assignMap.get(first).contains(region.getRegionNameAsString())) continue;
            admin.move(region.getEncodedNameAsBytes(), Bytes.toBytes((String)first.getServerName()));
        }
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Map<ServerName, List<String>> map = TestRSGroupsBase.this.getTableServerRegionMap().get(tableName);
                if (map == null) {
                    return true;
                }
                List<String> regions = map.get(first);
                if (regions == null) {
                    return true;
                }
                return regions.size() >= 6;
            }
        });
        admin.setBalancerRunning(true, true);
        rsGroupAdmin.balanceRSGroup("default");
        Assert.assertEquals((long)6L, (long)this.getTableServerRegionMap().get(tableName).get(first).size());
        admin.setBalancerRunning(false, true);
        Assert.assertFalse((boolean)rsGroupAdmin.balanceRSGroup(newGroupName));
        Assert.assertEquals((long)6L, (long)this.getTableServerRegionMap().get(tableName).get(first).size());
        admin.setBalancerRunning(true, true);
        rsGroupAdmin.balanceRSGroup(newGroupName);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                for (List<String> regions : TestRSGroupsBase.this.getTableServerRegionMap().get(tableName).values()) {
                    if (2 == regions.size()) continue;
                    return false;
                }
                return true;
            }
        });
        admin.setBalancerRunning(false, true);
    }

    @Test
    public void testRegionMove() throws Exception {
        Object server;
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        TEST_UTIL.createMultiRegionTable(this.tableName, familyNameBytes, 6);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName).size() >= 6;
            }
        });
        Map<ServerName, List<String>> assignMap = this.getTableServerRegionMap().get(this.tableName);
        String targetRegion = null;
        Iterator<ServerName> iterator = assignMap.keySet().iterator();
        while (iterator.hasNext() && (targetRegion = assignMap.get(server = iterator.next()).size() > 0 ? assignMap.get(server).get(0) : null) == null) {
        }
        ServerName targetServer = null;
        for (ServerName server2 : admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
            if (newGroup.containsServer(server2.getAddress())) continue;
            targetServer = server2;
            break;
        }
        final AdminProtos.AdminService.BlockingInterface targetRS = ((ClusterConnection)admin.getConnection()).getAdmin(targetServer);
        rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}), newGroup.getName());
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)targetRS).size() <= 0;
            }
        });
        TEST_UTIL.getAdmin().move(Bytes.toBytes((String)RegionInfo.encodeRegionName((byte[])Bytes.toBytes((String)targetRegion))), Bytes.toBytes((String)targetServer.getServerName()));
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName) != null && TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName).size() == 6 && admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.REGIONS_IN_TRANSITION)).getRegionStatesInTransition().size() < 1;
            }
        });
        for (RegionInfo region : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)targetRS)) {
            if (!targetRegion.equals(region.getRegionNameAsString())) continue;
            Assert.fail((String)"Target server opened region");
        }
    }

    @Test
    public void testFailRemoveGroup() throws IOException, InterruptedException {
        int initNumGroups = rsGroupAdmin.listRSGroups().size();
        this.addGroup("bar", 3);
        TEST_UTIL.createTable(this.tableName, Bytes.toBytes((String)"f"));
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), "bar");
        RSGroupInfo barGroup = rsGroupAdmin.getRSGroupInfo("bar");
        try {
            rsGroupAdmin.removeRSGroup(barGroup.getName());
            Assert.fail((String)"Expected remove group to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            rsGroupAdmin.moveServers(barGroup.getServers(), "default");
            Assert.fail((String)"Expected move servers to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        rsGroupAdmin.moveTables((Set)barGroup.getTables(), "default");
        try {
            rsGroupAdmin.removeRSGroup(barGroup.getName());
            Assert.fail((String)"Expected move servers to fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        rsGroupAdmin.moveServers(barGroup.getServers(), "default");
        rsGroupAdmin.removeRSGroup(barGroup.getName());
        Assert.assertEquals((long)initNumGroups, (long)rsGroupAdmin.listRSGroups().size());
    }

    @Test
    public void testKillRS() throws Exception {
        RSGroupInfo appInfo = this.addGroup("appInfo", 1);
        TableName tableName = TableName.valueOf((String)"Group_ns", (String)this.name.getMethodName());
        admin.createNamespace(NamespaceDescriptor.create((String)tableName.getNamespaceAsString()).addConfiguration("hbase.rsgroup.name", appInfo.getName()).build());
        final HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        admin.createTable((TableDescriptor)desc);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.this.getTableRegionMap().get(desc.getTableName()) != null;
            }
        });
        ServerName targetServer = ServerName.parseServerName((String)((Address)appInfo.getServers().iterator().next()).toString());
        AdminProtos.AdminService.BlockingInterface targetRS = ((ClusterConnection)admin.getConnection()).getAdmin(targetServer);
        RegionInfo targetRegion = (RegionInfo)ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)targetRS).get(0);
        Assert.assertEquals((long)1L, (long)ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)targetRS).size());
        try {
            targetRS.stopServer(null, AdminProtos.StopServerRequest.newBuilder().setReason("Die").build());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)cluster.getClusterMetrics().getLiveServerMetrics().containsKey(targetServer));
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return cluster.getClusterMetrics().getRegionStatesInTransition().isEmpty();
            }
        });
        HashSet newServers = Sets.newHashSet();
        newServers.add(rsGroupAdmin.getRSGroupInfo("default").getServers().iterator().next());
        rsGroupAdmin.moveServers((Set)newServers, appInfo.getName());
        admin.disableTable(tableName);
        admin.enableTable(tableName);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return cluster.getClusterMetrics().getRegionStatesInTransition().isEmpty();
            }
        });
        targetServer = ServerName.parseServerName((String)((Address)newServers.iterator().next()).toString());
        targetRS = ((ClusterConnection)admin.getConnection()).getAdmin(targetServer);
        Assert.assertEquals((long)1L, (long)ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)targetRS).size());
        Assert.assertEquals((Object)tableName, (Object)((RegionInfo)ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)targetRS).get(0)).getTable());
    }

    @Test
    public void testValidGroupNames() throws IOException {
        String[] badNames = new String[]{"foo*", "foo@", "-"};
        String[] goodNames = new String[]{"foo_123"};
        for (String entry : badNames) {
            try {
                rsGroupAdmin.addRSGroup(entry);
                Assert.fail((String)("Expected a constraint exception for: " + entry));
            }
            catch (ConstraintException constraintException) {
                // empty catch block
            }
        }
        for (String entry : goodNames) {
            rsGroupAdmin.addRSGroup(entry);
        }
    }

    private String getGroupName(String baseName) {
        return "Group_" + baseName + "_" + rand.nextInt(Integer.MAX_VALUE);
    }

    @Test
    public void testMultiTableMove() throws Exception {
        final TableName tableNameA = TableName.valueOf((String)("Group" + this.name.getMethodName() + "A"));
        final TableName tableNameB = TableName.valueOf((String)("Group" + this.name.getMethodName() + "B"));
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        String newGroupName = this.getGroupName(this.name.getMethodName());
        RSGroupInfo newGroup = this.addGroup(newGroupName, 1);
        TEST_UTIL.createTable(tableNameA, familyNameBytes);
        TEST_UTIL.createTable(tableNameB, familyNameBytes);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regionsA = TestRSGroupsBase.this.getTableRegionMap().get(tableNameA);
                if (regionsA == null) {
                    return false;
                }
                List<String> regionsB = TestRSGroupsBase.this.getTableRegionMap().get(tableNameB);
                if (regionsB == null) {
                    return false;
                }
                return TestRSGroupsBase.this.getTableRegionMap().get(tableNameA).size() >= 1 && TestRSGroupsBase.this.getTableRegionMap().get(tableNameB).size() >= 1;
            }
        });
        RSGroupInfo tableGrpA = rsGroupAdmin.getRSGroupInfoOfTable(tableNameA);
        Assert.assertTrue((boolean)tableGrpA.getName().equals("default"));
        RSGroupInfo tableGrpB = rsGroupAdmin.getRSGroupInfoOfTable(tableNameB);
        Assert.assertTrue((boolean)tableGrpB.getName().equals("default"));
        LOG.info("Moving table [" + tableNameA + "," + tableNameB + "] to " + newGroup.getName());
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{tableNameA, tableNameB}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)rsGroupAdmin.getRSGroupInfoOfTable(tableNameA).getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)rsGroupAdmin.getRSGroupInfoOfTable(tableNameB).getName());
        SortedSet DefaultTables = rsGroupAdmin.getRSGroupInfo("default").getTables();
        Assert.assertFalse((boolean)DefaultTables.contains(tableNameA));
        Assert.assertFalse((boolean)DefaultTables.contains(tableNameB));
        SortedSet newGroupTables = rsGroupAdmin.getRSGroupInfo(newGroupName).getTables();
        Assert.assertTrue((boolean)newGroupTables.contains(tableNameA));
        Assert.assertTrue((boolean)newGroupTables.contains(tableNameB));
    }

    @Test
    public void testDisabledTableMove() throws Exception {
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        String newGroupName = this.getGroupName(this.name.getMethodName());
        RSGroupInfo newGroup = this.addGroup(newGroupName, 2);
        TEST_UTIL.createMultiRegionTable(this.tableName, familyNameBytes, 5);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName).size() >= 5;
            }
        });
        RSGroupInfo tableGrp = rsGroupAdmin.getRSGroupInfoOfTable(this.tableName);
        Assert.assertTrue((boolean)tableGrp.getName().equals("default"));
        admin.disableTable(this.tableName);
        LOG.info("Moving table " + this.tableName + " to " + newGroup.getName());
        rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)rsGroupAdmin.getRSGroupInfoOfTable(this.tableName).getName());
    }

    @Test
    public void testNonExistentTableMove() throws Exception {
        TableName tableName = TableName.valueOf((String)("Group" + this.name.getMethodName()));
        RSGroupInfo tableGrp = rsGroupAdmin.getRSGroupInfoOfTable(tableName);
        Assert.assertNull((Object)tableGrp);
        boolean exist = admin.tableExists(tableName);
        Assert.assertFalse((boolean)exist);
        LOG.info("Moving table " + tableName + " to " + "default");
        try {
            rsGroupAdmin.moveTables((Set)Sets.newHashSet((Object[])new TableName[]{tableName}), "default");
            Assert.fail((String)("Table " + tableName + " shouldn't have been successfully moved."));
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)(ex instanceof TableNotFoundException));
        }
        try {
            rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Object[])new Address[]{Address.fromParts((String)"bogus", (int)123)}), (Set)Sets.newHashSet((Object[])new TableName[]{tableName}), "default");
            Assert.fail((String)("Table " + tableName + " shouldn't have been successfully moved."));
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)(ex instanceof TableNotFoundException));
        }
        Assert.assertNull((Object)rsGroupAdmin.getRSGroupInfoOfTable(tableName));
    }

    @Test
    public void testMoveServersAndTables() throws Exception {
        String msg;
        Object exp;
        LOG.info("testMoveServersAndTables");
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 1);
        byte[] familyNameBytes = Bytes.toBytes((String)"f");
        TEST_UTIL.createMultiRegionTable(this.tableName, familyNameBytes, 5);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName);
                if (regions == null) {
                    return false;
                }
                return TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName).size() >= 5;
            }
        });
        ServerName targetServer = null;
        for (ServerName server : admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
            if (newGroup.containsServer(server.getAddress()) || rsGroupAdmin.getRSGroupInfo("master").containsServer(server.getAddress())) continue;
            targetServer = server;
            break;
        }
        LOG.debug("Print group info : " + rsGroupAdmin.listRSGroups());
        int oldDefaultGroupServerSize = rsGroupAdmin.getRSGroupInfo("default").getServers().size();
        int oldDefaultGroupTableSize = rsGroupAdmin.getRSGroupInfo("default").getTables().size();
        try {
            rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Object[])new Address[]{Address.fromString((String)"foo:9999")}), (Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), newGroup.getName());
            Assert.fail((String)"Bogus servers shouldn't have been successfully moved.");
        }
        catch (IOException ex) {
            exp = "Source RSGroup for server foo:9999 does not exist.";
            msg = "Expected '" + (String)exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains((CharSequence)exp));
        }
        try {
            rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}), (Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), "default");
            Assert.fail((String)"servers shouldn't have been successfully moved.");
        }
        catch (IOException ex) {
            exp = "Target RSGroup default is same as source default RSGroup.";
            msg = "Expected '" + (String)exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains((CharSequence)exp));
        }
        Assert.assertEquals((long)oldDefaultGroupServerSize, (long)rsGroupAdmin.getRSGroupInfo("default").getServers().size());
        Assert.assertEquals((long)oldDefaultGroupTableSize, (long)rsGroupAdmin.getRSGroupInfo("default").getTables().size());
        Assert.assertEquals((long)1L, (long)rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getServers().size());
        Assert.assertEquals((long)0L, (long)rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getTables().size());
        List<String> regionList = this.getTableRegionMap().get(this.tableName);
        for (String region : regionList) {
            TEST_UTIL.getAdmin().move(Bytes.toBytes((String)RegionInfo.encodeRegionName((byte[])Bytes.toBytes((String)region))), Bytes.toBytes((String)targetServer.getServerName()));
        }
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName) != null && TestRSGroupsBase.this.getTableRegionMap().get(TestRSGroupsBase.this.tableName).size() == 5 && TestRSGroupsBase.this.getTableServerRegionMap().get(TestRSGroupsBase.this.tableName).size() == 1 && admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.REGIONS_IN_TRANSITION)).getRegionStatesInTransition().size() < 1;
            }
        });
        Assert.assertEquals((long)5L, (long)this.getTableServerRegionMap().get(this.tableName).get(targetServer).size());
        LOG.info("moving server and table to newGroup");
        rsGroupAdmin.moveServersAndTables((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}), (Set)Sets.newHashSet((Object[])new TableName[]{this.tableName}), newGroup.getName());
        Assert.assertEquals((Object)newGroup.getName(), (Object)rsGroupAdmin.getRSGroupInfoOfTable(this.tableName).getName());
        Set defaultServers = rsGroupAdmin.getRSGroupInfo("default").getServers();
        Assert.assertFalse((boolean)defaultServers.contains(targetServer.getAddress()));
        Set newGroupServers = rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getServers();
        Assert.assertTrue((boolean)newGroupServers.contains(targetServer.getAddress()));
        SortedSet defaultTables = rsGroupAdmin.getRSGroupInfo("default").getTables();
        Assert.assertFalse((boolean)defaultTables.contains(this.tableName));
        SortedSet newGroupTables = rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getTables();
        Assert.assertTrue((boolean)newGroupTables.contains(this.tableName));
        Assert.assertEquals((long)5L, (long)this.getTableServerRegionMap().get(this.tableName).get(targetServer).size());
    }

    @Test
    public void testClearDeadServers() throws Exception {
        LOG.info("testClearDeadServers");
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 3);
        NUM_DEAD_SERVERS = cluster.getClusterMetrics().getDeadServerNames().size();
        ServerName targetServer = ServerName.parseServerName((String)((Address)newGroup.getServers().iterator().next()).toString());
        AdminProtos.AdminService.BlockingInterface targetRS = ((ClusterConnection)admin.getConnection()).getAdmin(targetServer);
        try {
            targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)targetRS.getServerInfo(null, AdminProtos.GetServerInfoRequest.newBuilder().build()).getServerInfo().getServerName());
            targetRS.stopServer(null, AdminProtos.StopServerRequest.newBuilder().setReason("Die").build());
            ++NUM_DEAD_SERVERS;
        }
        catch (Exception exception) {
            // empty catch block
        }
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !master.getServerManager().areDeadServersInProgress() && cluster.getClusterMetrics().getDeadServerNames().size() == NUM_DEAD_SERVERS;
            }
        });
        Assert.assertFalse((boolean)cluster.getClusterMetrics().getLiveServerMetrics().containsKey(targetServer));
        Assert.assertTrue((boolean)cluster.getClusterMetrics().getDeadServerNames().contains(targetServer));
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        List notClearedServers = admin.clearDeadServers((List)Lists.newArrayList((Object[])new ServerName[]{targetServer}));
        Assert.assertEquals((long)0L, (long)notClearedServers.size());
        Set newGroupServers = rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getServers();
        Assert.assertFalse((boolean)newGroupServers.contains(targetServer.getAddress()));
        Assert.assertEquals((long)2L, (long)newGroupServers.size());
    }

    @Test
    public void testRemoveServers() throws Exception {
        LOG.info("testRemoveServers");
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 3);
        Iterator iterator = newGroup.getServers().iterator();
        ServerName targetServer = ServerName.parseServerName((String)((Address)iterator.next()).toString());
        try {
            rsGroupAdmin.removeServers((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}));
            Assert.fail((String)"Online servers shouldn't have been successfully removed.");
        }
        catch (IOException ex) {
            String exp = "Server " + targetServer.getAddress() + " is an online server, not allowed to remove.";
            String msg = "Expected '" + exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        NUM_DEAD_SERVERS = cluster.getClusterMetrics().getDeadServerNames().size();
        AdminProtos.AdminService.BlockingInterface targetRS = ((ClusterConnection)admin.getConnection()).getAdmin(targetServer);
        try {
            targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)targetRS.getServerInfo(null, AdminProtos.GetServerInfoRequest.newBuilder().build()).getServerInfo().getServerName());
            LOG.info("stopping server " + targetServer.getHostAndPort());
            targetRS.stopServer(null, AdminProtos.StopServerRequest.newBuilder().setReason("Die").build());
            ++NUM_DEAD_SERVERS;
        }
        catch (Exception exp) {
            // empty catch block
        }
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !master.getServerManager().areDeadServersInProgress() && cluster.getClusterMetrics().getDeadServerNames().size() == NUM_DEAD_SERVERS;
            }
        });
        try {
            rsGroupAdmin.removeServers((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}));
            Assert.fail((String)"Dead servers shouldn't have been successfully removed.");
        }
        catch (IOException ex) {
            String exp = "Server " + targetServer.getAddress() + " is on the dead servers list, Maybe it will come back again, not allowed to remove.";
            String msg = "Expected '" + exp + "' in exception message: ";
            Assert.assertTrue((String)(msg + " " + ex.getMessage()), (boolean)ex.getMessage().contains(exp));
        }
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        ArrayList<ServerName> serversToDecommission = new ArrayList<ServerName>();
        targetServer = ServerName.parseServerName((String)((Address)iterator.next()).toString());
        targetRS = ((ClusterConnection)admin.getConnection()).getAdmin(targetServer);
        targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)targetRS.getServerInfo(null, AdminProtos.GetServerInfoRequest.newBuilder().build()).getServerInfo().getServerName());
        Assert.assertTrue((boolean)master.getServerManager().getOnlineServers().containsKey(targetServer));
        serversToDecommission.add(targetServer);
        admin.decommissionRegionServers(serversToDecommission, true);
        Assert.assertEquals((long)1L, (long)admin.listDecommissionedRegionServers().size());
        Assert.assertTrue((boolean)newGroup.getServers().contains(targetServer.getAddress()));
        rsGroupAdmin.removeServers((Set)Sets.newHashSet((Object[])new Address[]{targetServer.getAddress()}));
        Set newGroupServers = rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getServers();
        Assert.assertFalse((boolean)newGroupServers.contains(targetServer.getAddress()));
        Assert.assertEquals((long)2L, (long)newGroupServers.size());
    }

    @Test
    public void testCreateWhenRsgroupNoOnlineServers() throws Exception {
        LOG.info("testCreateWhenRsgroupNoOnlineServers");
        RSGroupInfo appInfo = this.addGroup("appInfo", 1);
        Iterator iterator = appInfo.getServers().iterator();
        ArrayList<ServerName> serversToDecommission = new ArrayList<ServerName>();
        ServerName targetServer = ServerName.parseServerName((String)((Address)iterator.next()).toString());
        AdminProtos.AdminService.BlockingInterface targetRS = ((ClusterConnection)admin.getConnection()).getAdmin(targetServer);
        targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)targetRS.getServerInfo(null, AdminProtos.GetServerInfoRequest.newBuilder().build()).getServerInfo().getServerName());
        Assert.assertTrue((boolean)master.getServerManager().getOnlineServers().containsKey(targetServer));
        serversToDecommission.add(targetServer);
        admin.decommissionRegionServers(serversToDecommission, true);
        Assert.assertEquals((long)1L, (long)admin.listDecommissionedRegionServers().size());
        TableName tableName = TableName.valueOf((String)"Group_ns", (String)this.name.getMethodName());
        admin.createNamespace(NamespaceDescriptor.create((String)tableName.getNamespaceAsString()).addConfiguration("hbase.rsgroup.name", appInfo.getName()).build());
        final HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        try {
            admin.createTable((TableDescriptor)desc);
            Assert.fail((String)"Shouldn't create table successfully!");
        }
        catch (Exception e) {
            LOG.debug("create table error", (Throwable)e);
        }
        admin.recommissionRegionServer(targetServer, null);
        Assert.assertEquals((long)0L, (long)admin.listDecommissionedRegionServers().size());
        admin.createTable((TableDescriptor)desc);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.this.getTableRegionMap().get(desc.getTableName()) != null;
            }
        });
    }

    static {
        NUM_DEAD_SERVERS = 0;
    }
}

