/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.SimpleLoadBalancer;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SmallTests.class})
public class TestRSGroupBasedLoadBalancer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupBasedLoadBalancer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRSGroupBasedLoadBalancer.class);
    private static RSGroupBasedLoadBalancer loadBalancer;
    private static SecureRandom rand;
    static String[] groups;
    static TableName table0;
    static TableName[] tables;
    static List<ServerName> servers;
    static Map<String, RSGroupInfo> groupMap;
    static Map<TableName, String> tableMap;
    static List<HTableDescriptor> tableDescs;
    int[] regionAssignment = new int[]{2, 5, 7, 10, 4, 3, 1};
    static int regionId;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        rand = new SecureRandom();
        servers = TestRSGroupBasedLoadBalancer.generateServers(7);
        groupMap = TestRSGroupBasedLoadBalancer.constructGroupInfo(servers, groups);
        tableMap = new HashMap<TableName, String>();
        tableDescs = TestRSGroupBasedLoadBalancer.constructTableDesc();
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.regions.slop", "0");
        conf.set("hbase.rsgroup.grouploadbalancer.class", SimpleLoadBalancer.class.getCanonicalName());
        loadBalancer = new RSGroupBasedLoadBalancer();
        loadBalancer.setRsGroupInfoManager(TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager());
        loadBalancer.setMasterServices(TestRSGroupBasedLoadBalancer.getMockedMaster());
        loadBalancer.setConf(conf);
        loadBalancer.initialize();
    }

    @Test
    public void testBalanceCluster() throws Exception {
        Map<ServerName, List<RegionInfo>> servers = this.mockClusterServers();
        ArrayListMultimap<String, ServerAndLoad> list = this.convertToGroupBasedMap(servers);
        LOG.info("Mock Cluster :  " + this.printStats(list));
        List plans = loadBalancer.balanceCluster(servers);
        ArrayListMultimap<String, ServerAndLoad> balancedCluster = this.reconcile(list, plans);
        LOG.info("Mock Balance : " + this.printStats(balancedCluster));
        this.assertClusterAsBalanced(balancedCluster);
    }

    private void assertClusterAsBalanced(ArrayListMultimap<String, ServerAndLoad> groupLoadMap) {
        for (String gName : groupLoadMap.keySet()) {
            List groupLoad = groupLoadMap.get((Object)gName);
            int numServers = groupLoad.size();
            int numRegions = 0;
            int maxRegions = 0;
            int minRegions = Integer.MAX_VALUE;
            for (ServerAndLoad server : groupLoad) {
                int nr = server.getLoad();
                if (nr > maxRegions) {
                    maxRegions = nr;
                }
                if (nr < minRegions) {
                    minRegions = nr;
                }
                numRegions += nr;
            }
            if (maxRegions - minRegions < 2) {
                return;
            }
            int min = numRegions / numServers;
            int max = numRegions % numServers == 0 ? min : min + 1;
            for (ServerAndLoad server : groupLoad) {
                Assert.assertTrue((server.getLoad() <= max ? 1 : 0) != 0);
                Assert.assertTrue((server.getLoad() >= min ? 1 : 0) != 0);
            }
        }
    }

    private void assertImmediateAssignment(List<RegionInfo> regions, List<ServerName> servers, Map<RegionInfo, ServerName> assignments) throws IOException {
        for (RegionInfo region : regions) {
            Assert.assertTrue((boolean)assignments.containsKey(region));
            ServerName server = assignments.get(region);
            TableName tableName = region.getTable();
            String groupName = TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager().getRSGroupOfTable(tableName);
            Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)groupName));
            RSGroupInfo gInfo = TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager().getRSGroup(groupName);
            Assert.assertTrue((String)"Region is not correctly assigned to group servers.", (boolean)gInfo.containsServer(server.getAddress()));
        }
    }

    @Test
    public void testBulkAssignment() throws Exception {
        List<RegionInfo> regions = this.randomRegions(25);
        Map assignments = loadBalancer.roundRobinAssignment(regions, servers);
        loadBalancer.roundRobinAssignment(regions, Collections.EMPTY_LIST);
        Assert.assertTrue((assignments.keySet().size() == servers.size() ? 1 : 0) != 0);
        for (ServerName sn : assignments.keySet()) {
            List regionAssigned = (List)assignments.get(sn);
            for (RegionInfo region : regionAssigned) {
                TableName tableName = region.getTable();
                String groupName = TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager().getRSGroupOfTable(tableName);
                Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)groupName));
                RSGroupInfo gInfo = TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager().getRSGroup(groupName);
                Assert.assertTrue((String)"Region is not correctly assigned to group servers.", (boolean)gInfo.containsServer(sn.getAddress()));
            }
        }
        ArrayListMultimap<String, ServerAndLoad> loadMap = this.convertToGroupBasedMap(assignments);
        this.assertClusterAsBalanced(loadMap);
    }

    @Test
    public void testGetMisplacedRegions() throws Exception {
        HashMap<RegionInfo, ServerName> inputForTest = new HashMap<RegionInfo, ServerName>();
        RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)table0).setStartKey(new byte[16]).setEndKey(new byte[16]).setSplit(false).setRegionId((long)regionId++).build();
        inputForTest.put(ri, servers.iterator().next());
        Set misplacedRegions = loadBalancer.getMisplacedRegions(inputForTest);
        Assert.assertFalse((boolean)misplacedRegions.contains(ri));
    }

    @Test
    public void testRetainAssignment() throws Exception {
        Map<ServerName, List<RegionInfo>> currentAssignments = this.mockClusterServers();
        HashMap<RegionInfo, ServerName> inputForTest = new HashMap<RegionInfo, ServerName>();
        for (ServerName sn : currentAssignments.keySet()) {
            for (RegionInfo region : currentAssignments.get(sn)) {
                inputForTest.put(region, sn);
            }
        }
        inputForTest.put(this.randomRegions(1).get(0), null);
        Map newAssignment = loadBalancer.retainAssignment(inputForTest, servers);
        this.assertRetainedAssignment(inputForTest, servers, newAssignment);
    }

    @Test
    public void testRoundRobinAssignment() throws Exception {
        ArrayList<ServerName> onlineServers = new ArrayList<ServerName>(servers.size());
        onlineServers.addAll(servers);
        List<RegionInfo> regions = this.randomRegions(25);
        int bogusRegion = 0;
        for (RegionInfo region : regions) {
            String group = tableMap.get(region.getTable());
            if (!"dg3".equals(group) && !"dg4".equals(group)) continue;
            ++bogusRegion;
        }
        HashSet offlineServers = new HashSet();
        offlineServers.addAll(groupMap.get("dg3").getServers());
        offlineServers.addAll(groupMap.get("dg4").getServers());
        Iterator it = onlineServers.iterator();
        while (it.hasNext()) {
            ServerName server = (ServerName)it.next();
            Address address = server.getAddress();
            if (!offlineServers.contains(address)) continue;
            it.remove();
        }
        Map assignments = loadBalancer.roundRobinAssignment(regions, onlineServers);
        Assert.assertEquals((long)bogusRegion, (long)((List)assignments.get(LoadBalancer.BOGUS_SERVER_NAME)).size());
    }

    private void assertRetainedAssignment(Map<RegionInfo, ServerName> existing, List<ServerName> servers, Map<ServerName, List<RegionInfo>> assignment) throws FileNotFoundException, IOException {
        TreeSet<ServerName> onlineServerSet = new TreeSet<ServerName>(servers);
        TreeSet<RegionInfo> assignedRegions = new TreeSet<RegionInfo>(RegionInfo.COMPARATOR);
        for (Map.Entry<ServerName, List<RegionInfo>> a : assignment.entrySet()) {
            Assert.assertTrue((String)"Region assigned to server that was not listed as online", (boolean)onlineServerSet.contains(a.getKey()));
            for (RegionInfo r : a.getValue()) {
                assignedRegions.add(r);
            }
        }
        Assert.assertEquals((long)existing.size(), (long)assignedRegions.size());
        TreeSet<String> onlineHostNames = new TreeSet<String>();
        for (ServerName serverName : servers) {
            onlineHostNames.add(serverName.getHostname());
        }
        for (Map.Entry entry : assignment.entrySet()) {
            ServerName currentServer = (ServerName)entry.getKey();
            for (RegionInfo r : (List)entry.getValue()) {
                ServerName oldAssignedServer = existing.get(r);
                TableName tableName = r.getTable();
                String groupName = TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager().getRSGroupOfTable(tableName);
                Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)groupName));
                RSGroupInfo gInfo = TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager().getRSGroup(groupName);
                Assert.assertTrue((String)"Region is not correctly assigned to group servers.", (boolean)gInfo.containsServer(currentServer.getAddress()));
                if (oldAssignedServer == null || !onlineHostNames.contains(oldAssignedServer.getHostname()) || oldAssignedServer.getAddress().equals((Object)currentServer.getAddress())) continue;
                Assert.assertFalse((boolean)gInfo.containsServer(oldAssignedServer.getAddress()));
            }
        }
    }

    private String printStats(ArrayListMultimap<String, ServerAndLoad> groupBasedLoad) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        for (String groupName : groupBasedLoad.keySet()) {
            sb.append("Stats for group: " + groupName);
            sb.append("\n");
            sb.append(groupMap.get(groupName).getServers());
            sb.append("\n");
            List groupLoad = groupBasedLoad.get((Object)groupName);
            int numServers = groupLoad.size();
            int totalRegions = 0;
            sb.append("Per Server Load: \n");
            for (ServerAndLoad sLoad : groupLoad) {
                sb.append("Server :" + sLoad.getServerName() + " Load : " + sLoad.getLoad() + "\n");
                totalRegions += sLoad.getLoad();
            }
            sb.append(" Group Statistics : \n");
            float average = (float)totalRegions / (float)numServers;
            int max = (int)Math.ceil(average);
            int min = (int)Math.floor(average);
            sb.append("[srvr=" + numServers + " rgns=" + totalRegions + " avg=" + average + " max=" + max + " min=" + min + "]");
            sb.append("\n");
            sb.append("===============================");
            sb.append("\n");
        }
        return sb.toString();
    }

    private ArrayListMultimap<String, ServerAndLoad> convertToGroupBasedMap(Map<ServerName, List<RegionInfo>> serversMap) throws IOException {
        ArrayListMultimap loadMap = ArrayListMultimap.create();
        for (RSGroupInfo gInfo : TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager().listRSGroups()) {
            Set groupServers = gInfo.getServers();
            for (Address hostPort : groupServers) {
                ServerName actual = null;
                for (ServerName entry : servers) {
                    if (!entry.getAddress().equals((Object)hostPort)) continue;
                    actual = entry;
                    break;
                }
                List<RegionInfo> regions = serversMap.get(actual);
                Assert.assertTrue((String)("No load for " + actual), (regions != null ? 1 : 0) != 0);
                loadMap.put((Object)gInfo.getName(), (Object)new ServerAndLoad(actual, regions.size()));
            }
        }
        return loadMap;
    }

    private ArrayListMultimap<String, ServerAndLoad> reconcile(ArrayListMultimap<String, ServerAndLoad> previousLoad, List<RegionPlan> plans) {
        ArrayListMultimap result = ArrayListMultimap.create();
        result.putAll(previousLoad);
        if (plans != null) {
            for (RegionPlan plan : plans) {
                ServerName source = plan.getSource();
                this.updateLoad((ArrayListMultimap<String, ServerAndLoad>)result, source, -1);
                ServerName destination = plan.getDestination();
                this.updateLoad((ArrayListMultimap<String, ServerAndLoad>)result, destination, 1);
            }
        }
        return result;
    }

    private void updateLoad(ArrayListMultimap<String, ServerAndLoad> previousLoad, ServerName sn, int diff) {
        for (String groupName : previousLoad.keySet()) {
            ServerAndLoad newSAL = null;
            ServerAndLoad oldSAL = null;
            for (ServerAndLoad sal : previousLoad.get((Object)groupName)) {
                if (!ServerName.isSameAddress((ServerName)sn, (ServerName)sal.getServerName())) continue;
                oldSAL = sal;
                newSAL = new ServerAndLoad(sn, sal.getLoad() + diff);
                break;
            }
            if (newSAL == null) continue;
            previousLoad.remove((Object)groupName, oldSAL);
            previousLoad.put((Object)groupName, newSAL);
            break;
        }
    }

    private Map<ServerName, List<RegionInfo>> mockClusterServers() throws IOException {
        Assert.assertTrue((servers.size() == this.regionAssignment.length ? 1 : 0) != 0);
        TreeMap<ServerName, List<RegionInfo>> assignment = new TreeMap<ServerName, List<RegionInfo>>();
        for (int i = 0; i < servers.size(); ++i) {
            int numRegions = this.regionAssignment[i];
            List<RegionInfo> regions = this.assignedRegions(numRegions, servers.get(i));
            assignment.put(servers.get(i), regions);
        }
        return assignment;
    }

    private List<RegionInfo> randomRegions(int numRegions) {
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(numRegions);
        byte[] start = new byte[16];
        byte[] end = new byte[16];
        rand.nextBytes(start);
        rand.nextBytes(end);
        int regionIdx = rand.nextInt(tables.length);
        for (int i = 0; i < numRegions; ++i) {
            Bytes.putInt((byte[])start, (int)0, (int)(numRegions << 1));
            Bytes.putInt((byte[])end, (int)0, (int)((numRegions << 1) + 1));
            int tableIndex = (i + regionIdx) % tables.length;
            regions.add(RegionInfoBuilder.newBuilder((TableName)tables[tableIndex]).setStartKey(start).setEndKey(end).setSplit(false).setRegionId((long)regionId++).build());
        }
        return regions;
    }

    private List<RegionInfo> assignedRegions(int numRegions, ServerName sn) throws IOException {
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(numRegions);
        byte[] start = new byte[16];
        byte[] end = new byte[16];
        Bytes.putInt((byte[])start, (int)0, (int)(numRegions << 1));
        Bytes.putInt((byte[])end, (int)0, (int)((numRegions << 1) + 1));
        for (int i = 0; i < numRegions; ++i) {
            TableName tableName = this.getTableName(sn);
            regions.add(RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(start).setEndKey(end).setSplit(false).setRegionId((long)regionId++).build());
        }
        return regions;
    }

    private static List<ServerName> generateServers(int numServers) {
        ArrayList<ServerName> servers = new ArrayList<ServerName>(numServers);
        for (int i = 0; i < numServers; ++i) {
            String host = "server" + rand.nextInt(100000);
            int port = rand.nextInt(60000);
            servers.add(ServerName.valueOf((String)host, (int)port, (long)-1L));
        }
        return servers;
    }

    private static Map<String, RSGroupInfo> constructGroupInfo(List<ServerName> servers, String[] groups) {
        Assert.assertTrue((servers != null ? 1 : 0) != 0);
        Assert.assertTrue((servers.size() >= groups.length ? 1 : 0) != 0);
        int index = 0;
        HashMap<String, RSGroupInfo> groupMap = new HashMap<String, RSGroupInfo>();
        for (String grpName : groups) {
            RSGroupInfo RSGroupInfo2 = new RSGroupInfo(grpName);
            RSGroupInfo2.addServer(servers.get(index).getAddress());
            groupMap.put(grpName, RSGroupInfo2);
            ++index;
        }
        while (index < servers.size()) {
            int grpIndex = rand.nextInt(groups.length);
            ((RSGroupInfo)groupMap.get(groups[grpIndex])).addServer(servers.get(index).getAddress());
            ++index;
        }
        return groupMap;
    }

    private static List<HTableDescriptor> constructTableDesc() {
        ArrayList tds = Lists.newArrayList();
        int index = rand.nextInt(groups.length);
        for (int i = 0; i < tables.length; ++i) {
            HTableDescriptor htd = new HTableDescriptor(tables[i]);
            int grpIndex = (i + index) % groups.length;
            String groupName = groups[grpIndex];
            tableMap.put(tables[i], groupName);
            tds.add(htd);
        }
        tableMap.put(table0, "");
        tds.add(new HTableDescriptor(table0));
        return tds;
    }

    private static MasterServices getMockedMaster() throws IOException {
        TableDescriptors tds = (TableDescriptors)Mockito.mock(TableDescriptors.class);
        Mockito.when((Object)tds.get(tables[0])).thenReturn((Object)tableDescs.get(0));
        Mockito.when((Object)tds.get(tables[1])).thenReturn((Object)tableDescs.get(1));
        Mockito.when((Object)tds.get(tables[2])).thenReturn((Object)tableDescs.get(2));
        Mockito.when((Object)tds.get(tables[3])).thenReturn((Object)tableDescs.get(3));
        MasterServices services = (MasterServices)Mockito.mock(HMaster.class);
        Mockito.when((Object)services.getTableDescriptors()).thenReturn((Object)tds);
        AssignmentManager am = (AssignmentManager)Mockito.mock(AssignmentManager.class);
        Mockito.when((Object)services.getAssignmentManager()).thenReturn((Object)am);
        RegionStates rss = (RegionStates)Mockito.mock(RegionStates.class);
        Mockito.when((Object)am.getRegionStates()).thenReturn((Object)rss);
        return services;
    }

    private static RSGroupInfoManager getMockedGroupInfoManager() throws IOException {
        RSGroupInfoManager gm = (RSGroupInfoManager)Mockito.mock(RSGroupInfoManager.class);
        Mockito.when((Object)gm.getRSGroup(groups[0])).thenReturn((Object)groupMap.get(groups[0]));
        Mockito.when((Object)gm.getRSGroup(groups[1])).thenReturn((Object)groupMap.get(groups[1]));
        Mockito.when((Object)gm.getRSGroup(groups[2])).thenReturn((Object)groupMap.get(groups[2]));
        Mockito.when((Object)gm.getRSGroup(groups[3])).thenReturn((Object)groupMap.get(groups[3]));
        Mockito.when((Object)gm.listRSGroups()).thenReturn((Object)Lists.newLinkedList(groupMap.values()));
        Mockito.when((Object)gm.isOnline()).thenReturn((Object)true);
        Mockito.when((Object)gm.getRSGroupOfTable((TableName)Mockito.any())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return tableMap.get(invocation.getArgument(0));
            }
        });
        return gm;
    }

    private TableName getTableName(ServerName sn) throws IOException {
        TableName tableName = null;
        RSGroupInfoManager gm = TestRSGroupBasedLoadBalancer.getMockedGroupInfoManager();
        RSGroupInfo groupOfServer = null;
        for (RSGroupInfo gInfo : gm.listRSGroups()) {
            if (!gInfo.containsServer(sn.getAddress())) continue;
            groupOfServer = gInfo;
            break;
        }
        for (HTableDescriptor desc : tableDescs) {
            if (!gm.getRSGroupOfTable(desc.getTableName()).endsWith(groupOfServer.getName())) continue;
            tableName = desc.getTableName();
        }
        return tableName;
    }

    static {
        groups = new String[]{"default", "dg2", "dg3", "dg4"};
        table0 = TableName.valueOf((String)"dt0");
        tables = new TableName[]{TableName.valueOf((String)"dt1"), TableName.valueOf((String)"dt2"), TableName.valueOf((String)"dt3"), TableName.valueOf((String)"dt4")};
        regionId = 0;
    }
}

