/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.protobuf.ProtobufMagic;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.protobuf.generated.RSGroupProtos;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupProtobufUtil;
import org.apache.hadoop.hbase.rsgroup.Utility;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class RSGroupInfoManagerImpl
implements RSGroupInfoManager {
    private static final Logger LOG = LoggerFactory.getLogger(RSGroupInfoManagerImpl.class);
    private static final HTableDescriptor RSGROUP_TABLE_DESC = new HTableDescriptor(RSGROUP_TABLE_NAME);
    private volatile Map<String, RSGroupInfo> rsGroupMap = Collections.emptyMap();
    private volatile Map<TableName, String> tableMap = Collections.emptyMap();
    private final MasterServices masterServices;
    private Table rsGroupTable;
    private final ClusterConnection conn;
    private final ZKWatcher watcher;
    private final RSGroupStartupWorker rsGroupStartupWorker = new RSGroupStartupWorker();
    private Set<String> prevRSGroups = new HashSet<String>();
    private final ServerEventsListenerThread serverEventsListenerThread = new ServerEventsListenerThread();
    private FailedOpenUpdaterThread failedOpenUpdaterThread;

    private RSGroupInfoManagerImpl(MasterServices masterServices) throws IOException {
        this.masterServices = masterServices;
        this.watcher = masterServices.getZooKeeper();
        this.conn = masterServices.getClusterConnection();
    }

    private synchronized void init() throws IOException {
        this.refresh();
        this.serverEventsListenerThread.start();
        this.masterServices.getServerManager().registerListener((ServerListener)this.serverEventsListenerThread);
        this.failedOpenUpdaterThread = new FailedOpenUpdaterThread(this.masterServices.getConfiguration());
        this.failedOpenUpdaterThread.start();
        this.masterServices.getServerManager().registerListener((ServerListener)this.failedOpenUpdaterThread);
    }

    static RSGroupInfoManager getInstance(MasterServices master) throws IOException {
        RSGroupInfoManagerImpl instance = new RSGroupInfoManagerImpl(master);
        instance.init();
        return instance;
    }

    @Override
    public void start() {
        this.rsGroupStartupWorker.start();
    }

    @Override
    public synchronized void addRSGroup(RSGroupInfo rsGroupInfo) throws IOException {
        this.checkGroupName(rsGroupInfo.getName());
        if (this.rsGroupMap.get(rsGroupInfo.getName()) != null || rsGroupInfo.getName().equals("default")) {
            throw new DoNotRetryIOException("Group already exists: " + rsGroupInfo.getName());
        }
        HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
        newGroupMap.put(rsGroupInfo.getName(), rsGroupInfo);
        this.flushConfig(newGroupMap);
    }

    private RSGroupInfo getRSGroupInfo(String groupName) throws DoNotRetryIOException {
        RSGroupInfo rsGroupInfo = this.getRSGroup(groupName);
        if (rsGroupInfo == null) {
            throw new DoNotRetryIOException("RSGroup " + groupName + " does not exist");
        }
        return rsGroupInfo;
    }

    @Override
    public synchronized Set<Address> moveServers(Set<Address> servers, String srcGroup, String dstGroup) throws IOException {
        RSGroupInfo src = this.getRSGroupInfo(srcGroup);
        RSGroupInfo dst = this.getRSGroupInfo(dstGroup);
        Set<Address> onlineServers = dst.getName().equals("default") ? Utility.getOnlineServers(this.masterServices) : null;
        for (Address el : servers) {
            src.removeServer(el);
            if (onlineServers != null && !onlineServers.contains(el)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Dropping " + el + " during move-to-default rsgroup because not online");
                continue;
            }
            dst.addServer(el);
        }
        HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
        newGroupMap.put(src.getName(), src);
        newGroupMap.put(dst.getName(), dst);
        this.flushConfig(newGroupMap);
        return dst.getServers();
    }

    @Override
    public RSGroupInfo getRSGroupOfServer(Address serverHostPort) throws IOException {
        for (RSGroupInfo info : this.rsGroupMap.values()) {
            if (!info.containsServer(serverHostPort)) continue;
            return info;
        }
        return null;
    }

    @Override
    public RSGroupInfo getRSGroup(String groupName) {
        return this.rsGroupMap.get(groupName);
    }

    @Override
    public String getRSGroupOfTable(TableName tableName) {
        return this.tableMap.get(tableName);
    }

    @Override
    public synchronized void moveTables(Set<TableName> tableNames, String groupName) throws IOException {
        if (groupName != null && !this.rsGroupMap.containsKey(groupName)) {
            throw new DoNotRetryIOException("Group " + groupName + " does not exist");
        }
        HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
        for (TableName tableName : tableNames) {
            if (this.tableMap.containsKey(tableName)) {
                RSGroupInfo src = new RSGroupInfo((RSGroupInfo)newGroupMap.get(this.tableMap.get(tableName)));
                src.removeTable(tableName);
                newGroupMap.put(src.getName(), src);
            }
            if (groupName == null) continue;
            RSGroupInfo dst = new RSGroupInfo((RSGroupInfo)newGroupMap.get(groupName));
            dst.addTable(tableName);
            newGroupMap.put(dst.getName(), dst);
        }
        this.flushConfig(newGroupMap);
    }

    @Override
    public synchronized void removeRSGroup(String groupName) throws IOException {
        if (!this.rsGroupMap.containsKey(groupName) || groupName.equals("default")) {
            throw new DoNotRetryIOException("Group " + groupName + " does not exist or is a reserved group");
        }
        HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
        newGroupMap.remove(groupName);
        this.flushConfig(newGroupMap);
    }

    @Override
    public List<RSGroupInfo> listRSGroups() {
        return Lists.newLinkedList(this.rsGroupMap.values());
    }

    @Override
    public boolean isOnline() {
        return this.rsGroupStartupWorker.isOnline();
    }

    @Override
    public void moveServersAndTables(Set<Address> servers, Set<TableName> tables, String srcGroup, String dstGroup) throws IOException {
        RSGroupInfo srcGroupInfo = this.getRSGroupInfo(srcGroup);
        RSGroupInfo dstGroupInfo = this.getRSGroupInfo(dstGroup);
        for (Address el : servers) {
            srcGroupInfo.removeServer(el);
            dstGroupInfo.addServer(el);
        }
        for (TableName tableName : tables) {
            srcGroupInfo.removeTable(tableName);
            dstGroupInfo.addTable(tableName);
        }
        HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
        newGroupMap.put(srcGroupInfo.getName(), srcGroupInfo);
        newGroupMap.put(dstGroupInfo.getName(), dstGroupInfo);
        this.flushConfig(newGroupMap);
    }

    @Override
    public synchronized void removeServers(Set<Address> servers) throws IOException {
        HashMap<String, RSGroupInfo> rsGroupInfos = new HashMap<String, RSGroupInfo>();
        for (Address el : servers) {
            RSGroupInfo rsGroupInfo = this.getRSGroupOfServer(el);
            if (rsGroupInfo != null) {
                RSGroupInfo newRsGroupInfo = (RSGroupInfo)rsGroupInfos.get(rsGroupInfo.getName());
                if (newRsGroupInfo == null) {
                    rsGroupInfo.removeServer(el);
                    rsGroupInfos.put(rsGroupInfo.getName(), rsGroupInfo);
                    continue;
                }
                newRsGroupInfo.removeServer(el);
                rsGroupInfos.put(newRsGroupInfo.getName(), newRsGroupInfo);
                continue;
            }
            LOG.warn("Server " + el + " does not belong to any rsgroup.");
        }
        if (rsGroupInfos.size() > 0) {
            HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
            newGroupMap.putAll(rsGroupInfos);
            this.flushConfig(newGroupMap);
        }
    }

    List<RSGroupInfo> retrieveGroupListFromGroupTable() throws IOException {
        ArrayList rsGroupInfoList = Lists.newArrayList();
        for (Result result : this.rsGroupTable.getScanner(new Scan())) {
            RSGroupProtos.RSGroupInfo proto = RSGroupProtos.RSGroupInfo.parseFrom((byte[])result.getValue(META_FAMILY_BYTES, META_QUALIFIER_BYTES));
            rsGroupInfoList.add(RSGroupProtobufUtil.toGroupInfo(proto));
        }
        return rsGroupInfoList;
    }

    List<RSGroupInfo> retrieveGroupListFromZookeeper() throws IOException {
        String groupBasePath = ZNodePaths.joinZNode((String)this.watcher.getZNodePaths().baseZNode, (String)"rsgroup");
        ArrayList RSGroupInfoList = Lists.newArrayList();
        try {
            if (ZKUtil.checkExists((ZKWatcher)this.watcher, (String)groupBasePath) != -1) {
                List children = ZKUtil.listChildrenAndWatchForNewChildren((ZKWatcher)this.watcher, (String)groupBasePath);
                if (children == null) {
                    return RSGroupInfoList;
                }
                for (String znode : children) {
                    byte[] data = ZKUtil.getData((ZKWatcher)this.watcher, (String)ZNodePaths.joinZNode((String)groupBasePath, (String)znode));
                    if (data.length <= 0) continue;
                    ProtobufUtil.expectPBMagicPrefix((byte[])data);
                    ByteArrayInputStream bis = new ByteArrayInputStream(data, ProtobufUtil.lengthOfPBMagic(), data.length);
                    RSGroupInfoList.add(RSGroupProtobufUtil.toGroupInfo(RSGroupProtos.RSGroupInfo.parseFrom((InputStream)bis)));
                }
                LOG.debug("Read ZK GroupInfo count:" + RSGroupInfoList.size());
            }
        }
        catch (InterruptedException | DeserializationException | KeeperException e) {
            throw new IOException("Failed to read rsGroupZNode", e);
        }
        return RSGroupInfoList;
    }

    @Override
    public void refresh() throws IOException {
        this.refresh(false);
    }

    private synchronized void refresh(boolean forceOnline) throws IOException {
        LinkedList<RSGroupInfo> groupList = new LinkedList<RSGroupInfo>();
        if (forceOnline || this.isOnline()) {
            LOG.debug("Refreshing in Online mode.");
            if (this.rsGroupTable == null) {
                this.rsGroupTable = this.conn.getTable(RSGROUP_TABLE_NAME);
            }
            groupList.addAll(this.retrieveGroupListFromGroupTable());
        } else {
            LOG.debug("Refreshing in Offline mode.");
            groupList.addAll(this.retrieveGroupListFromZookeeper());
        }
        TreeSet<TableName> orphanTables = new TreeSet<TableName>();
        for (String entry : this.masterServices.getTableDescriptors().getAll().keySet()) {
            orphanTables.add(TableName.valueOf((String)entry));
        }
        for (RSGroupInfo group : groupList) {
            if (group.getName().equals("default")) continue;
            orphanTables.removeAll(group.getTables());
        }
        groupList.add(new RSGroupInfo("default", this.getDefaultServers(), orphanTables));
        HashMap newGroupMap = Maps.newHashMap();
        HashMap newTableMap = Maps.newHashMap();
        for (RSGroupInfo group : groupList) {
            newGroupMap.put(group.getName(), group);
            for (TableName table : group.getTables()) {
                newTableMap.put(table, group.getName());
            }
        }
        this.resetRSGroupAndTableMaps(newGroupMap, newTableMap);
        this.updateCacheOfRSGroups(this.rsGroupMap.keySet());
    }

    private synchronized Map<TableName, String> flushConfigTable(Map<String, RSGroupInfo> groupMap) throws IOException {
        HashMap newTableMap = Maps.newHashMap();
        ArrayList mutations = Lists.newArrayList();
        for (String groupName : this.prevRSGroups) {
            if (groupMap.containsKey(groupName)) continue;
            Delete d = new Delete(Bytes.toBytes((String)groupName));
            mutations.add(d);
        }
        for (RSGroupInfo RSGroupInfo2 : groupMap.values()) {
            RSGroupProtos.RSGroupInfo proto = RSGroupProtobufUtil.toProtoGroupInfo(RSGroupInfo2);
            Put p = new Put(Bytes.toBytes((String)RSGroupInfo2.getName()));
            p.addColumn(META_FAMILY_BYTES, META_QUALIFIER_BYTES, proto.toByteArray());
            mutations.add(p);
            for (TableName entry : RSGroupInfo2.getTables()) {
                newTableMap.put(entry, RSGroupInfo2.getName());
            }
        }
        if (mutations.size() > 0) {
            this.multiMutate(mutations);
        }
        return newTableMap;
    }

    private synchronized void flushConfig() throws IOException {
        this.flushConfig(this.rsGroupMap);
    }

    private synchronized void flushConfig(Map<String, RSGroupInfo> newGroupMap) throws IOException {
        if (!this.isOnline()) {
            HashMap m = Maps.newHashMap(this.rsGroupMap);
            RSGroupInfo oldDefaultGroup = (RSGroupInfo)m.remove("default");
            RSGroupInfo newDefaultGroup = newGroupMap.remove("default");
            if (!m.equals(newGroupMap) || !oldDefaultGroup.getTables().equals(newDefaultGroup.getTables())) {
                throw new IOException("Only default servers can be updated during offline mode");
            }
            newGroupMap.put("default", newDefaultGroup);
            this.rsGroupMap = newGroupMap;
            return;
        }
        Map<TableName, String> newTableMap = this.flushConfigTable(newGroupMap);
        this.resetRSGroupAndTableMaps(newGroupMap, newTableMap);
        try {
            String znode;
            String groupBasePath = ZNodePaths.joinZNode((String)this.watcher.getZNodePaths().baseZNode, (String)"rsgroup");
            ZKUtil.createAndFailSilent((ZKWatcher)this.watcher, (String)groupBasePath, (byte[])ProtobufMagic.PB_MAGIC);
            ArrayList<ZKUtil.ZKUtilOp> zkOps = new ArrayList<ZKUtil.ZKUtilOp>(newGroupMap.size());
            for (String groupName : this.prevRSGroups) {
                if (newGroupMap.containsKey(groupName)) continue;
                znode = ZNodePaths.joinZNode((String)groupBasePath, (String)groupName);
                zkOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)znode));
            }
            for (RSGroupInfo RSGroupInfo2 : newGroupMap.values()) {
                znode = ZNodePaths.joinZNode((String)groupBasePath, (String)RSGroupInfo2.getName());
                RSGroupProtos.RSGroupInfo proto = RSGroupProtobufUtil.toProtoGroupInfo(RSGroupInfo2);
                LOG.debug("Updating znode: " + znode);
                ZKUtil.createAndFailSilent((ZKWatcher)this.watcher, (String)znode);
                zkOps.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)znode));
                zkOps.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)znode, (byte[])ProtobufUtil.prependPBMagic((byte[])proto.toByteArray())));
            }
            LOG.debug("Writing ZK GroupInfo count: " + zkOps.size());
            ZKUtil.multiOrSequential((ZKWatcher)this.watcher, zkOps, (boolean)false);
        }
        catch (KeeperException e) {
            LOG.error("Failed to write to rsGroupZNode", (Throwable)e);
            this.masterServices.abort("Failed to write to rsGroupZNode", (Throwable)e);
            throw new IOException("Failed to write to rsGroupZNode", e);
        }
        this.updateCacheOfRSGroups(newGroupMap.keySet());
    }

    private void resetRSGroupAndTableMaps(Map<String, RSGroupInfo> newRSGroupMap, Map<TableName, String> newTableMap) {
        this.rsGroupMap = Collections.unmodifiableMap(newRSGroupMap);
        this.tableMap = Collections.unmodifiableMap(newTableMap);
    }

    private void updateCacheOfRSGroups(Set<String> currentGroups) {
        this.prevRSGroups.clear();
        this.prevRSGroups.addAll(currentGroups);
    }

    private List<ServerName> getOnlineRS() throws IOException {
        if (this.masterServices != null) {
            return this.masterServices.getServerManager().getOnlineServersList();
        }
        LOG.debug("Reading online RS from zookeeper");
        LinkedList<ServerName> servers = new LinkedList<ServerName>();
        try {
            for (String el : ZKUtil.listChildrenNoWatch((ZKWatcher)this.watcher, (String)this.watcher.getZNodePaths().rsZNode)) {
                servers.add(ServerName.parseServerName((String)el));
            }
        }
        catch (KeeperException e) {
            throw new IOException("Failed to retrieve server list from zookeeper", e);
        }
        return servers;
    }

    private SortedSet<Address> getDefaultServers() throws IOException {
        TreeSet defaultServers = Sets.newTreeSet();
        for (ServerName serverName : this.getOnlineRS()) {
            Address server = Address.fromParts((String)serverName.getHostname(), (int)serverName.getPort());
            boolean found = false;
            for (RSGroupInfo rsgi : this.listRSGroups()) {
                if ("default".equals(rsgi.getName()) || !rsgi.containsServer(server)) continue;
                found = true;
                break;
            }
            if (found) continue;
            defaultServers.add(server);
        }
        return defaultServers;
    }

    private synchronized void updateDefaultServers(SortedSet<Address> servers) throws IOException {
        RSGroupInfo info = this.rsGroupMap.get("default");
        RSGroupInfo newInfo = new RSGroupInfo(info.getName(), servers, info.getTables());
        HashMap newGroupMap = Maps.newHashMap(this.rsGroupMap);
        newGroupMap.put(newInfo.getName(), newInfo);
        this.flushConfig(newGroupMap);
    }

    private void updateFailedAssignments() {
        ArrayList stuckAssignments = Lists.newArrayList();
        for (RegionStates.RegionStateNode state : this.masterServices.getAssignmentManager().getRegionStates().getRegionsInTransition()) {
            if (!state.isStuck()) continue;
            stuckAssignments.add(state.getRegionInfo());
        }
        for (RegionInfo region : stuckAssignments) {
            LOG.info("Retrying assignment of " + region);
            try {
                this.masterServices.getAssignmentManager().unassign(region);
            }
            catch (IOException e) {
                LOG.warn("Unable to reassign " + region, (Throwable)e);
            }
        }
    }

    private static boolean isMasterRunning(MasterServices masterServices) {
        return !masterServices.isAborted() && !masterServices.isStopped();
    }

    private void multiMutate(List<Mutation> mutations) throws IOException {
        CoprocessorRpcChannel channel = this.rsGroupTable.coprocessorService(ROW_KEY);
        MultiRowMutationProtos.MutateRowsRequest.Builder mmrBuilder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
        for (Mutation mutation : mutations) {
            if (mutation instanceof Put) {
                mmrBuilder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)mutation));
                continue;
            }
            if (mutation instanceof Delete) {
                mmrBuilder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.DELETE, (Mutation)mutation));
                continue;
            }
            throw new DoNotRetryIOException("multiMutate doesn't support " + mutation.getClass().getName());
        }
        MultiRowMutationProtos.MultiRowMutationService.BlockingInterface service = MultiRowMutationProtos.MultiRowMutationService.newBlockingStub((BlockingRpcChannel)channel);
        try {
            service.mutateRows(null, mmrBuilder.build());
        }
        catch (ServiceException ex) {
            ProtobufUtil.toIOException((ServiceException)ex);
        }
    }

    private void checkGroupName(String groupName) throws ConstraintException {
        if (!groupName.matches("[a-zA-Z0-9_]+")) {
            throw new ConstraintException("RSGroup name should only contain alphanumeric characters");
        }
    }

    static {
        RSGROUP_TABLE_DESC.addFamily(new HColumnDescriptor(META_FAMILY_BYTES));
        RSGROUP_TABLE_DESC.setRegionSplitPolicyClassName(DisabledRegionSplitPolicy.class.getName());
        try {
            RSGROUP_TABLE_DESC.addCoprocessor(MultiRowMutationEndpoint.class.getName(), null, 0x1FFFFFFF, null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private class RSGroupStartupWorker
    extends Thread {
        private final Logger LOG = LoggerFactory.getLogger(RSGroupStartupWorker.class);
        private volatile boolean online = false;

        RSGroupStartupWorker() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.setName(RSGroupStartupWorker.class.getName() + "-" + RSGroupInfoManagerImpl.this.masterServices.getServerName());
            if (this.waitForGroupTableOnline()) {
                this.LOG.info("GroupBasedLoadBalancer is now online");
            }
        }

        private boolean waitForGroupTableOnline() {
            final LinkedList foundRegions = new LinkedList();
            final LinkedList assignedRegions = new LinkedList();
            final AtomicBoolean found = new AtomicBoolean(false);
            final TableStateManager tsm = RSGroupInfoManagerImpl.this.masterServices.getTableStateManager();
            boolean createSent = false;
            while (!found.get() && RSGroupInfoManagerImpl.isMasterRunning(RSGroupInfoManagerImpl.this.masterServices)) {
                foundRegions.clear();
                assignedRegions.clear();
                found.set(true);
                try {
                    RSGroupInfoManagerImpl.this.conn.getTable(TableName.NAMESPACE_TABLE_NAME);
                    RSGroupInfoManagerImpl.this.conn.getTable(RSGroupInfoManager.RSGROUP_TABLE_NAME);
                    boolean rootMetaFound = RSGroupInfoManagerImpl.this.masterServices.getMetaTableLocator().verifyMetaRegionLocation(RSGroupInfoManagerImpl.this.conn, RSGroupInfoManagerImpl.this.masterServices.getZooKeeper(), 1L);
                    final AtomicBoolean nsFound = new AtomicBoolean(false);
                    if (rootMetaFound) {
                        MetaTableAccessor.DefaultVisitorBase visitor = new MetaTableAccessor.DefaultVisitorBase(){

                            public boolean visitInternal(Result row) throws IOException {
                                RegionInfo info = MetaTableAccessor.getRegionInfo((Result)row);
                                if (info != null) {
                                    Cell serverCell = row.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                                    if (RSGroupInfoManager.RSGROUP_TABLE_NAME.equals((Object)info.getTable()) && serverCell != null) {
                                        ServerName sn = ServerName.parseVersionedServerName((byte[])CellUtil.cloneValue((Cell)serverCell));
                                        if (sn == null) {
                                            found.set(false);
                                        } else if (tsm.isTableState(RSGroupInfoManager.RSGROUP_TABLE_NAME, new TableState.State[]{TableState.State.ENABLED})) {
                                            try {
                                                ClientProtos.ClientService.BlockingInterface rs = RSGroupInfoManagerImpl.this.conn.getClient(sn);
                                                ClientProtos.GetRequest request = RequestConverter.buildGetRequest((byte[])info.getRegionName(), (Get)new Get(RSGroupInfoManager.ROW_KEY));
                                                rs.get(null, request);
                                                assignedRegions.add(info);
                                            }
                                            catch (Exception ex) {
                                                RSGroupStartupWorker.this.LOG.debug("Caught exception while verifying group region", (Throwable)ex);
                                            }
                                        }
                                        foundRegions.add(info);
                                    }
                                    if (TableName.NAMESPACE_TABLE_NAME.equals((Object)info.getTable())) {
                                        Cell cell = row.getColumnLatestCell(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                                        ServerName sn = null;
                                        if (cell != null) {
                                            sn = ServerName.parseVersionedServerName((byte[])CellUtil.cloneValue((Cell)cell));
                                        }
                                        if (sn == null) {
                                            nsFound.set(false);
                                        } else if (tsm.isTableState(TableName.NAMESPACE_TABLE_NAME, new TableState.State[]{TableState.State.ENABLED})) {
                                            try {
                                                ClientProtos.ClientService.BlockingInterface rs = RSGroupInfoManagerImpl.this.conn.getClient(sn);
                                                ClientProtos.GetRequest request = RequestConverter.buildGetRequest((byte[])info.getRegionName(), (Get)new Get(RSGroupInfoManager.ROW_KEY));
                                                rs.get(null, request);
                                                nsFound.set(true);
                                            }
                                            catch (Exception ex) {
                                                RSGroupStartupWorker.this.LOG.debug("Caught exception while verifying group region", (Throwable)ex);
                                            }
                                        }
                                    }
                                }
                                return true;
                            }
                        };
                        MetaTableAccessor.fullScanRegions((Connection)RSGroupInfoManagerImpl.this.conn, (MetaTableAccessor.Visitor)visitor);
                        if (foundRegions.size() < 1 && rootMetaFound && !createSent && nsFound.get()) {
                            this.createRSGroupTable();
                            createSent = true;
                        }
                        this.LOG.info("RSGroup table=" + RSGroupInfoManager.RSGROUP_TABLE_NAME + " isOnline=" + found.get() + ", regionCount=" + foundRegions.size() + ", assignCount=" + assignedRegions.size() + ", rootMetaFound=" + rootMetaFound);
                        found.set(found.get() && assignedRegions.size() == foundRegions.size() && foundRegions.size() > 0);
                    } else {
                        this.LOG.info("Waiting for catalog tables to come online");
                        found.set(false);
                    }
                    if (found.get()) {
                        this.LOG.debug("With group table online, refreshing cached information.");
                        RSGroupInfoManagerImpl.this.refresh(true);
                        this.online = true;
                        RSGroupInfoManagerImpl.this.flushConfig();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    found.set(false);
                    this.LOG.warn("Failed to perform check", (Throwable)e);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    this.LOG.info("Sleep interrupted", (Throwable)e);
                }
            }
            return found.get();
        }

        private void createRSGroupTable() throws IOException {
            int tries;
            Long procId = RSGroupInfoManagerImpl.this.masterServices.createSystemTable((TableDescriptor)RSGROUP_TABLE_DESC);
            for (tries = 600; !RSGroupInfoManagerImpl.this.masterServices.getMasterProcedureExecutor().isFinished(procId.longValue()) && RSGroupInfoManagerImpl.this.masterServices.getMasterProcedureExecutor().isRunning() && tries > 0; --tries) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException("Wait interrupted ", e);
                }
            }
            if (tries <= 0) {
                throw new IOException("Failed to create group table in a given time.");
            }
            Procedure result = RSGroupInfoManagerImpl.this.masterServices.getMasterProcedureExecutor().getResult(procId.longValue());
            if (result != null && result.isFailed()) {
                throw new IOException("Failed to create group table. " + MasterProcedureUtil.unwrapRemoteIOException((Procedure)result));
            }
        }

        public boolean isOnline() {
            return this.online;
        }
    }

    private class FailedOpenUpdaterThread
    extends Thread
    implements ServerListener {
        private final long waitInterval;
        private volatile boolean hasChanged = false;

        public FailedOpenUpdaterThread(Configuration conf) {
            this.waitInterval = conf.getLong("hbase.rsgroup.reassign.wait", 30000L);
            this.setDaemon(true);
        }

        public void serverAdded(ServerName serverName) {
            this.serverChanged();
        }

        public void serverRemoved(ServerName serverName) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (RSGroupInfoManagerImpl.isMasterRunning(RSGroupInfoManagerImpl.this.masterServices)) {
                boolean interrupted = false;
                try {
                    FailedOpenUpdaterThread failedOpenUpdaterThread = this;
                    synchronized (failedOpenUpdaterThread) {
                        while (!this.hasChanged) {
                            this.wait();
                        }
                        this.hasChanged = false;
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted", (Throwable)e);
                    interrupted = true;
                }
                if (!RSGroupInfoManagerImpl.isMasterRunning(RSGroupInfoManagerImpl.this.masterServices) || interrupted) continue;
                try {
                    Thread.sleep(this.waitInterval);
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted", (Throwable)e);
                }
                if (!RSGroupInfoManagerImpl.isMasterRunning(RSGroupInfoManagerImpl.this.masterServices)) continue;
                RSGroupInfoManagerImpl.this.updateFailedAssignments();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serverChanged() {
            FailedOpenUpdaterThread failedOpenUpdaterThread = this;
            synchronized (failedOpenUpdaterThread) {
                this.hasChanged = true;
                this.notify();
            }
        }
    }

    private class ServerEventsListenerThread
    extends Thread
    implements ServerListener {
        private final Logger LOG = LoggerFactory.getLogger(ServerEventsListenerThread.class);
        private boolean changed = false;

        ServerEventsListenerThread() {
            this.setDaemon(true);
        }

        public void serverAdded(ServerName serverName) {
            this.serverChanged();
        }

        public void serverRemoved(ServerName serverName) {
            this.serverChanged();
        }

        private synchronized void serverChanged() {
            this.changed = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName(ServerEventsListenerThread.class.getName() + "-" + RSGroupInfoManagerImpl.this.masterServices.getServerName());
            SortedSet prevDefaultServers = new TreeSet();
            while (RSGroupInfoManagerImpl.isMasterRunning(RSGroupInfoManagerImpl.this.masterServices)) {
                try {
                    this.LOG.info("Updating default servers.");
                    SortedSet servers = RSGroupInfoManagerImpl.this.getDefaultServers();
                    if (!servers.equals(prevDefaultServers)) {
                        RSGroupInfoManagerImpl.this.updateDefaultServers(servers);
                        prevDefaultServers = servers;
                        this.LOG.info("Updated with servers: " + servers.size());
                    }
                    try {
                        ServerEventsListenerThread serverEventsListenerThread = this;
                        synchronized (serverEventsListenerThread) {
                            while (!this.changed) {
                                this.wait();
                            }
                            this.changed = false;
                        }
                    }
                    catch (InterruptedException e) {
                        this.LOG.warn("Interrupted", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    this.LOG.warn("Failed to update default servers", (Throwable)e);
                }
            }
        }
    }
}

