/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParseException;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParser;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;

@InterfaceAudience.Private
@InterfaceStability.Unstable
abstract class TimelineParserForCompareExpr
implements TimelineParser {
    private final String expr;
    private final String exprInLowerCase;
    private final String exprName;
    private int offset = 0;
    private int kvStartOffset = 0;
    private final int exprLength;
    private ParseState currentParseState = ParseState.PARSING_KEY;
    private Deque<TimelineFilterList> filterListStack = new LinkedList<TimelineFilterList>();
    private TimelineFilter currentFilter = null;
    private TimelineFilterList filterList = null;

    public TimelineParserForCompareExpr(String expression, String name) {
        if (expression != null) {
            this.expr = expression.trim();
            this.exprLength = this.expr.length();
            this.exprInLowerCase = this.expr.toLowerCase();
        } else {
            this.expr = null;
            this.exprInLowerCase = null;
            this.exprLength = 0;
        }
        this.exprName = name;
    }

    protected TimelineFilter getCurrentFilter() {
        return this.currentFilter;
    }

    protected TimelineFilter getFilterList() {
        return this.filterList;
    }

    protected abstract TimelineFilter createFilter();

    protected abstract Object parseValue(String var1) throws TimelineParseException;

    protected abstract void setCompareOpToCurrentFilter(TimelineCompareOp var1, boolean var2) throws TimelineParseException;

    protected abstract void setValueToCurrentFilter(Object var1);

    private void handleSpaceChar() throws TimelineParseException {
        if (this.currentParseState == ParseState.PARSING_KEY || this.currentParseState == ParseState.PARSING_VALUE) {
            if (this.kvStartOffset == this.offset) {
                ++this.kvStartOffset;
                ++this.offset;
                return;
            }
            String str = this.expr.substring(this.kvStartOffset, this.offset);
            if (this.currentParseState == ParseState.PARSING_KEY) {
                if (this.currentFilter == null) {
                    this.currentFilter = this.createFilter();
                }
                ((TimelineCompareFilter)this.currentFilter).setKey(str);
                this.currentParseState = ParseState.PARSING_COMPAREOP;
            } else if (this.currentParseState == ParseState.PARSING_VALUE) {
                if (this.currentFilter != null) {
                    this.setValueToCurrentFilter(this.parseValue(str));
                }
                this.currentParseState = ParseState.PARSING_OP;
            }
        }
        ++this.offset;
    }

    private void handleOpeningBracketChar() throws TimelineParseException {
        if (this.currentParseState != ParseState.PARSING_KEY) {
            throw new TimelineParseException("Encountered unexpected opening bracket while parsing " + this.exprName + ".");
        }
        ++this.offset;
        this.kvStartOffset = this.offset;
        this.filterListStack.push(this.filterList);
        this.filterList = null;
    }

    private void handleClosingBracketChar() throws TimelineParseException {
        if (this.currentParseState != ParseState.PARSING_VALUE && this.currentParseState != ParseState.PARSING_OP) {
            throw new TimelineParseException("Encountered unexpected closing bracket while parsing " + this.exprName + ".");
        }
        if (!this.filterListStack.isEmpty()) {
            TimelineFilterList fList;
            if (this.currentParseState == ParseState.PARSING_VALUE) {
                this.setValueToCurrentFilter(this.parseValue(this.expr.substring(this.kvStartOffset, this.offset)));
                this.currentParseState = ParseState.PARSING_OP;
            }
            if (this.currentFilter != null) {
                this.filterList.addFilter(this.currentFilter);
            }
            if ((fList = this.filterListStack.pop()) != null) {
                fList.addFilter(this.filterList);
                this.filterList = fList;
            }
            this.currentFilter = null;
            ++this.offset;
        } else {
            throw new TimelineParseException("Encountered unexpected closing bracket while parsing " + this.exprName + ".");
        }
        this.kvStartOffset = this.offset;
    }

    private void parseCompareOp() throws TimelineParseException {
        if (this.offset + 2 >= this.exprLength) {
            throw new TimelineParseException("Compare op cannot be parsed for " + this.exprName + ".");
        }
        TimelineCompareOp compareOp = null;
        boolean keyExistFlag = true;
        if (this.expr.charAt(this.offset + 2) == ' ') {
            if (this.exprInLowerCase.startsWith("eq", this.offset)) {
                compareOp = TimelineCompareOp.EQUAL;
            } else if (this.exprInLowerCase.startsWith("ne", this.offset)) {
                compareOp = TimelineCompareOp.NOT_EQUAL;
                keyExistFlag = false;
            } else if (this.exprInLowerCase.startsWith("lt", this.offset)) {
                compareOp = TimelineCompareOp.LESS_THAN;
            } else if (this.exprInLowerCase.startsWith("le", this.offset)) {
                compareOp = TimelineCompareOp.LESS_OR_EQUAL;
            } else if (this.exprInLowerCase.startsWith("gt", this.offset)) {
                compareOp = TimelineCompareOp.GREATER_THAN;
            } else if (this.exprInLowerCase.startsWith("ge", this.offset)) {
                compareOp = TimelineCompareOp.GREATER_OR_EQUAL;
            }
            this.offset += 3;
        } else if (this.exprInLowerCase.startsWith("ene ", this.offset)) {
            compareOp = TimelineCompareOp.NOT_EQUAL;
            this.offset += 4;
        }
        if (compareOp == null) {
            throw new TimelineParseException("Compare op cannot be parsed for " + this.exprName + ".");
        }
        this.setCompareOpToCurrentFilter(compareOp, keyExistFlag);
        this.kvStartOffset = this.offset;
        this.currentParseState = ParseState.PARSING_VALUE;
    }

    private void parseOp(boolean closingBracket) throws TimelineParseException {
        TimelineFilterList.Operator operator = null;
        if (this.exprInLowerCase.startsWith("or ", this.offset)) {
            operator = TimelineFilterList.Operator.OR;
            this.offset += 3;
        } else if (this.exprInLowerCase.startsWith("and ", this.offset)) {
            operator = TimelineFilterList.Operator.AND;
            this.offset += 4;
        }
        if (operator == null) {
            throw new TimelineParseException("Operator cannot be parsed for " + this.exprName + ".");
        }
        if (this.filterList == null) {
            this.filterList = new TimelineFilterList(operator);
        }
        if (this.currentFilter != null) {
            this.filterList.addFilter(this.currentFilter);
        }
        if (closingBracket || this.filterList.getOperator() != operator) {
            this.filterList = new TimelineFilterList(operator, this.filterList);
        }
        this.currentFilter = null;
        this.kvStartOffset = this.offset;
        this.currentParseState = ParseState.PARSING_KEY;
    }

    @Override
    public TimelineFilterList parse() throws TimelineParseException {
        if (this.expr == null || this.exprLength == 0) {
            return null;
        }
        boolean closingBracket = false;
        block5: while (this.offset < this.exprLength) {
            char offsetChar = this.expr.charAt(this.offset);
            switch (offsetChar) {
                case ' ': {
                    this.handleSpaceChar();
                    continue block5;
                }
                case '(': {
                    this.handleOpeningBracketChar();
                    continue block5;
                }
                case ')': {
                    this.handleClosingBracketChar();
                    closingBracket = true;
                    continue block5;
                }
            }
            if (this.currentParseState == ParseState.PARSING_COMPAREOP) {
                this.parseCompareOp();
                continue;
            }
            if (this.currentParseState == ParseState.PARSING_OP) {
                this.parseOp(closingBracket);
                closingBracket = false;
                continue;
            }
            ++this.offset;
        }
        if (!this.filterListStack.isEmpty()) {
            this.filterListStack.clear();
            throw new TimelineParseException("Encountered improper brackets while parsing " + this.exprName + ".");
        }
        if (this.currentParseState == ParseState.PARSING_VALUE) {
            this.setValueToCurrentFilter(this.parseValue(this.expr.substring(this.kvStartOffset, this.offset)));
        }
        if (this.filterList == null || this.filterList.getFilterList().isEmpty()) {
            this.filterList = new TimelineFilterList(this.currentFilter);
        } else if (this.currentFilter != null) {
            this.filterList.addFilter(this.currentFilter);
        }
        return this.filterList;
    }

    @Override
    public void close() {
        if (this.filterListStack != null) {
            this.filterListStack.clear();
        }
        this.filterList = null;
        this.currentFilter = null;
    }

    private static enum ParseState {
        PARSING_KEY,
        PARSING_VALUE,
        PARSING_OP,
        PARSING_COMPAREOP;

    }
}

