/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.client.Admin;

public class FlushRandomRegionOfTableAction
extends Action {
    private final long sleepTime;
    private final TableName tableName;

    public FlushRandomRegionOfTableAction(TableName tableName) {
        this(-1, tableName);
    }

    public FlushRandomRegionOfTableAction(int sleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        Admin admin = util.getAdmin();
        LOG.info("Performing action: Flush random region of table " + this.tableName);
        List regions = admin.getTableRegions(this.tableName);
        if (regions == null || regions.isEmpty()) {
            LOG.info("Table " + this.tableName + " doesn't have regions to flush");
            return;
        }
        HRegionInfo region = PolicyBasedChaosMonkey.selectRandomItem(regions.toArray(new HRegionInfo[regions.size()]));
        LOG.debug("Flushing region " + region.getRegionNameAsString());
        try {
            admin.flushRegion(region.getRegionName());
        }
        catch (Exception ex) {
            LOG.warn("Flush failed, might be caused by other chaos: " + ex.getMessage());
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

