/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdmin;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminClient;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.rsgroup.VerifyingRSGroupAdminClient;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRSGroups
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroups.class);
    protected static final Logger LOG = LoggerFactory.getLogger(TestRSGroups.class);
    private static boolean INIT = false;
    private static RSGroupAdminEndpoint rsGroupAdminEndpoint;
    private static CPMasterObserver observer;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.getConfiguration().setFloat("hbase.master.balancer.stochastic.tableSkewCost", 6000.0f);
        TEST_UTIL.getConfiguration().set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName() + "," + CPMasterObserver.class.getName());
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TestRSGroups.initialize();
    }

    private static void initialize() throws Exception {
        admin = TEST_UTIL.getAdmin();
        cluster = TEST_UTIL.getHBaseCluster();
        master = ((MiniHBaseCluster)cluster).getMaster();
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.master.isInitialized() && ((RSGroupBasedLoadBalancer)TestRSGroupsBase.master.getLoadBalancer()).isOnline();
            }
        });
        admin.setBalancerRunning(false, true);
        rsGroupAdmin = new VerifyingRSGroupAdminClient((RSGroupAdmin)new RSGroupAdminClient(TEST_UTIL.getConnection()), TEST_UTIL.getConfiguration());
        MasterCoprocessorHost host = master.getMasterCoprocessorHost();
        observer = (CPMasterObserver)host.findCoprocessor(CPMasterObserver.class.getName());
        rsGroupAdminEndpoint = (RSGroupAdminEndpoint)host.findCoprocessor(RSGroupAdminEndpoint.class.getName());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void beforeMethod() throws Exception {
        if (!INIT) {
            INIT = true;
            this.afterMethod();
        }
    }

    @After
    public void afterMethod() throws Exception {
        this.deleteTableIfNecessary();
        this.deleteNamespaceIfNecessary();
        this.deleteGroups();
        for (ServerName sn : admin.listDecommissionedRegionServers()) {
            admin.recommissionRegionServer(sn, null);
        }
        Assert.assertTrue((boolean)admin.listDecommissionedRegionServers().isEmpty());
        int missing = 4 - this.getNumServers();
        LOG.info("Restoring servers: " + missing);
        for (int i = 0; i < missing; ++i) {
            ((MiniHBaseCluster)cluster).startRegionServer();
        }
        rsGroupAdmin.addRSGroup("master");
        ServerName masterServerName = ((MiniHBaseCluster)cluster).getMaster().getServerName();
        try {
            rsGroupAdmin.moveServers((Set)Sets.newHashSet((Object[])new Address[]{masterServerName.getAddress()}), "master");
        }
        catch (Exception ex) {
            LOG.warn("Got this on setup, FYI", (Throwable)ex);
        }
        Assert.assertTrue((boolean)TestRSGroups.observer.preMoveServersCalled);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                LOG.info("Waiting for cleanup to finish " + TestRSGroupsBase.rsGroupAdmin.listRSGroups());
                return TestRSGroupsBase.rsGroupAdmin.getRSGroupInfo("default").getServers().size() == 4;
            }
        });
    }

    @Test
    public void testBasicStartUp() throws IOException {
        RSGroupInfo defaultInfo = rsGroupAdmin.getRSGroupInfo("default");
        Assert.assertEquals((long)4L, (long)defaultInfo.getServers().size());
        int count = master.getAssignmentManager().getRegionStates().getRegionAssignments().size();
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testNamespaceCreateAndAssign() throws Exception {
        LOG.info("testNamespaceCreateAndAssign");
        String nsName = "Group_foo";
        TableName tableName = TableName.valueOf((String)nsName, (String)"Group_testCreateAndAssign");
        RSGroupInfo appInfo = this.addGroup("appInfo", 1);
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", "appInfo").build());
        final HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("f"));
        admin.createTable((TableDescriptor)desc);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroups.this.getTableRegionMap().get(desc.getTableName()) != null;
            }
        });
        ServerName targetServer = ServerName.parseServerName((String)((Address)appInfo.getServers().iterator().next()).toString());
        AdminProtos.AdminService.BlockingInterface rs = ((ClusterConnection)admin.getConnection()).getAdmin(targetServer);
        Assert.assertEquals((long)1L, (long)ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs).size());
    }

    @Test
    public void testDefaultNamespaceCreateAndAssign() throws Exception {
        LOG.info("testDefaultNamespaceCreateAndAssign");
        String tableName = "Group_testCreateAndAssign";
        admin.modifyNamespace(NamespaceDescriptor.create((String)"default").addConfiguration("hbase.rsgroup.name", "default").build());
        final HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)tableName));
        desc.addFamily(new HColumnDescriptor("f"));
        admin.createTable((TableDescriptor)desc);
        TEST_UTIL.waitFor(300000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroups.this.getTableRegionMap().get(desc.getTableName()) != null;
            }
        });
    }

    @Test
    public void testNamespaceConstraint() throws Exception {
        String nsName = "Group_foo";
        String groupName = "Group_foo";
        LOG.info("testNamespaceConstraint");
        rsGroupAdmin.addRSGroup(groupName);
        Assert.assertTrue((boolean)TestRSGroups.observer.preAddRSGroupCalled);
        Assert.assertTrue((boolean)TestRSGroups.observer.postAddRSGroupCalled);
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", groupName).build());
        try {
            rsGroupAdmin.removeRSGroup(groupName);
            Assert.fail((String)"Expected a constraint exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        admin.modifyNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", groupName).build());
        String anotherGroup = "Group_anotherGroup";
        rsGroupAdmin.addRSGroup(anotherGroup);
        admin.deleteNamespace(nsName);
        rsGroupAdmin.removeRSGroup(groupName);
        Assert.assertTrue((boolean)TestRSGroups.observer.preRemoveRSGroupCalled);
        Assert.assertTrue((boolean)TestRSGroups.observer.postRemoveRSGroupCalled);
        try {
            admin.createNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", "foo").build());
            Assert.fail((String)"Expected a constraint exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGroupInfoMultiAccessing() throws Exception {
        RSGroupInfoManager manager = rsGroupAdminEndpoint.getGroupInfoManager();
        RSGroupInfo defaultGroup = manager.getRSGroup("default");
        Iterator it = defaultGroup.getServers().iterator();
        manager.getRSGroup("default");
        it.next();
    }

    @Override
    @Test
    public void testMoveServersAndTables() throws Exception {
        super.testMoveServersAndTables();
        Assert.assertTrue((boolean)TestRSGroups.observer.preMoveServersAndTables);
        Assert.assertTrue((boolean)TestRSGroups.observer.postMoveServersAndTables);
    }

    @Override
    @Test
    public void testTableMoveTruncateAndDrop() throws Exception {
        super.testTableMoveTruncateAndDrop();
        Assert.assertTrue((boolean)TestRSGroups.observer.preMoveTablesCalled);
        Assert.assertTrue((boolean)TestRSGroups.observer.postMoveTablesCalled);
    }

    @Override
    @Test
    public void testRemoveServers() throws Exception {
        super.testRemoveServers();
        Assert.assertTrue((boolean)TestRSGroups.observer.preRemoveServersCalled);
        Assert.assertTrue((boolean)TestRSGroups.observer.postRemoveServersCalled);
    }

    @Test
    public void testMisplacedRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)"Group_testMisplacedRegions");
        LOG.info("testMisplacedRegions");
        final RSGroupInfo RSGroupInfo2 = this.addGroup("testMisplacedRegions", 1);
        TEST_UTIL.createMultiRegionTable(tableName, new byte[]{102}, 15);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        rsGroupAdminEndpoint.getGroupInfoManager().moveTables((Set)Sets.newHashSet((Object[])new TableName[]{tableName}), RSGroupInfo2.getName());
        admin.setBalancerRunning(true, true);
        Assert.assertTrue((boolean)rsGroupAdmin.balanceRSGroup(RSGroupInfo2.getName()));
        admin.setBalancerRunning(false, true);
        Assert.assertTrue((boolean)TestRSGroups.observer.preBalanceRSGroupCalled);
        Assert.assertTrue((boolean)TestRSGroups.observer.postBalanceRSGroupCalled);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ServerName serverName = ServerName.valueOf((String)((Address)RSGroupInfo2.getServers().iterator().next()).toString(), (long)1L);
                return TestRSGroupsBase.admin.getConnection().getAdmin().getOnlineRegions(serverName).size() == 15;
            }
        });
    }

    @Test
    public void testCloneSnapshot() throws Exception {
        byte[] FAMILY = Bytes.toBytes((String)"test");
        String snapshotName = this.tableName.getNameAsString() + "_snap";
        TableName clonedTableName = TableName.valueOf((String)(this.tableName.getNameAsString() + "_clone"));
        TEST_UTIL.createTable(this.tableName, FAMILY);
        admin.snapshot(snapshotName, this.tableName);
        admin.cloneSnapshot(snapshotName, clonedTableName);
    }

    @Test
    public void testRSGroupsWithHBaseQuota() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        this.restartHBaseCluster();
        try {
            TEST_UTIL.waitFor(90000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return TestRSGroupsBase.admin.isTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
                }
            });
        }
        finally {
            TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", false);
            this.restartHBaseCluster();
        }
    }

    private void restartHBaseCluster() throws Exception {
        LOG.info("\n\nShutting down cluster");
        TEST_UTIL.shutdownMiniHBaseCluster();
        LOG.info("\n\nSleeping a bit");
        Thread.sleep(2000L);
        TEST_UTIL.restartHBaseCluster(3);
        TestRSGroups.initialize();
    }

    public static class CPMasterObserver
    implements MasterCoprocessor,
    MasterObserver {
        boolean preBalanceRSGroupCalled = false;
        boolean postBalanceRSGroupCalled = false;
        boolean preMoveServersCalled = false;
        boolean postMoveServersCalled = false;
        boolean preMoveTablesCalled = false;
        boolean postMoveTablesCalled = false;
        boolean preAddRSGroupCalled = false;
        boolean postAddRSGroupCalled = false;
        boolean preRemoveRSGroupCalled = false;
        boolean postRemoveRSGroupCalled = false;
        boolean preRemoveServersCalled = false;
        boolean postRemoveServersCalled = false;
        boolean preMoveServersAndTables = false;
        boolean postMoveServersAndTables = false;

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preMoveServersAndTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
            this.preMoveServersAndTables = true;
        }

        public void postMoveServersAndTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
            this.postMoveServersAndTables = true;
        }

        public void preRemoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers) throws IOException {
            this.preRemoveServersCalled = true;
        }

        public void postRemoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers) throws IOException {
            this.postRemoveServersCalled = true;
        }

        public void preRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
            this.preRemoveRSGroupCalled = true;
        }

        public void postRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
            this.postRemoveRSGroupCalled = true;
        }

        public void preAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
            this.preAddRSGroupCalled = true;
        }

        public void postAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
            this.postAddRSGroupCalled = true;
        }

        public void preMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
            this.preMoveTablesCalled = true;
        }

        public void postMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
            this.postMoveTablesCalled = true;
        }

        public void preMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
            this.preMoveServersCalled = true;
        }

        public void postMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
            this.postMoveServersCalled = true;
        }

        public void preBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName) throws IOException {
            this.preBalanceRSGroupCalled = true;
        }

        public void postBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName, boolean balancerRan) throws IOException {
            this.postBalanceRSGroupCalled = true;
        }
    }
}

