/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestEnableRSGroup {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestEnableRSGroup.class);
    protected static final Logger LOG = LoggerFactory.getLogger(TestEnableRSGroup.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.coprocessor.enabled", true);
        TEST_UTIL.startMiniCluster(5);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        LOG.info("to stop miniCluster");
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testEnableRSGroup() throws IOException, InterruptedException {
        TEST_UTIL.getMiniHBaseCluster().stopMaster(0);
        TEST_UTIL.getMiniHBaseCluster().waitOnMaster(0);
        LOG.info("stopped master...");
        Configuration conf = TEST_UTIL.getMiniHBaseCluster().getConfiguration();
        conf.set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName());
        conf.set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
        TEST_UTIL.getMiniHBaseCluster().startMaster();
        TEST_UTIL.getMiniHBaseCluster().waitForActiveAndReadyMaster(60000L);
        LOG.info("started master...");
        Assert.assertTrue((TEST_UTIL.getMiniHBaseCluster().getMaster() != null ? 1 : 0) != 0);
        RSGroupBasedLoadBalancer loadBalancer = (RSGroupBasedLoadBalancer)TEST_UTIL.getMiniHBaseCluster().getMaster().getLoadBalancer();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start <= 60000L && !loadBalancer.isOnline()) {
            LOG.info("waiting for rsgroup load balancer onLine...");
            Thread.sleep(200L);
        }
        Assert.assertTrue((boolean)loadBalancer.isOnline());
    }
}

