/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.StorageClusterStatusModel;
import org.apache.hadoop.hbase.rest.model.StorageClusterVersionModel;
import org.apache.hadoop.hbase.rest.model.TableListModel;
import org.apache.hadoop.hbase.rest.model.TableSchemaModel;
import org.apache.hadoop.hbase.rest.model.VersionModel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RemoteAdmin {
    final Client client;
    final Configuration conf;
    final String accessToken;
    final int maxRetries;
    final long sleepTime;
    private static volatile Unmarshaller versionClusterUnmarshaller;

    public RemoteAdmin(Client client, Configuration conf) {
        this(client, conf, null);
    }

    static Unmarshaller getUnmarsheller() throws JAXBException {
        if (versionClusterUnmarshaller == null) {
            versionClusterUnmarshaller = JAXBContext.newInstance((Class[])new Class[]{StorageClusterVersionModel.class}).createUnmarshaller();
        }
        return versionClusterUnmarshaller;
    }

    public RemoteAdmin(Client client, Configuration conf, String accessToken) {
        this.client = client;
        this.conf = conf;
        this.accessToken = accessToken;
        this.maxRetries = conf.getInt("hbase.rest.client.max.retries", 10);
        this.sleepTime = conf.getLong("hbase.rest.client.sleep", 1000L);
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.isTableAvailable(Bytes.toBytes((String)tableName));
    }

    public VersionModel getRestVersion() throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        if (this.accessToken != null) {
            path.append(this.accessToken);
            path.append('/');
        }
        path.append("version/rest");
        int code = 0;
        block7: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.get(path.toString(), "application/x-protobuf");
            code = response.getCode();
            switch (code) {
                case 200: {
                    VersionModel v = new VersionModel();
                    return (VersionModel)v.getObjectFromMessage(response.getBody());
                }
                case 404: {
                    throw new IOException("REST version not found");
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block7;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("get request to " + path.toString() + " returned " + code);
                }
            }
        }
        throw new IOException("get request to " + path.toString() + " timed out");
    }

    public StorageClusterStatusModel getClusterStatus() throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        if (this.accessToken != null) {
            path.append(this.accessToken);
            path.append('/');
        }
        path.append("status/cluster");
        int code = 0;
        block7: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.get(path.toString(), "application/x-protobuf");
            code = response.getCode();
            switch (code) {
                case 200: {
                    StorageClusterStatusModel s = new StorageClusterStatusModel();
                    return (StorageClusterStatusModel)s.getObjectFromMessage(response.getBody());
                }
                case 404: {
                    throw new IOException("Cluster version not found");
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block7;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("get request to " + path + " returned " + code);
                }
            }
        }
        throw new IOException("get request to " + path + " timed out");
    }

    public StorageClusterVersionModel getClusterVersion() throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        if (this.accessToken != null) {
            path.append(this.accessToken);
            path.append('/');
        }
        path.append("version/cluster");
        int code = 0;
        block9: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.get(path.toString(), "text/xml");
            code = response.getCode();
            switch (code) {
                case 200: {
                    try {
                        return (StorageClusterVersionModel)RemoteAdmin.getUnmarsheller().unmarshal(this.getInputStream(response));
                    }
                    catch (JAXBException jaxbe) {
                        throw new IOException("Issue parsing StorageClusterVersionModel object in XML form: " + jaxbe.getLocalizedMessage(), jaxbe);
                    }
                }
                case 404: {
                    throw new IOException("Cluster version not found");
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block9;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException(path.toString() + " request returned " + code);
                }
            }
        }
        throw new IOException("get request to " + path.toString() + " request timed out");
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        if (this.accessToken != null) {
            path.append(this.accessToken);
            path.append('/');
        }
        path.append(Bytes.toStringBinary((byte[])tableName));
        path.append('/');
        path.append("exists");
        int code = 0;
        block7: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.get(path.toString(), "application/x-protobuf");
            code = response.getCode();
            switch (code) {
                case 200: {
                    return true;
                }
                case 404: {
                    return false;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block7;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("get request to " + path.toString() + " returned " + code);
                }
            }
        }
        throw new IOException("get request to " + path.toString() + " timed out");
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        TableSchemaModel model = new TableSchemaModel(desc);
        StringBuilder path = new StringBuilder();
        path.append('/');
        if (this.accessToken != null) {
            path.append(this.accessToken);
            path.append('/');
        }
        path.append(desc.getTableName());
        path.append('/');
        path.append("schema");
        int code = 0;
        block6: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.put(path.toString(), "application/x-protobuf", model.createProtobufOutput());
            code = response.getCode();
            switch (code) {
                case 201: {
                    return;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("create request to " + path.toString() + " returned " + code);
                }
            }
        }
        throw new IOException("create request to " + path.toString() + " timed out");
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(Bytes.toBytes((String)tableName));
    }

    public void deleteTable(byte[] tableName) throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        if (this.accessToken != null) {
            path.append(this.accessToken);
            path.append('/');
        }
        path.append(Bytes.toStringBinary((byte[])tableName));
        path.append('/');
        path.append("schema");
        int code = 0;
        block6: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.delete(path.toString());
            code = response.getCode();
            switch (code) {
                case 200: {
                    return;
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block6;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("delete request to " + path.toString() + " returned " + code);
                }
            }
        }
        throw new IOException("delete request to " + path.toString() + " timed out");
    }

    public TableListModel getTableList() throws IOException {
        StringBuilder path = new StringBuilder();
        path.append('/');
        if (this.accessToken != null) {
            path.append(this.accessToken);
            path.append('/');
        }
        int code = 0;
        block7: for (int i = 0; i < this.maxRetries; ++i) {
            Response response = this.client.get(path.toString(), "application/x-protobuf");
            code = response.getCode();
            switch (code) {
                case 200: {
                    TableListModel t = new TableListModel();
                    return (TableListModel)t.getObjectFromMessage(response.getBody());
                }
                case 404: {
                    throw new IOException("Table list not found");
                }
                case 509: {
                    try {
                        Thread.sleep(this.sleepTime);
                        continue block7;
                    }
                    catch (InterruptedException e) {
                        throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                    }
                }
                default: {
                    throw new IOException("get request to " + path.toString() + " request returned " + code);
                }
            }
        }
        throw new IOException("get request to " + path.toString() + " request timed out");
    }

    private XMLStreamReader getInputStream(Response response) throws IOException {
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            return xif.createXMLStreamReader(new ByteArrayInputStream(response.getBody()));
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to parse XML", e);
        }
    }
}

