/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import java.io.FileWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.RegionMover;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestRegionMover {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionMover.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionMover.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRegionMover");
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(tableName)) {
            TEST_UTIL.deleteTable(tableName);
        }
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"fam1")).build();
        String startKey = "a";
        String endKey = "z";
        admin.createTable(tableDesc, startKey.getBytes(), endKey.getBytes(), 9);
    }

    @Test
    public void testWithAck() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HRegionServer regionServer = cluster.getRegionServer(0);
        String rsName = regionServer.getServerName().getAddress().toString();
        int numRegions = regionServer.getNumberOfOnlineRegions();
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(rsName, TEST_UTIL.getConfiguration()).ack(true).maxthreads(8);
        try (RegionMover rm = rmBuilder.build();){
            LOG.info("Unloading " + regionServer.getServerName());
            rm.unload();
            Assert.assertEquals((long)0L, (long)regionServer.getNumberOfOnlineRegions());
            LOG.info("Successfully Unloaded\nNow Loading");
            rm.load();
            Assert.assertEquals((long)numRegions, (long)regionServer.getNumberOfOnlineRegions());
            rm.load();
        }
    }

    @Test
    public void testWithoutAck() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        final HRegionServer regionServer = cluster.getRegionServer(0);
        String rsName = regionServer.getServerName().getAddress().toString();
        final int numRegions = regionServer.getNumberOfOnlineRegions();
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(rsName, TEST_UTIL.getConfiguration()).ack(false);
        try (RegionMover rm = rmBuilder.build();){
            LOG.info("Unloading " + regionServer.getServerName());
            rm.unload();
            TEST_UTIL.waitFor(30000L, 1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return regionServer.getNumberOfOnlineRegions() == 0;
                }
            });
            LOG.info("Successfully Unloaded\nNow Loading");
            rm.load();
            TEST_UTIL.waitFor(30000L, 1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return regionServer.getNumberOfOnlineRegions() == numRegions;
                }
            });
        }
    }

    @Test
    public void testExclude() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        File excludeFile = new File(TEST_UTIL.getDataTestDir().toUri().getPath(), "exclude_file");
        FileWriter fos = new FileWriter(excludeFile);
        HRegionServer excludeServer = cluster.getRegionServer(1);
        String excludeHostname = excludeServer.getServerName().getHostname();
        int excludeServerPort = excludeServer.getServerName().getPort();
        int regionsExcludeServer = excludeServer.getNumberOfOnlineRegions();
        String excludeServerName = excludeHostname + ":" + Integer.toString(excludeServerPort);
        fos.write(excludeServerName);
        fos.close();
        HRegionServer regionServer = cluster.getRegionServer(0);
        String rsName = regionServer.getServerName().getHostname();
        int port = regionServer.getServerName().getPort();
        String rs = rsName + ":" + Integer.toString(port);
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(rs, TEST_UTIL.getConfiguration()).ack(true).excludeFile(excludeFile.getCanonicalPath());
        try (RegionMover rm = rmBuilder.build();){
            rm.unload();
            LOG.info("Unloading " + rs);
            Assert.assertEquals((long)0L, (long)regionServer.getNumberOfOnlineRegions());
            Assert.assertEquals((long)regionsExcludeServer, (long)cluster.getRegionServer(1).getNumberOfOnlineRegions());
            LOG.info("Before:" + regionsExcludeServer + " After:" + cluster.getRegionServer(1).getNumberOfOnlineRegions());
        }
    }

    @Test
    public void testRegionServerPort() {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HRegionServer regionServer = cluster.getRegionServer(0);
        String rsName = regionServer.getServerName().getHostname();
        int PORT = 16021;
        Configuration conf = TEST_UTIL.getConfiguration();
        String originalPort = conf.get("hbase.regionserver.port");
        conf.set("hbase.regionserver.port", Integer.toString(16021));
        RegionMover.RegionMoverBuilder rmBuilder = new RegionMover.RegionMoverBuilder(rsName, conf);
        Assert.assertEquals((long)16021L, (long)rmBuilder.port);
        if (originalPort != null) {
            conf.set("hbase.regionserver.port", originalPort);
        }
    }

    @Test
    public void testLoadMetaRegion() throws Exception {
        HRegionServer rsWithMeta = TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer()).filter(rs -> rs.getRegions(TableName.META_TABLE_NAME).size() > 0).findFirst().get();
        int onlineRegions = rsWithMeta.getNumberOfOnlineRegions();
        String rsName = rsWithMeta.getServerName().getAddress().toString();
        try (RegionMover rm = new RegionMover.RegionMoverBuilder(rsName, TEST_UTIL.getConfiguration()).ack(true).build();){
            LOG.info("Unloading " + rsWithMeta.getServerName());
            rm.unload();
            Assert.assertEquals((long)0L, (long)rsWithMeta.getNumberOfOnlineRegions());
            LOG.info("Loading " + rsWithMeta.getServerName());
            rm.load();
            Assert.assertEquals((long)onlineRegions, (long)rsWithMeta.getNumberOfOnlineRegions());
        }
    }

    @Test
    public void testTargetServerDeadWhenLoading() throws Exception {
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        String rsName = rs.getServerName().getAddress().toString();
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.serverstart.wait.max", 5);
        String filename = new Path(TEST_UTIL.getDataTestDir(), "testTargetServerDeadWhenLoading").toString();
        try (RegionMover rm = new RegionMover.RegionMoverBuilder(rsName, conf).filename(filename).ack(true).build();){
            LOG.info("Unloading " + rs.getServerName());
            rm.unload();
            Assert.assertEquals((long)0L, (long)rs.getNumberOfOnlineRegions());
        }
        String inexistRsName = "whatever:123";
        try (RegionMover rm = new RegionMover.RegionMoverBuilder(inexistRsName, conf).filename(filename).ack(true).build();){
            LOG.info("Loading to an inexist region server {}", (Object)inexistRsName);
            Assert.assertFalse((boolean)rm.load());
        }
    }
}

