/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.TestSimpleTimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestSyncTimeRangeTracker
extends TestSimpleTimeRangeTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncTimeRangeTracker.class);
    private static final int NUM_KEYS = 10000000;
    private static final int NUM_OF_THREADS = 20;

    @Override
    protected TimeRangeTracker getTimeRangeTracker() {
        return TimeRangeTracker.create((TimeRangeTracker.Type)TimeRangeTracker.Type.SYNC);
    }

    @Override
    protected TimeRangeTracker getTimeRangeTracker(long min, long max) {
        return TimeRangeTracker.create((TimeRangeTracker.Type)TimeRangeTracker.Type.SYNC, (long)min, (long)max);
    }

    @Test
    public void testArriveAtRightAnswer() throws InterruptedException {
        int i;
        final TimeRangeTracker trr = this.getTimeRangeTracker();
        int threadCount = 10;
        int calls = 1000000;
        Thread[] threads = new Thread[10];
        for (i = 0; i < threads.length; ++i) {
            Thread t = new Thread("" + i){

                @Override
                public void run() {
                    boolean even;
                    int offset = Integer.parseInt(this.getName());
                    boolean bl = even = offset % 2 == 0;
                    if (even) {
                        for (int i = offset * 1000000; i < 1000000; ++i) {
                            trr.includeTimestamp((long)i);
                        }
                    } else {
                        int base = offset * 1000000;
                        for (int i = base + 1000000; i >= base; --i) {
                            trr.includeTimestamp((long)i);
                        }
                    }
                }
            };
            t.start();
            threads[i] = t;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        Assert.assertTrue((trr.getMax() == 10000000L ? 1 : 0) != 0);
        Assert.assertTrue((trr.getMin() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentIncludeTimestampCorrectness() {
        RandomTestData[] testData = new RandomTestData[20];
        long min = Long.MAX_VALUE;
        long max = 0L;
        for (int i = 0; i < 20; ++i) {
            testData[i] = new RandomTestData();
            if (testData[i].getMin() < min) {
                min = testData[i].getMin();
            }
            if (testData[i].getMax() <= max) continue;
            max = testData[i].getMax();
        }
        TimeRangeTracker trt = TimeRangeTracker.create((TimeRangeTracker.Type)TimeRangeTracker.Type.SYNC);
        Thread[] t = new Thread[20];
        for (int i = 0; i < 20; ++i) {
            t[i] = new Thread(new TrtUpdateRunnable(trt, testData[i]));
            t[i].start();
        }
        for (Thread thread : t) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.assertTrue((min == trt.getMin() ? 1 : 0) != 0);
        Assert.assertTrue((max == trt.getMax() ? 1 : 0) != 0);
    }

    static class TrtUpdateRunnable
    implements Runnable {
        private TimeRangeTracker trt;
        private RandomTestData data;

        public TrtUpdateRunnable(TimeRangeTracker trt, RandomTestData data) {
            this.trt = trt;
            this.data = data;
        }

        @Override
        public void run() {
            for (long key : this.data.keys) {
                this.trt.includeTimestamp(key);
            }
        }
    }

    static class RandomTestData {
        private long[] keys = new long[10000000];
        private long min = Long.MAX_VALUE;
        private long max = 0L;

        public RandomTestData() {
            if (ThreadLocalRandom.current().nextInt(20) % 2 == 0) {
                for (int i = 0; i < 10000000; ++i) {
                    this.keys[i] = (long)i + ThreadLocalRandom.current().nextLong(20L);
                    if (this.keys[i] < this.min) {
                        this.min = this.keys[i];
                    }
                    if (this.keys[i] <= this.max) continue;
                    this.max = this.keys[i];
                }
            } else {
                for (int i = 9999999; i >= 0; --i) {
                    this.keys[i] = (long)i + ThreadLocalRandom.current().nextLong(20L);
                    if (this.keys[i] < this.min) {
                        this.min = this.keys[i];
                    }
                    if (this.keys[i] <= this.max) continue;
                    this.max = this.keys[i];
                }
            }
        }

        public long getMax() {
            return this.max;
        }

        public long getMin() {
            return this.min;
        }
    }
}

