/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRegionLocationFinder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionLocationFinder.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster;
    private static final TableName tableName;
    private static final byte[] FAMILY;
    private static Table table;
    private static final int ServerNum = 5;
    private static RegionLocationFinder finder;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        cluster = TEST_UTIL.startMiniCluster(1, 5);
        table = TEST_UTIL.createTable(tableName, FAMILY, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        TEST_UTIL.waitTableAvailable(tableName, 1000L);
        TEST_UTIL.loadTable(table, FAMILY);
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            for (HRegion region : server.getRegions(tableName)) {
                region.flush(true);
            }
        }
        finder.setConf(TEST_UTIL.getConfiguration());
        finder.setServices((MasterServices)cluster.getMaster());
        finder.setClusterMetrics(cluster.getMaster().getClusterMetrics());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        table.close();
        TEST_UTIL.deleteTable(tableName);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testInternalGetTopBlockLocation() throws Exception {
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            for (HRegion region : server.getRegions(tableName)) {
                HDFSBlocksDistribution blocksDistribution1 = region.getHDFSBlocksDistribution();
                HDFSBlocksDistribution blocksDistribution2 = finder.getBlockDistribution(region.getRegionInfo());
                Assert.assertEquals((long)blocksDistribution1.getUniqueBlocksTotalWeight(), (long)blocksDistribution2.getUniqueBlocksTotalWeight());
                if (blocksDistribution1.getUniqueBlocksTotalWeight() == 0L) continue;
                Assert.assertEquals(blocksDistribution1.getTopHosts().get(0), blocksDistribution2.getTopHosts().get(0));
            }
        }
    }

    @Test
    public void testMapHostNameToServerName() throws Exception {
        ArrayList<String> topHosts = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            String serverHost = server.getServerName().getHostname();
            if (topHosts.contains(serverHost)) continue;
            topHosts.add(serverHost);
        }
        List servers = finder.mapHostNameToServerName(topHosts);
        Assert.assertEquals((long)1L, (long)topHosts.size());
        for (int i = 0; i < 5; ++i) {
            ServerName server = cluster.getRegionServer(i).getServerName();
            Assert.assertTrue((boolean)servers.contains(server));
        }
    }

    @Test
    public void testGetTopBlockLocations() throws Exception {
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            for (HRegion region : server.getRegions(tableName)) {
                List topHosts;
                List servers = finder.getTopBlockLocations(region.getRegionInfo());
                if (region.getHDFSBlocksDistribution().getUniqueBlocksTotalWeight() == 0L || !(topHosts = region.getHDFSBlocksDistribution().getTopHosts()).contains(server.getServerName().getHostname())) continue;
                for (int j = 0; j < 5; ++j) {
                    ServerName serverName = cluster.getRegionServer(j).getServerName();
                    Assert.assertTrue((boolean)servers.contains(serverName));
                }
            }
        }
    }

    @Test
    public void testRefreshAndWait() throws Exception {
        finder.getCache().invalidateAll();
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            List regions = server.getRegions(tableName);
            if (regions.size() <= 0) continue;
            ArrayList<RegionInfo> regionInfos = new ArrayList<RegionInfo>(regions.size());
            for (HRegion region : regions) {
                regionInfos.add(region.getRegionInfo());
            }
            finder.refreshAndWait(regionInfos);
            for (RegionInfo regionInfo : regionInfos) {
                Assert.assertNotNull((Object)finder.getCache().getIfPresent((Object)regionInfo));
            }
        }
    }

    static {
        tableName = TableName.valueOf((String)"table");
        FAMILY = Bytes.toBytes((String)"cf");
        finder = new RegionLocationFinder();
    }
}

