/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestRegionBypass {
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionBypass.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionBypass.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private TableName tableName;

    @BeforeClass
    public static void startCluster() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void stopCluster() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(this.tableName, Bytes.toBytes((String)"cf"));
    }

    @Test
    public void testBypass() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        List regions = admin.getRegions(this.tableName);
        for (Object ri : regions) {
            admin.unassign(ri.getRegionName(), false);
        }
        ArrayList<Long> pids = new ArrayList<Long>(regions.size());
        for (RegionInfo ri : regions) {
            StallingAssignProcedure p = new StallingAssignProcedure(ri);
            pids.add(TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().submitProcedure((Procedure)p));
        }
        for (Long pid : pids) {
            while (!TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().isStarted(pid.longValue())) {
                Thread.currentThread();
                Thread.yield();
            }
        }
        List ps = TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().getProcedures();
        for (StallingAssignProcedure p : ps) {
            if (!(p instanceof StallingAssignProcedure)) continue;
            List bs = TEST_UTIL.getHbck().bypassProcedure(Arrays.asList(p.getProcId()), 1L, false, false);
            for (Boolean b : bs) {
                LOG.info("BYPASSED {} {}", (Object)p.getProcId(), (Object)b);
            }
        }
        for (StallingAssignProcedure p : ps) {
            if (!(p instanceof StallingAssignProcedure)) continue;
            p.latch.countDown();
        }
        for (RegionInfo ri : regions) {
            try {
                admin.assign(ri.getRegionName());
            }
            catch (Throwable dnrioe) {
                LOG.info("Expected {}", dnrioe);
            }
        }
        while (!TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().getActiveProcIds().isEmpty()) {
            Thread.currentThread();
            Thread.yield();
        }
        for (RegionInfo ri : regions) {
            TEST_UTIL.getHbck().assigns(Arrays.asList(ri.getEncodedName()), true);
        }
        while (!TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().getActiveProcIds().isEmpty()) {
            Thread.currentThread();
            Thread.yield();
        }
        for (RegionInfo ri : regions) {
            Assert.assertTrue((String)ri.toString(), (boolean)TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionOnline(ri));
        }
    }

    public static class StallingAssignProcedure
    extends AssignProcedure {
        public final CountDownLatch latch = new CountDownLatch(2);

        public StallingAssignProcedure() {
        }

        public StallingAssignProcedure(RegionInfo regionInfo) {
            super(regionInfo);
        }

        void setTransitionState(MasterProcedureProtos.RegionTransitionState state) {
            if (state == MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_DISPATCH) {
                try {
                    LOG.info("LATCH2 {}", (Object)this.latch.getCount());
                    this.latch.await();
                    LOG.info("LATCH3 {}", (Object)this.latch.getCount());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else if (state == MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_QUEUE) {
                LOG.info("LATCH1 {}", (Object)this.latch.getCount());
                this.latch.countDown();
            }
            super.setTransitionState(state);
        }
    }
}

