/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.assignment.MoveRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterAbortAndRSGotKilled {
    private static Logger LOG = LoggerFactory.getLogger((String)TestMasterAbortAndRSGotKilled.class.getName());
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterAbortAndRSGotKilled.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static CountDownLatch countDownLatch = new CountDownLatch(1);
    private static byte[] CF = Bytes.toBytes((String)"cf");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setStrings("hbase.coprocessor.region.classes", new String[]{DelayCloseCP.class.getName()});
        UTIL.startMiniCluster(3);
        UTIL.getAdmin().balancerSwitch(false, true);
        UTIL.createTable(TABLE_NAME, CF);
        UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        JVMClusterUtil.RegionServerThread rsThread = null;
        for (JVMClusterUtil.RegionServerThread t : UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            if (t.getRegionServer().getRegions(TABLE_NAME).isEmpty()) continue;
            rsThread = t;
            break;
        }
        HRegionServer rs = rsThread.getRegionServer();
        RegionInfo hri = ((HRegion)rs.getRegions(TABLE_NAME).get(0)).getRegionInfo();
        MoveRegionProcedure moveRegionProcedure = new MoveRegionProcedure((MasterProcedureEnv)UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment(), new RegionPlan(hri, rs.getServerName(), rs.getServerName()), true);
        long procID = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().submitProcedure((Procedure)moveRegionProcedure);
        countDownLatch.await();
        UTIL.getMiniHBaseCluster().stopMaster(0);
        UTIL.getMiniHBaseCluster().startMaster();
        UTIL.waitFor(30000L, () -> UTIL.getMiniHBaseCluster().getMaster() != null && UTIL.getMiniHBaseCluster().getMaster().isInitialized());
        Assert.assertTrue((String)"Should be 3 RS after master restart", (UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size() == 3 ? 1 : 0) != 0);
    }

    public static class DelayCloseCP
    implements RegionCoprocessor,
    RegionObserver {
        public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) throws IOException {
            try {
                if (!((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().isSystemTable()) {
                    LOG.error("begin to sleep");
                    countDownLatch.countDown();
                    Thread.sleep(10000L);
                    LOG.error("finish sleep");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }
    }
}

