/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.bucket.ByteBufferIOEngine;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestByteBufferIOEngine {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestByteBufferIOEngine.class);

    @Test
    public void testByteBufferIOEngine() throws Exception {
        int capacity = 0x2000000;
        int testNum = 100;
        int maxBlockSize = 65536;
        ByteBufferIOEngine ioEngine = new ByteBufferIOEngine((long)capacity);
        int testOffsetAtStartNum = testNum / 10;
        int testOffsetAtEndNum = testNum / 10;
        for (int i = 0; i < testNum; ++i) {
            byte val = (byte)(Math.random() * 255.0);
            int blockSize = (int)(Math.random() * (double)maxBlockSize);
            if (blockSize == 0) {
                blockSize = 1;
            }
            byte[] byteArray = new byte[blockSize];
            for (int j = 0; j < byteArray.length; ++j) {
                byteArray[j] = val;
            }
            ByteBuffer srcBuffer = ByteBuffer.wrap(byteArray);
            int offset = 0;
            if (testOffsetAtStartNum > 0) {
                --testOffsetAtStartNum;
                offset = 0;
            } else if (testOffsetAtEndNum > 0) {
                --testOffsetAtEndNum;
                offset = capacity - blockSize;
            } else {
                offset = (int)(Math.random() * (double)(capacity - maxBlockSize));
            }
            ioEngine.write(srcBuffer, (long)offset);
            BufferGrabbingDeserializer deserializer = new BufferGrabbingDeserializer();
            ioEngine.read((long)offset, blockSize, (CacheableDeserializer)deserializer);
            ByteBuff dstBuffer = deserializer.buf;
            for (int j = 0; j < byteArray.length; ++j) {
                Assert.assertTrue((byteArray[j] == dstBuffer.get(j) ? 1 : 0) != 0);
            }
        }
        assert (testOffsetAtStartNum == 0);
        assert (testOffsetAtEndNum == 0);
    }

    @Test
    public void testByteBufferIOEngineWithMBB() throws Exception {
        int capacity = 0x2000000;
        int testNum = 100;
        int maxBlockSize = 65536;
        ByteBufferIOEngine ioEngine = new ByteBufferIOEngine((long)capacity);
        int testOffsetAtStartNum = testNum / 10;
        int testOffsetAtEndNum = testNum / 10;
        for (int i = 0; i < testNum; ++i) {
            byte val = (byte)(Math.random() * 255.0);
            int blockSize = (int)(Math.random() * (double)maxBlockSize);
            if (blockSize == 0) {
                blockSize = 1;
            }
            byte[] byteArray = new byte[blockSize];
            for (int j = 0; j < byteArray.length; ++j) {
                byteArray[j] = val;
            }
            ByteBuffer srcBuffer = ByteBuffer.wrap(byteArray);
            int offset = 0;
            if (testOffsetAtStartNum > 0) {
                --testOffsetAtStartNum;
                offset = 0;
            } else if (testOffsetAtEndNum > 0) {
                --testOffsetAtEndNum;
                offset = capacity - blockSize;
            } else {
                offset = (int)(Math.random() * (double)(capacity - maxBlockSize));
            }
            ioEngine.write(srcBuffer, (long)offset);
            BufferGrabbingDeserializer deserializer = new BufferGrabbingDeserializer();
            ioEngine.read((long)offset, blockSize, (CacheableDeserializer)deserializer);
            ByteBuff dstBuffer = deserializer.buf;
            for (int j = 0; j < byteArray.length; ++j) {
                Assert.assertTrue((srcBuffer.get(j) == dstBuffer.get(j) ? 1 : 0) != 0);
            }
        }
        assert (testOffsetAtStartNum == 0);
        assert (testOffsetAtEndNum == 0);
    }

    static class BufferGrabbingDeserializer
    implements CacheableDeserializer<Cacheable> {
        private ByteBuff buf;

        BufferGrabbingDeserializer() {
        }

        public Cacheable deserialize(ByteBuff b) throws IOException {
            return null;
        }

        public Cacheable deserialize(ByteBuff b, boolean reuse, Cacheable.MemoryType memType) throws IOException {
            this.buf = b;
            return null;
        }

        public int getDeserialiserIdentifier() {
            return 0;
        }

        public ByteBuff getDeserializedByteBuff() {
            return this.buf;
        }
    }
}

