/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestAdmin1 {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAdmin1.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAdmin1.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Admin admin;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getAdmin();
    }

    @After
    public void tearDown() throws Exception {
        for (HTableDescriptor htd : this.admin.listTables()) {
            TEST_UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void testSplitFlushCompactUnknownTable() throws InterruptedException {
        TableName unknowntable = TableName.valueOf((String)this.name.getMethodName());
        IOException exception = null;
        try {
            this.admin.compact(unknowntable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.flush(unknowntable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.split(unknowntable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteEditUnknownColumnFamilyAndOrTable() throws IOException {
        TableName nonexistentTable = TableName.valueOf((String)"nonexistent");
        byte[] nonexistentColumn = Bytes.toBytes((String)"nonexistent");
        HColumnDescriptor nonexistentHcd = new HColumnDescriptor(nonexistentColumn);
        IOException exception = null;
        try {
            this.admin.addColumnFamily(nonexistentTable, (ColumnFamilyDescriptor)nonexistentHcd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.deleteTable(nonexistentTable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.deleteColumnFamily(nonexistentTable, nonexistentColumn);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.disableTable(nonexistentTable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.enableTable(nonexistentTable);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            this.admin.modifyColumnFamily(nonexistentTable, (ColumnFamilyDescriptor)nonexistentHcd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        exception = null;
        try {
            HTableDescriptor htd = new HTableDescriptor(nonexistentTable);
            htd.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
            this.admin.modifyTable(htd.getTableName(), (TableDescriptor)htd);
        }
        catch (IOException e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof TableNotFoundException));
        TableName tableName = TableName.valueOf((String)(this.name.getMethodName() + System.currentTimeMillis()));
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor("cf"));
        this.admin.createTable((TableDescriptor)htd);
        try {
            exception = null;
            try {
                this.admin.deleteColumnFamily(htd.getTableName(), nonexistentHcd.getName());
            }
            catch (IOException e) {
                exception = e;
            }
            Assert.assertTrue((String)("found=" + exception.getClass().getName()), (boolean)(exception instanceof InvalidFamilyOperationException));
            exception = null;
            try {
                this.admin.modifyColumnFamily(htd.getTableName(), (ColumnFamilyDescriptor)nonexistentHcd);
            }
            catch (IOException e) {
                exception = e;
            }
            Assert.assertTrue((String)("found=" + exception.getClass().getName()), (boolean)(exception instanceof InvalidFamilyOperationException));
        }
        finally {
            this.admin.disableTable(tableName);
            this.admin.deleteTable(tableName);
        }
    }

    @Test
    public void testDisableAndEnableTable() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.addColumn(HConstants.CATALOG_FAMILY, qualifier, value);
        ht.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht.get(get);
        this.admin.disableTable(ht.getName());
        Assert.assertTrue((String)"Table must be disabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getTableStateManager().isTableState(ht.getName(), new TableState.State[]{TableState.State.DISABLED}));
        Assert.assertEquals((Object)TableState.State.DISABLED, (Object)this.getStateFromMeta(table));
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht.get(get);
        }
        catch (TableNotEnabledException e) {
            ok = true;
        }
        ok = false;
        Scan scan = new Scan();
        try {
            ResultScanner scanner = ht.getScanner(scan);
            Result res = null;
            while ((res = scanner.next()) != null) {
            }
        }
        catch (TableNotEnabledException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        this.admin.enableTable(table);
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getTableStateManager().isTableState(ht.getName(), new TableState.State[]{TableState.State.ENABLED}));
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)this.getStateFromMeta(table));
        try {
            ht.get(get);
        }
        catch (RetriesExhaustedException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        ht.close();
    }

    private TableState.State getStateFromMeta(TableName table) throws IOException {
        TableState state = MetaTableAccessor.getTableState((Connection)TEST_UTIL.getConnection(), (TableName)table);
        Assert.assertNotNull((Object)state);
        return state.getState();
    }

    @Test
    public void testDisableAndEnableTables() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        TableName table1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName table2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        Table ht1 = TEST_UTIL.createTable(table1, HConstants.CATALOG_FAMILY);
        Table ht2 = TEST_UTIL.createTable(table2, HConstants.CATALOG_FAMILY);
        Put put = new Put(row);
        put.addColumn(HConstants.CATALOG_FAMILY, qualifier, value);
        ht1.put(put);
        ht2.put(put);
        Get get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        ht1.get(get);
        ht2.get(get);
        this.admin.disableTables("testDisableAndEnableTable.*");
        get = new Get(row);
        get.addColumn(HConstants.CATALOG_FAMILY, qualifier);
        boolean ok = false;
        try {
            ht1.get(get);
            ht2.get(get);
        }
        catch (DoNotRetryIOException e) {
            ok = true;
        }
        Assert.assertEquals((Object)TableState.State.DISABLED, (Object)this.getStateFromMeta(table1));
        Assert.assertEquals((Object)TableState.State.DISABLED, (Object)this.getStateFromMeta(table2));
        Assert.assertTrue((boolean)ok);
        this.admin.enableTables("testDisableAndEnableTable.*");
        try {
            ht1.get(get);
        }
        catch (IOException e) {
            ok = false;
        }
        try {
            ht2.get(get);
        }
        catch (IOException e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        ht1.close();
        ht2.close();
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)this.getStateFromMeta(table1));
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)this.getStateFromMeta(table2));
    }

    @Test
    public void testCreateTable() throws IOException {
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getTableStateManager().isTableState(tableName, new TableState.State[]{TableState.State.ENABLED}));
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)this.getStateFromMeta(tableName));
    }

    @Test
    public void testTruncateTable() throws IOException {
        this.testTruncateTable(TableName.valueOf((String)this.name.getMethodName()), false);
    }

    @Test
    public void testTruncateTablePreservingSplits() throws IOException {
        this.testTruncateTable(TableName.valueOf((String)this.name.getMethodName()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTruncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((int)4), Bytes.toBytes((int)8)};
        try (Table table = TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY, (byte[][])splitKeys);){
            TEST_UTIL.loadNumericRows(table, HConstants.CATALOG_FAMILY, 0, 10);
            Assert.assertEquals((long)10L, (long)TEST_UTIL.countRows(table));
        }
        Assert.assertEquals((long)3L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        this.admin.disableTable(tableName);
        this.admin.truncateTable(tableName, preserveSplits);
        table = TEST_UTIL.getConnection().getTable(tableName);
        try {
            Assert.assertEquals((long)0L, (long)TEST_UTIL.countRows(table));
        }
        finally {
            table.close();
        }
        if (preserveSplits) {
            Assert.assertEquals((long)3L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        } else {
            Assert.assertEquals((long)1L, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        }
    }

    @Test
    public void testGetTableDescriptor() throws IOException {
        HColumnDescriptor fam1 = new HColumnDescriptor("fam1");
        HColumnDescriptor fam2 = new HColumnDescriptor("fam2");
        HColumnDescriptor fam3 = new HColumnDescriptor("fam3");
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        htd.addFamily(fam1);
        htd.addFamily(fam2);
        htd.addFamily(fam3);
        this.admin.createTable((TableDescriptor)htd);
        Table table = TEST_UTIL.getConnection().getTable(htd.getTableName());
        TableDescriptor confirmedHtd = table.getDescriptor();
        Assert.assertEquals((long)0L, (long)TableDescriptor.COMPARATOR.compare(htd, confirmedHtd));
        MetaTableAccessor.fullScanMetaAndPrint((Connection)TEST_UTIL.getConnection());
        table.close();
    }

    @Test
    public void testCompactionTimestamps() throws Exception {
        byte[] regionName;
        HColumnDescriptor fam1 = new HColumnDescriptor("fam1");
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(fam1);
        this.admin.createTable((TableDescriptor)htd);
        Table table = TEST_UTIL.getConnection().getTable(htd.getTableName());
        long ts = this.admin.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)0L, (long)ts);
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.addColumn(Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam1"));
        table.put(p);
        ts = this.admin.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)0L, (long)ts);
        this.admin.flush(tableName);
        ts = this.admin.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)0L, (long)ts);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            regionName = ((HRegionLocation)l.getAllRegionLocations().get(0)).getRegionInfo().getRegionName();
        }
        long ts1 = this.admin.getLastMajorCompactionTimestampForRegion(regionName);
        Assert.assertEquals((long)ts, (long)ts1);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.addColumn(Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam1"));
        table.put(p);
        this.admin.flush(tableName);
        ts = this.admin.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)ts1, (long)ts);
        TEST_UTIL.compact(tableName, true);
        table.put(p);
        this.admin.flush(tableName);
        ts = this.admin.getLastMajorCompactionTimestamp(tableName);
        Assert.assertTrue((ts > ts1 ? 1 : 0) != 0);
        ts1 = this.admin.getLastMajorCompactionTimestampForRegion(regionName);
        Assert.assertEquals((long)ts, (long)ts1);
        table.put(p);
        this.admin.flush(tableName);
        ts = this.admin.getLastMajorCompactionTimestamp(tableName);
        Assert.assertEquals((long)ts, (long)ts1);
        table.close();
    }

    @Test
    public void testHColumnValidName() {
        try {
            new HColumnDescriptor("\\test\\abc");
        }
        catch (IllegalArgumentException iae) {
            boolean exceptionThrown = true;
            Assert.assertTrue((boolean)exceptionThrown);
        }
    }

    @Test
    public void testReadOnlyTableModify() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableDescriptor)this.admin.getDescriptor(tableName)).setReadOnly(true).build();
        this.admin.modifyTable(htd);
        htd = TableDescriptorBuilder.newBuilder((TableDescriptor)this.admin.getDescriptor(tableName)).setCompactionEnabled(false).build();
        this.admin.modifyTable(htd);
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
        Assert.assertFalse((boolean)this.admin.tableExists(tableName));
    }

    @Test(expected=TableNotDisabledException.class)
    public void testModifyRegionReplicasEnabledTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableDescriptor)this.admin.getDescriptor(tableName)).setRegionReplication(3).build();
        try {
            this.admin.modifyTable(htd);
            Assert.fail((String)"Expected an exception");
        }
        finally {
            this.admin.disableTable(tableName);
            this.admin.deleteTable(tableName);
            Assert.assertFalse((boolean)this.admin.tableExists(tableName));
        }
    }

    @Test
    public void testOnlineChangeTableSchema() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor[] tables = this.admin.listTables();
        int numTables = tables.length;
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        tables = this.admin.listTables();
        Assert.assertEquals((long)(numTables + 1), (long)tables.length);
        HTableDescriptor htd = this.admin.getTableDescriptor(tableName);
        HTableDescriptor copy = new HTableDescriptor(htd);
        Assert.assertTrue((boolean)htd.equals((Object)copy));
        long newFlushSize = htd.getMemStoreFlushSize() / 2L;
        if (newFlushSize <= 0L) {
            newFlushSize = 0x4000000L;
        }
        copy.setMemStoreFlushSize(newFlushSize);
        String key = "anyoldkey";
        Assert.assertTrue((htd.getValue("anyoldkey") == null ? 1 : 0) != 0);
        copy.setValue("anyoldkey", "anyoldkey");
        boolean expectedException = false;
        try {
            this.admin.modifyTable(tableName, (TableDescriptor)copy);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        HTableDescriptor modifiedHtd = new HTableDescriptor(this.admin.getTableDescriptor(tableName));
        Assert.assertFalse((boolean)htd.equals((Object)modifiedHtd));
        Assert.assertTrue((boolean)copy.equals((Object)modifiedHtd));
        Assert.assertEquals((long)newFlushSize, (long)modifiedHtd.getMemStoreFlushSize());
        Assert.assertEquals((Object)"anyoldkey", (Object)modifiedHtd.getValue("anyoldkey"));
        int countOfFamilies = modifiedHtd.getFamilies().size();
        Assert.assertTrue((countOfFamilies > 0 ? 1 : 0) != 0);
        HColumnDescriptor hcd = (HColumnDescriptor)modifiedHtd.getFamilies().iterator().next();
        int maxversions = hcd.getMaxVersions();
        int newMaxVersions = maxversions + 1;
        hcd.setMaxVersions(newMaxVersions);
        byte[] hcdName = hcd.getName();
        expectedException = false;
        try {
            this.admin.modifyColumnFamily(tableName, (ColumnFamilyDescriptor)hcd);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        HColumnDescriptor modifiedHcd = modifiedHtd.getFamily(hcdName);
        Assert.assertEquals((long)newMaxVersions, (long)modifiedHcd.getMaxVersions());
        Assert.assertFalse((boolean)this.admin.isTableDisabled(tableName));
        String xtracolName = "xtracol";
        HColumnDescriptor xtracol = new HColumnDescriptor("xtracol");
        xtracol.setValue("xtracol", "xtracol");
        expectedException = false;
        try {
            this.admin.addColumnFamily(tableName, (ColumnFamilyDescriptor)xtracol);
        }
        catch (TableNotDisabledException re) {
            expectedException = true;
        }
        Assert.assertFalse((boolean)expectedException);
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        hcd = modifiedHtd.getFamily(xtracol.getName());
        Assert.assertTrue((hcd != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)hcd.getValue("xtracol").equals("xtracol"));
        this.admin.deleteColumnFamily(tableName, xtracol.getName());
        modifiedHtd = this.admin.getTableDescriptor(tableName);
        hcd = modifiedHtd.getFamily(xtracol.getName());
        Assert.assertTrue((hcd == null ? 1 : 0) != 0);
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
        this.admin.listTables();
        Assert.assertFalse((boolean)this.admin.tableExists(tableName));
    }

    protected void verifyRoundRobinDistribution(ClusterConnection c, RegionLocator regionLocator, int expectedRegions) throws IOException {
        int numRS = c.getCurrentNrHRS();
        List regions = regionLocator.getAllRegionLocations();
        HashMap<ServerName, ArrayList<HRegionInfo>> server2Regions = new HashMap<ServerName, ArrayList<HRegionInfo>>();
        for (HRegionLocation loc : regions) {
            ServerName server = loc.getServerName();
            ArrayList<HRegionInfo> regs = (ArrayList<HRegionInfo>)server2Regions.get(server);
            if (regs == null) {
                regs = new ArrayList<HRegionInfo>();
                server2Regions.put(server, regs);
            }
            regs.add(loc.getRegionInfo());
        }
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)TEST_UTIL.getConfiguration());
        if (tablesOnMaster) {
            --numRS;
        }
        float average = (float)expectedRegions / (float)numRS;
        int min = (int)Math.floor(average);
        int max = (int)Math.ceil(average);
        for (List regionList : server2Regions.values()) {
            Assert.assertTrue((String)("numRS=" + numRS + ", min=" + min + ", max=" + max + ", size=" + regionList.size() + ", tablesOnMaster=" + tablesOnMaster), (regionList.size() == min || regionList.size() == max ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCreateTableNumberOfRegions() throws IOException, InterruptedException {
        List regions;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable((TableDescriptor)desc);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)"Table should have only 1 region", (long)1L, (long)regions.size());
        }
        TableName TABLE_2 = TableName.valueOf((String)(tableName.getNameAsString() + "_2"));
        desc = new HTableDescriptor(TABLE_2);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable((TableDescriptor)desc, (byte[][])new byte[][]{{42}});
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(TABLE_2);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)"Table should have only 2 region", (long)2L, (long)regions.size());
        }
        TableName TABLE_3 = TableName.valueOf((String)(tableName.getNameAsString() + "_3"));
        desc = new HTableDescriptor(TABLE_3);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable((TableDescriptor)desc, "a".getBytes(), "z".getBytes(), 3);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(TABLE_3);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)"Table should have only 3 region", (long)3L, (long)regions.size());
        }
        TableName TABLE_4 = TableName.valueOf((String)(tableName.getNameAsString() + "_4"));
        desc = new HTableDescriptor(TABLE_4);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        try {
            this.admin.createTable((TableDescriptor)desc, "a".getBytes(), "z".getBytes(), 2);
            Assert.fail((String)"Should not be able to create a table with only 2 regions using this API.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TableName TABLE_5 = TableName.valueOf((String)(tableName.getNameAsString() + "_5"));
        desc = new HTableDescriptor(TABLE_5);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable((TableDescriptor)desc, new byte[]{1}, new byte[]{127}, 16);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(TABLE_5);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)"Table should have 16 region", (long)16L, (long)regions.size());
        }
    }

    @Test
    public void testCreateTableWithRegions() throws IOException, InterruptedException {
        HRegionInfo hri;
        Iterator hris;
        List regions;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable((TableDescriptor)desc, (byte[][])splitKeys);
        boolean tableAvailable = this.admin.isTableAvailable(tableName, (byte[][])splitKeys);
        Assert.assertTrue((String)"Table should be created with splitKyes + 1 rows in META", (boolean)tableAvailable);
        ClusterConnection conn = (ClusterConnection)TEST_UTIL.getConnection();
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
            System.err.println("Found " + regions.size() + " regions");
            hris = regions.iterator();
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[0]));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[0]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[1]));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[1]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[2]));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[2]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[3]));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[3]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[4]));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[4]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[5]));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[5]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[6]));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[6]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[7]));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[7]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])splitKeys[8]));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])splitKeys[8]));
            Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
            this.verifyRoundRobinDistribution(conn, l, expectedRegions);
        }
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        expectedRegions = 10;
        TableName TABLE_2 = TableName.valueOf((String)(tableName.getNameAsString() + "_2"));
        desc = new HTableDescriptor(TABLE_2);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = TEST_UTIL.getAdmin();
        this.admin.createTable((TableDescriptor)desc, startKey, endKey, expectedRegions);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(TABLE_2);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
            System.err.println("Found " + regions.size() + " regions");
            hris = regions.iterator();
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((hri.getStartKey() == null || hri.getStartKey().length == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8}));
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getEndKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
            hri = ((HRegionLocation)hris.next()).getRegionInfo();
            Assert.assertTrue((boolean)Bytes.equals((byte[])hri.getStartKey(), (byte[])new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9}));
            Assert.assertTrue((hri.getEndKey() == null || hri.getEndKey().length == 0 ? 1 : 0) != 0);
            this.verifyRoundRobinDistribution(conn, l, expectedRegions);
        }
        startKey = new byte[]{0, 0, 0, 0, 0, 0};
        endKey = new byte[]{1, 0, 0, 0, 0, 0};
        expectedRegions = 5;
        TableName TABLE_3 = TableName.valueOf((String)(tableName.getNameAsString() + "_3"));
        desc = new HTableDescriptor(TABLE_3);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin = TEST_UTIL.getAdmin();
        this.admin.createTable((TableDescriptor)desc, startKey, endKey, expectedRegions);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(TABLE_3);){
            regions = l.getAllRegionLocations();
            Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
            System.err.println("Found " + regions.size() + " regions");
            this.verifyRoundRobinDistribution(conn, l, expectedRegions);
        }
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {2, 2, 2}};
        TableName TABLE_4 = TableName.valueOf((String)(tableName.getNameAsString() + "_4"));
        desc = new HTableDescriptor(TABLE_4);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        try {
            this.admin.createTable((TableDescriptor)desc, (byte[][])splitKeys);
            Assert.assertTrue((String)"Should not be able to create this table because of duplicate split keys", (boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTableAvailableWithRandomSplitKeys() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor("col"));
        byte[][] splitKeys = new byte[1][];
        splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}};
        this.admin.createTable((TableDescriptor)desc);
        boolean tableAvailable = this.admin.isTableAvailable(tableName, (byte[][])splitKeys);
        Assert.assertFalse((String)"Table should be created with 1 row in META", (boolean)tableAvailable);
    }

    @Test
    public void testCreateTableWithOnlyEmptyStartRow() throws IOException {
        byte[] tableName = Bytes.toBytes((String)this.name.getMethodName());
        byte[][] splitKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY};
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor("col"));
        try {
            this.admin.createTable((TableDescriptor)desc, (byte[][])splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateTableWithEmptyRowInTheSplitKeys() throws IOException {
        byte[] tableName = Bytes.toBytes((String)this.name.getMethodName());
        byte[][] splitKeys = new byte[][]{"region1".getBytes(), HConstants.EMPTY_BYTE_ARRAY, "region2".getBytes()};
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        desc.addFamily(new HColumnDescriptor("col"));
        try {
            this.admin.createTable((TableDescriptor)desc, (byte[][])splitKeys);
            Assert.fail((String)"Test case should fail as empty split key is passed.");
        }
        catch (IllegalArgumentException e) {
            LOG.info("Expected ", (Throwable)e);
        }
    }

    @Test
    public void testTableExist() throws IOException {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        boolean exist = this.admin.tableExists(table);
        Assert.assertEquals((Object)false, (Object)exist);
        TEST_UTIL.createTable(table, HConstants.CATALOG_FAMILY);
        exist = this.admin.tableExists(table);
        Assert.assertEquals((Object)true, (Object)exist);
    }

    @Test
    public void testForceSplit() throws Exception {
        byte[][] familyNames = new byte[][]{Bytes.toBytes((String)"cf")};
        int[] rowCounts = new int[]{6000};
        int numVersions = 1;
        int blockSize = 256;
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize, true);
        byte[] splitKey = Bytes.toBytes((int)3500);
        this.splitTest(splitKey, familyNames, rowCounts, numVersions, blockSize, true);
        this.splitTest(splitKey, familyNames, rowCounts, numVersions, blockSize, false);
    }

    @Test
    public void testEnableTableRetainAssignment() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable((TableDescriptor)desc, (byte[][])splitKeys);
        try (RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            List regions = l.getAllRegionLocations();
            Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
            this.admin.disableTable(tableName);
            this.admin.enableTable(tableName);
            List regions2 = l.getAllRegionLocations();
            Assert.assertEquals((long)regions.size(), (long)regions2.size());
            Assert.assertTrue((boolean)regions2.containsAll(regions));
        }
    }

    @Test
    public void testForceSplitMultiFamily() throws Exception {
        int numVersions = 1;
        int blockSize = 256;
        byte[][] familyNames = new byte[][]{Bytes.toBytes((String)"cf1"), Bytes.toBytes((String)"cf2")};
        int[] rowCounts = new int[]{6000, 1};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize, true);
        rowCounts = new int[]{1, 6000};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize, true);
        rowCounts = new int[]{6000, 300};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize, true);
        rowCounts = new int[]{300, 6000};
        this.splitTest(null, familyNames, rowCounts, numVersions, blockSize, true);
    }

    void splitTest(byte[] splitPoint, byte[][] familyNames, int[] rowCounts, int numVersions, int blockSize, boolean async) throws Exception {
        TableName tableName = TableName.valueOf((String)"testForceSplit");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowCounts.length; ++i) {
            sb.append("_").append(Integer.toString(rowCounts[i]));
        }
        Assert.assertFalse((boolean)this.admin.tableExists(tableName));
        try (Table table = TEST_UTIL.createTable(tableName, familyNames, numVersions, blockSize);
             final RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            int rowCount = 0;
            byte[] q = new byte[]{};
            for (int index = 0; index < familyNames.length; ++index) {
                ArrayList<Put> puts = new ArrayList<Put>(rowCounts[index]);
                for (int i = 0; i < rowCounts[index]; ++i) {
                    byte[] k = Bytes.toBytes((int)i);
                    Put put = new Put(k);
                    put.addColumn(familyNames[index], q, k);
                    puts.add(put);
                }
                table.put(puts);
                if (rowCount >= rowCounts[index]) continue;
                rowCount = rowCounts[index];
            }
            List m = locator.getAllRegionLocations();
            LOG.info("Initial regions (" + m.size() + "): " + m);
            Assert.assertTrue((m.size() == 1 ? 1 : 0) != 0);
            Scan scan = new Scan();
            ResultScanner scanner = table.getScanner(scan);
            int rows = 0;
            for (Result result : scanner) {
                ++rows;
            }
            scanner.close();
            Assert.assertEquals((long)rowCount, (long)rows);
            scan = new Scan();
            scanner = table.getScanner(scan);
            scanner.next();
            if (async) {
                this.admin.split(tableName, splitPoint);
                final AtomicInteger count = new AtomicInteger(0);
                Thread t = new Thread("CheckForSplit"){

                    @Override
                    public void run() {
                        for (int i = 0; i < 45; ++i) {
                            try {
                                1.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                continue;
                            }
                            List regions = null;
                            try {
                                regions = locator.getAllRegionLocations();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            if (regions == null) continue;
                            count.set(regions.size());
                            if (count.get() >= 2) {
                                LOG.info("Found: " + regions);
                                break;
                            }
                            LOG.debug("Cycle waiting on split");
                        }
                        LOG.debug("CheckForSplit thread exited, current region count: " + count.get());
                    }
                };
                t.setPriority(3);
                t.start();
                t.join();
            } else {
                ((HBaseAdmin)this.admin).splitRegionSync(((HRegionLocation)m.get(0)).getRegionInfo().getRegionName(), splitPoint);
            }
            rows = 1;
            for (Result result : scanner) {
                if (++rows <= rowCount) continue;
                scanner.close();
                Assert.assertTrue((String)("Scanned more than expected (" + rowCount + ")"), (boolean)false);
            }
            scanner.close();
            Assert.assertEquals((long)rowCount, (long)rows);
            List regions = null;
            try {
                regions = locator.getAllRegionLocations();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Assert.assertEquals((long)2L, (long)regions.size());
            if (splitPoint != null) {
                Assert.assertEquals((Object)Bytes.toString((byte[])splitPoint), (Object)Bytes.toString((byte[])((HRegionLocation)regions.get(0)).getRegionInfo().getEndKey()));
                Assert.assertEquals((Object)Bytes.toString((byte[])splitPoint), (Object)Bytes.toString((byte[])((HRegionLocation)regions.get(1)).getRegionInfo().getStartKey()));
                LOG.debug("Properly split on " + Bytes.toString((byte[])splitPoint));
            } else if (familyNames.length > 1) {
                int splitKey = Bytes.toInt((byte[])((HRegionLocation)regions.get(0)).getRegionInfo().getEndKey());
                int deltaForLargestFamily = Math.abs(rowCount / 2 - splitKey);
                LOG.debug("SplitKey=" + splitKey + "&deltaForLargestFamily=" + deltaForLargestFamily + ", r=" + ((HRegionLocation)regions.get(0)).getRegionInfo());
                for (int index = 0; index < familyNames.length; ++index) {
                    int delta = Math.abs(rowCounts[index] / 2 - splitKey);
                    if (delta >= deltaForLargestFamily) continue;
                    Assert.assertTrue((String)("Delta " + delta + " for family " + index + " should be at least deltaForLargestFamily " + deltaForLargestFamily), (boolean)false);
                }
            }
            TEST_UTIL.deleteTable(tableName);
        }
    }

    @Test
    public void testSplitAndMergeWithReplicaTable() throws Exception {
        List<HRegion> oldRegions;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.setRegionReplication(3);
        byte[] cf = "f".getBytes();
        HColumnDescriptor hcd = new HColumnDescriptor(cf);
        desc.addFamily(hcd);
        byte[][] splitRows = new byte[][]{{52}, {55}};
        TEST_UTIL.getAdmin().createTable((TableDescriptor)desc, (byte[][])splitRows);
        do {
            oldRegions = TEST_UTIL.getHBaseCluster().getRegions(tableName);
            Thread.sleep(10L);
        } while (oldRegions.size() != 9);
        Table ht = TEST_UTIL.getConnection().getTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        byte[] qualifier = "c".getBytes();
        Put put = new Put(new byte[]{49});
        put.addColumn(cf, qualifier, "100".getBytes());
        puts.add(put);
        put = new Put(new byte[]{54});
        put.addColumn(cf, qualifier, "100".getBytes());
        puts.add(put);
        put = new Put(new byte[]{56});
        put.addColumn(cf, qualifier, "100".getBytes());
        puts.add(put);
        ht.put(puts);
        ht.close();
        List regions = MetaTableAccessor.getTableRegionsAndLocations((Connection)TEST_UTIL.getConnection(), (TableName)tableName);
        boolean gotException = false;
        try {
            TEST_UTIL.getAdmin().splitRegion(((RegionInfo)((Pair)regions.get(1)).getFirst()).getRegionName());
        }
        catch (IllegalArgumentException ex) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        gotException = false;
        try {
            TEST_UTIL.getHBaseAdmin().splitRegionAsync((RegionInfo)((Pair)regions.get(1)).getFirst(), new byte[]{49});
        }
        catch (IOException ex) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        gotException = false;
        try {
            TEST_UTIL.getHBaseAdmin().splitRegionSync(((RegionInfo)((Pair)regions.get(1)).getFirst()).getRegionName(), new byte[]{49});
        }
        catch (IllegalArgumentException ex) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        gotException = false;
        try {
            TEST_UTIL.getHBaseAdmin().mergeRegionsSync(((RegionInfo)((Pair)regions.get(1)).getFirst()).getEncodedNameAsBytes(), ((RegionInfo)((Pair)regions.get(2)).getFirst()).getEncodedNameAsBytes(), true);
        }
        catch (IllegalArgumentException m) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        try {
            byte[][] nameofRegionsToMerge = new byte[][]{((RegionInfo)((Pair)regions.get(1)).getFirst()).getEncodedNameAsBytes(), ((RegionInfo)((Pair)regions.get(2)).getFirst()).getEncodedNameAsBytes()};
            MasterProtos.MergeTableRegionsRequest request = RequestConverter.buildMergeTableRegionsRequest((byte[][])nameofRegionsToMerge, (boolean)true, (long)0L, (long)0L);
            ((ClusterConnection)TEST_UTIL.getAdmin().getConnection()).getMaster().mergeTableRegions(null, request);
        }
        catch (ServiceException m) {
            Throwable t = m.getCause();
            do {
                if (!(t instanceof MergeRegionException)) continue;
                gotException = true;
                break;
            } while ((t = t.getCause()) != null);
        }
        Assert.assertTrue((boolean)gotException);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidHColumnDescriptor() throws IOException {
        new HColumnDescriptor("/cfamily/name");
    }

    @Test
    public void testEnableDisableAddColumnDeleteColumn() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        while (!this.admin.isTableEnabled(TableName.valueOf((String)this.name.getMethodName()))) {
            Thread.sleep(10L);
        }
        this.admin.disableTable(tableName);
        try {
            TEST_UTIL.getConnection().getTable(tableName);
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
        this.admin.addColumnFamily(tableName, (ColumnFamilyDescriptor)new HColumnDescriptor("col2"));
        this.admin.enableTable(tableName);
        try {
            this.admin.deleteColumnFamily(tableName, Bytes.toBytes((String)"col2"));
        }
        catch (TableNotDisabledException e) {
            LOG.info(e.toString(), (Throwable)e);
        }
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
    }

    @Test
    public void testDeleteLastColumnFamily() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY).close();
        while (!this.admin.isTableEnabled(TableName.valueOf((String)this.name.getMethodName()))) {
            Thread.sleep(10L);
        }
        try {
            this.admin.deleteColumnFamily(tableName, HConstants.CATALOG_FAMILY);
            Assert.fail((String)"Should have failed to delete the only column family of a table");
        }
        catch (InvalidFamilyOperationException invalidFamilyOperationException) {
            // empty catch block
        }
        this.admin.disableTable(tableName);
        try {
            this.admin.deleteColumnFamily(tableName, HConstants.CATALOG_FAMILY);
            Assert.fail((String)"Should have failed to delete the only column family of a table");
        }
        catch (InvalidFamilyOperationException invalidFamilyOperationException) {
            // empty catch block
        }
        this.admin.deleteTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHFileReplication() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String fn1 = "rep1";
        HColumnDescriptor hcd1 = new HColumnDescriptor(fn1);
        hcd1.setDFSReplication((short)1);
        String fn = "defaultRep";
        HColumnDescriptor hcd = new HColumnDescriptor(fn);
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(hcd);
        htd.addFamily(hcd1);
        Table table = TEST_UTIL.createTable((TableDescriptor)htd, (byte[][])null);
        TEST_UTIL.waitTableAvailable(tableName);
        Put p = new Put(Bytes.toBytes((String)"defaultRep_rk"));
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] v1 = Bytes.toBytes((String)"v1");
        p.addColumn(Bytes.toBytes((String)fn), q1, v1);
        ArrayList<Put> puts = new ArrayList<Put>(2);
        puts.add(p);
        p = new Put(Bytes.toBytes((String)"rep1_rk"));
        p.addColumn(Bytes.toBytes((String)fn1), q1, v1);
        puts.add(p);
        try {
            table.put(puts);
            this.admin.flush(tableName);
            List<HRegion> regions = TEST_UTIL.getMiniHBaseCluster().getRegions(tableName);
            for (HRegion r : regions) {
                HStore store = r.getStore(Bytes.toBytes((String)fn));
                for (HStoreFile sf : store.getStorefiles()) {
                    Assert.assertTrue((boolean)sf.toString().contains(fn));
                    Assert.assertTrue((String)("Column family " + fn + " should have 3 copies"), (FSUtils.getDefaultReplication((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)sf.getPath()) == sf.getFileInfo().getFileStatus().getReplication() ? 1 : 0) != 0);
                }
                store = r.getStore(Bytes.toBytes((String)fn1));
                for (HStoreFile sf : store.getStorefiles()) {
                    Assert.assertTrue((boolean)sf.toString().contains(fn1));
                    Assert.assertTrue((String)("Column family " + fn1 + " should have only 1 copy"), (1 == sf.getFileInfo().getFileStatus().getReplication() ? 1 : 0) != 0);
                }
            }
        }
        finally {
            if (this.admin.isTableEnabled(tableName)) {
                this.admin.disableTable(tableName);
                this.admin.deleteTable(tableName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HColumnDescriptor cd = new HColumnDescriptor("d");
        HTableDescriptor td = new HTableDescriptor(tableName);
        td.addFamily(cd);
        byte[][] splitRows = new byte[][]{{51}, {54}};
        try {
            TEST_UTIL.createTable((TableDescriptor)td, (byte[][])splitRows);
            TEST_UTIL.waitTableAvailable(tableName);
            List tableRegions = this.admin.getRegions(tableName);
            Assert.assertEquals((long)3L, (long)this.admin.getTableRegions(tableName).size());
            RegionInfo regionA = (RegionInfo)tableRegions.get(0);
            RegionInfo regionB = (RegionInfo)tableRegions.get(1);
            this.admin.mergeRegionsAsync(regionA.getRegionName(), regionB.getRegionName(), false).get(60L, TimeUnit.SECONDS);
            Assert.assertEquals((long)2L, (long)this.admin.getTableRegions(tableName).size());
            tableRegions = this.admin.getRegions(tableName);
            regionA = (RegionInfo)tableRegions.get(0);
            regionB = (RegionInfo)tableRegions.get(1);
            this.admin.mergeRegionsAsync(regionA.getEncodedNameAsBytes(), regionB.getEncodedNameAsBytes(), false).get(60L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)this.admin.getTableRegions(tableName).size());
        }
        finally {
            this.admin.disableTable(tableName);
            this.admin.deleteTable(tableName);
        }
    }

    @Test
    public void testSplitShouldNotHappenIfSplitIsDisabledForTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor("f"));
        htd.setRegionSplitPolicyClassName(DisabledRegionSplitPolicy.class.getName());
        Table table = TEST_UTIL.createTable((TableDescriptor)htd, (byte[][])null);
        for (int i = 0; i < 10; ++i) {
            Put p = new Put(Bytes.toBytes((String)("row" + i)));
            byte[] q1 = Bytes.toBytes((String)"q1");
            byte[] v1 = Bytes.toBytes((String)"v1");
            p.addColumn(Bytes.toBytes((String)"f"), q1, v1);
            table.put(p);
        }
        this.admin.flush(tableName);
        try {
            this.admin.split(tableName, Bytes.toBytes((String)"row5"));
            Threads.sleep((long)10000L);
        }
        catch (Exception i) {
            // empty catch block
        }
        List allRegions = MetaTableAccessor.getTableRegions((Connection)this.admin.getConnection(), (TableName)tableName, (boolean)true);
        Assert.assertEquals((long)1L, (long)allRegions.size());
    }

    @Test
    public void testCloneTableSchema() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName newTableName = TableName.valueOf((String)(tableName.getNameAsString() + "_new"));
        this.testCloneTableSchema(tableName, newTableName, false);
    }

    @Test
    public void testCloneTableSchemaPreservingSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName newTableName = TableName.valueOf((String)(tableName.getNameAsString() + "_new"));
        this.testCloneTableSchema(tableName, newTableName, true);
    }

    private void testCloneTableSchema(TableName tableName, TableName newTableName, boolean preserveSplits) throws Exception {
        byte[] FAMILY_0 = Bytes.toBytes((String)"cf0");
        byte[] FAMILY_1 = Bytes.toBytes((String)"cf1");
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((int)4), Bytes.toBytes((int)8)};
        int NUM_FAMILYS = 2;
        int NUM_REGIONS = 3;
        int BLOCK_SIZE = 1024;
        int TTL = 86400;
        boolean BLOCK_CACHE = false;
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY_0)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY_1).setBlocksize(BLOCK_SIZE).setBlockCacheEnabled(BLOCK_CACHE).setTimeToLive(TTL).build()).build();
        this.admin.createTable(tableDesc, (byte[][])splitKeys);
        Assert.assertEquals((long)NUM_REGIONS, (long)TEST_UTIL.getHBaseCluster().getRegions(tableName).size());
        Assert.assertTrue((String)"Table should be created with splitKyes + 1 rows in META", (boolean)this.admin.isTableAvailable(tableName, (byte[][])splitKeys));
        this.admin.cloneTableSchema(tableName, newTableName, preserveSplits);
        TableDescriptor newTableDesc = this.admin.getDescriptor(newTableName);
        Assert.assertEquals((long)NUM_FAMILYS, (long)newTableDesc.getColumnFamilyCount());
        Assert.assertEquals((long)BLOCK_SIZE, (long)newTableDesc.getColumnFamily(FAMILY_1).getBlocksize());
        Assert.assertEquals((Object)BLOCK_CACHE, (Object)newTableDesc.getColumnFamily(FAMILY_1).isBlockCacheEnabled());
        Assert.assertEquals((long)TTL, (long)newTableDesc.getColumnFamily(FAMILY_1).getTimeToLive());
        TEST_UTIL.verifyTableDescriptorIgnoreTableName(tableDesc, newTableDesc);
        if (preserveSplits) {
            Assert.assertEquals((long)NUM_REGIONS, (long)TEST_UTIL.getHBaseCluster().getRegions(newTableName).size());
            Assert.assertTrue((String)"New table should be created with splitKyes + 1 rows in META", (boolean)this.admin.isTableAvailable(newTableName, (byte[][])splitKeys));
        } else {
            Assert.assertEquals((long)1L, (long)TEST_UTIL.getHBaseCluster().getRegions(newTableName).size());
        }
    }

    @Test
    public void testCloneTableSchemaWithNonExistentSourceTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName newTableName = TableName.valueOf((String)(tableName.getNameAsString() + "_new"));
        try {
            this.admin.cloneTableSchema(tableName, newTableName, false);
            Assert.fail((String)"Should have failed to create a new table by cloning non-existent source table.");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testCloneTableSchemaWithExistentDestinationTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName newTableName = TableName.valueOf((String)(tableName.getNameAsString() + "_new"));
        byte[] FAMILY_0 = Bytes.toBytes((String)"cf0");
        TEST_UTIL.createTable(tableName, FAMILY_0);
        TEST_UTIL.createTable(newTableName, FAMILY_0);
        try {
            this.admin.cloneTableSchema(tableName, newTableName, false);
            Assert.fail((String)"Should have failed to create a existent table.");
        }
        catch (TableExistsException tableExistsException) {
            // empty catch block
        }
    }
}

