/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestGlobalMemStoreSize {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestGlobalMemStoreSize.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestGlobalMemStoreSize.class);
    private static int regionServerNum = 4;
    private static int regionNum = 16;
    private static int totalRegionNum = regionNum + 2;
    private HBaseTestingUtility TEST_UTIL;
    private MiniHBaseCluster cluster;
    @Rule
    public TestName name = new TestName();

    @Test
    public void testGlobalMemStore() throws Exception {
        LOG.info("Starting cluster");
        Configuration conf = HBaseConfiguration.create();
        this.TEST_UTIL = new HBaseTestingUtility(conf);
        this.TEST_UTIL.startMiniCluster(1, regionServerNum);
        this.cluster = this.TEST_UTIL.getHBaseCluster();
        LOG.info("Waiting for active/ready master");
        this.cluster.waitForActiveAndReadyMaster();
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        byte[] family = Bytes.toBytes((String)"family");
        LOG.info("Creating table with " + regionNum + " regions");
        Table ht = this.TEST_UTIL.createMultiRegionTable(table, family, regionNum);
        int numRegions = -1;
        RegionLocator r = this.TEST_UTIL.getConnection().getRegionLocator(table);
        Object object = null;
        try {
            numRegions = r.getStartKeys().length;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (r != null) {
                if (object != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    r.close();
                }
            }
        }
        Assert.assertEquals((long)regionNum, (long)numRegions);
        this.waitForAllRegionsAssigned();
        for (HRegionServer server : this.getOnlineRegionServers()) {
            long globalMemStoreSize = 0L;
            for (RegionInfo regionInfo : ProtobufUtil.getOnlineRegions(null, (AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices())) {
                globalMemStoreSize += server.getRegion(regionInfo.getEncodedName()).getMemStoreDataSize();
            }
            Assert.assertEquals((long)server.getRegionServerAccounting().getGlobalMemStoreDataSize(), (long)globalMemStoreSize);
        }
        int i = 0;
        for (HRegionServer server : this.getOnlineRegionServers()) {
            LOG.info("Starting flushes on " + server.getServerName() + ", size=" + server.getRegionServerAccounting().getGlobalMemStoreDataSize());
            for (RegionInfo regionInfo : ProtobufUtil.getOnlineRegions(null, (AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices())) {
                HRegion r2 = server.getRegion(regionInfo.getEncodedName());
                this.flush(r2, server);
            }
            LOG.info("Post flush on " + server.getServerName());
            long now = System.currentTimeMillis();
            long timeout = now + 1000L;
            while (server.getRegionServerAccounting().getGlobalMemStoreDataSize() != 0L && timeout < System.currentTimeMillis()) {
                Threads.sleep((long)10L);
            }
            long size = server.getRegionServerAccounting().getGlobalMemStoreDataSize();
            if (size > 0L) {
                for (RegionInfo regionInfo : ProtobufUtil.getOnlineRegions(null, (AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices())) {
                    HRegion r3 = server.getRegion(regionInfo.getEncodedName());
                    long l = r3.getMemStoreDataSize();
                    if (l <= 0L) continue;
                    Assert.assertTrue((boolean)regionInfo.isMetaRegion());
                    LOG.info(r3.toString() + " " + l + ", reflushing");
                    r3.flush(true);
                }
            }
            size = server.getRegionServerAccounting().getGlobalMemStoreDataSize();
            Assert.assertEquals((String)("Server=" + server.getServerName() + ", i=" + i++), (long)0L, (long)size);
        }
        ht.close();
        this.TEST_UTIL.shutdownMiniCluster();
    }

    private void flush(HRegion r, HRegionServer server) throws IOException {
        LOG.info("Flush " + r.toString() + " on " + server.getServerName() + ", " + r.flush(true) + ", size=" + server.getRegionServerAccounting().getGlobalMemStoreDataSize());
    }

    private List<HRegionServer> getOnlineRegionServers() {
        ArrayList<HRegionServer> list = new ArrayList<HRegionServer>();
        for (JVMClusterUtil.RegionServerThread rst : this.cluster.getRegionServerThreads()) {
            if (!rst.getRegionServer().isOnline()) continue;
            list.add(rst.getRegionServer());
        }
        return list;
    }

    private void waitForAllRegionsAssigned() throws IOException {
        int regionCount;
        while ((regionCount = HBaseTestingUtility.getAllOnlineRegions(this.cluster).size()) < totalRegionNum) {
            LOG.debug("Waiting for there to be " + totalRegionNum + " regions, but there are " + regionCount + " right now.");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

