/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.FSQueueMetricsForCustomResources;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

@Metrics(context="yarn")
public class FSQueueMetrics
extends QueueMetrics {
    @Metric(value={"Fair share of memory in MB"})
    MutableGaugeLong fairShareMB;
    @Metric(value={"Fair share of CPU in vcores"})
    MutableGaugeLong fairShareVCores;
    @Metric(value={"Steady fair share of memory in MB"})
    MutableGaugeLong steadyFairShareMB;
    @Metric(value={"Steady fair share of CPU in vcores"})
    MutableGaugeLong steadyFairShareVCores;
    @Metric(value={"Minimum share of memory in MB"})
    MutableGaugeLong minShareMB;
    @Metric(value={"Minimum share of CPU in vcores"})
    MutableGaugeLong minShareVCores;
    @Metric(value={"Maximum share of memory in MB"})
    MutableGaugeLong maxShareMB;
    @Metric(value={"Maximum share of CPU in vcores"})
    MutableGaugeLong maxShareVCores;
    @Metric(value={"Maximum number of applications"})
    MutableGaugeInt maxApps;
    @Metric(value={"Maximum AM share of memory in MB"})
    MutableGaugeLong maxAMShareMB;
    @Metric(value={"Maximum AM share of CPU in vcores"})
    MutableGaugeInt maxAMShareVCores;
    @Metric(value={"AM resource usage of memory in MB"})
    MutableGaugeLong amResourceUsageMB;
    @Metric(value={"AM resource usage of CPU in vcores"})
    MutableGaugeInt amResourceUsageVCores;
    private final FSQueueMetricsForCustomResources customResources = ResourceUtils.getNumberOfKnownResourceTypes() > 2 ? new FSQueueMetricsForCustomResources() : null;
    private String schedulingPolicy;

    FSQueueMetrics(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        super(ms, queueName, parent, enableUserMetrics, conf);
    }

    long getFairShareMB() {
        return this.fairShareMB.value();
    }

    long getFairShareVirtualCores() {
        return this.fairShareVCores.value();
    }

    public Resource getFairShare() {
        if (this.customResources != null) {
            return Resource.newInstance((long)this.fairShareMB.value(), (int)((int)this.fairShareVCores.value()), this.customResources.getFairShareValues());
        }
        return Resource.newInstance((long)this.fairShareMB.value(), (int)((int)this.fairShareVCores.value()));
    }

    public void setFairShare(Resource resource) {
        this.fairShareMB.set(resource.getMemorySize());
        this.fairShareVCores.set((long)resource.getVirtualCores());
        if (this.customResources != null) {
            this.customResources.setFairShare(resource);
        }
    }

    public long getSteadyFairShareMB() {
        return this.steadyFairShareMB.value();
    }

    public long getSteadyFairShareVCores() {
        return this.steadyFairShareVCores.value();
    }

    public Resource getSteadyFairShare() {
        if (this.customResources != null) {
            return Resource.newInstance((long)this.steadyFairShareMB.value(), (int)((int)this.steadyFairShareVCores.value()), this.customResources.getSteadyFairShareValues());
        }
        return Resource.newInstance((long)this.steadyFairShareMB.value(), (int)((int)this.steadyFairShareVCores.value()));
    }

    public void setSteadyFairShare(Resource resource) {
        this.steadyFairShareMB.set(resource.getMemorySize());
        this.steadyFairShareVCores.set((long)resource.getVirtualCores());
        if (this.customResources != null) {
            this.customResources.setSteadyFairShare(resource);
        }
    }

    public long getMinShareMB() {
        return this.minShareMB.value();
    }

    public long getMinShareVirtualCores() {
        return this.minShareVCores.value();
    }

    public Resource getMinShare() {
        if (this.customResources != null) {
            return Resource.newInstance((long)this.minShareMB.value(), (int)((int)this.minShareVCores.value()), this.customResources.getMinShareValues());
        }
        return Resource.newInstance((long)this.minShareMB.value(), (int)((int)this.minShareVCores.value()));
    }

    public void setMinShare(Resource resource) {
        this.minShareMB.set(resource.getMemorySize());
        this.minShareVCores.set((long)resource.getVirtualCores());
        if (this.customResources != null) {
            this.customResources.setMinShare(resource);
        }
    }

    public long getMaxShareMB() {
        return this.maxShareMB.value();
    }

    public long getMaxShareVirtualCores() {
        return this.maxShareVCores.value();
    }

    public Resource getMaxShare() {
        if (this.customResources != null) {
            return Resource.newInstance((long)this.maxShareMB.value(), (int)((int)this.maxShareVCores.value()), this.customResources.getMaxShareValues());
        }
        return Resource.newInstance((long)this.maxShareMB.value(), (int)((int)this.maxShareVCores.value()));
    }

    public void setMaxShare(Resource resource) {
        this.maxShareMB.set(resource.getMemorySize());
        this.maxShareVCores.set((long)resource.getVirtualCores());
        if (this.customResources != null) {
            this.customResources.setMaxShare(resource);
        }
    }

    public int getMaxApps() {
        return this.maxApps.value();
    }

    public void setMaxApps(int max) {
        this.maxApps.set(max);
    }

    public long getMaxAMShareMB() {
        return this.maxAMShareMB.value();
    }

    public int getMaxAMShareVCores() {
        return this.maxAMShareVCores.value();
    }

    public Resource getMaxAMShare() {
        if (this.customResources != null) {
            return Resource.newInstance((long)this.maxAMShareMB.value(), (int)this.maxAMShareVCores.value(), this.customResources.getMaxAMShareValues());
        }
        return Resource.newInstance((long)this.maxAMShareMB.value(), (int)this.maxAMShareVCores.value());
    }

    public void setMaxAMShare(Resource resource) {
        this.maxAMShareMB.set(resource.getMemorySize());
        this.maxAMShareVCores.set(resource.getVirtualCores());
        if (this.customResources != null) {
            this.customResources.setMaxAMShare(resource);
        }
    }

    public long getAMResourceUsageMB() {
        return this.amResourceUsageMB.value();
    }

    public int getAMResourceUsageVCores() {
        return this.amResourceUsageVCores.value();
    }

    public Resource getAMResourceUsage() {
        if (this.customResources != null) {
            return Resource.newInstance((long)this.amResourceUsageMB.value(), (int)this.amResourceUsageVCores.value(), this.customResources.getAMResourceUsageValues());
        }
        return Resource.newInstance((long)this.amResourceUsageMB.value(), (int)this.amResourceUsageVCores.value());
    }

    public void setAMResourceUsage(Resource resource) {
        this.amResourceUsageMB.set(resource.getMemorySize());
        this.amResourceUsageVCores.set(resource.getVirtualCores());
        if (this.customResources != null) {
            this.customResources.setAMResourceUsage(resource);
        }
    }

    @Metric(value={"Scheduling policy"})
    public String getSchedulingPolicy() {
        return this.schedulingPolicy;
    }

    public void setSchedulingPolicy(String policy) {
        this.schedulingPolicy = policy;
    }

    public static synchronized FSQueueMetrics forQueue(String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return FSQueueMetrics.forQueue(ms, queueName, parent, enableUserMetrics, conf);
    }

    @VisibleForTesting
    public static synchronized FSQueueMetrics forQueue(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics, Configuration conf) {
        QueueMetrics metrics = QueueMetrics.getQueueMetrics().get(queueName);
        if (metrics == null) {
            metrics = new FSQueueMetrics(ms, queueName, parent, enableUserMetrics, conf).tag(QUEUE_INFO, queueName);
            if (ms != null) {
                metrics = (QueueMetrics)ms.register(FSQueueMetrics.sourceName(queueName).toString(), "Metrics for queue: " + queueName, (Object)metrics);
            }
            QueueMetrics.getQueueMetrics().put(queueName, metrics);
        }
        return (FSQueueMetrics)metrics;
    }

    FSQueueMetricsForCustomResources getCustomResources() {
        return this.customResources;
    }
}

