/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementFactory;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.PreemptableResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueInvalidException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesLogger;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityDiagnosticConstant;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.AllocationState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ReservationQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.CSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.FileBasedCSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.MutableCSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.KillableContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.AssignmentInformation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerAllocationProposal;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceAllocationCommitter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.SchedulerContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeLabelsUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeResourceUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ReleaseContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSetUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.SimpleCandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.security.AppPriorityACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Evolving
public class CapacityScheduler
extends AbstractYarnScheduler<FiCaSchedulerApp, FiCaSchedulerNode>
implements PreemptableResourceScheduler,
CapacitySchedulerContext,
Configurable,
ResourceAllocationCommitter,
MutableConfScheduler {
    private static final Log LOG = LogFactory.getLog(CapacityScheduler.class);
    private CapacitySchedulerQueueManager queueManager;
    protected final long THREAD_JOIN_TIMEOUT_MS = 1000L;
    private PreemptionManager preemptionManager = new PreemptionManager();
    private volatile boolean isLazyPreemptionEnabled = false;
    private int offswitchPerHeartbeatLimit;
    private boolean assignMultipleEnabled;
    private int maxAssignPerHeartbeat;
    private CSConfigurationProvider csConfProvider;
    private CapacitySchedulerConfiguration conf;
    private Configuration yarnConf;
    private ResourceCalculator calculator;
    private boolean usePortForNodeName;
    private boolean scheduleAsynchronously;
    private List<AsyncScheduleThread> asyncSchedulerThreads;
    private ResourceCommitterService resourceCommitterService;
    private RMNodeLabelsManager labelManager;
    private AppPriorityACLsManager appPriorityACLManager;
    private static boolean printedVerboseLoggingForAsyncScheduling = false;
    private long asyncScheduleInterval;
    private static final String ASYNC_SCHEDULER_INTERVAL = "yarn.scheduler.capacity.schedule-asynchronously.scheduling-interval-ms";
    private static final long DEFAULT_ASYNC_SCHEDULER_INTERVAL = 5L;
    private static final Random random = new Random(System.currentTimeMillis());

    public void setConf(Configuration conf) {
        this.yarnConf = conf;
    }

    private void validateConf(Configuration conf) {
        int minMem = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem <= 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration, yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ", min and max should be greater than 0, max should be no smaller than min.");
        }
        int minVcores = conf.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        int maxVcores = conf.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        if (minVcores <= 0 || minVcores > maxVcores) {
            throw new YarnRuntimeException("Invalid resource scheduler vcores allocation configuration, yarn.scheduler.minimum-allocation-vcores=" + minVcores + ", " + "yarn.scheduler.maximum-allocation-vcores" + "=" + maxVcores + ", min and max should be greater than 0, max should be no smaller than min.");
        }
    }

    @Override
    public Configuration getConf() {
        return this.yarnConf;
    }

    public CapacityScheduler() {
        super(CapacityScheduler.class.getName());
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.getRootQueue().getMetrics();
    }

    public CSQueue getRootQueue() {
        return this.queueManager.getRootQueue();
    }

    @Override
    public CapacitySchedulerConfiguration getConfiguration() {
        return this.conf;
    }

    @Override
    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.rmContext.getContainerTokenSecretManager();
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return this.calculator;
    }

    @VisibleForTesting
    public void setResourceCalculator(ResourceCalculator rc) {
        this.calculator = rc;
    }

    @Override
    public int getNumClusterNodes() {
        return this.nodeTracker.nodeCount();
    }

    @Override
    public RMContext getRMContext() {
        return this.rmContext;
    }

    @Override
    public void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void initScheduler(Configuration configuration) throws IOException {
        try {
            String confProviderStr;
            this.writeLock.lock();
            switch (confProviderStr = configuration.get("yarn.scheduler.configuration.store.class", "file")) {
                case "file": {
                    this.csConfProvider = new FileBasedCSConfigurationProvider(this.rmContext);
                    break;
                }
                case "memory": 
                case "leveldb": 
                case "zk": {
                    this.csConfProvider = new MutableCSConfigurationProvider(this.rmContext);
                    break;
                }
                default: {
                    throw new IOException("Invalid configuration store class: " + confProviderStr);
                }
            }
            this.csConfProvider.init(configuration);
            this.conf = this.csConfProvider.loadConfiguration(configuration);
            this.validateConf(this.conf);
            this.minimumAllocation = super.getMinimumAllocation();
            this.initMaximumResourceCapability(super.getMaximumAllocation());
            this.calculator = this.conf.getResourceCalculator();
            this.usePortForNodeName = this.conf.getUsePortForNodeName();
            this.applications = new ConcurrentHashMap();
            this.labelManager = this.rmContext.getNodeLabelManager();
            this.appPriorityACLManager = new AppPriorityACLsManager(this.conf);
            this.queueManager = new CapacitySchedulerQueueManager(this.yarnConf, this.labelManager, this.appPriorityACLManager);
            this.queueManager.setCapacitySchedulerContext(this);
            this.activitiesManager = new ActivitiesManager(this.rmContext);
            this.activitiesManager.init(this.conf);
            this.initializeQueues(this.conf);
            this.isLazyPreemptionEnabled = this.conf.getLazyPreemptionEnabled();
            this.scheduleAsynchronously = this.conf.getScheduleAynschronously();
            this.asyncScheduleInterval = this.conf.getLong(ASYNC_SCHEDULER_INTERVAL, 5L);
            this.assignMultipleEnabled = this.conf.getAssignMultipleEnabled();
            this.maxAssignPerHeartbeat = this.conf.getMaxAssignPerHeartbeat();
            int maxAsyncSchedulingThreads = this.conf.getInt("yarn.scheduler.capacity.schedule-asynchronously.maximum-threads", 1);
            maxAsyncSchedulingThreads = Math.max(maxAsyncSchedulingThreads, 1);
            if (this.scheduleAsynchronously) {
                this.asyncSchedulerThreads = new ArrayList<AsyncScheduleThread>();
                for (int i = 0; i < maxAsyncSchedulingThreads; ++i) {
                    this.asyncSchedulerThreads.add(new AsyncScheduleThread(this));
                }
                this.resourceCommitterService = new ResourceCommitterService(this);
            }
            this.offswitchPerHeartbeatLimit = this.conf.getOffSwitchPerHeartbeatLimit();
            LOG.info((Object)("Initialized CapacityScheduler with calculator=" + this.getResourceCalculator().getClass() + ", minimumAllocation=<" + this.getMinimumResourceCapability() + ">, maximumAllocation=<" + this.getMaximumResourceCapability() + ">, asynchronousScheduling=" + this.scheduleAsynchronously + ", asyncScheduleInterval=" + this.asyncScheduleInterval + "ms"));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void startSchedulerThreads() {
        try {
            this.writeLock.lock();
            this.activitiesManager.start();
            if (this.scheduleAsynchronously) {
                Preconditions.checkNotNull(this.asyncSchedulerThreads, (Object)"asyncSchedulerThreads is null");
                for (Thread thread : this.asyncSchedulerThreads) {
                    thread.start();
                }
                this.resourceCommitterService.start();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void serviceInit(Configuration conf) throws Exception {
        Configuration configuration = new Configuration(conf);
        super.serviceInit(conf);
        this.initScheduler(configuration);
    }

    @Override
    public void serviceStart() throws Exception {
        this.startSchedulerThreads();
        super.serviceStart();
    }

    @Override
    public void serviceStop() throws Exception {
        try {
            this.writeLock.lock();
            if (this.scheduleAsynchronously && this.asyncSchedulerThreads != null) {
                for (Thread thread : this.asyncSchedulerThreads) {
                    thread.interrupt();
                    thread.join(1000L);
                }
                this.resourceCommitterService.interrupt();
                this.resourceCommitterService.join(1000L);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.isConfigurationMutable()) {
            ((MutableConfigurationProvider)((Object)this.csConfProvider)).close();
        }
        super.serviceStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize(Configuration newConf, RMContext rmContext) throws IOException {
        try {
            this.writeLock.lock();
            Configuration configuration = new Configuration(newConf);
            CapacitySchedulerConfiguration oldConf = this.conf;
            this.conf = this.csConfProvider.loadConfiguration(configuration);
            this.validateConf(this.conf);
            try {
                LOG.info((Object)"Re-initializing queues...");
                this.refreshMaximumAllocation(ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)this.conf));
                this.reinitializeQueues(this.conf);
            }
            catch (Throwable t) {
                this.conf = oldConf;
                this.refreshMaximumAllocation(ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)this.conf));
                throw new IOException("Failed to re-init queues : " + t.getMessage(), t);
            }
            this.isLazyPreemptionEnabled = this.conf.getLazyPreemptionEnabled();
            this.offswitchPerHeartbeatLimit = this.conf.getOffSwitchPerHeartbeatLimit();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    long getAsyncScheduleInterval() {
        return this.asyncScheduleInterval;
    }

    private static boolean shouldSkipNodeSchedule(FiCaSchedulerNode node, CapacityScheduler cs, boolean printVerboseLog) {
        long timeElapsedFromLastHeartbeat = Time.monotonicNow() - node.getLastHeartbeatMonotonicTime();
        if (timeElapsedFromLastHeartbeat > cs.nmHeartbeatInterval * 2L) {
            if (printVerboseLog && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skip scheduling on node because it haven't heartbeated for " + (float)timeElapsedFromLastHeartbeat / 1000.0f + " secs"));
            }
            return true;
        }
        return false;
    }

    static void schedule(CapacityScheduler cs) throws InterruptedException {
        int current = 0;
        List nodes = cs.nodeTracker.getAllNodes();
        int start = random.nextInt(nodes.size());
        boolean printSkipedNodeLogging = false;
        if (Time.monotonicNow() / 1000L % 10L == 0L) {
            printSkipedNodeLogging = !printedVerboseLoggingForAsyncScheduling;
        } else {
            printedVerboseLoggingForAsyncScheduling = false;
        }
        for (FiCaSchedulerNode node : nodes) {
            if (current++ < start || CapacityScheduler.shouldSkipNodeSchedule(node, cs, printSkipedNodeLogging)) continue;
            cs.allocateContainersToNode(node.getNodeID(), false);
        }
        current = 0;
        for (FiCaSchedulerNode node : nodes) {
            if (current++ > start) break;
            if (CapacityScheduler.shouldSkipNodeSchedule(node, cs, printSkipedNodeLogging)) continue;
            cs.allocateContainersToNode(node.getNodeID(), false);
        }
        if (printSkipedNodeLogging) {
            printedVerboseLoggingForAsyncScheduling = true;
        }
        Thread.sleep(cs.getAsyncScheduleInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public UserGroupMappingPlacementRule getUserGroupMappingPlacementRule() throws IOException {
        try {
            this.readLock.lock();
            boolean overrideWithQueueMappings = this.conf.getOverrideWithQueueMappings();
            LOG.info((Object)("Initialized queue mappings, override: " + overrideWithQueueMappings));
            List<UserGroupMappingPlacementRule.QueueMapping> newMappings = this.conf.getQueueMappings();
            for (UserGroupMappingPlacementRule.QueueMapping mapping : newMappings) {
                CSQueue queue;
                String mappingQueue = mapping.getQueue();
                if (mappingQueue.equals("%user") || mappingQueue.equals("%primary_group") || (queue = this.getQueue(mappingQueue)) != null && queue instanceof LeafQueue) continue;
                throw new IOException("mapping contains invalid or non-leaf queue " + mappingQueue);
            }
            if (newMappings.size() > 0) {
                Groups groups = new Groups((Configuration)this.conf);
                UserGroupMappingPlacementRule userGroupMappingPlacementRule = new UserGroupMappingPlacementRule(overrideWithQueueMappings, newMappings, groups);
                return userGroupMappingPlacementRule;
            }
            Iterator<UserGroupMappingPlacementRule.QueueMapping> iterator = null;
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void updatePlacementRules() throws IOException {
        Collection placementRuleStrs = this.conf.getStringCollection("yarn.scheduler.queue-placement-rules");
        ArrayList<PlacementRule> placementRules = new ArrayList<PlacementRule>();
        if (placementRuleStrs.isEmpty()) {
            UserGroupMappingPlacementRule ugRule = this.getUserGroupMappingPlacementRule();
            if (null != ugRule) {
                placementRules.add(ugRule);
            }
        } else {
            Iterator iterator = placementRuleStrs.iterator();
            block8: while (iterator.hasNext()) {
                String placementRuleStr;
                switch (placementRuleStr = (String)iterator.next()) {
                    case "user-group": {
                        UserGroupMappingPlacementRule ugRule = this.getUserGroupMappingPlacementRule();
                        if (null == ugRule) continue block8;
                        placementRules.add(ugRule);
                        continue block8;
                    }
                }
                try {
                    PlacementRule rule = PlacementFactory.getPlacementRule(placementRuleStr, this.conf);
                    if (null == rule) continue;
                    placementRules.add(rule);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IOException(cnfe);
                }
            }
        }
        this.rmContext.getQueuePlacementManager().updateRules(placementRules);
    }

    @Lock(value={CapacityScheduler.class})
    private void initializeQueues(CapacitySchedulerConfiguration conf) throws IOException {
        this.queueManager.initializeQueues(conf);
        this.updatePlacementRules();
        this.preemptionManager.refreshQueues(null, this.getRootQueue());
    }

    @Lock(value={CapacityScheduler.class})
    private void reinitializeQueues(CapacitySchedulerConfiguration newConf) throws IOException {
        this.queueManager.reinitializeQueues(newConf);
        this.updatePlacementRules();
        this.preemptionManager.refreshQueues(null, this.getRootQueue());
    }

    @Override
    public CSQueue getQueue(String queueName) {
        if (queueName == null) {
            return null;
        }
        return this.queueManager.getQueue(queueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addApplicationOnRecovery(ApplicationId applicationId, String queueName, String user, Priority priority) {
        try {
            this.writeLock.lock();
            CSQueue queue = this.getQueue(queueName);
            if (queue == null) {
                if (!YarnConfiguration.shouldRMFailFast((Configuration)this.getConfig())) {
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.KILL, "Application killed on recovery as it was submitted to queue " + queueName + " which no longer exists after restart."));
                    return;
                }
                String queueErrorMsg = "Queue named " + queueName + " missing during application recovery. Queue removal during recovery is not presently supported by the capacity scheduler, please restart with all queues configured which were present before shutdown/restart.";
                LOG.fatal((Object)queueErrorMsg);
                throw new QueueInvalidException(queueErrorMsg);
            }
            if (!(queue instanceof LeafQueue)) {
                if (!YarnConfiguration.shouldRMFailFast((Configuration)this.getConfig())) {
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.KILL, "Application killed on recovery as it was submitted to queue " + queueName + " which is no longer a leaf queue after restart."));
                    return;
                }
                String queueErrorMsg = "Queue named " + queueName + " is no longer a leaf queue during application recovery. Changing a leaf queue to a parent queue during recovery is not presently supported by the capacity scheduler. Please restart with leaf queues before shutdown/restart continuing as leaf queues.";
                LOG.fatal((Object)queueErrorMsg);
                throw new QueueInvalidException(queueErrorMsg);
            }
            try {
                queue.submitApplication(applicationId, user, queueName);
            }
            catch (AccessControlException queueErrorMsg) {
                // empty catch block
            }
            queue.getMetrics().submitApp(user);
            SchedulerApplication application = new SchedulerApplication(queue, user, priority);
            this.applications.put(applicationId, application);
            LOG.info((Object)("Accepted application " + applicationId + " from user: " + user + ", in queue: " + queueName));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(applicationId + " is recovering. Skip notifying APP_ACCEPTED"));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addApplication(ApplicationId applicationId, String queueName, String user, Priority priority) {
        try {
            this.writeLock.lock();
            if (this.isSystemAppsLimitReached()) {
                String message = "Maximum system application limit reached,cannot accept submission of application: " + applicationId;
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                return;
            }
            CSQueue queue = this.getQueue(queueName);
            if (queue == null) {
                String message = "Application " + applicationId + " submitted by user " + user + " to unknown queue: " + queueName;
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                return;
            }
            if (!(queue instanceof LeafQueue)) {
                String message = "Application " + applicationId + " submitted by user " + user + " to non-leaf queue: " + queueName;
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                return;
            }
            try {
                queue.submitApplication(applicationId, user, queueName);
            }
            catch (AccessControlException ace) {
                LOG.info((Object)("Failed to submit application " + applicationId + " to queue " + queueName + " from user " + user), (Throwable)ace);
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, ace.toString()));
                this.writeLock.unlock();
                return;
            }
            queue.getMetrics().submitApp(user);
            SchedulerApplication application = new SchedulerApplication(queue, user, priority);
            this.applications.put(applicationId, application);
            LOG.info((Object)("Accepted application " + applicationId + " from user: " + user + ", in queue: " + queueName));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_ACCEPTED));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addApplicationAttempt(ApplicationAttemptId applicationAttemptId, boolean transferStateFromPreviousAttempt, boolean isAttemptRecovering) {
        try {
            this.writeLock.lock();
            SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
            if (application == null) {
                LOG.warn((Object)("Application " + applicationAttemptId.getApplicationId() + " cannot be found in scheduler."));
                return;
            }
            CSQueue queue = (CSQueue)application.getQueue();
            FiCaSchedulerApp attempt = new FiCaSchedulerApp(applicationAttemptId, application.getUser(), queue, queue.getAbstractUsersManager(), this.rmContext, application.getPriority(), isAttemptRecovering, this.activitiesManager);
            if (transferStateFromPreviousAttempt) {
                attempt.transferStateFromPreviousAttempt((SchedulerApplicationAttempt)application.getCurrentAppAttempt());
            }
            application.setCurrentAppAttempt(attempt);
            attempt.setPriority(application.getPriority());
            queue.submitApplicationAttempt(attempt, application.getUser());
            LOG.info((Object)("Added Application Attempt " + applicationAttemptId + " to scheduler from user " + application.getUser() + " in queue " + queue.getQueueName()));
            if (isAttemptRecovering) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(applicationAttemptId + " is recovering. Skipping notifying ATTEMPT_ADDED"));
                }
            } else {
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(applicationAttemptId, RMAppAttemptEventType.ATTEMPT_ADDED));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneApplication(ApplicationId applicationId, RMAppState finalState) {
        try {
            this.writeLock.lock();
            SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationId);
            if (application == null) {
                LOG.warn((Object)("Couldn't find application " + applicationId));
                return;
            }
            CSQueue queue = (CSQueue)application.getQueue();
            if (!(queue instanceof LeafQueue)) {
                LOG.error((Object)("Cannot finish application from non-leaf queue: " + queue.getQueueName()));
            } else {
                queue.finishApplication(applicationId, application.getUser());
            }
            application.stop(finalState);
            this.applications.remove(applicationId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneApplicationAttempt(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState, boolean keepContainers) {
        try {
            this.writeLock.lock();
            LOG.info((Object)("Application Attempt " + applicationAttemptId + " is done. finalState=" + (Object)((Object)rmAppAttemptFinalState)));
            FiCaSchedulerApp attempt = this.getApplicationAttempt(applicationAttemptId);
            SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
            if (application == null || attempt == null) {
                LOG.info((Object)("Unknown application " + applicationAttemptId + " has completed!"));
                return;
            }
            for (RMContainer rmContainer : attempt.getLiveContainers()) {
                if (keepContainers && rmContainer.getState().equals((Object)RMContainerState.RUNNING)) {
                    LOG.info((Object)("Skip killing " + rmContainer.getContainerId()));
                    continue;
                }
                super.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
            }
            for (RMContainer rmContainer : attempt.getReservedContainers()) {
                super.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Application Complete"), RMContainerEventType.KILL);
            }
            attempt.stop(rmAppAttemptFinalState);
            String queueName = attempt.getQueue().getQueueName();
            CSQueue queue = this.getQueue(queueName);
            if (!(queue instanceof LeafQueue)) {
                LOG.error((Object)("Cannot finish application from non-leaf queue: " + queueName));
            } else {
                queue.finishApplicationAttempt(attempt, queue.getQueueName());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Lock(value={Lock.NoLock.class})
    public Allocation allocate(ApplicationAttemptId applicationAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals, ContainerUpdates updateRequests) {
        Allocation allocation;
        FiCaSchedulerApp application = this.getApplicationAttempt(applicationAttemptId);
        if (application == null) {
            LOG.error((Object)("Calling allocate on removed or non existent application " + applicationAttemptId.getApplicationId()));
            return EMPTY_ALLOCATION;
        }
        if (!application.getApplicationAttemptId().equals((Object)applicationAttemptId)) {
            LOG.error((Object)("Calling allocate on previous or removed or non existent application attempt " + applicationAttemptId));
            return EMPTY_ALLOCATION;
        }
        this.handleContainerUpdates(application, updateRequests);
        this.releaseContainers(release, application);
        LeafQueue updateDemandForQueue = null;
        this.normalizeRequests(ask);
        try {
            application.getWriteLock().lock();
            if (application.isStopped()) {
                Allocation allocation2 = EMPTY_ALLOCATION;
                return allocation2;
            }
            if (!ask.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("allocate: pre-update " + applicationAttemptId + " ask size =" + ask.size()));
                    application.showRequests();
                }
                if (application.updateResourceRequests(ask)) {
                    updateDemandForQueue = (LeafQueue)application.getQueue();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"allocate: post-update");
                    application.showRequests();
                }
            }
            application.updateBlacklist(blacklistAdditions, blacklistRemovals);
            allocation = application.getAllocation(this.getResourceCalculator(), this.getClusterResource(), this.getMinimumResourceCapability());
        }
        finally {
            application.getWriteLock().unlock();
        }
        if (updateDemandForQueue != null && !application.isWaitingForAMContainer()) {
            updateDemandForQueue.getOrderingPolicy().demandUpdated(application);
        }
        return allocation;
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) throws IOException {
        CSQueue queue = null;
        queue = this.getQueue(queueName);
        if (queue == null) {
            throw new IOException("Unknown queue: " + queueName);
        }
        return queue.getQueueInfo(includeChildQueues, recursive);
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        UserGroupInformation user = null;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            return new ArrayList<QueueUserACLInfo>();
        }
        return this.getRootQueue().getQueueUserAclInfo(user);
    }

    @Override
    protected void nodeUpdate(RMNode rmNode) {
        try {
            this.readLock.lock();
            this.setLastNodeUpdateTime(Time.now());
            super.nodeUpdate(rmNode);
        }
        finally {
            this.readLock.unlock();
        }
        if (!this.scheduleAsynchronously) {
            try {
                this.writeLock.lock();
                ActivitiesLogger.NODE.startNodeUpdateRecording(this.activitiesManager, rmNode.getNodeID());
                this.updateSchedulerHealth(this.lastNodeUpdateTime, rmNode.getNodeID(), CSAssignment.NULL_ASSIGNMENT);
                this.allocateContainersToNode(rmNode.getNodeID(), true);
                ActivitiesLogger.NODE.finishNodeUpdateRecording(this.activitiesManager, rmNode.getNodeID());
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodeAndQueueResource(RMNode nm, ResourceOption resourceOption) {
        try {
            this.writeLock.lock();
            this.updateNodeResource(nm, resourceOption);
            Resource clusterResource = this.getClusterResource();
            this.getRootQueue().updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateLabelsOnNode(NodeId nodeId, Set<String> newLabels) {
        FiCaSchedulerNode node = (FiCaSchedulerNode)this.nodeTracker.getNode(nodeId);
        if (null == node) {
            return;
        }
        String newPartition = newLabels.isEmpty() ? "" : newLabels.iterator().next();
        String oldPartition = node.getPartition();
        for (RMContainer rmContainer : node.getCopiedListOfRunningContainers()) {
            FiCaSchedulerApp application = this.getApplicationAttempt(rmContainer.getApplicationAttemptId());
            if (null != application) {
                application.nodePartitionUpdated(rmContainer, oldPartition, newPartition);
                continue;
            }
            LOG.warn((Object)("There's something wrong, some RMContainers running on a node, but we cannot find SchedulerApplicationAttempt for it. Node=" + node.getNodeID() + " applicationAttemptId=" + rmContainer.getApplicationAttemptId()));
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (null != reservedContainer) {
            this.killReservedContainer(reservedContainer);
        }
        node.updateLabels(newLabels);
    }

    private void updateSchedulerHealth(long now, NodeId nodeId, CSAssignment assignment) {
        List<AssignmentInformation.AssignmentDetails> allocations = assignment.getAssignmentInformation().getAllocationDetails();
        List<AssignmentInformation.AssignmentDetails> reservations = assignment.getAssignmentInformation().getReservationDetails();
        if (!allocations.isEmpty()) {
            ContainerId allocatedContainerId = allocations.get((int)(allocations.size() - 1)).containerId;
            String allocatedQueue = allocations.get((int)(allocations.size() - 1)).queue;
            this.schedulerHealth.updateAllocation(now, nodeId, allocatedContainerId, allocatedQueue);
        }
        if (!reservations.isEmpty()) {
            ContainerId reservedContainerId = reservations.get((int)(reservations.size() - 1)).containerId;
            String reservedQueue = reservations.get((int)(reservations.size() - 1)).queue;
            this.schedulerHealth.updateReservation(now, nodeId, reservedContainerId, reservedQueue);
        }
        this.schedulerHealth.updateSchedulerReservationCounts(assignment.getAssignmentInformation().getNumReservations());
        this.schedulerHealth.updateSchedulerAllocationCounts(assignment.getAssignmentInformation().getNumAllocations());
        this.schedulerHealth.updateSchedulerRunDetails(now, assignment.getAssignmentInformation().getAllocated(), assignment.getAssignmentInformation().getReserved());
    }

    private boolean canAllocateMore(CSAssignment assignment, int offswitchCount, int assignedContainers) {
        if (assignment == null || Resources.equals((Resource)assignment.getResource(), (Resource)Resources.none())) {
            return false;
        }
        if (offswitchCount >= this.offswitchPerHeartbeatLimit) {
            return false;
        }
        if (assignment.getAssignmentInformation().getNumReservations() > 0) {
            return false;
        }
        return this.assignMultipleEnabled && (this.maxAssignPerHeartbeat == -1 || assignedContainers < this.maxAssignPerHeartbeat);
    }

    private void allocateContainersToNode(NodeId nodeId, boolean withNodeHeartbeat) {
        FiCaSchedulerNode node = this.getNode(nodeId);
        if (null != node) {
            int offswitchCount = 0;
            int assignedContainers = 0;
            SimpleCandidateNodeSet<FiCaSchedulerNode> candidates = new SimpleCandidateNodeSet<FiCaSchedulerNode>(node);
            CSAssignment assignment = this.allocateContainersToNode(candidates, withNodeHeartbeat);
            if (null != assignment && withNodeHeartbeat) {
                if (assignment.getType() == NodeType.OFF_SWITCH) {
                    ++offswitchCount;
                }
                if (Resources.greaterThan((ResourceCalculator)this.calculator, (Resource)this.getClusterResource(), (Resource)assignment.getResource(), (Resource)Resources.none())) {
                    ++assignedContainers;
                }
                while (this.canAllocateMore(assignment, offswitchCount, assignedContainers)) {
                    assignment = this.allocateContainersToNode(candidates, true);
                    if (null != assignment && assignment.getType() == NodeType.OFF_SWITCH) {
                        ++offswitchCount;
                    }
                    if (null == assignment || !Resources.greaterThan((ResourceCalculator)this.calculator, (Resource)this.getClusterResource(), (Resource)assignment.getResource(), (Resource)Resources.none())) continue;
                    ++assignedContainers;
                }
                if (offswitchCount >= this.offswitchPerHeartbeatLimit && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Assigned maximum number of off-switch containers: " + offswitchCount + ", assignments so far: " + assignment));
                }
            }
        }
    }

    private CSAssignment allocateContainerOnSingleNode(CandidateNodeSet<FiCaSchedulerNode> candidates, FiCaSchedulerNode node, boolean withNodeHeartbeat) {
        if (this.getNode(node.getNodeID()) != node) {
            LOG.error((Object)"Trying to schedule on a removed node, please double check.");
            return null;
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            FiCaSchedulerApp reservedApplication = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(reservedContainer.getContainerId());
            if (reservedApplication == null) {
                LOG.error((Object)"Trying to schedule for a finished app, please double check.");
                return null;
            }
            LOG.info((Object)("Trying to fulfill reservation for application " + reservedApplication.getApplicationId() + " on node: " + node.getNodeID()));
            LeafQueue queue = (LeafQueue)reservedApplication.getQueue();
            CSAssignment assignment = queue.assignContainers(this.getClusterResource(), candidates, new ResourceLimits(this.labelManager.getResourceByLabel("", this.getClusterResource())), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
            if (assignment.isFulfilledReservation()) {
                if (withNodeHeartbeat) {
                    this.updateSchedulerHealth(this.lastNodeUpdateTime, node.getNodeID(), assignment);
                }
                this.schedulerHealth.updateSchedulerFulfilledReservationCounts(1L);
                ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, queue.getParent().getQueueName(), queue.getQueueName(), ActivityState.ACCEPTED, ActivityDiagnosticConstant.EMPTY);
                ActivitiesLogger.NODE.finishAllocatedNodeAllocation(this.activitiesManager, node, reservedContainer.getContainerId(), AllocationState.ALLOCATED_FROM_RESERVED);
            } else {
                ActivitiesLogger.QUEUE.recordQueueActivity(this.activitiesManager, node, queue.getParent().getQueueName(), queue.getQueueName(), ActivityState.ACCEPTED, ActivityDiagnosticConstant.EMPTY);
                ActivitiesLogger.NODE.finishAllocatedNodeAllocation(this.activitiesManager, node, reservedContainer.getContainerId(), AllocationState.SKIPPED);
            }
            assignment.setSchedulingMode(SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
            this.submitResourceCommitRequest(this.getClusterResource(), assignment);
        }
        if (node.getReservedContainer() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skipping scheduling since node " + node.getNodeID() + " is reserved by application " + node.getReservedContainer().getContainerId().getApplicationAttemptId()));
            }
            return null;
        }
        if (this.calculator.computeAvailableContainers(Resources.add((Resource)node.getUnallocatedResource(), (Resource)node.getTotalKillableResources()), this.minimumAllocation) <= 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"This node or this node partition doesn't have available orkillable resource");
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to schedule on node: " + node.getNodeName() + ", available: " + node.getUnallocatedResource()));
        }
        return this.allocateOrReserveNewContainers(candidates, withNodeHeartbeat);
    }

    private CSAssignment allocateOrReserveNewContainers(CandidateNodeSet<FiCaSchedulerNode> candidates, boolean withNodeHeartbeat) {
        CSAssignment assignment = this.getRootQueue().assignContainers(this.getClusterResource(), candidates, new ResourceLimits(this.labelManager.getResourceByLabel(candidates.getPartition(), this.getClusterResource())), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        assignment.setSchedulingMode(SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.submitResourceCommitRequest(this.getClusterResource(), assignment);
        if (Resources.greaterThan((ResourceCalculator)this.calculator, (Resource)this.getClusterResource(), (Resource)assignment.getResource(), (Resource)Resources.none())) {
            if (withNodeHeartbeat) {
                this.updateSchedulerHealth(this.lastNodeUpdateTime, CandidateNodeSetUtils.getSingleNode(candidates).getNodeID(), assignment);
            }
            return assignment;
        }
        if (StringUtils.equals((String)candidates.getPartition(), (String)"")) {
            return null;
        }
        try {
            if (this.rmContext.getNodeLabelManager().isExclusiveNodeLabel(candidates.getPartition())) {
                return null;
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Exception when trying to get exclusivity of node label=" + candidates.getPartition()), (Throwable)e);
            return null;
        }
        assignment = this.getRootQueue().assignContainers(this.getClusterResource(), candidates, new ResourceLimits(this.labelManager.getResourceByLabel("", this.getClusterResource())), SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY);
        assignment.setSchedulingMode(SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY);
        this.submitResourceCommitRequest(this.getClusterResource(), assignment);
        return assignment;
    }

    private CSAssignment allocateContainersOnMultiNodes(CandidateNodeSet<FiCaSchedulerNode> candidates) {
        if (this.getRootQueue().getQueueCapacities().getUsedCapacity(candidates.getPartition()) >= 1.0f && this.preemptionManager.getKillableResource("root", candidates.getPartition()) == Resources.none()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"This node or this node partition doesn't have available orkillable resource");
            }
            return null;
        }
        return this.allocateOrReserveNewContainers(candidates, false);
    }

    @VisibleForTesting
    CSAssignment allocateContainersToNode(CandidateNodeSet<FiCaSchedulerNode> candidates, boolean withNodeHeartbeat) {
        if (this.rmContext.isWorkPreservingRecoveryEnabled() && !this.rmContext.isSchedulerReadyForAllocatingContainers()) {
            return null;
        }
        FiCaSchedulerNode node = CandidateNodeSetUtils.getSingleNode(candidates);
        if (null != node) {
            return this.allocateContainerOnSingleNode(candidates, node, withNodeHeartbeat);
        }
        return this.allocateContainersOnMultiNodes(candidates);
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                this.recoverContainersOnNode(nodeAddedEvent.getContainerReports(), nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_RESOURCE_UPDATE: {
                NodeResourceUpdateSchedulerEvent nodeResourceUpdatedEvent = (NodeResourceUpdateSchedulerEvent)event;
                this.updateNodeAndQueueResource(nodeResourceUpdatedEvent.getRMNode(), nodeResourceUpdatedEvent.getResourceOption());
                break;
            }
            case NODE_LABELS_UPDATE: {
                NodeLabelsUpdateSchedulerEvent labelUpdateEvent = (NodeLabelsUpdateSchedulerEvent)event;
                this.updateNodeLabelsAndQueueResource(labelUpdateEvent);
                break;
            }
            case NODE_UPDATE: {
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode());
                break;
            }
            case APP_ADDED: {
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                String queueName = this.resolveReservationQueueName(appAddedEvent.getQueue(), appAddedEvent.getApplicationId(), appAddedEvent.getReservationID(), appAddedEvent.getIsAppRecovering());
                if (queueName == null) break;
                if (!appAddedEvent.getIsAppRecovering()) {
                    this.addApplication(appAddedEvent.getApplicationId(), queueName, appAddedEvent.getUser(), appAddedEvent.getApplicatonPriority());
                    break;
                }
                this.addApplicationOnRecovery(appAddedEvent.getApplicationId(), queueName, appAddedEvent.getUser(), appAddedEvent.getApplicatonPriority());
                break;
            }
            case APP_REMOVED: {
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.doneApplication(appRemovedEvent.getApplicationID(), appRemovedEvent.getFinalState());
                break;
            }
            case APP_ATTEMPT_ADDED: {
                AppAttemptAddedSchedulerEvent appAttemptAddedEvent = (AppAttemptAddedSchedulerEvent)event;
                this.addApplicationAttempt(appAttemptAddedEvent.getApplicationAttemptId(), appAttemptAddedEvent.getTransferStateFromPreviousAttempt(), appAttemptAddedEvent.getIsAttemptRecovering());
                break;
            }
            case APP_ATTEMPT_REMOVED: {
                AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = (AppAttemptRemovedSchedulerEvent)event;
                this.doneApplicationAttempt(appAttemptRemovedEvent.getApplicationAttemptID(), appAttemptRemovedEvent.getFinalAttemptState(), appAttemptRemovedEvent.getKeepContainersAcrossAppAttempts());
                break;
            }
            case CONTAINER_EXPIRED: {
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerId = containerExpiredEvent.getContainerId();
                if (containerExpiredEvent.isIncrease()) {
                    this.rollbackContainerUpdate(containerId);
                    break;
                }
                this.completedContainer(this.getRMContainer(containerId), SchedulerUtils.createAbnormalContainerStatus(containerId, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            case RELEASE_CONTAINER: {
                RMContainer container = ((ReleaseContainerEvent)event).getContainer();
                this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released by application"), RMContainerEventType.RELEASED);
                break;
            }
            case KILL_RESERVED_CONTAINER: {
                ContainerPreemptEvent killReservedContainerEvent = (ContainerPreemptEvent)event;
                RMContainer container = killReservedContainerEvent.getContainer();
                this.killReservedContainer(container);
                break;
            }
            case MARK_CONTAINER_FOR_PREEMPTION: {
                ContainerPreemptEvent preemptContainerEvent = (ContainerPreemptEvent)event;
                ApplicationAttemptId aid = preemptContainerEvent.getAppId();
                RMContainer containerToBePreempted = preemptContainerEvent.getContainer();
                this.markContainerForPreemption(aid, containerToBePreempted);
                break;
            }
            case MARK_CONTAINER_FOR_KILLABLE: {
                ContainerPreemptEvent containerKillableEvent = (ContainerPreemptEvent)event;
                RMContainer killableContainer = containerKillableEvent.getContainer();
                this.markContainerForKillable(killableContainer);
                break;
            }
            case MARK_CONTAINER_FOR_NONKILLABLE: {
                if (!this.isLazyPreemptionEnabled) break;
                ContainerPreemptEvent cancelKillContainerEvent = (ContainerPreemptEvent)event;
                this.markContainerForNonKillable(cancelKillContainerEvent.getContainer());
                break;
            }
            default: {
                LOG.error((Object)("Invalid eventtype " + event.getType() + ". Ignoring!"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodeLabelsAndQueueResource(NodeLabelsUpdateSchedulerEvent labelUpdateEvent) {
        try {
            this.writeLock.lock();
            for (Map.Entry<NodeId, Set<String>> entry : labelUpdateEvent.getUpdatedNodeToLabels().entrySet()) {
                NodeId id = entry.getKey();
                Set<String> labels = entry.getValue();
                this.updateLabelsOnNode(id, labels);
            }
            Resource clusterResource = this.getClusterResource();
            this.getRootQueue().updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNode(RMNode nodeManager) {
        try {
            this.writeLock.lock();
            FiCaSchedulerNode schedulerNode = new FiCaSchedulerNode(nodeManager, this.usePortForNodeName, nodeManager.getNodeLabels());
            this.nodeTracker.addNode(schedulerNode);
            if (this.labelManager != null) {
                this.labelManager.activateNode(nodeManager.getNodeID(), schedulerNode.getTotalResource());
            }
            Resource clusterResource = this.getClusterResource();
            this.getRootQueue().updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
            LOG.info((Object)("Added node " + nodeManager.getNodeAddress() + " clusterResource: " + clusterResource));
            if (this.scheduleAsynchronously && this.getNumClusterNodes() == 1) {
                for (AsyncScheduleThread t : this.asyncSchedulerThreads) {
                    t.beginSchedule();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode(RMNode nodeInfo) {
        try {
            NodeId nodeId;
            FiCaSchedulerNode node;
            this.writeLock.lock();
            if (this.labelManager != null) {
                this.labelManager.deactivateNode(nodeInfo.getNodeID());
            }
            if ((node = (FiCaSchedulerNode)this.nodeTracker.getNode(nodeId = nodeInfo.getNodeID())) == null) {
                LOG.error((Object)("Attempting to remove non-existent node " + nodeId));
                return;
            }
            List<RMContainer> runningContainers = node.getCopiedListOfRunningContainers();
            for (RMContainer container : runningContainers) {
                super.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
            }
            RMContainer reservedContainer = node.getReservedContainer();
            if (reservedContainer != null) {
                super.completedContainer(reservedContainer, SchedulerUtils.createAbnormalContainerStatus(reservedContainer.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
            }
            this.nodeTracker.removeNode(nodeId);
            Resource clusterResource = this.getClusterResource();
            this.getRootQueue().updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
            int numNodes = this.nodeTracker.nodeCount();
            if (this.scheduleAsynchronously && numNodes == 0) {
                for (AsyncScheduleThread t : this.asyncSchedulerThreads) {
                    t.suspendSchedule();
                }
            }
            LOG.info((Object)("Removed node " + nodeInfo.getNodeAddress() + " clusterResource: " + this.getClusterResource()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    protected void completedContainerInternal(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        Container container = rmContainer.getContainer();
        ContainerId containerId = container.getId();
        FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(container.getId());
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        if (application == null) {
            LOG.info((Object)("Container " + container + " of finished application " + appId + " completed with event " + (Object)((Object)event)));
            return;
        }
        FiCaSchedulerNode node = this.getNode(container.getNodeId());
        if (null == node) {
            LOG.info((Object)("Container " + container + " of removed node " + container.getNodeId() + " completed with event " + (Object)((Object)event)));
            return;
        }
        LeafQueue queue = (LeafQueue)application.getQueue();
        queue.completedContainer(this.getClusterResource(), application, node, rmContainer, containerStatus, event, null, true);
        if (-102 == containerStatus.getExitStatus()) {
            this.updateQueuePreemptionMetrics(queue, rmContainer);
        }
    }

    private void updateQueuePreemptionMetrics(CSQueue queue, RMContainer rmc) {
        QueueMetrics qMetrics = queue.getMetrics();
        long usedMillis = rmc.getFinishTime() - rmc.getCreationTime();
        long usedSeconds = usedMillis / 1000L;
        Resource containerResource = rmc.getAllocatedResource();
        qMetrics.preemptContainer();
        long mbSeconds = containerResource.getMemorySize() * usedMillis / 1000L;
        long vcSeconds = (long)containerResource.getVirtualCores() * usedMillis / 1000L;
        qMetrics.updatePreemptedMemoryMBSeconds(mbSeconds);
        qMetrics.updatePreemptedVcoreSeconds(vcSeconds);
        qMetrics.updatePreemptedSecondsForCustomResources(containerResource, usedSeconds);
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    @VisibleForTesting
    public FiCaSchedulerApp getApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
        return (FiCaSchedulerApp)super.getApplicationAttempt(applicationAttemptId);
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public FiCaSchedulerNode getNode(NodeId nodeId) {
        return (FiCaSchedulerNode)this.nodeTracker.getNode(nodeId);
    }

    @Lock(value={Lock.NoLock.class})
    public List<FiCaSchedulerNode> getAllNodes() {
        return this.nodeTracker.getAllNodes();
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public void recover(RMStateStore.RMState state) throws Exception {
    }

    @Override
    public void killReservedContainer(RMContainer container) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)((Object)((Object)SchedulerEventType.KILL_RESERVED_CONTAINER) + ":" + container.toString()));
        }
        super.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container reservation no longer required."), RMContainerEventType.KILL);
    }

    @Override
    public void markContainerForPreemption(ApplicationAttemptId aid, RMContainer cont) {
        FiCaSchedulerApp app;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)((Object)((Object)SchedulerEventType.MARK_CONTAINER_FOR_PREEMPTION) + ": appAttempt:" + aid.toString() + " container: " + cont.toString()));
        }
        if ((app = this.getApplicationAttempt(aid)) != null) {
            app.markContainerForPreemption(cont.getContainerId());
        }
    }

    @Override
    @VisibleForTesting
    public void killContainer(RMContainer container) {
        this.markContainerForKillable(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markContainerForKillable(RMContainer killableContainer) {
        try {
            this.writeLock.lock();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)((Object)((Object)SchedulerEventType.MARK_CONTAINER_FOR_KILLABLE) + ": container" + killableContainer.toString()));
            }
            if (!this.isLazyPreemptionEnabled) {
                super.completedContainer(killableContainer, SchedulerUtils.createPreemptedContainerStatus(killableContainer.getContainerId(), "Container preempted by scheduler"), RMContainerEventType.KILL);
            } else {
                FiCaSchedulerNode node = (FiCaSchedulerNode)this.getSchedulerNode(killableContainer.getAllocatedNode());
                FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(killableContainer.getContainerId());
                node.markContainerToKillable(killableContainer.getContainerId());
                if (null != application) {
                    String leafQueueName = application.getCSLeafQueue().getQueueName();
                    this.getPreemptionManager().addKillableContainer(new KillableContainer(killableContainer, node.getPartition(), leafQueueName));
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markContainerForNonKillable(RMContainer nonKillableContainer) {
        try {
            this.writeLock.lock();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)((Object)((Object)SchedulerEventType.MARK_CONTAINER_FOR_NONKILLABLE) + ": container" + nonKillableContainer.toString()));
            }
            FiCaSchedulerNode node = (FiCaSchedulerNode)this.getSchedulerNode(nonKillableContainer.getAllocatedNode());
            FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(nonKillableContainer.getContainerId());
            node.markContainerToNonKillable(nonKillableContainer.getContainerId());
            if (null != application) {
                String leafQueueName = application.getCSLeafQueue().getQueueName();
                this.getPreemptionManager().removeKillableContainer(new KillableContainer(nonKillableContainer, node.getPartition(), leafQueueName));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ACL not found for queue access-type " + acl + " for queue " + queueName));
            }
            return false;
        }
        return queue.hasAccess(acl, callerUGI);
    }

    @Override
    public List<ApplicationAttemptId> getAppsInQueue(String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            return null;
        }
        ArrayList<ApplicationAttemptId> apps = new ArrayList<ApplicationAttemptId>();
        queue.collectSchedulerApplications(apps);
        return apps;
    }

    public boolean isSystemAppsLimitReached() {
        return this.getRootQueue().getNumApplications() >= this.conf.getMaximumSystemApplications();
    }

    private String getDefaultReservationQueueName(String planQueueName) {
        return planQueueName + "-default";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveReservationQueueName(String queueName, ApplicationId applicationId, ReservationId reservationID, boolean isRecovering) {
        try {
            this.readLock.lock();
            CSQueue queue = this.getQueue(queueName);
            if (queue == null || !(queue instanceof PlanQueue)) {
                String string = queueName;
                return string;
            }
            if (reservationID != null) {
                String resQName = reservationID.toString();
                queue = this.getQueue(resQName);
                if (queue == null) {
                    if (isRecovering && this.conf.getMoveOnExpiry(this.getQueue(queueName).getQueuePath())) {
                        String string = this.getDefaultReservationQueueName(queueName);
                        return string;
                    }
                    String message = "Application " + applicationId + " submitted to a reservation which is not currently active: " + resQName;
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                    String string = null;
                    return string;
                }
                if (!queue.getParent().getQueueName().equals(queueName)) {
                    String message = "Application: " + applicationId + " submitted to a reservation " + resQName + " which does not belong to the specified queue: " + queueName;
                    this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                    String string = null;
                    return string;
                }
                queueName = resQName;
            } else {
                queueName = this.getDefaultReservationQueueName(queueName);
            }
            String string = queueName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueue(String queueName) throws SchedulerDynamicEditException {
        try {
            this.writeLock.lock();
            LOG.info((Object)("Removing queue: " + queueName));
            CSQueue q = this.getQueue(queueName);
            if (!(q instanceof ReservationQueue)) {
                throw new SchedulerDynamicEditException("The queue that we are asked to remove (" + queueName + ") is not a ReservationQueue");
            }
            ReservationQueue disposableLeafQueue = (ReservationQueue)q;
            if (disposableLeafQueue.getNumApplications() > 0) {
                throw new SchedulerDynamicEditException("The queue " + queueName + " is not empty " + disposableLeafQueue.getApplications().size() + " active apps " + disposableLeafQueue.getPendingApplications().size() + " pending apps");
            }
            ((PlanQueue)disposableLeafQueue.getParent()).removeChildQueue(q);
            this.queueManager.removeQueue(queueName);
            LOG.info((Object)("Removal of ReservationQueue " + queueName + " has succeeded"));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQueue(Queue queue) throws SchedulerDynamicEditException {
        try {
            this.writeLock.lock();
            if (!(queue instanceof ReservationQueue)) {
                throw new SchedulerDynamicEditException("Queue " + queue.getQueueName() + " is not a ReservationQueue");
            }
            ReservationQueue newQueue = (ReservationQueue)queue;
            if (newQueue.getParent() == null || !(newQueue.getParent() instanceof PlanQueue)) {
                throw new SchedulerDynamicEditException("ParentQueue for " + newQueue.getQueueName() + " is not properly set (should be set and be a PlanQueue)");
            }
            PlanQueue parentPlan = (PlanQueue)newQueue.getParent();
            String queuename = newQueue.getQueueName();
            parentPlan.addChildQueue(newQueue);
            this.queueManager.addQueue(queuename, newQueue);
            LOG.info((Object)("Creation of ReservationQueue " + newQueue + " succeeded"));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEntitlement(String inQueue, QueueEntitlement entitlement) throws YarnException {
        try {
            this.writeLock.lock();
            LeafQueue queue = this.queueManager.getAndCheckLeafQueue(inQueue);
            ParentQueue parent = (ParentQueue)queue.getParent();
            if (!(queue instanceof ReservationQueue)) {
                throw new SchedulerDynamicEditException("Entitlement can not be modified dynamically since queue " + inQueue + " is not a ReservationQueue");
            }
            if (!(parent instanceof PlanQueue)) {
                throw new SchedulerDynamicEditException("The parent of ReservationQueue " + inQueue + " must be an PlanQueue");
            }
            ReservationQueue newQueue = (ReservationQueue)queue;
            float sumChilds = ((PlanQueue)parent).sumOfChildCapacities();
            float newChildCap = sumChilds - queue.getCapacity() + entitlement.getCapacity();
            if (newChildCap >= 0.0f && newChildCap < 1.0001f) {
                if (Math.abs(entitlement.getCapacity() - queue.getCapacity()) == 0.0f && Math.abs(entitlement.getMaxCapacity() - queue.getMaximumCapacity()) == 0.0f) {
                    return;
                }
            } else {
                throw new SchedulerDynamicEditException("Sum of child queues would exceed 100% for PlanQueue: " + parent.getQueueName());
            }
            newQueue.setEntitlement(entitlement);
            LOG.info((Object)("Set entitlement for ReservationQueue " + inQueue + "  to " + queue.getCapacity() + " request was (" + entitlement.getCapacity() + ")"));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String moveApplication(ApplicationId appId, String targetQueueName) throws YarnException {
        try {
            this.writeLock.lock();
            SchedulerApplication application = (SchedulerApplication)this.applications.get(appId);
            if (application == null) {
                throw new YarnException("App to be moved " + appId + " not found.");
            }
            String sourceQueueName = application.getQueue().getQueueName();
            LeafQueue source = this.queueManager.getAndCheckLeafQueue(sourceQueueName);
            String destQueueName = this.handleMoveToPlanQueue(targetQueueName);
            LeafQueue dest = this.queueManager.getAndCheckLeafQueue(destQueueName);
            String user = application.getUser();
            try {
                dest.submitApplication(appId, user, destQueueName);
            }
            catch (AccessControlException e) {
                throw new YarnException((Throwable)e);
            }
            FiCaSchedulerApp app = (FiCaSchedulerApp)application.getCurrentAppAttempt();
            if (app != null) {
                for (RMContainer rmContainer : app.getLiveContainers()) {
                    source.detachContainer(this.getClusterResource(), app, rmContainer);
                    dest.attachContainer(this.getClusterResource(), app, rmContainer);
                }
                if (!app.isStopped()) {
                    source.finishApplicationAttempt(app, sourceQueueName);
                    dest.submitApplicationAttempt(app, user);
                }
                app.move(dest);
            }
            source.appFinished();
            source.getParent().finishApplication(appId, user);
            application.setQueue(dest);
            LOG.info((Object)("App: " + appId + " successfully moved from " + sourceQueueName + " to: " + destQueueName));
            String string = targetQueueName;
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preValidateMoveApplication(ApplicationId appId, String newQueue) throws YarnException {
        try {
            this.writeLock.lock();
            SchedulerApplication application = (SchedulerApplication)this.applications.get(appId);
            if (application == null) {
                throw new YarnException("App to be moved " + appId + " not found.");
            }
            String sourceQueueName = application.getQueue().getQueueName();
            this.queueManager.getAndCheckLeafQueue(sourceQueueName);
            String destQueueName = this.handleMoveToPlanQueue(newQueue);
            LeafQueue dest = this.queueManager.getAndCheckLeafQueue(destQueueName);
            String user = application.getUser();
            FiCaSchedulerApp appAttempt = this.getApplicationAttempt(ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0));
            if (null != appAttempt) {
                this.checkQueuePartition(appAttempt, dest);
            }
            try {
                dest.validateSubmitApplication(appId, user, destQueueName);
            }
            catch (AccessControlException e) {
                throw new YarnException((Throwable)e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void checkQueuePartition(FiCaSchedulerApp app, LeafQueue dest) throws YarnException {
        if (!YarnConfiguration.areNodeLabelsEnabled((Configuration)this.conf)) {
            return;
        }
        Set<String> targetqueuelabels = dest.getAccessibleNodeLabels();
        AppSchedulingInfo schedulingInfo = app.getAppSchedulingInfo();
        Set<String> appLabelexpressions = schedulingInfo.getRequestedPartitions();
        appLabelexpressions.remove("");
        HashSet<String> nonAccessiblelabels = new HashSet<String>();
        for (String label : appLabelexpressions) {
            if (SchedulerUtils.checkQueueLabelExpression(targetqueuelabels, label, null)) continue;
            nonAccessiblelabels.add(label);
        }
        if (nonAccessiblelabels.size() > 0) {
            throw new YarnException("Specified queue=" + dest.getQueueName() + " can't satisfy following apps label expressions =" + nonAccessiblelabels + " accessible node labels =" + targetqueuelabels);
        }
    }

    @Override
    public EnumSet<YarnServiceProtos.SchedulerResourceTypes> getSchedulingResourceTypes() {
        if (this.calculator.getClass().getName().equals(DefaultResourceCalculator.class.getName())) {
            return EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY);
        }
        return EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY, YarnServiceProtos.SchedulerResourceTypes.CPU);
    }

    @Override
    public Resource getMaximumResourceCapability(String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            LOG.error((Object)("Unknown queue: " + queueName));
            return this.getMaximumResourceCapability();
        }
        if (!(queue instanceof LeafQueue)) {
            LOG.error((Object)("queue " + queueName + " is not an leaf queue"));
            return this.getMaximumResourceCapability();
        }
        return ((LeafQueue)queue).getMaximumAllocation();
    }

    private String handleMoveToPlanQueue(String targetQueueName) {
        CSQueue dest = this.getQueue(targetQueueName);
        if (dest != null && dest instanceof PlanQueue) {
            targetQueueName = targetQueueName + "-default";
        }
        return targetQueueName;
    }

    @Override
    public Set<String> getPlanQueues() {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<String, CSQueue> l : this.queueManager.getQueues().entrySet()) {
            if (!(l.getValue() instanceof PlanQueue)) continue;
            ret.add(l.getKey());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Priority checkAndGetApplicationPriority(Priority priorityRequestedByApp, UserGroupInformation user, String queueName, ApplicationId applicationId) throws YarnException {
        try {
            this.readLock.lock();
            Priority appPriority = priorityRequestedByApp;
            if (null == appPriority) {
                appPriority = this.appPriorityACLManager.getDefaultPriority(queueName, user);
                if (null == appPriority) {
                    appPriority = this.queueManager.getDefaultPriorityForQueue(queueName);
                }
                LOG.info((Object)("Application '" + applicationId + "' is submitted without priority hence considering default queue/cluster priority: " + appPriority.getPriority()));
            }
            if (appPriority.getPriority() > this.getMaxClusterLevelAppPriority().getPriority()) {
                appPriority = Priority.newInstance((int)this.getMaxClusterLevelAppPriority().getPriority());
            }
            if (!this.appPriorityACLManager.checkAccess(user, queueName, appPriority)) {
                throw new YarnException((Throwable)new AccessControlException("User " + user + " does not have permission to submit/update " + applicationId + " for " + appPriority));
            }
            LOG.info((Object)("Priority '" + appPriority.getPriority() + "' is acceptable in queue : " + queueName + " for application: " + applicationId));
            Priority priority = appPriority;
            return priority;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Priority updateApplicationPriority(Priority newPriority, ApplicationId applicationId, SettableFuture<Object> future, UserGroupInformation user) throws YarnException {
        try {
            this.writeLock.lock();
            Priority appPriority = null;
            SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationId);
            if (application == null) {
                throw new YarnException("Application '" + applicationId + "' is not present, hence could not change priority.");
            }
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(applicationId);
            appPriority = this.checkAndGetApplicationPriority(newPriority, user, rmApp.getQueue(), applicationId);
            if (application.getPriority().equals((Object)appPriority)) {
                future.set(null);
                Priority priority = appPriority;
                return priority;
            }
            rmApp.getApplicationSubmissionContext().setPriority(appPriority);
            ApplicationStateData appState = ApplicationStateData.newInstance(rmApp.getSubmitTime(), rmApp.getStartTime(), rmApp.getApplicationSubmissionContext(), rmApp.getUser(), rmApp.getCallerContext());
            appState.setApplicationTimeouts(rmApp.getApplicationTimeouts());
            this.rmContext.getStateStore().updateApplicationStateSynchronously(appState, false, future);
            LeafQueue queue = (LeafQueue)this.getQueue(rmApp.getQueue());
            queue.updateApplicationPriority(application, appPriority);
            LOG.info((Object)("Priority '" + appPriority + "' is updated in queue :" + rmApp.getQueue() + " for application: " + applicationId + " for the user: " + rmApp.getUser()));
            Priority priority = appPriority;
            return priority;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public PreemptionManager getPreemptionManager() {
        return this.preemptionManager;
    }

    @Override
    public ResourceUsage getClusterResourceUsage() {
        return this.getRootQueue().getQueueResourceUsage();
    }

    private SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> getSchedulerContainer(RMContainer rmContainer, boolean allocated) {
        if (null == rmContainer) {
            return null;
        }
        FiCaSchedulerApp app = this.getApplicationAttempt(rmContainer.getApplicationAttemptId());
        if (null == app) {
            return null;
        }
        NodeId nodeId = rmContainer.getState() == RMContainerState.RESERVED ? rmContainer.getReservedNode() : rmContainer.getNodeId();
        FiCaSchedulerNode node = this.getNode(nodeId);
        if (null == node) {
            return null;
        }
        return new SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode>(app, node, rmContainer, node.getPartition(), allocated);
    }

    private List<SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode>> getSchedulerContainersToRelease(CSAssignment csAssignment) {
        ArrayList<SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode>> list = null;
        if (csAssignment.getContainersToKill() != null && !csAssignment.getContainersToKill().isEmpty()) {
            list = new ArrayList<SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode>>();
            for (RMContainer rmContainer : csAssignment.getContainersToKill()) {
                list.add(this.getSchedulerContainer(rmContainer, false));
            }
        }
        if (csAssignment.getExcessReservation() != null) {
            if (null == list) {
                list = new ArrayList();
            }
            list.add(this.getSchedulerContainer(csAssignment.getExcessReservation(), false));
        }
        return list;
    }

    @VisibleForTesting
    public void submitResourceCommitRequest(Resource cluster, CSAssignment csAssignment) {
        ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request = this.createResourceCommitRequest(csAssignment);
        if (null == request) {
            return;
        }
        if (this.scheduleAsynchronously) {
            this.resourceCommitterService.addNewCommitRequest(request);
        } else {
            this.tryCommit(cluster, request);
        }
    }

    @VisibleForTesting
    public ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> createResourceCommitRequest(CSAssignment csAssignment) {
        ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocated = null;
        ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> reserved = null;
        List released = null;
        if (Resources.greaterThan((ResourceCalculator)this.calculator, (Resource)this.getClusterResource(), (Resource)csAssignment.getResource(), (Resource)Resources.none())) {
            List<AssignmentInformation.AssignmentDetails> reservation;
            List<AssignmentInformation.AssignmentDetails> allocations = csAssignment.getAssignmentInformation().getAllocationDetails();
            if (!allocations.isEmpty()) {
                RMContainer rmContainer = allocations.get((int)0).rmContainer;
                allocated = new ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode>(this.getSchedulerContainer(rmContainer, true), this.getSchedulerContainersToRelease(csAssignment), this.getSchedulerContainer(csAssignment.getFulfilledReservedContainer(), false), csAssignment.getType(), csAssignment.getRequestLocalityType(), csAssignment.getSchedulingMode() != null ? csAssignment.getSchedulingMode() : SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, csAssignment.getResource());
            }
            if (!(reservation = csAssignment.getAssignmentInformation().getReservationDetails()).isEmpty()) {
                RMContainer rmContainer = reservation.get((int)0).rmContainer;
                reserved = new ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode>(this.getSchedulerContainer(rmContainer, false), this.getSchedulerContainersToRelease(csAssignment), this.getSchedulerContainer(csAssignment.getFulfilledReservedContainer(), false), csAssignment.getType(), csAssignment.getRequestLocalityType(), csAssignment.getSchedulingMode() != null ? csAssignment.getSchedulingMode() : SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY, csAssignment.getResource());
            }
        }
        if (null == allocated && null == reserved) {
            released = this.getSchedulerContainersToRelease(csAssignment);
        }
        if (null != allocated || null != reserved || null != released && !released.isEmpty()) {
            ArrayList allocationsList = null;
            if (allocated != null) {
                allocationsList = new ArrayList();
                allocationsList.add(allocated);
            }
            ArrayList reservationsList = null;
            if (reserved != null) {
                reservationsList = new ArrayList();
                reservationsList.add(reserved);
            }
            return new ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode>(allocationsList, reservationsList, released);
        }
        return null;
    }

    @Override
    public void tryCommit(Resource cluster, ResourceCommitRequest r) {
        FiCaSchedulerApp app;
        boolean updateUnconfirmedAllocatedResource;
        ResourceCommitRequest request = r;
        ApplicationAttemptId attemptId = null;
        boolean bl = updateUnconfirmedAllocatedResource = request.getContainersToAllocate() != null && !request.getContainersToAllocate().isEmpty();
        if (request.anythingAllocatedOrReserved()) {
            ContainerAllocationProposal c = request.getFirstAllocatedOrReservedContainer();
            attemptId = ((FiCaSchedulerApp)c.getAllocatedOrReservedContainer().getSchedulerApplicationAttempt()).getApplicationAttemptId();
        } else if (!request.getContainersToRelease().isEmpty()) {
            attemptId = ((FiCaSchedulerApp)request.getContainersToRelease().get(0).getSchedulerApplicationAttempt()).getApplicationAttemptId();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Try to commit allocation proposal=" + request));
        }
        if (attemptId != null && (app = this.getApplicationAttempt(attemptId)) != null && attemptId.equals((Object)app.getApplicationAttemptId())) {
            if (app.accept(cluster, request)) {
                app.apply(cluster, request);
                LOG.info((Object)"Allocation proposal accepted");
            } else {
                LOG.info((Object)"Failed to accept allocation proposal");
            }
            if (updateUnconfirmedAllocatedResource) {
                app.decUnconfirmedRes(request.getTotalAllocatedResource());
            }
        }
    }

    public int getAsyncSchedulingPendingBacklogs() {
        if (this.scheduleAsynchronously) {
            return this.resourceCommitterService.getPendingBacklogs();
        }
        return 0;
    }

    @Override
    public CapacitySchedulerQueueManager getCapacitySchedulerQueueManager() {
        return this.queueManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveReservedContainer(RMContainer toBeMovedContainer, FiCaSchedulerNode targetNode) {
        try {
            FiCaSchedulerNode sourceNode;
            this.writeLock.lock();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to move container=" + toBeMovedContainer + " to node=" + targetNode.getNodeID()));
            }
            if (null == (sourceNode = this.getNode(toBeMovedContainer.getNodeId()))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Failed to move reservation, cannot find source node=" + toBeMovedContainer.getNodeId()));
                }
                boolean bl = false;
                return bl;
            }
            if (this.getNode(targetNode.getNodeID()) != targetNode) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Failed to move reservation, node updated or removed, moving cancelled.");
                }
                boolean bl = false;
                return bl;
            }
            if (targetNode.getReservedContainer() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Target node's reservation status changed, moving cancelled.");
                }
                boolean bl = false;
                return bl;
            }
            FiCaSchedulerApp app = this.getApplicationAttempt(toBeMovedContainer.getApplicationAttemptId());
            if (null == app) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cannot find to-be-moved container's application=" + toBeMovedContainer.getApplicationAttemptId()));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = app.moveReservation(toBeMovedContainer, sourceNode, targetNode);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long checkAndGetApplicationLifetime(String queueName, long lifetimeRequestedByApp) {
        try {
            this.readLock.lock();
            CSQueue queue = this.getQueue(queueName);
            if (queue == null || !(queue instanceof LeafQueue)) {
                long l = lifetimeRequestedByApp;
                return l;
            }
            long defaultApplicationLifetime = ((LeafQueue)queue).getDefaultApplicationLifetime();
            long maximumApplicationLifetime = ((LeafQueue)queue).getMaximumApplicationLifetime();
            if (maximumApplicationLifetime <= 0L) {
                long l = lifetimeRequestedByApp;
                return l;
            }
            if (lifetimeRequestedByApp <= 0L) {
                long l = defaultApplicationLifetime;
                return l;
            }
            if (lifetimeRequestedByApp > maximumApplicationLifetime) {
                long l = maximumApplicationLifetime;
                return l;
            }
            long l = lifetimeRequestedByApp;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getMaximumApplicationLifetime(String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null || !(queue instanceof LeafQueue)) {
            LOG.error((Object)("Unknown queue: " + queueName));
            return -1L;
        }
        return ((LeafQueue)queue).getMaximumApplicationLifetime();
    }

    @Override
    public boolean isConfigurationMutable() {
        return this.csConfProvider instanceof MutableConfigurationProvider;
    }

    @Override
    public MutableConfigurationProvider getMutableConfProvider() {
        if (this.isConfigurationMutable()) {
            return (MutableConfigurationProvider)((Object)this.csConfProvider);
        }
        return null;
    }

    static class ResourceCommitterService
    extends Thread {
        private final CapacityScheduler cs;
        private BlockingQueue<ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode>> backlogs = new LinkedBlockingQueue<ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode>>();

        public ResourceCommitterService(CapacityScheduler cs) {
            this.cs = cs;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request = this.backlogs.take();
                    try {
                        this.cs.writeLock.lock();
                        this.cs.tryCommit(this.cs.getClusterResource(), request);
                    }
                    finally {
                        this.cs.writeLock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    LOG.error((Object)e);
                    Thread.currentThread().interrupt();
                }
            }
            LOG.info((Object)"ResourceCommitterService exited!");
        }

        public void addNewCommitRequest(ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> proposal) {
            this.backlogs.add(proposal);
        }

        public int getPendingBacklogs() {
            return this.backlogs.size();
        }
    }

    static class AsyncScheduleThread
    extends Thread {
        private final CapacityScheduler cs;
        private AtomicBoolean runSchedules = new AtomicBoolean(false);

        public AsyncScheduleThread(CapacityScheduler cs) {
            this.cs = cs;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (!this.runSchedules.get()) {
                        Thread.sleep(100L);
                        continue;
                    }
                    if (this.cs.getAsyncSchedulingPendingBacklogs() > 100) {
                        Thread.sleep(1L);
                        continue;
                    }
                    CapacityScheduler.schedule(this.cs);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            LOG.info((Object)("AsyncScheduleThread[" + this.getName() + "] exited!"));
        }

        public void beginSchedule() {
            this.runSchedules.set(true);
        }

        public void suspendSchedule() {
            this.runSchedules.set(false);
        }
    }
}

