/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.subapplication;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationTable;

public enum SubApplicationColumn implements Column<SubApplicationTable>
{
    ID(SubApplicationColumnFamily.INFO, "id"),
    TYPE(SubApplicationColumnFamily.INFO, "type"),
    CREATED_TIME(SubApplicationColumnFamily.INFO, "created_time", new LongConverter()),
    FLOW_VERSION(SubApplicationColumnFamily.INFO, "flow_version");

    private final ColumnHelper<SubApplicationTable> column;
    private final ColumnFamily<SubApplicationTable> columnFamily;
    private final String columnQualifier;
    private final byte[] columnQualifierBytes;

    private SubApplicationColumn(ColumnFamily<SubApplicationTable> columnFamily, String columnQualifier) {
        this(columnFamily, columnQualifier, GenericConverter.getInstance());
    }

    private SubApplicationColumn(ColumnFamily<SubApplicationTable> columnFamily, String columnQualifier, ValueConverter converter) {
        this.columnFamily = columnFamily;
        this.columnQualifier = columnQualifier;
        this.columnQualifierBytes = Bytes.toBytes((String)Separator.SPACE.encode(columnQualifier));
        this.column = new ColumnHelper<SubApplicationTable>(columnFamily, converter);
    }

    @Override
    public void store(byte[] rowKey, TypedBufferedMutator<SubApplicationTable> tableMutator, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        this.column.store(rowKey, tableMutator, this.columnQualifierBytes, timestamp, inputValue, attributes);
    }

    @Override
    public Object readResult(Result result) throws IOException {
        return this.column.readResult(result, this.columnQualifierBytes);
    }

    @Override
    public byte[] getColumnQualifierBytes() {
        return (byte[])this.columnQualifierBytes.clone();
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.column.getValueConverter();
    }
}

