/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.reader;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.AbstractTimelineStorageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityTypeReader
extends AbstractTimelineStorageReader {
    private static final Logger LOG = LoggerFactory.getLogger(EntityTypeReader.class);
    private static final EntityTable ENTITY_TABLE = new EntityTable();

    public EntityTypeReader(TimelineReaderContext context) {
        super(context);
    }

    public Set<String> readEntityTypes(Configuration hbaseConf, Connection conn) throws IOException {
        this.validateParams();
        this.augmentParams(hbaseConf, conn);
        TreeSet<String> types = new TreeSet<String>();
        TimelineReaderContext context = this.getContext();
        EntityRowKeyPrefix prefix = new EntityRowKeyPrefix(context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId(), context.getAppId());
        byte[] currRowKey = prefix.getRowKeyPrefix();
        byte[] nextRowKey = prefix.getRowKeyPrefix();
        int n = nextRowKey.length - 1;
        nextRowKey[n] = (byte)(nextRowKey[n] + 1);
        FilterList typeFilterList = new FilterList(new Filter[0]);
        typeFilterList.addFilter((Filter)new FirstKeyOnlyFilter());
        typeFilterList.addFilter((Filter)new KeyOnlyFilter());
        typeFilterList.addFilter((Filter)new PageFilter(1L));
        LOG.debug("FilterList created for scan is - {}", (Object)typeFilterList);
        int counter = 0;
        while (true) {
            ResultScanner results = this.getResult(hbaseConf, conn, typeFilterList, currRowKey, nextRowKey);
            Throwable throwable = null;
            try {
                TimelineEntity entity = this.parseEntityForType(results.next());
                if (entity == null) break;
                ++counter;
                if (!types.add(entity.getType())) {
                    LOG.warn("Failed to add type " + entity.getType() + " to the result set because there is a duplicated copy. ");
                }
                String currType = entity.getType();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Current row key: " + Arrays.toString(currRowKey));
                    LOG.debug("New entity type discovered: " + currType);
                }
                currRowKey = EntityTypeReader.getNextRowKey(prefix.getRowKeyPrefix(), currType);
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (results == null) continue;
                if (throwable != null) {
                    try {
                        results.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                results.close();
                continue;
            }
            break;
        }
        LOG.debug("Scanned {} records for {} types", (Object)counter, (Object)types.size());
        return types;
    }

    @Override
    protected void validateParams() {
        Preconditions.checkNotNull((Object)this.getContext(), (Object)"context shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getClusterId(), (Object)"clusterId shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getAppId(), (Object)"appId shouldn't be null");
    }

    private static byte[] getNextRowKey(byte[] currRowKeyPrefix, String entityType) {
        if (currRowKeyPrefix == null || entityType == null) {
            return null;
        }
        byte[] entityTypeEncoded = Separator.QUALIFIERS.join(Separator.encode(entityType, Separator.SPACE, Separator.TAB, Separator.QUALIFIERS), Separator.EMPTY_BYTES);
        byte[] currRowKey = new byte[currRowKeyPrefix.length + entityTypeEncoded.length];
        System.arraycopy(currRowKeyPrefix, 0, currRowKey, 0, currRowKeyPrefix.length);
        System.arraycopy(entityTypeEncoded, 0, currRowKey, currRowKeyPrefix.length, entityTypeEncoded.length);
        return HBaseTimelineStorageUtils.calculateTheClosestNextRowKeyForPrefix(currRowKey);
    }

    private ResultScanner getResult(Configuration hbaseConf, Connection conn, FilterList filterList, byte[] startPrefix, byte[] endPrefix) throws IOException {
        Scan scan = new Scan(startPrefix, endPrefix);
        scan.setFilter((Filter)filterList);
        scan.setSmall(true);
        return ENTITY_TABLE.getResultScanner(hbaseConf, conn, scan);
    }

    private TimelineEntity parseEntityForType(Result result) throws IOException {
        if (result == null || result.isEmpty()) {
            return null;
        }
        TimelineEntity entity = new TimelineEntity();
        EntityRowKey newRowKey = EntityRowKey.parseRowKey(result.getRow());
        entity.setType(newRowKey.getEntityType());
        return entity;
    }
}

