/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunTable;

public enum FlowRunColumnPrefix implements ColumnPrefix<FlowRunTable>
{
    METRIC(FlowRunColumnFamily.INFO, "m", null, new LongConverter());

    private final ColumnHelper<FlowRunTable> column;
    private final ColumnFamily<FlowRunTable> columnFamily;
    private final String columnPrefix;
    private final byte[] columnPrefixBytes;
    private final AggregationOperation aggOp;

    private FlowRunColumnPrefix(ColumnFamily<FlowRunTable> columnFamily, String columnPrefix, AggregationOperation fra, ValueConverter converter) {
        this(columnFamily, columnPrefix, fra, converter, false);
    }

    private FlowRunColumnPrefix(ColumnFamily<FlowRunTable> columnFamily, String columnPrefix, AggregationOperation fra, ValueConverter converter, boolean compoundColQual) {
        this.column = new ColumnHelper<FlowRunTable>(columnFamily, converter, true);
        this.columnFamily = columnFamily;
        this.columnPrefix = columnPrefix;
        this.columnPrefixBytes = (byte[])(columnPrefix == null ? null : Bytes.toBytes((String)Separator.SPACE.encode(columnPrefix)));
        this.aggOp = fra;
    }

    public String getColumnPrefix() {
        return this.columnPrefix;
    }

    public byte[] getColumnPrefixBytes() {
        return (byte[])this.columnPrefixBytes.clone();
    }

    @Override
    public byte[] getColumnPrefixBytes(byte[] qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnPrefixBytes(String qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    public AggregationOperation getAttribute() {
        return this.aggOp;
    }

    @Override
    public void store(byte[] rowKey, TypedBufferedMutator<FlowRunTable> tableMutator, String qualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (qualifier == null) {
            throw new IOException("Cannot store column with null qualifier in " + tableMutator.getName().getNameAsString());
        }
        byte[] columnQualifier = this.getColumnPrefixBytes(qualifier);
        Attribute[] combinedAttributes = HBaseTimelineStorageUtils.combineAttributes(attributes, this.aggOp);
        this.column.store(rowKey, tableMutator, columnQualifier, timestamp, inputValue, combinedAttributes);
    }

    @Override
    public void store(byte[] rowKey, TypedBufferedMutator<FlowRunTable> tableMutator, byte[] qualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (qualifier == null) {
            throw new IOException("Cannot store column with null qualifier in " + tableMutator.getName().getNameAsString());
        }
        byte[] columnQualifier = this.getColumnPrefixBytes(qualifier);
        Attribute[] combinedAttributes = HBaseTimelineStorageUtils.combineAttributes(attributes, this.aggOp);
        this.column.store(rowKey, tableMutator, columnQualifier, timestamp, inputValue, combinedAttributes);
    }

    @Override
    public Object readResult(Result result, String qualifier) throws IOException {
        byte[] columnQualifier = ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifier);
        return this.column.readResult(result, columnQualifier);
    }

    @Override
    public <K> Map<K, Object> readResults(Result result, KeyConverter<K> keyConverter) throws IOException {
        return this.column.readResults(result, this.columnPrefixBytes, keyConverter);
    }

    @Override
    public <K, V> NavigableMap<K, NavigableMap<Long, V>> readResultsWithTimestamps(Result result, KeyConverter<K> keyConverter) throws IOException {
        return this.column.readResultsWithTimestamps(result, this.columnPrefixBytes, keyConverter);
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.column.getValueConverter();
    }
}

