/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.handlers;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.nativetask.NativeDataTarget;
import org.apache.hadoop.mapred.nativetask.buffer.ByteBufferDataWriter;
import org.apache.hadoop.mapred.nativetask.serde.IKVSerializer;
import org.apache.hadoop.mapred.nativetask.serde.KVSerializer;
import org.apache.hadoop.mapred.nativetask.util.SizedWritable;

@InterfaceAudience.Private
public class BufferPusher<K, V>
implements OutputCollector<K, V> {
    private static Log LOG = LogFactory.getLog(BufferPusher.class);
    private final SizedWritable<K> tmpInputKey;
    private final SizedWritable<V> tmpInputValue;
    private ByteBufferDataWriter out;
    IKVSerializer serializer;
    private boolean closed = false;

    public BufferPusher(Class<K> iKClass, Class<V> iVClass, NativeDataTarget target) throws IOException {
        this.tmpInputKey = new SizedWritable(iKClass);
        this.tmpInputValue = new SizedWritable(iVClass);
        if (null != iKClass && null != iVClass) {
            this.serializer = new KVSerializer<K, V>(iKClass, iVClass);
        }
        this.out = new ByteBufferDataWriter(target);
    }

    public void collect(K key, V value, int partition) throws IOException {
        this.tmpInputKey.reset(key);
        this.tmpInputValue.reset(value);
        this.serializer.serializePartitionKV(this.out, partition, this.tmpInputKey, this.tmpInputValue);
    }

    public void collect(K key, V value) throws IOException {
        if (this.closed) {
            return;
        }
        this.tmpInputKey.reset(key);
        this.tmpInputValue.reset(value);
        this.serializer.serializeKV(this.out, this.tmpInputKey, this.tmpInputValue);
    }

    public void flush() throws IOException {
        if (null != this.out && this.out.hasUnFlushedData()) {
            this.out.flush();
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (null != this.out) {
            this.out.close();
        }
        this.closed = true;
    }
}

