/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyState;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageReconstructor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageViewer;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageViewerPB;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageCorruption;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageCorruptionDetector;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageDelimitedTextWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestOfflineImageViewer {
    private static final Log LOG = LogFactory.getLog(OfflineImageViewerPB.class);
    private static final int NUM_DIRS = 3;
    private static final int FILES_PER_DIR = 4;
    private static final String TEST_RENEWER = "JobTracker";
    private static File originalFsimage = null;
    private static int filesECCount = 0;
    private static String addedErasureCodingPolicyName = null;
    private static final long FILE_NODE_ID_1 = 16388L;
    private static final long FILE_NODE_ID_2 = 16389L;
    private static final long FILE_NODE_ID_3 = 16394L;
    private static final long DIR_NODE_ID = 16391L;
    static final HashMap<String, FileStatus> writtenFiles = Maps.newHashMap();
    static int dirCount = 0;
    private static File tempDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void createOriginalFSImage() throws IOException {
        File[] nnDirs = MiniDFSCluster.getNameNodeDirectory(MiniDFSCluster.getBaseDirectory(), 0, 0);
        tempDir = nnDirs[0];
        MiniDFSCluster cluster = null;
        try {
            Token[] delegationTokens;
            ErasureCodingPolicy ecPolicy = SystemErasureCodingPolicies.getByID((byte)4);
            Configuration conf = new Configuration();
            conf.setLong("dfs.namenode.delegation.token.max-lifetime", 10000L);
            conf.setLong("dfs.namenode.delegation.token.renew-interval", 5000L);
            conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
            conf.setBoolean("dfs.namenode.acls.enabled", true);
            conf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](JobTracker@.*FOO.COM)s/@.*//DEFAULT");
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            hdfs.enableErasureCodingPolicy(ecPolicy.getName());
            ImmutableMap options = ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2");
            ECSchema schema = new ECSchema("rs", 10, 4, (Map)options);
            ErasureCodingPolicy policy = new ErasureCodingPolicy(schema, 1024);
            AddErasureCodingPolicyResponse[] responses = hdfs.addErasureCodingPolicies(new ErasureCodingPolicy[]{policy});
            addedErasureCodingPolicyName = responses[0].getPolicy().getName();
            hdfs.enableErasureCodingPolicy(addedErasureCodingPolicyName);
            int i = 0;
            while (i < 3) {
                Path dir = new Path("/dir" + i);
                hdfs.mkdirs(dir);
                writtenFiles.put(dir.toString(), TestOfflineImageViewer.pathToFileEntry((FileSystem)hdfs, dir.toString()));
                for (int j = 0; j < 4; ++j) {
                    Path file = new Path(dir, "file" + j);
                    FSDataOutputStream o = hdfs.create(file);
                    o.write(23);
                    o.close();
                    writtenFiles.put(file.toString(), TestOfflineImageViewer.pathToFileEntry((FileSystem)hdfs, file.toString()));
                }
                ++i;
                ++dirCount;
            }
            Path emptydir = new Path("/emptydir");
            hdfs.mkdirs(emptydir);
            ++dirCount;
            writtenFiles.put(emptydir.toString(), hdfs.getFileStatus(emptydir));
            Path invalidXMLDir = new Path("/dirContainingInvalidXMLChar\u0000here");
            hdfs.mkdirs(invalidXMLDir);
            ++dirCount;
            Path newLFDir = new Path("/dirContainingNewLineChar\nhere");
            hdfs.mkdirs(newLFDir);
            ++dirCount;
            writtenFiles.put("\"/dirContainingNewLineChar%x0Ahere\"", hdfs.getFileStatus(newLFDir));
            Path newCRLFDir = new Path("/dirContainingNewLineChar\r\nhere");
            hdfs.mkdirs(newCRLFDir);
            ++dirCount;
            writtenFiles.put("\"/dirContainingNewLineChar%x0D%x0Ahere\"", hdfs.getFileStatus(newCRLFDir));
            Path stickyBitDir = new Path("/stickyBit");
            hdfs.mkdirs(stickyBitDir);
            hdfs.setPermission(stickyBitDir, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL, true));
            ++dirCount;
            writtenFiles.put(stickyBitDir.toString(), hdfs.getFileStatus(stickyBitDir));
            for (Token t : delegationTokens = hdfs.addDelegationTokens(TEST_RENEWER, null)) {
                LOG.debug((Object)("got token " + t));
            }
            Path src = new Path("/src");
            hdfs.mkdirs(src);
            ++dirCount;
            writtenFiles.put(src.toString(), hdfs.getFileStatus(src));
            Path orig = new Path("/src/orig");
            hdfs.mkdirs(orig);
            Path file1 = new Path("/src/file");
            FSDataOutputStream o = hdfs.create(file1);
            o.write(23);
            o.write(45);
            o.close();
            hdfs.allowSnapshot(src);
            hdfs.createSnapshot(src, "snapshot");
            Path dst = new Path("/dst");
            hdfs.rename(orig, dst);
            ++dirCount;
            writtenFiles.put(dst.toString(), hdfs.getFileStatus(dst));
            hdfs.truncate(file1, 1L);
            writtenFiles.put(file1.toString(), hdfs.getFileStatus(file1));
            Path xattr = new Path("/xattr");
            hdfs.mkdirs(xattr);
            ++dirCount;
            hdfs.setXAttr(xattr, "user.a1", new byte[]{49, 50, 51});
            hdfs.setXAttr(xattr, "user.a2", new byte[]{55, 56, 57});
            hdfs.setXAttr(xattr, "user.a3", null);
            hdfs.setXAttr(xattr, "user.a4", new byte[]{-61, 40});
            writtenFiles.put(xattr.toString(), hdfs.getFileStatus(xattr));
            hdfs.setAcl(xattr, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.EXECUTE)}));
            Path ecDir = new Path("/ec");
            hdfs.mkdirs(ecDir);
            ++dirCount;
            hdfs.getClient().setErasureCodingPolicy(ecDir.toString(), ecPolicy.getName());
            writtenFiles.put(ecDir.toString(), hdfs.getFileStatus(ecDir));
            Path emptyECFile = new Path(ecDir, "EmptyECFile.txt");
            hdfs.create(emptyECFile).close();
            writtenFiles.put(emptyECFile.toString(), TestOfflineImageViewer.pathToFileEntry((FileSystem)hdfs, emptyECFile.toString()));
            ++filesECCount;
            Path smallECFile = new Path(ecDir, "SmallECFile.txt");
            FSDataOutputStream out = hdfs.create(smallECFile);
            Random r = new Random();
            byte[] bytes = new byte[10240];
            r.nextBytes(bytes);
            out.write(bytes);
            writtenFiles.put(smallECFile.toString(), TestOfflineImageViewer.pathToFileEntry((FileSystem)hdfs, smallECFile.toString()));
            ++filesECCount;
            hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            hdfs.saveNamespace();
            hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
            originalFsimage = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
            if (originalFsimage == null) {
                throw new RuntimeException("Didn't generate or can't find fsimage");
            }
            LOG.debug((Object)("original FS image file is " + originalFsimage));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @AfterClass
    public static void deleteOriginalFSImage() throws IOException {
        FileUtils.deleteQuietly((File)tempDir);
        if (originalFsimage != null && originalFsimage.exists()) {
            originalFsimage.delete();
        }
    }

    private static FileStatus pathToFileEntry(FileSystem hdfs, String file) throws IOException {
        return hdfs.getFileStatus(new Path(file));
    }

    @Test(expected=IOException.class)
    public void testTruncatedFSImage() throws IOException {
        File truncatedFile = new File(tempDir, "truncatedFsImage");
        PrintStream output = new PrintStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        this.copyPartOfFile(originalFsimage, truncatedFile);
        new FileDistributionCalculator(new Configuration(), 0L, 0, false, output).visit(new RandomAccessFile(truncatedFile, "r"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPartOfFile(File src, File dest) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        int MAX_BYTES = 700;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            in.getChannel().transferTo(0L, 700L, out.getChannel());
            out.close();
            out = null;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(in);
            IOUtils.closeStream(out);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)in);
        IOUtils.closeStream((Closeable)out);
    }

    @Test
    public void testFileDistributionCalculator() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream o = new PrintStream(output);
        new FileDistributionCalculator(new Configuration(), 0L, 0, false, o).visit(new RandomAccessFile(originalFsimage, "r"));
        o.close();
        String outputString = output.toString();
        Pattern p = Pattern.compile("totalFiles = (\\d+)\n");
        Matcher matcher = p.matcher(outputString);
        Assert.assertTrue((matcher.find() && matcher.groupCount() == 1 ? 1 : 0) != 0);
        int totalFiles = Integer.parseInt(matcher.group(1));
        Assert.assertEquals((long)(12 + filesECCount + 1), (long)totalFiles);
        p = Pattern.compile("totalDirectories = (\\d+)\n");
        matcher = p.matcher(outputString);
        Assert.assertTrue((matcher.find() && matcher.groupCount() == 1 ? 1 : 0) != 0);
        int totalDirs = Integer.parseInt(matcher.group(1));
        Assert.assertEquals((long)(dirCount + 1), (long)totalDirs);
        FileStatus maxFile = Collections.max(writtenFiles.values(), new Comparator<FileStatus>(){

            @Override
            public int compare(FileStatus first, FileStatus second) {
                return first.getLen() < second.getLen() ? -1 : (first.getLen() == second.getLen() ? 0 : 1);
            }
        });
        p = Pattern.compile("maxFileSize = (\\d+)\n");
        matcher = p.matcher(output.toString("UTF-8"));
        Assert.assertTrue((matcher.find() && matcher.groupCount() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)maxFile.getLen(), (long)Long.parseLong(matcher.group(1)));
    }

    @Test
    public void testFileDistributionCalculatorWithOptions() throws Exception {
        int status = OfflineImageViewerPB.run((String[])new String[]{"-i", originalFsimage.getAbsolutePath(), "-o", "-", "-p", "FileDistribution", "-maxSize", "512", "-step", "8"});
        Assert.assertEquals((long)0L, (long)status);
    }

    @Test
    public void testPBImageXmlWriter() throws IOException, SAXException, ParserConfigurationException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream o = new PrintStream(output);
        PBImageXmlWriter v = new PBImageXmlWriter(new Configuration(), o);
        v.visit(new RandomAccessFile(originalFsimage, "r"));
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser parser = spf.newSAXParser();
        String xml = output.toString();
        ECXMLHandler ecxmlHandler = new ECXMLHandler();
        parser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)ecxmlHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebImageViewer() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URI uri = new URI("webhdfs://localhost:" + String.valueOf(port));
            Configuration conf = new Configuration();
            WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            FileStatus[] statuses = webhdfs.listStatus(new Path("/"));
            Assert.assertEquals((long)dirCount, (long)statuses.length);
            statuses = webhdfs.listStatus(new Path("/dir0"));
            Assert.assertEquals((long)4L, (long)statuses.length);
            FileStatus status = webhdfs.listStatus(new Path("/dir0/file0"))[0];
            FileStatus expected = writtenFiles.get("/dir0/file0");
            TestOfflineImageViewer.compareFile(expected, status);
            statuses = webhdfs.listStatus(new Path("/emptydir"));
            Assert.assertEquals((long)0L, (long)statuses.length);
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/invalid/?op=LISTSTATUS");
            this.verifyHttpResponseCode(404, url);
            url = new URL("http://localhost:" + port + "/foo");
            this.verifyHttpResponseCode(404, url);
            Path emptyECFilePath = new Path("/ec/EmptyECFile.txt");
            FileStatus actualEmptyECFileStatus = webhdfs.getFileStatus(new Path(emptyECFilePath.toString()));
            FileStatus expectedEmptyECFileStatus = writtenFiles.get(emptyECFilePath.toString());
            System.out.println(webhdfs.getFileStatus(new Path(emptyECFilePath.toString())));
            TestOfflineImageViewer.compareFile(expectedEmptyECFileStatus, actualEmptyECFileStatus);
            Path smallECFilePath = new Path("/ec/SmallECFile.txt");
            FileStatus actualSmallECFileStatus = webhdfs.getFileStatus(new Path(smallECFilePath.toString()));
            FileStatus expectedSmallECFileStatus = writtenFiles.get(smallECFilePath.toString());
            TestOfflineImageViewer.compareFile(expectedSmallECFileStatus, actualSmallECFileStatus);
            status = webhdfs.getFileStatus(new Path("/dir0/file0"));
            TestOfflineImageViewer.compareFile(expected, status);
            url = new URL("http://localhost:" + port + "/webhdfs/v1/invalid/?op=GETFILESTATUS");
            this.verifyHttpResponseCode(404, url);
            url = new URL("http://localhost:" + port + "/webhdfs/v1/?op=INVALID");
            this.verifyHttpResponseCode(400, url);
            url = new URL("http://localhost:" + port + "/webhdfs/v1/?op=LISTSTATUS");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.connect();
            Assert.assertEquals((long)405L, (long)connection.getResponseCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebImageViewerNullOp() throws Exception {
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));){
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/");
            this.verifyHttpResponseCode(400, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebImageViewerSecureMode() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"), conf);){
            RuntimeException runtimeException = (RuntimeException)LambdaTestUtils.intercept(RuntimeException.class, (String)"WebImageViewer does not support secure mode.", () -> viewer.start("foo"));
        }
        finally {
            conf.set("hadoop.security.authentication", "simple");
            UserGroupInformation.setConfiguration((Configuration)conf);
        }
    }

    @Test
    public void testPBDelimitedWriter() throws IOException, InterruptedException {
        this.testPBDelimitedWriter("");
        this.testPBDelimitedWriter(new FileSystemTestHelper().getTestRootDir() + "/delimited.db");
    }

    @Test
    public void testOutputEntryBuilder() throws IOException {
        PBImageCorruptionDetector corrDetector = new PBImageCorruptionDetector(null, ",", "");
        PBImageCorruption c1 = new PBImageCorruption(342L, true, false, 3);
        PBImageCorruptionDetector.OutputEntryBuilder entryBuilder1 = new PBImageCorruptionDetector.OutputEntryBuilder(corrDetector, false);
        entryBuilder1.setParentId(1L).setCorruption(c1).setParentPath("/dir1/dir2/");
        Assert.assertEquals((Object)entryBuilder1.build(), (Object)"MissingChild,342,false,/dir1/dir2/,1,,,3");
        corrDetector = new PBImageCorruptionDetector(null, "\t", "");
        PBImageCorruption c2 = new PBImageCorruption(781L, false, true, 0);
        PBImageCorruptionDetector.OutputEntryBuilder entryBuilder2 = new PBImageCorruptionDetector.OutputEntryBuilder(corrDetector, true);
        entryBuilder2.setParentPath("/dir3/").setCorruption(c2).setName("folder").setNodeType("Node");
        Assert.assertEquals((Object)entryBuilder2.build(), (Object)"CorruptNode\t781\ttrue\t/dir3/\tMissing\tfolder\tNode\t0");
    }

    @Test
    public void testPBCorruptionDetector() throws IOException, InterruptedException {
        this.testPBCorruptionDetector("");
        this.testPBCorruptionDetector(new FileSystemTestHelper().getTestRootDir() + "/corruption.db");
    }

    @Test
    public void testInvalidProcessorOption() throws Exception {
        int status = OfflineImageViewerPB.run((String[])new String[]{"-i", originalFsimage.getAbsolutePath(), "-o", "-", "-p", "invalid"});
        Assert.assertTrue((String)"Exit code returned for invalid processor option is incorrect", (status != 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOfflineImageViewerHelpMessage() throws Throwable {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        try {
            System.setOut(out);
            int status = OfflineImageViewerPB.run((String[])new String[]{"-h"});
            Assert.assertTrue((String)"Exit code returned for help option is incorrect", (status == 0 ? 1 : 0) != 0);
            Assert.assertFalse((String)"Invalid Command error displayed when help option is passed.", (boolean)bytes.toString().contains("Error parsing command-line options"));
            status = OfflineImageViewerPB.run((String[])new String[]{"-h", "-i", originalFsimage.getAbsolutePath(), "-o", "-", "-p", "FileDistribution", "-maxSize", "512", "-step", "8"});
            Assert.assertTrue((String)"Exit code returned for help with other option is incorrect", (status == -1 ? 1 : 0) != 0);
        }
        finally {
            System.setOut(oldOut);
            IOUtils.closeStream((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(expected=IOException.class)
    public void testDelimitedWithExistingFolder() throws IOException, InterruptedException {
        File tempDelimitedDir = null;
        try {
            String tempDelimitedDirName = "tempDirDelimited";
            String tempDelimitedDirPath = new FileSystemTestHelper().getTestRootDir() + "/" + tempDelimitedDirName;
            tempDelimitedDir = new File(tempDelimitedDirPath);
            Assert.assertTrue((String)"Couldn't create temp directory!", (boolean)tempDelimitedDir.mkdirs());
            this.testPBDelimitedWriter(tempDelimitedDirPath);
            if (tempDelimitedDir == null) return;
        }
        catch (Throwable throwable) {
            if (tempDelimitedDir == null) throw throwable;
            FileUtils.deleteDirectory(tempDelimitedDir);
            throw throwable;
        }
        FileUtils.deleteDirectory((File)tempDelimitedDir);
    }

    private void testPBDelimitedWriter(String db) throws IOException, InterruptedException {
        Object v;
        String DELIMITER = "\t";
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (PrintStream o = new PrintStream(output);){
            v = new PBImageDelimitedTextWriter(o, "\t", db);
            v.visit(new RandomAccessFile(originalFsimage, "r"));
        }
        HashSet<String> fileNames = new HashSet<String>();
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        v = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line;
            boolean header = true;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                String[] fields = line.split("\t");
                Assert.assertEquals((long)12L, (long)fields.length);
                if (!header) {
                    fileNames.add(fields[0]);
                }
                header = false;
            }
        }
        catch (Throwable throwable) {
            v = throwable;
            throw throwable;
        }
        finally {
            if (input != null) {
                if (v != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)v).addSuppressed(throwable);
                    }
                } else {
                    input.close();
                }
            }
        }
        Iterator it = fileNames.iterator();
        while (it.hasNext()) {
            String filename = (String)it.next();
            if (filename.startsWith("/dirContainingInvalidXMLChar")) {
                it.remove();
                continue;
            }
            if (!filename.equals("/")) continue;
            it.remove();
        }
        Assert.assertEquals(writtenFiles.keySet(), fileNames);
    }

    private void testPBCorruptionDetector(String db) throws IOException, InterruptedException {
        String delimiter = "\t";
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (PrintStream o = new PrintStream(output);){
            PBImageCorruptionDetector v = new PBImageCorruptionDetector(o, "\t", db);
            v.visit(new RandomAccessFile(originalFsimage, "r"));
        }
        var5_5 = null;
        try (ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
             BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line = reader.readLine();
            System.out.println(line);
            String[] fields = line.split("\t");
            Assert.assertEquals((long)8L, (long)fields.length);
            PBImageCorruptionDetector v = new PBImageCorruptionDetector(null, "\t", "");
            Assert.assertEquals((Object)line, (Object)v.getHeader());
            line = reader.readLine();
            Assert.assertNull((Object)line);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    private void properINodeDelete(List<Long> idsToDelete, Document doc) throws IOException {
        NodeList inodes = doc.getElementsByTagName("id");
        if (inodes.getLength() < 1) {
            throw new IOException("No id tags found in the image xml.");
        }
        for (long idToDelete : idsToDelete) {
            boolean found = false;
            for (int i = 0; i < inodes.getLength(); ++i) {
                Node id = inodes.item(i);
                if (!id.getTextContent().equals(String.valueOf(idToDelete))) continue;
                found = true;
                Node inode = id.getParentNode();
                Node inodeSection = inode.getParentNode();
                inodeSection.removeChild(inode);
                break;
            }
            if (found) continue;
            throw new IOException("Couldn't find the id in the image.");
        }
        NodeList numInodesNodes = doc.getElementsByTagName("numInodes");
        if (numInodesNodes.getLength() != 1) {
            throw new IOException("More than one numInodes tag found.");
        }
        Node numInodesNode = numInodesNodes.item(0);
        int numberOfINodes = Integer.parseInt(numInodesNode.getTextContent());
        numInodesNode.setTextContent(String.valueOf(numberOfINodes -= idsToDelete.size()));
    }

    private void deleteINodeFromXML(File inputFile, File outputFile, List<Long> corruptibleIds) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(inputFile);
        this.properINodeDelete(corruptibleIds, doc);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(outputFile);
        transformer.transform(source, result);
    }

    private void generateMissingNodeCorruption(File goodImageXml, File corruptedImageXml, File corruptedImage, List<Long> corruptibleIds) throws Exception {
        if (OfflineImageViewerPB.run((String[])new String[]{"-p", "XML", "-i", originalFsimage.getAbsolutePath(), "-o", goodImageXml.getAbsolutePath()}) != 0) {
            throw new IOException("Couldn't create XML!");
        }
        this.deleteINodeFromXML(goodImageXml, corruptedImageXml, corruptibleIds);
        if (OfflineImageViewerPB.run((String[])new String[]{"-p", "ReverseXML", "-i", corruptedImageXml.getAbsolutePath(), "-o", corruptedImage.getAbsolutePath()}) != 0) {
            throw new IOException("Couldn't create from XML!");
        }
    }

    private String testCorruptionDetectorRun(int runNumber, List<Long> corruptions, String db) throws Exception {
        File goodImageXml = new File(tempDir, "goodImage" + runNumber + ".xml");
        File corruptedImageXml = new File(tempDir, "corruptedImage" + runNumber + ".xml");
        File corruptedImage = new File(originalFsimage.getParent(), "fsimage_corrupted" + runNumber);
        this.generateMissingNodeCorruption(goodImageXml, corruptedImageXml, corruptedImage, corruptions);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (PrintStream o = new PrintStream(output);){
            PBImageCorruptionDetector v = new PBImageCorruptionDetector(o, ",", db);
            v.visit(new RandomAccessFile(corruptedImage, "r"));
        }
        return output.toString();
    }

    private String readExpectedFile(String fileName) throws IOException {
        String line;
        File file = new File(System.getProperty("test.cache.data", "build/test/cache"), fileName);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuilder s = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
            s.append(line);
            s.append("\n");
        }
        return s.toString();
    }

    @Test
    public void testCorruptionDetectionSingleFileCorruption() throws Exception {
        List<Long> corruptions = Collections.singletonList(16388L);
        String result = this.testCorruptionDetectorRun(1, corruptions, "");
        String expected = this.readExpectedFile("testSingleFileCorruption.csv");
        Assert.assertEquals((Object)expected, (Object)result);
        result = this.testCorruptionDetectorRun(2, corruptions, new FileSystemTestHelper().getTestRootDir() + "/corruption2.db");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testCorruptionDetectionMultipleFileCorruption() throws Exception {
        List<Long> corruptions = Arrays.asList(16388L, 16389L, 16394L);
        String result = this.testCorruptionDetectorRun(3, corruptions, "");
        String expected = this.readExpectedFile("testMultipleFileCorruption.csv");
        Assert.assertEquals((Object)expected, (Object)result);
        result = this.testCorruptionDetectorRun(4, corruptions, new FileSystemTestHelper().getTestRootDir() + "/corruption4.db");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testCorruptionDetectionSingleFolderCorruption() throws Exception {
        List<Long> corruptions = Collections.singletonList(16391L);
        String result = this.testCorruptionDetectorRun(5, corruptions, "");
        String expected = this.readExpectedFile("testSingleFolderCorruption.csv");
        Assert.assertEquals((Object)expected, (Object)result);
        result = this.testCorruptionDetectorRun(6, corruptions, new FileSystemTestHelper().getTestRootDir() + "/corruption6.db");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testCorruptionDetectionMultipleCorruption() throws Exception {
        List<Long> corruptions = Arrays.asList(16388L, 16389L, 16394L, 16391L);
        String result = this.testCorruptionDetectorRun(7, corruptions, "");
        String expected = this.readExpectedFile("testMultipleCorruption.csv");
        Assert.assertEquals((Object)expected, (Object)result);
        result = this.testCorruptionDetectorRun(8, corruptions, new FileSystemTestHelper().getTestRootDir() + "/corruption8.db");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private static void compareFile(FileStatus expected, FileStatus status) {
        Assert.assertEquals((long)expected.getAccessTime(), (long)status.getAccessTime());
        Assert.assertEquals((long)expected.getBlockSize(), (long)status.getBlockSize());
        Assert.assertEquals((Object)expected.getGroup(), (Object)status.getGroup());
        Assert.assertEquals((long)expected.getLen(), (long)status.getLen());
        Assert.assertEquals((long)expected.getModificationTime(), (long)status.getModificationTime());
        Assert.assertEquals((Object)expected.getOwner(), (Object)status.getOwner());
        Assert.assertEquals((Object)expected.getPermission(), (Object)status.getPermission());
        Assert.assertEquals((long)expected.getReplication(), (long)status.getReplication());
        Assert.assertEquals((Object)expected.isDirectory(), (Object)status.isDirectory());
    }

    private void verifyHttpResponseCode(int expectedCode, URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        Assert.assertEquals((long)expectedCode, (long)connection.getResponseCode());
    }

    @Test
    public void testReverseXmlRoundTrip() throws Throwable {
        GenericTestUtils.setLogLevel((Log)OfflineImageReconstructor.LOG, (Level)Level.TRACE);
        File reverseImageXml = new File(tempDir, "reverseImage.xml");
        File reverseImage = new File(tempDir, "reverseImage");
        File reverseImage2Xml = new File(tempDir, "reverseImage2.xml");
        LOG.info((Object)("Creating reverseImage.xml=" + reverseImageXml.getAbsolutePath() + ", reverseImage=" + reverseImage.getAbsolutePath() + ", reverseImage2Xml=" + reverseImage2Xml.getAbsolutePath()));
        if (OfflineImageViewerPB.run((String[])new String[]{"-p", "XML", "-i", originalFsimage.getAbsolutePath(), "-o", reverseImageXml.getAbsolutePath()}) != 0) {
            throw new IOException("oiv returned failure creating first XML file.");
        }
        if (OfflineImageViewerPB.run((String[])new String[]{"-p", "ReverseXML", "-i", reverseImageXml.getAbsolutePath(), "-o", reverseImage.getAbsolutePath()}) != 0) {
            throw new IOException("oiv returned failure recreating fsimage file.");
        }
        if (OfflineImageViewerPB.run((String[])new String[]{"-p", "XML", "-i", reverseImage.getAbsolutePath(), "-o", reverseImage2Xml.getAbsolutePath()}) != 0) {
            throw new IOException("oiv returned failure creating second XML file.");
        }
        Assert.assertEquals((Object)"", (Object)GenericTestUtils.getFilesDiff((File)reverseImageXml, (File)reverseImage2Xml));
    }

    @Test
    public void testReverseXmlWrongLayoutVersion() throws Throwable {
        File imageWrongVersion = new File(tempDir, "imageWrongVersion.xml");
        try (PrintWriter writer = new PrintWriter(imageWrongVersion, "UTF-8");){
            writer.println("<?xml version=\"1.0\"?>");
            writer.println("<fsimage>");
            writer.println("<version>");
            writer.println(String.format("<layoutVersion>%d</layoutVersion>", NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION + 1));
            writer.println("<onDiskVersion>1</onDiskVersion>");
            writer.println("<oivRevision>545bbef596c06af1c3c8dca1ce29096a64608478</oivRevision>");
            writer.println("</version>");
            writer.println("</fsimage>");
        }
        try {
            OfflineImageReconstructor.run((String)imageWrongVersion.getAbsolutePath(), (String)(imageWrongVersion.getAbsolutePath() + ".out"));
            Assert.fail((String)"Expected OfflineImageReconstructor to fail with version mismatch.");
        }
        catch (Throwable t) {
            GenericTestUtils.assertExceptionContains((String)"Layout version mismatch.", (Throwable)t);
        }
    }

    @Test
    public void testFileDistributionCalculatorForException() throws Exception {
        File fsimageFile = null;
        Configuration conf = new Configuration();
        HashMap files = Maps.newHashMap();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();){
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            Path dir = new Path("/dir");
            hdfs.mkdirs(dir);
            files.put(dir.toString(), TestOfflineImageViewer.pathToFileEntry((FileSystem)hdfs, dir.toString()));
            for (int i = 0; i < 4; ++i) {
                Path file = new Path(dir, "file" + i);
                DFSTestUtil.createFile((FileSystem)hdfs, file, 6 * i + 3, (short)1, 0L);
                files.put(file.toString(), TestOfflineImageViewer.pathToFileEntry((FileSystem)hdfs, file.toString()));
            }
            hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            hdfs.saveNamespace();
            fsimageFile = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
            if (fsimageFile == null) {
                throw new RuntimeException("Didn't generate or can't find fsimage");
            }
        }
        int status = OfflineImageViewerPB.run((String[])new String[]{"-i", fsimageFile.getAbsolutePath(), "-o", "-", "-p", "FileDistribution", "-maxSize", "23", "-step", "4"});
        Assert.assertEquals((long)0L, (long)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOfflineImageViewerMaxSizeAndStepOptions() throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        try {
            System.setOut(out);
            OfflineImageViewer.main((String[])new String[]{"-i", "-", "-o", "-", "-p", "FileDistribution", "-maxSize", "512", "-step", "8", "-h"});
            Assert.assertFalse((boolean)bytes.toString().contains("Error parsing command-line options: "));
        }
        finally {
            System.setOut(oldOut);
            IOUtils.closeStream((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOfflineImageViewerWithFormatOption() throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        try {
            System.setOut(out);
            int status = OfflineImageViewerPB.run((String[])new String[]{"-i", originalFsimage.getAbsolutePath(), "-o", "-", "-p", "FileDistribution", "-maxSize", "512", "-step", "8", "-format"});
            Assert.assertEquals((long)0L, (long)status);
            Assert.assertTrue((boolean)bytes.toString().contains("(0 B, 8 B]"));
        }
        finally {
            System.setOut(oldOut);
            IOUtils.closeStream((Closeable)out);
        }
    }

    private static String getXmlString(Element element, String name) {
        NodeList id = element.getElementsByTagName(name);
        Element line = (Element)id.item(0);
        if (line == null) {
            return "";
        }
        Node first = line.getFirstChild();
        if (first == null) {
            return "";
        }
        String val = first.getNodeValue();
        if (val == null) {
            return "";
        }
        return val;
    }

    @Test
    public void testOfflineImageViewerForECPolicies() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream o = new PrintStream(output);
        PBImageXmlWriter v = new PBImageXmlWriter(new Configuration(), o);
        v.visit(new RandomAccessFile(originalFsimage, "r"));
        String xml = output.toString();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList ecSection = dom.getElementsByTagName("ErasureCodingSection");
        Assert.assertEquals((long)1L, (long)ecSection.getLength());
        NodeList policies = dom.getElementsByTagName("erasureCodingPolicy");
        Assert.assertEquals((long)(1 + SystemErasureCodingPolicies.getPolicies().size()), (long)policies.getLength());
        for (int i = 0; i < policies.getLength(); ++i) {
            Element policy = (Element)policies.item(i);
            String name = TestOfflineImageViewer.getXmlString(policy, "policyName");
            if (!name.equals(addedErasureCodingPolicyName)) continue;
            String cellSize = TestOfflineImageViewer.getXmlString(policy, "cellSize");
            Assert.assertEquals((Object)"1024", (Object)cellSize);
            String state = TestOfflineImageViewer.getXmlString(policy, "policyState");
            Assert.assertEquals((Object)ErasureCodingPolicyState.ENABLED.toString(), (Object)state);
            Element schema = (Element)policy.getElementsByTagName("ecSchema").item(0);
            String codecName = TestOfflineImageViewer.getXmlString(schema, "codecName");
            Assert.assertEquals((Object)"rs", (Object)codecName);
            NodeList options = schema.getElementsByTagName("option");
            Assert.assertEquals((long)2L, (long)options.getLength());
            Element option1 = (Element)options.item(0);
            Assert.assertEquals((Object)"k1", (Object)TestOfflineImageViewer.getXmlString(option1, "key"));
            Assert.assertEquals((Object)"v1", (Object)TestOfflineImageViewer.getXmlString(option1, "value"));
            Element option2 = (Element)options.item(1);
            Assert.assertEquals((Object)"k2", (Object)TestOfflineImageViewer.getXmlString(option2, "key"));
            Assert.assertEquals((Object)"v2", (Object)TestOfflineImageViewer.getXmlString(option2, "value"));
        }
    }

    class ECXMLHandler
    extends DefaultHandler {
        private boolean isInode = false;
        private boolean isAttrRepl = false;
        private boolean isAttrName = false;
        private boolean isXAttrs = false;
        private boolean isAttrECPolicy = false;
        private boolean isAttrBlockType = false;
        private String currentInodeName;
        private String currentECPolicy;
        private String currentBlockType;
        private String currentRepl;

        ECXMLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (qName.equalsIgnoreCase("inode")) {
                this.isInode = true;
            } else if (this.isInode && !this.isXAttrs && qName.equalsIgnoreCase("name")) {
                this.isAttrName = true;
            } else if (this.isInode && qName.equalsIgnoreCase("replication")) {
                this.isAttrRepl = true;
            } else if (this.isInode && qName.equalsIgnoreCase("erasureCodingPolicyId")) {
                this.isAttrECPolicy = true;
            } else if (this.isInode && qName.equalsIgnoreCase("blockType")) {
                this.isAttrBlockType = true;
            } else if (this.isInode && qName.equalsIgnoreCase("xattrs")) {
                this.isXAttrs = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (qName.equalsIgnoreCase("inode")) {
                if (this.currentInodeName != null && this.currentInodeName.length() > 0 && this.currentBlockType != null && this.currentBlockType.equalsIgnoreCase(BlockType.STRIPED.name())) {
                    Assert.assertEquals((String)("INode '" + this.currentInodeName + "' has unexpected EC Policy!"), (long)Byte.parseByte(this.currentECPolicy), (long)4L);
                    Assert.assertEquals((String)("INode '" + this.currentInodeName + "' has unexpected replication!"), (Object)this.currentRepl, (Object)Short.toString((short)1));
                }
                this.isInode = false;
                this.currentInodeName = "";
                this.currentECPolicy = "";
                this.currentRepl = "";
            } else if (qName.equalsIgnoreCase("xattrs")) {
                this.isXAttrs = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            String value = new String(ch, start, length);
            if (this.isAttrName) {
                this.currentInodeName = value;
                this.isAttrName = false;
            } else if (this.isAttrRepl) {
                this.currentRepl = value;
                this.isAttrRepl = false;
            } else if (this.isAttrECPolicy) {
                this.currentECPolicy = value;
                this.isAttrECPolicy = false;
            } else if (this.isAttrBlockType) {
                this.currentBlockType = value;
                this.isAttrBlockType = false;
            }
        }
    }
}

