/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.tools.ECAdmin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestECAdmin {
    public static final Logger LOG = LoggerFactory.getLogger(TestECAdmin.class);
    private Configuration conf = new Configuration();
    private MiniDFSCluster cluster;
    private ECAdmin admin = new ECAdmin(this.conf);
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private static final PrintStream OLD_OUT = System.out;
    private static final PrintStream OLD_ERR = System.err;
    private static final String RS_3_2 = SystemErasureCodingPolicies.getByID((byte)2).getName();
    private static final String RS_6_3 = SystemErasureCodingPolicies.getByID((byte)1).getName();
    private static final String RS_10_4 = SystemErasureCodingPolicies.getByID((byte)5).getName();
    private static final String XOR_2_1 = SystemErasureCodingPolicies.getByID((byte)4).getName();
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Before
    public void setup() throws Exception {
        System.setOut(new PrintStream(this.out));
        System.setErr(new PrintStream(this.err));
    }

    @After
    public void tearDown() throws Exception {
        try {
            System.out.flush();
            System.err.flush();
            this.resetOutputs();
        }
        finally {
            System.setOut(OLD_OUT);
            System.setErr(OLD_ERR);
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testRS63MinDN() throws Exception {
        int numDataNodes = 6;
        int numRacks = 3;
        int expectedNumDataNodes = 9;
        this.cluster = DFSTestUtil.setupCluster(this.conf, 6, 3, 0);
        int ret = this.runCommandWithParams("-verifyClusterSetup");
        Assert.assertEquals((String)"Return value of the command is not successful", (long)2L, (long)ret);
        this.assertNotEnoughDataNodesMessage(RS_6_3, 6, 9);
    }

    @Test
    public void testRS104MinRacks() throws Exception {
        String testPolicy = RS_10_4;
        int numDataNodes = 15;
        int numRacks = 3;
        int expectedNumRacks = 4;
        this.cluster = DFSTestUtil.setupCluster(this.conf, 15, 3, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(RS_6_3);
        this.cluster.getFileSystem().enableErasureCodingPolicy(testPolicy);
        int ret = this.runCommandWithParams("-verifyClusterSetup");
        Assert.assertEquals((String)"Return value of the command is not successful", (long)2L, (long)ret);
        this.assertNotEnoughRacksMessage(testPolicy, 3, 4);
    }

    @Test
    public void testXOR21MinRacks() throws Exception {
        String testPolicy = XOR_2_1;
        int numDataNodes = 5;
        int numRacks = 2;
        int expectedNumRacks = 3;
        this.cluster = DFSTestUtil.setupCluster(this.conf, 5, 2, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(RS_6_3);
        this.cluster.getFileSystem().enableErasureCodingPolicy(testPolicy);
        int ret = this.runCommandWithParams("-verifyClusterSetup");
        Assert.assertEquals((String)"Return value of the command is not successful", (long)2L, (long)ret);
        this.assertNotEnoughRacksMessage(testPolicy, 2, 3);
    }

    @Test
    public void testRS32MinRacks() throws Exception {
        String testPolicy = RS_3_2;
        int numDataNodes = 5;
        int numRacks = 2;
        int expectedNumRacks = 3;
        this.cluster = DFSTestUtil.setupCluster(this.conf, 5, 2, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(RS_6_3);
        this.cluster.getFileSystem().enableErasureCodingPolicy(testPolicy);
        int ret = this.runCommandWithParams("-verifyClusterSetup");
        Assert.assertEquals((String)"Return value of the command is not successful", (long)2L, (long)ret);
        this.assertNotEnoughRacksMessage(testPolicy, 2, 3);
    }

    @Test
    public void testRS63Good() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 9, 3, 0);
        int ret = this.runCommandWithParams("-verifyClusterSetup");
        Assert.assertEquals((String)"Return value of the command is successful", (long)0L, (long)ret);
        Assert.assertTrue((String)"Result of cluster topology verify should be logged correctly", (boolean)this.out.toString().contains("The cluster setup can support EC policies: " + RS_6_3));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
    }

    @Test
    public void testNoECEnabled() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 9, 3, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(RS_6_3);
        int ret = this.runCommandWithParams("-verifyClusterSetup");
        Assert.assertEquals((String)"Return value of the command is successful", (long)0L, (long)ret);
        Assert.assertTrue((String)"Result of cluster topology verify should be logged correctly", (boolean)this.out.toString().contains("No erasure coding policy is given"));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
    }

    @Test
    public void testUnsuccessfulEnablePolicyMessage() throws Exception {
        String testPolicy = RS_3_2;
        int numDataNodes = 5;
        int numRacks = 2;
        this.cluster = DFSTestUtil.setupCluster(this.conf, 5, 2, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(RS_6_3);
        int ret = this.runCommandWithParams("-enablePolicy", "-policy", testPolicy);
        Assert.assertEquals((String)"Return value of the command is successful", (long)0L, (long)ret);
        Assert.assertTrue((String)"Enabling policy should be logged", (boolean)this.out.toString().contains("Erasure coding policy " + testPolicy + " is enabled"));
        Assert.assertTrue((String)"Warning about cluster topology should be printed", (boolean)this.err.toString().contains("Warning: The cluster setup does not support EC policy " + testPolicy + ". Reason:"));
        Assert.assertTrue((String)"Warning about cluster topology should be printed", (boolean)this.err.toString().contains(" racks are required for the erasure coding policies: " + testPolicy));
    }

    @Test
    public void testSuccessfulEnablePolicyMessage() throws Exception {
        String testPolicy = RS_3_2;
        this.cluster = DFSTestUtil.setupCluster(this.conf, 5, 3, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(RS_6_3);
        int ret = this.runCommandWithParams("-enablePolicy", "-policy", testPolicy);
        Assert.assertEquals((String)"Return value of the command is successful", (long)0L, (long)ret);
        Assert.assertTrue((String)"Enabling policy should be logged", (boolean)this.out.toString().contains("Erasure coding policy " + testPolicy + " is enabled"));
        Assert.assertFalse((String)"Warning about cluster topology should not be printed", (boolean)this.out.toString().contains("Warning: The cluster setup does not support"));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
    }

    @Test
    public void testEnableNonExistentPolicyMessage() throws Exception {
        this.cluster = DFSTestUtil.setupCluster(this.conf, 5, 3, 0);
        this.cluster.getFileSystem().disableErasureCodingPolicy(RS_6_3);
        int ret = this.runCommandWithParams("-enablePolicy", "-policy", "NonExistentPolicy");
        Assert.assertEquals((String)"Return value of the command is unsuccessful", (long)2L, (long)ret);
        Assert.assertFalse((String)"Enabling policy should not be logged when it was unsuccessful", (boolean)this.out.toString().contains("is enabled"));
        Assert.assertTrue((String)"Error message should be printed", (boolean)this.err.toString().contains("RemoteException: The policy name NonExistentPolicy does not exist"));
    }

    @Test
    public void testVerifyClusterSetupWithGivenPolicies() throws Exception {
        int numDataNodes = 5;
        int numRacks = 2;
        this.cluster = DFSTestUtil.setupCluster(this.conf, 5, 2, 0);
        int ret = this.runCommandWithParams("-verifyClusterSetup", "-policy", RS_3_2);
        Assert.assertEquals((String)"Return value of the command is not successful", (long)2L, (long)ret);
        this.assertNotEnoughRacksMessage(RS_3_2, 2, 3);
        this.resetOutputs();
        ret = this.runCommandWithParams("-verifyClusterSetup", "-policy", RS_10_4, RS_3_2);
        Assert.assertEquals((String)"Return value of the command is not successful", (long)2L, (long)ret);
        this.assertNotEnoughDataNodesMessage(RS_10_4 + ", " + RS_3_2, 5, 14);
        this.resetOutputs();
        ret = this.runCommandWithParams("-verifyClusterSetup", "-policy", "invalidPolicy");
        Assert.assertEquals((String)"Return value of the command is not successful", (long)-1L, (long)ret);
        Assert.assertTrue((String)"Error message should be logged", (boolean)this.err.toString().contains("The given erasure coding policy invalidPolicy does not exist."));
        this.resetOutputs();
        ret = this.runCommandWithParams("-verifyClusterSetup", "-policy");
        Assert.assertEquals((String)"Return value of the command is not successful", (long)-1L, (long)ret);
        Assert.assertTrue((String)"Error message should be logged", (boolean)this.err.toString().contains("NotEnoughArgumentsException: Not enough arguments: expected 1 but got 0"));
    }

    private void resetOutputs() {
        this.out.reset();
        this.err.reset();
    }

    private void assertNotEnoughDataNodesMessage(String policy, int numDataNodes, int expectedNumDataNodes) {
        Assert.assertTrue((String)"Result of cluster topology verify should be logged correctly", (boolean)this.out.toString().contains(expectedNumDataNodes + " DataNodes are required for the erasure coding policies: " + policy + ". The number of DataNodes is only " + numDataNodes));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
    }

    private void assertNotEnoughRacksMessage(String policy, int numRacks, int expectedNumRacks) {
        Assert.assertTrue((String)"Result of cluster topology verify should be logged correctly", (boolean)this.out.toString().contains(expectedNumRacks + " racks are required for the erasure coding policies: " + policy + ". The number of racks is only " + numRacks));
        Assert.assertTrue((String)"Error output should be empty", (boolean)this.err.toString().isEmpty());
    }

    private int runCommandWithParams(String ... args) throws Exception {
        int ret = this.admin.run(args);
        LOG.info("Command stdout: {}", (Object)this.out.toString());
        LOG.info("Command stderr: {}", (Object)this.err.toString());
        return ret;
    }
}

