/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FileSystemTestWrapper;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.client.CreateEncryptionZoneFlag;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.MockNameNodeResourceChecker;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.NameNodeResourceChecker;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.tools.NNHAServiceTarget;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNameNodeMetrics {
    private static final Configuration CONF = new HdfsConfiguration();
    private static final int DFS_REDUNDANCY_INTERVAL = 1;
    private static final Path TEST_ROOT_DIR_PATH = new Path("/testNameNodeMetrics");
    private static final String NN_METRICS = "NameNodeActivity";
    private static final String NS_METRICS = "FSNamesystem";
    private static final int BLOCK_SIZE = 0x100000;
    private static final ErasureCodingPolicy EC_POLICY = SystemErasureCodingPolicies.getByID((byte)4);
    public static final Log LOG = LogFactory.getLog(TestNameNodeMetrics.class);
    private static final int DATANODE_COUNT = EC_POLICY.getNumDataUnits() + EC_POLICY.getNumParityUnits() + 1;
    private static final int WAIT_GAUGE_VALUE_RETRIES = 20;
    private static final int PERCENTILES_INTERVAL = 1;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private final Random rand = new Random();
    private FSNamesystem namesystem;
    private HostsFileWriter hostsFileWriter;
    private BlockManager bm;
    private Path ecDir;

    private static Path getTestPath(String fileName) {
        return new Path(TEST_ROOT_DIR_PATH, fileName);
    }

    @Before
    public void setUp() throws Exception {
        this.hostsFileWriter = new HostsFileWriter();
        this.hostsFileWriter.initialize(CONF, "temp/decommission");
        this.cluster = new MiniDFSCluster.Builder(CONF).numDataNodes(DATANODE_COUNT).build();
        this.cluster.waitActive();
        this.namesystem = this.cluster.getNamesystem();
        this.bm = this.namesystem.getBlockManager();
        this.fs = this.cluster.getFileSystem();
        this.fs.enableErasureCodingPolicy(EC_POLICY.getName());
        this.ecDir = TestNameNodeMetrics.getTestPath("/ec");
        this.fs.mkdirs(this.ecDir);
        this.fs.setErasureCodingPolicy(this.ecDir, EC_POLICY.getName());
    }

    @After
    public void tearDown() throws Exception {
        MetricsSource source = DefaultMetricsSystem.instance().getSource("UgiMetrics");
        if (source != null) {
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)source);
            MetricsAsserts.assertQuantileGauges((String)"GetGroups1s", (MetricsRecordBuilder)rb);
        }
        if (this.hostsFileWriter != null) {
            this.hostsFileWriter.cleanup();
            this.hostsFileWriter = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void createFile(Path file, long fileLen, short replicas) throws IOException {
        DFSTestUtil.createFile((FileSystem)this.fs, file, fileLen, replicas, this.rand.nextLong());
    }

    private void readFile(FileSystem fileSys, Path name) throws IOException {
        FSDataInputStream stm = fileSys.open(name);
        byte[] buffer = new byte[4];
        stm.read(buffer, 0, 4);
        stm.close();
    }

    @Test(timeout=10000L)
    public void testCapacityMetrics() throws Exception {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NS_METRICS);
        long capacityTotal = MetricsAsserts.getLongGauge((String)"CapacityTotal", (MetricsRecordBuilder)rb);
        assert (capacityTotal != 0L);
        long capacityUsed = MetricsAsserts.getLongGauge((String)"CapacityUsed", (MetricsRecordBuilder)rb);
        long capacityRemaining = MetricsAsserts.getLongGauge((String)"CapacityRemaining", (MetricsRecordBuilder)rb);
        long capacityUsedNonDFS = MetricsAsserts.getLongGauge((String)"CapacityUsedNonDFS", (MetricsRecordBuilder)rb);
        assert (capacityUsed + capacityRemaining + capacityUsedNonDFS <= capacityTotal);
    }

    @Test
    public void testStaleNodes() throws Exception {
        DataNode dn;
        int i;
        for (i = 0; i < 2; ++i) {
            dn = this.cluster.getDataNodes().get(i);
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
            long staleInterval = CONF.getLong("dfs.namenode.stale.datanode.interval", 30000L);
            DatanodeDescriptor dnDes = this.cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId());
            DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dnDes, -(staleInterval + 1L));
        }
        BlockManagerTestUtil.checkHeartbeat(this.cluster.getNameNode().getNamesystem().getBlockManager());
        MetricsAsserts.assertGauge((String)"StaleDataNodes", (int)2, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        for (i = 0; i < 2; ++i) {
            dn = this.cluster.getDataNodes().get(i);
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, false);
            DatanodeDescriptor dnDes = this.cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId());
            DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dnDes, 0L);
        }
        BlockManagerTestUtil.checkHeartbeat(this.cluster.getNameNode().getNamesystem().getBlockManager());
        MetricsAsserts.assertGauge((String)"StaleDataNodes", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
    }

    @Test
    public void testVolumeFailures() throws Exception {
        MetricsAsserts.assertGauge((String)"VolumeFailuresTotal", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"EstimatedCapacityLostTotal", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        DataNode dn = this.cluster.getDataNodes().get(0);
        FsDatasetSpi.FsVolumeReferences volumeReferences = DataNodeTestUtils.getFSDataset(dn).getFsVolumeReferences();
        FsVolumeImpl fsVolume = (FsVolumeImpl)volumeReferences.get(0);
        File dataDir = new File(fsVolume.getBaseURI());
        long capacity = fsVolume.getCapacity();
        volumeReferences.close();
        DataNodeTestUtils.injectDataDirFailure(dataDir);
        DataNodeTestUtils.waitForDiskError(dn, (FsVolumeSpi)fsVolume);
        DataNodeTestUtils.triggerHeartbeat(dn);
        BlockManagerTestUtil.checkHeartbeat(this.bm);
        MetricsAsserts.assertGauge((String)"VolumeFailuresTotal", (int)1, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"EstimatedCapacityLostTotal", (long)capacity, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
    }

    @Test
    public void testDataNodeLivenessAndDecom() throws Exception {
        int i;
        int i2;
        ArrayList<DataNode> dataNodes = this.cluster.getDataNodes();
        DatanodeDescriptor[] dnDescriptors = new DatanodeDescriptor[DATANODE_COUNT];
        String[] dnAddresses = new String[DATANODE_COUNT];
        for (i2 = 0; i2 < DATANODE_COUNT; ++i2) {
            dnDescriptors[i2] = this.bm.getDatanodeManager().getDatanode(((DataNode)dataNodes.get(i2)).getDatanodeId());
            dnAddresses[i2] = dnDescriptors[i2].getXferAddr();
        }
        this.hostsFileWriter.initIncludeHosts(dnAddresses);
        this.bm.getDatanodeManager().refreshNodes(CONF);
        MetricsAsserts.assertGauge((String)"NumDecomLiveDataNodes", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumLiveDataNodes", (int)DATANODE_COUNT, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        this.hostsFileWriter.initExcludeHost(dnAddresses[0]);
        this.bm.getDatanodeManager().refreshNodes(CONF);
        MetricsAsserts.assertGauge((String)"NumDecommissioningDataNodes", (int)1, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        BlockManagerTestUtil.recheckDecommissionState(this.bm.getDatanodeManager());
        MetricsAsserts.assertGauge((String)"NumDecommissioningDataNodes", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumDecomLiveDataNodes", (int)1, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumLiveDataNodes", (int)DATANODE_COUNT, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        for (i2 = 0; i2 < DATANODE_COUNT; ++i2) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests((DataNode)dataNodes.get(i2), true);
            long expireInterval = CONF.getLong("dfs.namenode.heartbeat.recheck-interval", 300000L) * 2L + CONF.getLong("dfs.heartbeat.interval", 3L) * 10L * 1000L;
            DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dnDescriptors[i2], -(expireInterval + 1L));
        }
        BlockManagerTestUtil.checkHeartbeat(this.bm);
        MetricsAsserts.assertGauge((String)"NumDecomLiveDataNodes", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumDecomDeadDataNodes", (int)1, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumLiveDataNodes", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumDeadDataNodes", (int)DATANODE_COUNT, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        String[] includeHosts = new String[dnAddresses.length - 1];
        for (i = 0; i < includeHosts.length; ++i) {
            includeHosts[i] = dnAddresses[i + 1];
        }
        this.hostsFileWriter.initIncludeHosts(includeHosts);
        this.hostsFileWriter.initExcludeHosts(new ArrayList<String>());
        this.bm.getDatanodeManager().refreshNodes(CONF);
        MetricsAsserts.assertGauge((String)"NumDecomLiveDataNodes", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumDecomDeadDataNodes", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumLiveDataNodes", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumDeadDataNodes", (int)(DATANODE_COUNT - 1), (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        for (i = 1; i < dataNodes.size(); ++i) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests((DataNode)dataNodes.get(i), false);
            DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dnDescriptors[i], 0L);
        }
        BlockManagerTestUtil.checkHeartbeat(this.bm);
        MetricsAsserts.assertGauge((String)"NumLiveDataNodes", (int)(DATANODE_COUNT - 1), (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumDeadDataNodes", (int)0, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
    }

    @Test
    public void testFileAdd() throws Exception {
        long blockCount = 32L;
        Path normalFile = TestNameNodeMetrics.getTestPath("testFileAdd");
        this.createFile(normalFile, 0x2000000L, (short)3);
        Path ecFile = new Path(this.ecDir, "ecFile.log");
        DFSTestUtil.createStripedFile(this.cluster, ecFile, null, 32, 1, false, EC_POLICY);
        int blockCapacity = this.namesystem.getBlockCapacity();
        MetricsAsserts.assertGauge((String)"BlockCapacity", (int)blockCapacity, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NN_METRICS);
        MetricsAsserts.assertCounter((String)"CreateFileOps", (long)2L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"FilesCreated", (long)(normalFile.depth() + ecFile.depth()), (MetricsRecordBuilder)rb);
        long filesTotal = normalFile.depth() + ecFile.depth() + 1;
        rb = MetricsAsserts.getMetrics((String)NS_METRICS);
        MetricsAsserts.assertGauge((String)"FilesTotal", (long)filesTotal, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"BlocksTotal", (long)64L, (MetricsRecordBuilder)rb);
        this.fs.delete(normalFile, true);
        rb = this.waitForDnMetricValue(NS_METRICS, "FilesTotal", --filesTotal);
        MetricsAsserts.assertGauge((String)"BlocksTotal", (long)32L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingDeletionBlocks", (long)0L, (MetricsRecordBuilder)rb);
        this.fs.delete(ecFile, true);
        rb = this.waitForDnMetricValue(NS_METRICS, "FilesTotal", --filesTotal);
        MetricsAsserts.assertGauge((String)"BlocksTotal", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingDeletionBlocks", (long)0L, (MetricsRecordBuilder)rb);
        rb = MetricsAsserts.getMetrics((String)NN_METRICS);
        MetricsAsserts.assertCounter((String)"DeleteFileOps", (long)2L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"FilesDeleted", (long)2L, (MetricsRecordBuilder)rb);
    }

    private void verifyZeroMetrics() throws Exception {
        BlockManagerTestUtil.updateState(this.bm);
        MetricsRecordBuilder rb = this.waitForDnMetricValue(NS_METRICS, "CorruptBlocks", 0L, 500L);
        MetricsAsserts.assertGauge((String)"UnderReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"LowRedundancyBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingReplicationBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingReconstructionBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"LowRedundancyReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"CorruptReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"HighestPriorityLowRedundancyReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"LowRedundancyECBlockGroups", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"CorruptECBlockGroups", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"HighestPriorityLowRedundancyECBlocks", (long)0L, (MetricsRecordBuilder)rb);
    }

    private void verifyAggregatedMetricsTally() throws Exception {
        BlockManagerTestUtil.updateState(this.bm);
        Assert.assertEquals((String)"Under replicated metrics not matching!", (long)this.namesystem.getLowRedundancyBlocks(), (long)this.namesystem.getUnderReplicatedBlocks());
        Assert.assertEquals((String)"Low redundancy metrics not matching!", (long)this.namesystem.getLowRedundancyBlocks(), (long)(this.namesystem.getLowRedundancyReplicatedBlocks() + this.namesystem.getLowRedundancyECBlockGroups()));
        Assert.assertEquals((String)"Corrupt blocks metrics not matching!", (long)this.namesystem.getCorruptReplicaBlocks(), (long)(this.namesystem.getCorruptReplicatedBlocks() + this.namesystem.getCorruptECBlockGroups()));
        Assert.assertEquals((String)"Missing blocks metrics not matching!", (long)this.namesystem.getMissingBlocksCount(), (long)(this.namesystem.getMissingReplicatedBlocks() + this.namesystem.getMissingECBlockGroups()));
        Assert.assertEquals((String)"Missing blocks with replication factor one not matching!", (long)this.namesystem.getMissingReplOneBlocksCount(), (long)this.namesystem.getMissingReplicationOneBlocks());
        Assert.assertEquals((String)"Bytes in future blocks metrics not matching!", (long)this.namesystem.getBytesInFuture(), (long)(this.namesystem.getBytesInFutureReplicatedBlocks() + this.namesystem.getBytesInFutureECBlockGroups()));
        Assert.assertEquals((String)"Pending deletion blocks metrics not matching!", (long)this.namesystem.getPendingDeletionBlocks(), (long)(this.namesystem.getPendingDeletionReplicatedBlocks() + this.namesystem.getPendingDeletionECBlocks()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptBlock() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testCorruptBlock");
        int replicaCount = 2;
        this.createFile(file, 100L, (short)2);
        DFSTestUtil.waitForReplication(this.fs, file, (short)2, 15000);
        for (DataNode dn : this.cluster.getDataNodes()) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
        }
        this.verifyZeroMetrics();
        this.verifyAggregatedMetricsTally();
        LocatedBlock block = NameNodeAdapter.getBlockLocations(this.cluster.getNameNode(), file.toString(), 0L, 1L).get(0);
        this.cluster.getNamesystem().writeLock();
        try {
            this.bm.findAndMarkBlockAsCorrupt(block.getBlock(), block.getLocations()[0], "STORAGE_ID", "TEST");
        }
        finally {
            this.cluster.getNamesystem().writeUnlock();
        }
        BlockManagerTestUtil.updateState(this.bm);
        MetricsRecordBuilder rb = this.waitForDnMetricValue(NS_METRICS, "CorruptBlocks", 1L, 500L);
        MetricsAsserts.assertGauge((String)"LowRedundancyBlocks", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingReplicationBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingReconstructionBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"LowRedundancyReplicatedBlocks", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"CorruptReplicatedBlocks", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"HighestPriorityLowRedundancyReplicatedBlocks", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"LowRedundancyECBlockGroups", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"CorruptECBlockGroups", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"HighestPriorityLowRedundancyECBlocks", (long)0L, (MetricsRecordBuilder)rb);
        this.verifyAggregatedMetricsTally();
        for (DataNode dn : this.cluster.getDataNodes()) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, false);
        }
        BlockManagerTestUtil.getComputedDatanodeWork(this.bm);
        BlockManagerTestUtil.updateState(this.bm);
        DFSTestUtil.waitForReplication(this.fs, file, (short)2, 30000);
        rb = this.waitForDnMetricValue(NS_METRICS, "CorruptBlocks", 0L, 500L);
        MetricsAsserts.assertGauge((String)"LowRedundancyBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"CorruptBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingReplicationBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingReconstructionBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"LowRedundancyReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"CorruptReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"HighestPriorityLowRedundancyReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"LowRedundancyECBlockGroups", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"CorruptECBlockGroups", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"HighestPriorityLowRedundancyECBlocks", (long)0L, (MetricsRecordBuilder)rb);
        this.verifyAggregatedMetricsTally();
        this.fs.delete(file, true);
        BlockManagerTestUtil.getComputedDatanodeWork(this.bm);
        BlockManagerTestUtil.updateState(this.bm);
        this.waitForDnMetricValue(NS_METRICS, "CorruptBlocks", 0L, 500L);
        this.verifyZeroMetrics();
        this.verifyAggregatedMetricsTally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=90000L)
    public void testStripedFileCorruptBlocks() throws Exception {
        long fileLen = 0x400000L;
        Path ecFile = new Path(this.ecDir, "ecFile.log");
        DFSTestUtil.createFile((FileSystem)this.fs, ecFile, 0x400000L, (short)1, 0L);
        StripedFileTestUtil.waitBlockGroupsReported(this.fs, ecFile.toString());
        for (DataNode dn : this.cluster.getDataNodes()) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
        }
        this.verifyZeroMetrics();
        this.verifyAggregatedMetricsTally();
        LocatedBlocks lbs = this.fs.getClient().getNamenode().getBlockLocations(ecFile.toString(), 0L, 0x400000L);
        assert (lbs.get(0) instanceof LocatedStripedBlock);
        LocatedStripedBlock bg = (LocatedStripedBlock)lbs.get(0);
        this.cluster.getNamesystem().writeLock();
        try {
            this.bm.findAndMarkBlockAsCorrupt(bg.getBlock(), bg.getLocations()[0], "STORAGE_ID", "TEST");
        }
        finally {
            this.cluster.getNamesystem().writeUnlock();
        }
        BlockManagerTestUtil.updateState(this.bm);
        MetricsRecordBuilder rb = this.waitForDnMetricValue(NS_METRICS, "CorruptBlocks", 1L, 500L);
        MetricsAsserts.assertGauge((String)"LowRedundancyBlocks", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingReplicationBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingReconstructionBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"LowRedundancyReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"CorruptReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"HighestPriorityLowRedundancyReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"LowRedundancyECBlockGroups", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"CorruptECBlockGroups", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"HighestPriorityLowRedundancyECBlocks", (long)1L, (MetricsRecordBuilder)rb);
        this.verifyAggregatedMetricsTally();
        for (DataNode dn : this.cluster.getDataNodes()) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, false);
        }
        BlockManagerTestUtil.getComputedDatanodeWork(this.bm);
        BlockManagerTestUtil.updateState(this.bm);
        StripedFileTestUtil.waitForReconstructionFinished(ecFile, this.fs, 3);
        rb = this.waitForDnMetricValue(NS_METRICS, "CorruptBlocks", 0L, 500L);
        MetricsAsserts.assertGauge((String)"CorruptBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingReplicationBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingReconstructionBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"LowRedundancyReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"CorruptReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"HighestPriorityLowRedundancyReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"LowRedundancyECBlockGroups", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"CorruptECBlockGroups", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"HighestPriorityLowRedundancyECBlocks", (long)0L, (MetricsRecordBuilder)rb);
        this.verifyAggregatedMetricsTally();
        this.fs.delete(ecFile, true);
        BlockManagerTestUtil.getComputedDatanodeWork(this.bm);
        BlockManagerTestUtil.updateState(this.bm);
        this.waitForDnMetricValue(NS_METRICS, "CorruptBlocks", 0L, 500L);
        this.verifyZeroMetrics();
        this.verifyAggregatedMetricsTally();
    }

    @Test
    public void testExcessBlocks() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testExcessBlocks");
        this.createFile(file, 100L, (short)2);
        NameNodeAdapter.setReplication(this.namesystem, file.toString(), (short)1);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NS_METRICS);
        MetricsAsserts.assertGauge((String)"ExcessBlocks", (long)1L, (MetricsRecordBuilder)rb);
        this.fs.delete(file, true);
        rb = MetricsAsserts.getMetrics((String)NS_METRICS);
        MetricsAsserts.assertGauge((String)"ExcessBlocks", (long)0L, (MetricsRecordBuilder)rb);
        Assert.assertEquals((long)0L, (long)this.bm.getExcessBlocksCount());
    }

    @Test
    public void testMissingBlock() throws Exception {
        Path file = TestNameNodeMetrics.getTestPath("testMissingBlocks");
        this.createFile(file, 100L, (short)1);
        LocatedBlock block = NameNodeAdapter.getBlockLocations(this.cluster.getNameNode(), file.toString(), 0L, 1L).get(0);
        this.cluster.getNamesystem().writeLock();
        try {
            this.bm.findAndMarkBlockAsCorrupt(block.getBlock(), block.getLocations()[0], "STORAGE_ID", "TEST");
        }
        finally {
            this.cluster.getNamesystem().writeUnlock();
        }
        Thread.sleep(1000L);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NS_METRICS);
        MetricsAsserts.assertGauge((String)"UnderReplicatedBlocks", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"MissingBlocks", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"MissingReplOneBlocks", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"HighestPriorityLowRedundancyReplicatedBlocks", (long)0L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"HighestPriorityLowRedundancyECBlocks", (long)0L, (MetricsRecordBuilder)rb);
        this.fs.delete(file, true);
        this.waitForDnMetricValue(NS_METRICS, "UnderReplicatedBlocks", 0L);
    }

    private void waitForDeletion() throws InterruptedException {
        Thread.sleep(1 * DATANODE_COUNT * 1000);
    }

    private MetricsRecordBuilder waitForDnMetricValue(String source, String name, long expected) throws Exception {
        this.waitForDeletion();
        return this.waitForDnMetricValue(source, name, expected, 500L);
    }

    private MetricsRecordBuilder waitForDnMetricValue(String source, String name, long expected, long sleepInterval) throws Exception {
        int retries = DATANODE_COUNT * 20;
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)source);
        long gauge = MetricsAsserts.getLongGauge((String)name, (MetricsRecordBuilder)rb);
        while (gauge != expected && --retries > 0) {
            Thread.sleep(sleepInterval);
            BlockManagerTestUtil.updateState(this.bm);
            rb = MetricsAsserts.getMetrics((String)source);
            gauge = MetricsAsserts.getLongGauge((String)name, (MetricsRecordBuilder)rb);
        }
        MetricsAsserts.assertGauge((String)name, (long)expected, (MetricsRecordBuilder)rb);
        return rb;
    }

    @Test
    public void testRenameMetrics() throws Exception {
        Path src = TestNameNodeMetrics.getTestPath("src");
        this.createFile(src, 100L, (short)1);
        Path target = TestNameNodeMetrics.getTestPath("target");
        this.createFile(target, 100L, (short)1);
        this.fs.rename(src, target, new Options.Rename[]{Options.Rename.OVERWRITE});
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NN_METRICS);
        MetricsAsserts.assertCounter((String)"FilesRenamed", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"FilesDeleted", (long)1L, (MetricsRecordBuilder)rb);
    }

    @Test
    public void testGetBlockLocationMetric() throws Exception {
        Path file1_Path = new Path(TEST_ROOT_DIR_PATH, "file1.dat");
        MetricsAsserts.assertCounter((String)"GetBlockLocations", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.createFile(file1_Path, 100L, (short)2);
        MetricsAsserts.assertCounter((String)"GetBlockLocations", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.readFile((FileSystem)this.fs, file1_Path);
        MetricsAsserts.assertCounter((String)"GetBlockLocations", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
        this.readFile((FileSystem)this.fs, file1_Path);
        this.readFile((FileSystem)this.fs, file1_Path);
        MetricsAsserts.assertCounter((String)"GetBlockLocations", (long)3L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NN_METRICS));
    }

    @Test(timeout=300000L)
    public void testTransactionSinceLastCheckpointMetrics() throws Exception {
        Random random = new Random();
        for (int retryCount = 0; retryCount < 5; ++retryCount) {
            try {
                int basePort = 10060 + random.nextInt(100) * 2;
                MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ns1").addNN(new MiniDFSNNTopology.NNConf("nn1").setHttpPort(basePort)).addNN(new MiniDFSNNTopology.NNConf("nn2").setHttpPort(basePort + 1)));
                HdfsConfiguration conf2 = new HdfsConfiguration();
                conf2.setInt("dfs.namenode.checkpoint.txns", 100);
                conf2.setInt("dfs.namenode.checkpoint.check.period", 1);
                conf2.setInt("dfs.ha.tail-edits.period", 1);
                MiniDFSCluster cluster2 = new MiniDFSCluster.Builder((Configuration)conf2).nnTopology(topology).numDataNodes(1).build();
                cluster2.waitActive();
                DistributedFileSystem fs2 = cluster2.getFileSystem(0);
                NameNode nn0 = cluster2.getNameNode(0);
                NameNode nn1 = cluster2.getNameNode(1);
                cluster2.transitionToActive(0);
                fs2.mkdirs(new Path("/tmp-t1"));
                fs2.mkdirs(new Path("/tmp-t2"));
                HATestUtil.waitForStandbyToCatchUp(nn0, nn1);
                Assert.assertEquals((String)"SBN failed to track 2 transactions pre-checkpoint.", (long)4L, (long)cluster2.getNameNode(1).getNamesystem().getTransactionsSinceLastCheckpoint());
                for (int i = 1; i <= 94; ++i) {
                    fs2.mkdirs(new Path("/tmp-" + i));
                }
                HATestUtil.waitForStandbyToCatchUp(nn0, nn1);
                HATestUtil.waitForCheckpoint(cluster2, 1, (List<Integer>)ImmutableList.of((Object)100));
                Assert.assertEquals((String)"Should be zero right after the checkpoint.", (long)0L, (long)cluster2.getNameNode(1).getNamesystem().getTransactionsSinceLastCheckpoint());
                fs2.mkdirs(new Path("/tmp-t3"));
                fs2.mkdirs(new Path("/tmp-t4"));
                HATestUtil.waitForStandbyToCatchUp(nn0, nn1);
                Assert.assertEquals((String)"SBN failed to track 2 added txns after the ckpt.", (long)4L, (long)cluster2.getNameNode(1).getNamesystem().getTransactionsSinceLastCheckpoint());
                cluster2.shutdown();
                break;
            }
            catch (Exception e) {
                LOG.warn((Object)("Unable to set up HA cluster, exception thrown: " + e));
                continue;
            }
        }
    }

    @Test
    public void testTransactionAndCheckpointMetrics() throws Exception {
        long lastCkptTime = MetricsAsserts.getLongGauge((String)"LastCheckpointTime", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"LastCheckpointTime", (long)lastCkptTime, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"LastWrittenTransactionId", (long)4L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"TransactionsSinceLastCheckpoint", (long)4L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"TransactionsSinceLastLogRoll", (long)4L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        this.fs.mkdirs(new Path(TEST_ROOT_DIR_PATH, "/tmp"));
        MetricsAsserts.assertGauge((String)"LastCheckpointTime", (long)lastCkptTime, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"LastWrittenTransactionId", (long)5L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"TransactionsSinceLastCheckpoint", (long)5L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"TransactionsSinceLastLogRoll", (long)5L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        this.cluster.getNameNodeRpc().rollEditLog();
        MetricsAsserts.assertGauge((String)"LastCheckpointTime", (long)lastCkptTime, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"LastWrittenTransactionId", (long)7L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"TransactionsSinceLastCheckpoint", (long)7L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"TransactionsSinceLastLogRoll", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        this.cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
        this.cluster.getNameNodeRpc().saveNamespace(0L, 0L);
        this.cluster.getNameNodeRpc().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
        long newLastCkptTime = MetricsAsserts.getLongGauge((String)"LastCheckpointTime", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        Assert.assertTrue((lastCkptTime < newLastCkptTime ? 1 : 0) != 0);
        MetricsAsserts.assertGauge((String)"LastWrittenTransactionId", (long)9L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"TransactionsSinceLastCheckpoint", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"TransactionsSinceLastLogRoll", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
    }

    @Test
    public void testSyncAndBlockReportMetric() throws Exception {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NN_METRICS);
        MetricsAsserts.assertCounter((String)"SyncsNumOps", (long)4L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"StorageBlockReportNumOps", (long)((long)DATANODE_COUNT * (long)this.cluster.getStoragesPerDatanode()), (MetricsRecordBuilder)rb);
        Thread.sleep(2000L);
        MetricsAsserts.assertQuantileGauges((String)"Syncs1s", (MetricsRecordBuilder)rb);
        MetricsAsserts.assertQuantileGauges((String)"StorageBlockReport1s", (MetricsRecordBuilder)rb);
    }

    @Test
    public void testReadWriteOps() throws Exception {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NN_METRICS);
        long startWriteCounter = MetricsAsserts.getLongCounter((String)"TransactionsNumOps", (MetricsRecordBuilder)rb);
        Path file1_Path = new Path(TEST_ROOT_DIR_PATH, "ReadData.dat");
        this.createFile(file1_Path, 1024L, (short)2);
        this.readFile((FileSystem)this.fs, file1_Path);
        MetricsRecordBuilder rbNew = MetricsAsserts.getMetrics((String)NN_METRICS);
        Assert.assertTrue((MetricsAsserts.getLongCounter((String)"TransactionsNumOps", (MetricsRecordBuilder)rbNew) > startWriteCounter ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNumActiveClientsAndFilesUnderConstructionMetrics() throws Exception {
        Path file1 = TestNameNodeMetrics.getTestPath("testFileAdd1");
        this.createFile(file1, 100L, (short)3);
        MetricsAsserts.assertGauge((String)"NumActiveClients", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumFilesUnderConstruction", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        Path file2 = new Path("/testFileAdd2");
        FSDataOutputStream output2 = this.fs.create(file2);
        output2.writeBytes("Some test data");
        MetricsAsserts.assertGauge((String)"NumActiveClients", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumFilesUnderConstruction", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        Path file3 = new Path("/testFileAdd3");
        FSDataOutputStream output3 = this.fs.create(file3);
        output3.writeBytes("Some test data");
        MetricsAsserts.assertGauge((String)"NumActiveClients", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        MetricsAsserts.assertGauge((String)"NumFilesUnderConstruction", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        try (DistributedFileSystem fs1 = (DistributedFileSystem)this.cluster.getNewFileSystemInstance(0);){
            Path file4 = new Path("/testFileAdd4");
            FSDataOutputStream output4 = fs1.create(file4);
            output4.writeBytes("Some test data");
            MetricsAsserts.assertGauge((String)"NumActiveClients", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
            MetricsAsserts.assertGauge((String)"NumFilesUnderConstruction", (long)3L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
            Path file5 = new Path("/testFileAdd35");
            FSDataOutputStream output5 = fs1.create(file5);
            output5.writeBytes("Some test data");
            MetricsAsserts.assertGauge((String)"NumActiveClients", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
            MetricsAsserts.assertGauge((String)"NumFilesUnderConstruction", (long)4L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
            output2.close();
            output3.close();
            MetricsAsserts.assertGauge((String)"NumActiveClients", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
            MetricsAsserts.assertGauge((String)"NumFilesUnderConstruction", (long)2L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
            output4.close();
            output5.close();
            MetricsAsserts.assertGauge((String)"NumActiveClients", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
            MetricsAsserts.assertGauge((String)"NumFilesUnderConstruction", (long)0L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)NS_METRICS));
        }
    }

    @Test
    public void testGenerateEDEKTime() throws IOException, NoSuchAlgorithmException {
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystemTestHelper fsHelper = new FileSystemTestHelper();
        String testRoot = fsHelper.getTestRootDir();
        File testRootDir = new File(testRoot).getAbsoluteFile();
        conf.set("hadoop.security.key.provider.path", "jceks://file" + new Path(testRootDir.toString(), "test.jks").toUri());
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        conf.setInt("dfs.namenode.list.encryption.zones.num.responses", 2);
        try (MiniDFSCluster clusterEDEK = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();){
            DistributedFileSystem fsEDEK = clusterEDEK.getFileSystem();
            FileSystemTestWrapper fsWrapper = new FileSystemTestWrapper((FileSystem)fsEDEK);
            HdfsAdmin dfsAdmin = new HdfsAdmin(clusterEDEK.getURI(), (Configuration)conf);
            fsEDEK.getClient().setKeyProvider((KeyProvider)clusterEDEK.getNameNode().getNamesystem().getProvider());
            String testKey = "test_key";
            DFSTestUtil.createKey(testKey, clusterEDEK, (Configuration)conf);
            Path zoneParent = new Path("/zones");
            Path zone1 = new Path(zoneParent, "zone1");
            fsWrapper.mkdir(zone1, FsPermission.getDirDefault(), true);
            dfsAdmin.createEncryptionZone(zone1, "test_key", EnumSet.of(CreateEncryptionZoneFlag.NO_TRASH));
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NN_METRICS);
            for (int i = 0; i < 3; ++i) {
                Path filePath = new Path("/zones/zone1/testfile-" + i);
                DFSTestUtil.createFile((FileSystem)fsEDEK, filePath, 1024L, (short)3, 1L);
                MetricsAsserts.assertQuantileGauges((String)"GenerateEDEKTime1s", (MetricsRecordBuilder)rb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceCheck() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster tmpCluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
        try {
            MockNameNodeResourceChecker mockResourceChecker = new MockNameNodeResourceChecker((Configuration)conf);
            tmpCluster.getNameNode(0).getNamesystem().setNNResourceChecker((NameNodeResourceChecker)mockResourceChecker);
            NNHAServiceTarget haTarget = new NNHAServiceTarget((Configuration)conf, DFSUtil.getNamenodeNameServiceId((Configuration)new HdfsConfiguration()), "nn1");
            HAServiceProtocol rpc = haTarget.getHealthMonitorProxy((Configuration)conf, conf.getInt("ha.health-monitor.rpc-timeout.ms", 45000));
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)NN_METRICS);
            for (long i = 0L; i < 10L; ++i) {
                rpc.monitorHealth();
                MetricsAsserts.assertQuantileGauges((String)"ResourceCheckTime1s", (MetricsRecordBuilder)rb);
            }
        }
        finally {
            if (tmpCluster != null) {
                tmpCluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditLogTailing() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.ha.tail-edits.period", 1);
        conf.setInt("dfs.metrics.percentiles.intervals", 60);
        MiniDFSCluster dfsCluster = null;
        try {
            dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
            DistributedFileSystem dfs = dfsCluster.getFileSystem(0);
            dfsCluster.transitionToActive(0);
            dfsCluster.waitActive();
            Path testDir = new Path("/testdir");
            dfs.mkdir(testDir, FsPermission.getDefault());
            dfsCluster.getNameNodeRpc(0).rollEditLog();
            Thread.sleep(2000L);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)"NameNodeActivity-2");
            MetricsAsserts.assertQuantileGauges((String)"EditLogTailTime60s", (MetricsRecordBuilder)rb);
            MetricsAsserts.assertQuantileGauges((String)"EditLogFetchTime60s", (MetricsRecordBuilder)rb);
            MetricsAsserts.assertQuantileGauges((String)"NumEditLogLoaded60s", (MetricsRecordBuilder)rb, (String)"Count");
            MetricsAsserts.assertQuantileGauges((String)"EditLogTailInterval60s", (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounterGt((String)"EditLogTailTimeNumOps", (long)0L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounterGt((String)"EditLogFetchTimeNumOps", (long)0L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounterGt((String)"NumEditLogLoadedNumOps", (long)0L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounterGt((String)"EditLogTailIntervalNumOps", (long)0L, (MetricsRecordBuilder)rb);
        }
        finally {
            if (dfsCluster != null) {
                dfsCluster.shutdown();
            }
        }
    }

    static {
        CONF.setLong("dfs.blocksize", 0x100000L);
        CONF.setInt("dfs.bytes-per-checksum", 1);
        CONF.setLong("dfs.heartbeat.interval", 1L);
        CONF.setTimeDuration("dfs.namenode.decommission.interval.testing", 999L, TimeUnit.DAYS);
        CONF.setTimeDuration("dfs.datanode.disk.check.min.gap", 10L, TimeUnit.MILLISECONDS);
        CONF.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        CONF.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        CONF.set("dfs.metrics.percentiles.intervals", "1");
        CONF.setBoolean("dfs.namenode.avoid.read.stale.datanode", true);
        GenericTestUtils.setLogLevel((Log)LogFactory.getLog(MetricsAsserts.class), (Level)Level.DEBUG);
    }
}

