/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OfflineEditsViewerHelper {
    private static final Log LOG = LogFactory.getLog(OfflineEditsViewerHelper.class);
    final long blockSize = 512L;
    MiniDFSCluster cluster = null;
    final Configuration config = new Configuration();

    public String generateEdits() throws IOException {
        CheckpointSignature signature = this.runOperations();
        return this.getEditsFilename(signature);
    }

    private String getEditsFilename(CheckpointSignature sig) throws IOException {
        FSImage image = this.cluster.getNameNode().getFSImage();
        Iterator it = image.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS);
        Storage.StorageDirectory sd = (Storage.StorageDirectory)it.next();
        File ret = NNStorage.getFinalizedEditsFile((Storage.StorageDirectory)sd, (long)1L, (long)(sig.curSegmentTxId - 1L));
        assert (ret.exists()) : "expected " + ret + " exists";
        return ret.getAbsolutePath();
    }

    public void startCluster(String dfsDir) throws IOException {
        this.config.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(dfsDir, "name")).toString());
        this.config.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(dfsDir, "namesecondary1")).toString());
        this.config.setLong("dfs.blocksize", 512L);
        this.config.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](JobTracker@.*FOO.COM)s/@.*//DEFAULT");
        this.config.setBoolean("dfs.namenode.delegation.token.always-use", true);
        this.config.setBoolean("dfs.namenode.acls.enabled", true);
        int numDataNodes = 9;
        this.cluster = new MiniDFSCluster.Builder(this.config).manageNameDfsDirs(false).numDataNodes(9).build();
        this.cluster.waitClusterUp();
    }

    public void shutdownCluster() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private CheckpointSignature runOperations() throws IOException {
        LOG.info((Object)"Creating edits by performing fs operations");
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        DFSTestUtil.runOperations(this.cluster, dfs, this.cluster.getConfiguration(0), dfs.getDefaultBlockSize(), 0);
        this.cluster.getNamesystem().getEditLog().logStartRollingUpgrade(Time.now());
        this.cluster.getNamesystem().getEditLog().logFinalizeRollingUpgrade(Time.now());
        return this.cluster.getNameNodeRpc().rollEditLog();
    }
}

