/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.TestStateStoreBase;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.QueryResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestStateStoreMountTable
extends TestStateStoreBase {
    private static List<String> nameservices;
    private static MountTableStore mountStore;

    @BeforeClass
    public static void create() throws IOException {
        nameservices = new ArrayList<String>();
        nameservices.add(FederationTestUtils.NAMESERVICES[0]);
        nameservices.add(FederationTestUtils.NAMESERVICES[1]);
    }

    @Before
    public void setup() throws IOException, InterruptedException {
        mountStore = (MountTableStore)TestStateStoreMountTable.getStateStore().getRegisteredRecordStore(MountTableStore.class);
        Assert.assertTrue((boolean)FederationStateStoreTestUtils.clearRecords(TestStateStoreMountTable.getStateStore(), MountTable.class));
    }

    @Test
    public void testStateStoreDisconnected() throws Exception {
        TestStateStoreMountTable.getStateStore().closeDriver();
        Assert.assertFalse((boolean)TestStateStoreMountTable.getStateStore().isDriverReady());
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance();
        FederationTestUtils.verifyException(mountStore, "addMountTableEntry", StateStoreUnavailableException.class, new Class[]{AddMountTableEntryRequest.class}, new Object[]{addRequest});
        UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance();
        FederationTestUtils.verifyException(mountStore, "updateMountTableEntry", StateStoreUnavailableException.class, new Class[]{UpdateMountTableEntryRequest.class}, new Object[]{updateRequest});
        RemoveMountTableEntryRequest removeRequest = RemoveMountTableEntryRequest.newInstance();
        FederationTestUtils.verifyException(mountStore, "removeMountTableEntry", StateStoreUnavailableException.class, new Class[]{RemoveMountTableEntryRequest.class}, new Object[]{removeRequest});
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance();
        mountStore.loadCache(true);
        FederationTestUtils.verifyException(mountStore, "getMountTableEntries", StateStoreUnavailableException.class, new Class[]{GetMountTableEntriesRequest.class}, new Object[]{getRequest});
    }

    @Test
    public void testSynchronizeMountTable() throws IOException {
        List<MountTable> entries = FederationStateStoreTestUtils.createMockMountTable(nameservices);
        Assert.assertTrue((boolean)FederationStateStoreTestUtils.synchronizeRecords(TestStateStoreMountTable.getStateStore(), entries, MountTable.class));
        for (MountTable e : entries) {
            mountStore.loadCache(true);
            MountTable entry = this.getMountTableEntry(e.getSourcePath());
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((Object)e.getDefaultLocation().getDest(), (Object)entry.getDefaultLocation().getDest());
        }
    }

    @Test
    public void testAddMountTableEntry() throws IOException {
        List<MountTable> entries = FederationStateStoreTestUtils.createMockMountTable(nameservices);
        List entries1 = this.getMountTableEntries("/").getRecords();
        Assert.assertEquals((long)0L, (long)entries1.size());
        MountTable entry0 = entries.get(0);
        AddMountTableEntryRequest request = AddMountTableEntryRequest.newInstance((MountTable)entry0);
        AddMountTableEntryResponse response = mountStore.addMountTableEntry(request);
        Assert.assertTrue((boolean)response.getStatus());
        mountStore.loadCache(true);
        List entries2 = this.getMountTableEntries("/").getRecords();
        Assert.assertEquals((long)1L, (long)entries2.size());
    }

    @Test
    public void testRemoveMountTableEntry() throws IOException {
        List<MountTable> entries = FederationStateStoreTestUtils.createMockMountTable(nameservices);
        FederationStateStoreTestUtils.synchronizeRecords(TestStateStoreMountTable.getStateStore(), entries, MountTable.class);
        mountStore.loadCache(true);
        List entries1 = this.getMountTableEntries("/").getRecords();
        Assert.assertEquals((long)entries.size(), (long)entries1.size());
        RemoveMountTableEntryRequest request = RemoveMountTableEntryRequest.newInstance();
        request.setSrcPath(entries.get(0).getSourcePath());
        Assert.assertTrue((boolean)mountStore.removeMountTableEntry(request).getStatus());
        mountStore.loadCache(true);
        List entries2 = this.getMountTableEntries("/").getRecords();
        Assert.assertEquals((long)(entries.size() - 1), (long)entries2.size());
    }

    @Test
    public void testUpdateMountTableEntry() throws IOException {
        List<MountTable> entries = FederationStateStoreTestUtils.createMockMountTable(nameservices);
        MountTable entry0 = entries.get(0);
        String srcPath = entry0.getSourcePath();
        String nsId = entry0.getDefaultLocation().getNameserviceId();
        AddMountTableEntryRequest request = AddMountTableEntryRequest.newInstance((MountTable)entry0);
        AddMountTableEntryResponse response = mountStore.addMountTableEntry(request);
        Assert.assertTrue((boolean)response.getStatus());
        mountStore.loadCache(true);
        MountTable matchingEntry0 = this.getMountTableEntry(srcPath);
        Assert.assertNotNull((Object)matchingEntry0);
        Assert.assertEquals((Object)nsId, (Object)matchingEntry0.getDefaultLocation().getNameserviceId());
        Map<String, String> destMap = Collections.singletonMap("testnameservice", "/");
        MountTable replacement = MountTable.newInstance((String)srcPath, destMap);
        UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance((MountTable)replacement);
        UpdateMountTableEntryResponse updateResponse = mountStore.updateMountTableEntry(updateRequest);
        Assert.assertTrue((boolean)updateResponse.getStatus());
        mountStore.loadCache(true);
        MountTable matchingEntry1 = this.getMountTableEntry(srcPath);
        Assert.assertNotNull((Object)matchingEntry1);
        Assert.assertEquals((Object)"testnameservice", (Object)matchingEntry1.getDefaultLocation().getNameserviceId());
    }

    private MountTable getMountTableEntry(String mount) throws IOException {
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance((String)mount);
        GetMountTableEntriesResponse response = mountStore.getMountTableEntries(request);
        List results = response.getEntries();
        if (results.size() > 0) {
            return (MountTable)results.get(0);
        }
        return null;
    }

    private QueryResult<MountTable> getMountTableEntries(String mount) throws IOException {
        if (mount == null) {
            throw new IOException("Please specify a root search path");
        }
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance();
        request.setSrcPath(mount);
        GetMountTableEntriesResponse response = mountStore.getMountTableEntries(request);
        List records = response.getEntries();
        long timestamp = response.getTimestamp();
        return new QueryResult(records, timestamp);
    }
}

