/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.TestRouterRpc;
import org.junit.Assert;

public class TestRouterRpcMultiDestination
extends TestRouterRpc {
    @Override
    public void testSetup() throws Exception {
        MockResolver resolver;
        Router router;
        RouterDFSCluster cluster = this.getCluster();
        this.getCluster().installMockLocations();
        List<RouterDFSCluster.RouterContext> routers = cluster.getRouters();
        for (RouterDFSCluster.RouterContext rc : routers) {
            router = rc.getRouter();
            resolver = (MockResolver)router.getSubclusterResolver();
            resolver.addLocation("/", cluster.getNameservices().get(1), "/");
        }
        for (RouterDFSCluster.RouterContext rc : routers) {
            router = rc.getRouter();
            resolver = (MockResolver)router.getSubclusterResolver();
            List<String> nss = cluster.getNameservices();
            String ns0 = nss.get(0);
            resolver.addLocation("/same", ns0, "/");
            resolver.addLocation("/same", ns0, cluster.getNamenodePathForNS(ns0));
        }
        cluster.deleteAllFiles();
        cluster.createTestDirectoriesNamenode();
        Thread.sleep(100L);
        RouterDFSCluster.RouterContext router2 = cluster.getRandomRouter();
        this.setRouter(router2);
        String ns = cluster.getRandomNameservice();
        this.setNs(ns);
        this.setNamenode(cluster.getNamenode(ns, null));
        Random r = new Random();
        String randomString = "testfile-" + r.nextInt();
        this.setNamenodeFile("/" + randomString);
        this.setRouterFile("/" + randomString);
        FileSystem nnFs = this.getNamenodeFileSystem();
        FileSystem routerFs = this.getRouterFileSystem();
        FederationTestUtils.createFile(nnFs, this.getNamenodeFile(), 32L);
        FederationTestUtils.verifyFileExists(nnFs, this.getNamenodeFile());
        FederationTestUtils.verifyFileExists(routerFs, this.getRouterFile());
    }

    private void testListing(String path) throws IOException {
        TreeSet<String> requiredPaths = new TreeSet<String>();
        RouterDFSCluster.RouterContext rc = this.getRouterContext();
        Router router = rc.getRouter();
        FileSubclusterResolver subclusterResolver = router.getSubclusterResolver();
        for (Object mount : subclusterResolver.getMountPoints(path)) {
            requiredPaths.add((String)mount);
        }
        PathLocation location = subclusterResolver.getDestinationForPath(path);
        for (RemoteLocation loc : location.getDestinations()) {
            FileStatus[] files;
            String nsId = loc.getNameserviceId();
            String dest = loc.getDest();
            RouterDFSCluster.NamenodeContext nn = this.getCluster().getNamenode(nsId, null);
            FileSystem fs = nn.getFileSystem();
            for (FileStatus file : files = fs.listStatus(new Path(dest))) {
                String pathName = file.getPath().getName();
                requiredPaths.add(pathName);
            }
        }
        DirectoryListing listing = this.getRouterProtocol().getListing(path, HdfsFileStatus.EMPTY_NAME, false);
        Iterator requiredPathsIterator = requiredPaths.iterator();
        Object[] partialListing = listing.getPartialListing();
        for (HdfsFileStatus fileStatus : listing.getPartialListing()) {
            String fileName = (String)requiredPathsIterator.next();
            String currentFile = fileStatus.getFullPath(new Path(path)).getName();
            Assert.assertEquals((Object)currentFile, (Object)fileName);
        }
        Assert.assertEquals((String)(requiredPaths + " doesn't match " + Arrays.toString(partialListing)), (long)requiredPaths.size(), (long)partialListing.length);
    }

    @Override
    public void testProxyListFiles() throws IOException, InterruptedException, URISyntaxException, NoSuchMethodException, SecurityException {
        this.testListing("/");
        this.testListing("/same");
        ClientProtocol namenodeProtocol = this.getCluster().getRandomNamenode().getClient().getNamenode();
        Method m = ClientProtocol.class.getMethod("getListing", String.class, byte[].class, Boolean.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpcMultiDestination.compareResponses(this.getRouterProtocol(), namenodeProtocol, m, new Object[]{badPath, HdfsFileStatus.EMPTY_NAME, false});
    }

    @Override
    public void testProxyRenameFiles() throws IOException, InterruptedException {
        super.testProxyRenameFiles();
        List<String> nss = this.getCluster().getNameservices();
        String ns0 = nss.get(0);
        String ns1 = nss.get(1);
        String testDir0 = this.getCluster().getFederatedTestDirectoryForNS(ns0);
        String filename0 = testDir0 + "/testrename";
        String renamedFile = "/testrename";
        this.testRename(this.getRouterContext(), filename0, renamedFile, false);
        this.testRename2(this.getRouterContext(), filename0, renamedFile, false);
        String testDir1 = this.getCluster().getFederatedTestDirectoryForNS(ns1);
        String filename1 = testDir1 + "/testrename";
        this.testRename(this.getRouterContext(), filename1, renamedFile, false);
        this.testRename2(this.getRouterContext(), filename1, renamedFile, false);
    }
}

