/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.RouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.impl.MountTableStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.util.Time;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRouterAdmin {
    private static StateStoreDFSCluster cluster;
    private static RouterDFSCluster.RouterContext routerContext;
    public static final String RPC_BEAN = "Hadoop:service=Router,name=FederationRPC";
    private static List<MountTable> mockMountTable;
    private static StateStoreService stateStore;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 1);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        cluster.addRouterOverrides(conf);
        cluster.startRouters();
        routerContext = cluster.getRandomRouter();
        mockMountTable = cluster.generateMockMountTable();
        Router router = routerContext.getRouter();
        stateStore = router.getStateStore();
    }

    @AfterClass
    public static void tearDown() {
        cluster.stopRouter(routerContext);
    }

    @Before
    public void testSetup() throws Exception {
        Assert.assertTrue((boolean)FederationStateStoreTestUtils.synchronizeRecords(stateStore, mockMountTable, MountTable.class));
    }

    @Test
    public void testAddMountTable() throws IOException {
        MountTable newEntry = MountTable.newInstance((String)"/testpath", Collections.singletonMap("ns0", "/testdir"), (long)Time.now(), (long)Time.now());
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        List<MountTable> records = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)records.size(), (long)mockMountTable.size());
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTable.addMountTableEntry(addRequest);
        Assert.assertTrue((boolean)addResponse.getStatus());
        List<MountTable> records2 = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)records2.size(), (long)(mockMountTable.size() + 1));
    }

    @Test
    public void testAddDuplicateMountTable() throws IOException {
        MountTable newEntry = MountTable.newInstance((String)"/testpath", Collections.singletonMap("ns0", "/testdir"), (long)Time.now(), (long)Time.now());
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        List<MountTable> entries1 = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)entries1.size(), (long)mockMountTable.size());
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTable.addMountTableEntry(addRequest);
        Assert.assertTrue((boolean)addResponse.getStatus());
        List<MountTable> entries2 = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)entries2.size(), (long)(mockMountTable.size() + 1));
        AddMountTableEntryResponse addResponse2 = mountTable.addMountTableEntry(addRequest);
        Assert.assertFalse((boolean)addResponse2.getStatus());
    }

    @Test
    public void testRemoveMountTable() throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        List<MountTable> entries1 = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)entries1.size(), (long)mockMountTable.size());
        RemoveMountTableEntryRequest removeRequest = RemoveMountTableEntryRequest.newInstance((String)"/");
        mountTable.removeMountTableEntry(removeRequest);
        List<MountTable> entries2 = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)entries2.size(), (long)(mockMountTable.size() - 1));
    }

    @Test
    public void testEditMountTable() throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        MountTable entry = this.getMountTableEntry("/");
        Assert.assertEquals(Collections.singletonList(new RemoteLocation("ns0", "/")), (Object)entry.getDestinations());
        MountTable updatedEntry = MountTable.newInstance((String)"/", Collections.singletonMap("ns1", "/"), (long)Time.now(), (long)Time.now());
        UpdateMountTableEntryRequest updateRequest = UpdateMountTableEntryRequest.newInstance((MountTable)updatedEntry);
        mountTable.updateMountTableEntry(updateRequest);
        entry = this.getMountTableEntry("/");
        Assert.assertEquals(Collections.singletonList(new RemoteLocation("ns1", "/")), (Object)entry.getDestinations());
    }

    @Test
    public void testGetMountTable() throws IOException {
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        List<MountTable> entries = this.getMountTableEntries(mountTable);
        Assert.assertEquals((long)mockMountTable.size(), (long)entries.size());
        int matches = 0;
        for (MountTable e : entries) {
            for (MountTable entry : mockMountTable) {
                Assert.assertEquals((long)e.getDestinations().size(), (long)1L);
                Assert.assertNotNull((Object)e.getDateCreated());
                Assert.assertNotNull((Object)e.getDateModified());
                if (!entry.getSourcePath().equals(e.getSourcePath())) continue;
                ++matches;
            }
        }
        Assert.assertEquals((long)matches, (long)mockMountTable.size());
    }

    @Test
    public void testGetSingleMountTableEntry() throws IOException {
        MountTable entry = this.getMountTableEntry("/ns0");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)entry.getSourcePath(), (Object)"/ns0");
    }

    private MountTable getMountTableEntry(String mount) throws IOException {
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance((String)mount);
        RouterClient client = routerContext.getAdminClient();
        MountTableManager mountTable = client.getMountTableManager();
        List<MountTable> results = this.getMountTableEntries(mountTable, request);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    private List<MountTable> getMountTableEntries(MountTableManager mountTable) throws IOException {
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance((String)"/");
        return this.getMountTableEntries(mountTable, request);
    }

    private List<MountTable> getMountTableEntries(MountTableManager mountTable, GetMountTableEntriesRequest request) throws IOException {
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesResponse response = mountTable.getMountTableEntries(request);
        return response.getEntries();
    }
}

