/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMountTableResolver {
    private static final Logger LOG = LoggerFactory.getLogger(TestMountTableResolver.class);
    private MountTableResolver mountTable;

    private Map<String, String> getMountTableEntry(String subcluster, String path) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(subcluster, path);
        return ret;
    }

    private void setupMountTable() throws IOException {
        Configuration conf = new Configuration();
        this.mountTable = new MountTableResolver(conf);
        Map<String, String> map = this.getMountTableEntry("1", "/");
        this.mountTable.addEntry(MountTable.newInstance((String)"/", map));
        map = this.getMountTableEntry("2", "/");
        this.mountTable.addEntry(MountTable.newInstance((String)"/tmp", map));
        map = this.getMountTableEntry("3", "/user");
        this.mountTable.addEntry(MountTable.newInstance((String)"/user", map));
        map = this.getMountTableEntry("2", "/bin");
        this.mountTable.addEntry(MountTable.newInstance((String)"/usr/bin", map));
        map = this.getMountTableEntry("2", "/user/test");
        this.mountTable.addEntry(MountTable.newInstance((String)"/user/a", map));
        map = this.getMountTableEntry("4", "/user/file1.txt");
        this.mountTable.addEntry(MountTable.newInstance((String)"/user/b/file1.txt", map));
        map = this.getMountTableEntry("1", "/user/test");
        this.mountTable.addEntry(MountTable.newInstance((String)"/user/a/demo/test/a", map));
        map = this.getMountTableEntry("3", "/user/test");
        this.mountTable.addEntry(MountTable.newInstance((String)"/user/a/demo/test/b", map));
    }

    @Before
    public void setup() throws IOException {
        this.setupMountTable();
    }

    @Test
    public void testDestination() throws IOException {
        Assert.assertEquals((Object)"1->/tesfile1.txt", (Object)this.mountTable.getDestinationForPath("/tesfile1.txt").toString());
        Assert.assertEquals((Object)"3->/user/testfile2.txt", (Object)this.mountTable.getDestinationForPath("/user/testfile2.txt").toString());
        Assert.assertEquals((Object)"2->/user/test/testfile3.txt", (Object)this.mountTable.getDestinationForPath("/user/a/testfile3.txt").toString());
        Assert.assertEquals((Object)"3->/user/b/testfile4.txt", (Object)this.mountTable.getDestinationForPath("/user/b/testfile4.txt").toString());
        Assert.assertEquals((Object)"1->/share/file5.txt", (Object)this.mountTable.getDestinationForPath("/share/file5.txt").toString());
        Assert.assertEquals((Object)"2->/bin/file7.txt", (Object)this.mountTable.getDestinationForPath("/usr/bin/file7.txt").toString());
        Assert.assertEquals((Object)"1->/usr/file8.txt", (Object)this.mountTable.getDestinationForPath("/usr/file8.txt").toString());
        Assert.assertEquals((Object)"2->/user/test/demo/file9.txt", (Object)this.mountTable.getDestinationForPath("/user/a/demo/file9.txt").toString());
        Assert.assertEquals((Object)"3->/user/testfolder", (Object)this.mountTable.getDestinationForPath("/user/testfolder").toString());
        Assert.assertEquals((Object)"2->/user/test/b", (Object)this.mountTable.getDestinationForPath("/user/a/b").toString());
        Assert.assertEquals((Object)"3->/user/test/a", (Object)this.mountTable.getDestinationForPath("/user/test/a").toString());
    }

    private void compareLists(List<String> list1, String[] list2) {
        Assert.assertEquals((long)list1.size(), (long)list2.length);
        for (String item : list2) {
            Assert.assertTrue((boolean)list1.contains(item));
        }
    }

    @Test
    public void testGetMountPoints() throws IOException {
        List mounts = this.mountTable.getMountPoints("/");
        Assert.assertEquals((long)3L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"tmp", "user", "usr"});
        mounts = this.mountTable.getMountPoints("/user");
        Assert.assertEquals((long)2L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"a", "b"});
        mounts = this.mountTable.getMountPoints("/user/a");
        Assert.assertEquals((long)1L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"demo"});
        mounts = this.mountTable.getMountPoints("/user/a/demo");
        Assert.assertEquals((long)1L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"test"});
        mounts = this.mountTable.getMountPoints("/user/a/demo/test");
        Assert.assertEquals((long)2L, (long)mounts.size());
        this.compareLists(mounts, new String[]{"a", "b"});
        mounts = this.mountTable.getMountPoints("/tmp");
        Assert.assertEquals((long)0L, (long)mounts.size());
        mounts = this.mountTable.getMountPoints("/t");
        Assert.assertNull((Object)mounts);
        mounts = this.mountTable.getMountPoints("/unknownpath");
        Assert.assertNull((Object)mounts);
    }

    private void compareRecords(List<MountTable> list1, String[] list2) {
        Assert.assertEquals((long)list1.size(), (long)list2.length);
        for (String item : list2) {
            for (MountTable record : list1) {
                if (!record.getSourcePath().equals(item)) continue;
                return;
            }
        }
        Assert.fail();
    }

    @Test
    public void testGetMounts() throws IOException {
        List records = this.mountTable.getMounts("/");
        Assert.assertEquals((long)8L, (long)records.size());
        this.compareRecords(records, new String[]{"/", "/tmp", "/user", "/usr/bin", "user/a", "/user/a/demo/a", "/user/a/demo/b", "/user/b/file1.txt"});
        records = this.mountTable.getMounts("/user");
        Assert.assertEquals((long)5L, (long)records.size());
        this.compareRecords(records, new String[]{"/user", "/user/a/demo/a", "/user/a/demo/b", "user/a", "/user/b/file1.txt"});
        records = this.mountTable.getMounts("/user/a");
        Assert.assertEquals((long)3L, (long)records.size());
        this.compareRecords(records, new String[]{"/user/a/demo/a", "/user/a/demo/b", "/user/a"});
        records = this.mountTable.getMounts("/tmp");
        Assert.assertEquals((long)1L, (long)records.size());
        this.compareRecords(records, new String[]{"/tmp"});
    }

    @Test
    public void testRemoveSubTree() throws UnsupportedOperationException, IOException {
        this.compareLists(this.mountTable.getMountPoints("/"), new String[]{"user", "usr", "tmp"});
        Assert.assertEquals((Object)"2", (Object)this.mountTable.getDestinationForPath("/tmp/testfile.txt").getDefaultLocation().getNameserviceId());
        this.mountTable.removeEntry("/tmp");
        this.compareLists(this.mountTable.getMountPoints("/"), new String[]{"user", "usr"});
        Assert.assertEquals((Object)"1", (Object)this.mountTable.getDestinationForPath("/tmp/testfile.txt").getDefaultLocation().getNameserviceId());
    }

    @Test
    public void testRemoveVirtualNode() throws UnsupportedOperationException, IOException {
        this.compareLists(this.mountTable.getMountPoints("/"), new String[]{"user", "usr", "tmp"});
        Assert.assertEquals((Object)"1", (Object)this.mountTable.getDestinationForPath("/usr/testfile.txt").getDefaultLocation().getNameserviceId());
        this.mountTable.removeEntry("/usr");
        this.compareLists(this.mountTable.getMountPoints("/"), new String[]{"user", "usr", "tmp"});
    }

    @Test
    public void testRemoveLeafNode() throws UnsupportedOperationException, IOException {
        Assert.assertEquals((Object)"1", (Object)this.mountTable.getDestinationForPath("/user/a/demo/test/a").getDefaultLocation().getNameserviceId());
        this.mountTable.removeEntry("/user/a/demo/test/a");
        Assert.assertEquals((Object)"2", (Object)this.mountTable.getDestinationForPath("/user/a/demo/test/a").getDefaultLocation().getNameserviceId());
        this.compareLists(this.mountTable.getMountPoints("/user/a"), new String[]{"demo"});
        Assert.assertEquals((Object)"3", (Object)this.mountTable.getDestinationForPath("/user/a/demo/test/b").getDefaultLocation().getNameserviceId());
    }

    @Test
    public void testRefreshEntries() throws UnsupportedOperationException, IOException {
        this.testDestination();
        Assert.assertEquals((long)8L, (long)this.mountTable.getMounts("/").size());
        ArrayList<MountTable> records = new ArrayList<MountTable>();
        Map<String, String> map1 = this.getMountTableEntry("1", "/");
        records.add(MountTable.newInstance((String)"/1", map1));
        Map<String, String> map2 = this.getMountTableEntry("2", "/");
        records.add(MountTable.newInstance((String)"/2", map2));
        this.mountTable.refreshEntries(records);
        PathLocation destination1 = this.mountTable.getDestinationForPath("/1");
        RemoteLocation defaultLoc1 = destination1.getDefaultLocation();
        Assert.assertEquals((Object)"1", (Object)defaultLoc1.getNameserviceId());
        PathLocation destination2 = this.mountTable.getDestinationForPath("/2");
        RemoteLocation defaultLoc2 = destination2.getDefaultLocation();
        Assert.assertEquals((Object)"2", (Object)defaultLoc2.getNameserviceId());
        Assert.assertEquals((long)2L, (long)this.mountTable.getMounts("/").size());
        boolean assertionThrown = false;
        try {
            this.testDestination();
            Assert.fail();
        }
        catch (AssertionError e) {
            assertionThrown = true;
        }
        Assert.assertTrue((boolean)assertionThrown);
    }

    @Test
    public void testMountTableScalability() throws IOException {
        ArrayList emptyList = new ArrayList();
        this.mountTable.refreshEntries(emptyList);
        for (int i = 0; i < 100000; ++i) {
            Map<String, String> map = this.getMountTableEntry("1", "/" + i);
            MountTable record = MountTable.newInstance((String)("/" + i), map);
            this.mountTable.addEntry(record);
            if (i % 10000 != 0) continue;
            LOG.info("Adding flat mount record {}: {}", (Object)i, (Object)record);
        }
        Assert.assertEquals((long)100000L, (long)this.mountTable.getMountPoints("/").size());
        Assert.assertEquals((long)100000L, (long)this.mountTable.getMounts("/").size());
        this.mountTable.refreshEntries(emptyList);
        String parent = "/";
        for (int i = 0; i < 1000; ++i) {
            int index = i;
            Map<String, String> map = this.getMountTableEntry("1", "/" + index);
            if (i > 0) {
                parent = parent + "/";
            }
            parent = parent + i;
            MountTable record = MountTable.newInstance((String)parent, map);
            this.mountTable.addEntry(record);
        }
        Assert.assertEquals((long)1L, (long)this.mountTable.getMountPoints("/").size());
        Assert.assertEquals((long)1000L, (long)this.mountTable.getMounts("/").size());
        this.mountTable.refreshEntries(emptyList);
        Random rand = new Random();
        parent = "/" + Integer.toString(rand.nextInt());
        int numRootTrees = 1;
        for (int i = 0; i < 100000; ++i) {
            int index = i;
            Map<String, String> map = this.getMountTableEntry("1", "/" + index);
            if ((parent = parent + "/" + i).length() > 2000) {
                parent = "/" + Integer.toString(rand.nextInt());
                ++numRootTrees;
            }
            MountTable record = MountTable.newInstance((String)parent, map);
            this.mountTable.addEntry(record);
        }
        Assert.assertEquals((long)numRootTrees, (long)this.mountTable.getMountPoints("/").size());
        Assert.assertEquals((long)100000L, (long)this.mountTable.getMounts("/").size());
    }
}

