/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.management.MalformedObjectNameException;
import org.apache.commons.collections.ListUtils;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationMBean;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationMetrics;
import org.apache.hadoop.hdfs.server.federation.metrics.TestMetricsBase;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipStats;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestFederationMetrics
extends TestMetricsBase {
    public static final String FEDERATION_BEAN = "Hadoop:service=Router,name=FederationState";
    public static final String STATE_STORE_BEAN = "Hadoop:service=Router,name=StateStore";
    public static final String RPC_BEAN = "Hadoop:service=Router,name=FederationRPC";

    @Test
    public void testClusterStatsJMX() throws MalformedObjectNameException, IOException {
        FederationMBean bean = FederationTestUtils.getBean(FEDERATION_BEAN, FederationMBean.class);
        this.validateClusterStatsBean(bean);
    }

    @Test
    public void testClusterStatsDataSource() throws IOException {
        FederationMetrics metrics = this.getRouter().getMetrics();
        this.validateClusterStatsBean((FederationMBean)metrics);
    }

    @Test
    public void testMountTableStatsDataSource() throws IOException, JSONException {
        FederationMetrics metrics = this.getRouter().getMetrics();
        String jsonString = metrics.getMountTable();
        JSONArray jsonArray = new JSONArray(jsonString);
        Assert.assertEquals((long)jsonArray.length(), (long)this.getMockMountTable().size());
        int match = 0;
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            String src = json.getString("sourcePath");
            for (MountTable entry : this.getMockMountTable()) {
                if (!entry.getSourcePath().equals(src)) continue;
                Assert.assertEquals((Object)entry.getDefaultLocation().getNameserviceId(), (Object)json.getString("nameserviceId"));
                Assert.assertEquals((Object)entry.getDefaultLocation().getDest(), (Object)json.getString("path"));
                this.assertNotNullAndNotEmpty(json.getString("dateCreated"));
                this.assertNotNullAndNotEmpty(json.getString("dateModified"));
                ++match;
            }
        }
        Assert.assertEquals((long)match, (long)this.getMockMountTable().size());
    }

    private MembershipState findMockNamenode(String nsId, String nnId) {
        List namenodes = ListUtils.union(this.getActiveMemberships(), this.getStandbyMemberships());
        for (MembershipState nn : namenodes) {
            if (!nn.getNamenodeId().equals(nnId) || !nn.getNameserviceId().equals(nsId)) continue;
            return nn;
        }
        return null;
    }

    @Test
    public void testNamenodeStatsDataSource() throws IOException, JSONException {
        FederationMetrics metrics = this.getRouter().getMetrics();
        String jsonString = metrics.getNamenodes();
        JSONObject jsonObject = new JSONObject(jsonString);
        Iterator keys = jsonObject.keys();
        int nnsFound = 0;
        while (keys.hasNext()) {
            JSONObject json = jsonObject.getJSONObject((String)keys.next());
            String nameserviceId = json.getString("nameserviceId");
            String namenodeId = json.getString("namenodeId");
            MembershipState mockEntry = this.findMockNamenode(nameserviceId, namenodeId);
            Assert.assertNotNull((Object)mockEntry);
            Assert.assertEquals((Object)json.getString("state"), (Object)mockEntry.getState().toString());
            MembershipStats stats = mockEntry.getStats();
            Assert.assertEquals((long)json.getLong("numOfActiveDatanodes"), (long)stats.getNumOfActiveDatanodes());
            Assert.assertEquals((long)json.getLong("numOfDeadDatanodes"), (long)stats.getNumOfDeadDatanodes());
            Assert.assertEquals((long)json.getLong("numOfDecommissioningDatanodes"), (long)stats.getNumOfDecommissioningDatanodes());
            Assert.assertEquals((long)json.getLong("numOfDecomActiveDatanodes"), (long)stats.getNumOfDecomActiveDatanodes());
            Assert.assertEquals((long)json.getLong("numOfDecomDeadDatanodes"), (long)stats.getNumOfDecomDeadDatanodes());
            Assert.assertEquals((long)json.getLong("numOfBlocks"), (long)stats.getNumOfBlocks());
            Assert.assertEquals((Object)json.getString("rpcAddress"), (Object)mockEntry.getRpcAddress());
            Assert.assertEquals((Object)json.getString("webAddress"), (Object)mockEntry.getWebAddress());
            ++nnsFound;
        }
        Assert.assertEquals((long)(this.getActiveMemberships().size() + this.getStandbyMemberships().size()), (long)nnsFound);
    }

    @Test
    public void testNameserviceStatsDataSource() throws IOException, JSONException {
        FederationMetrics metrics = this.getRouter().getMetrics();
        String jsonString = metrics.getNameservices();
        JSONObject jsonObject = new JSONObject(jsonString);
        Iterator keys = jsonObject.keys();
        int nameservicesFound = 0;
        while (keys.hasNext()) {
            JSONObject json = jsonObject.getJSONObject((String)keys.next());
            String nameserviceId = json.getString("nameserviceId");
            String namenodeId = json.getString("namenodeId");
            MembershipState mockEntry = this.findMockNamenode(nameserviceId, namenodeId);
            Assert.assertNotNull((Object)mockEntry);
            Assert.assertEquals((Object)mockEntry.getState().toString(), (Object)json.getString("state"));
            Assert.assertEquals((Object)"ACTIVE", (Object)json.getString("state"));
            MembershipStats stats = mockEntry.getStats();
            Assert.assertEquals((long)stats.getNumOfFiles(), (long)json.getLong("numOfFiles"));
            Assert.assertEquals((long)stats.getTotalSpace(), (long)json.getLong("totalSpace"));
            Assert.assertEquals((long)stats.getAvailableSpace(), (long)json.getLong("availableSpace"));
            Assert.assertEquals((long)stats.getNumOfBlocksMissing(), (long)json.getLong("numOfBlocksMissing"));
            Assert.assertEquals((long)stats.getNumOfActiveDatanodes(), (long)json.getLong("numOfActiveDatanodes"));
            Assert.assertEquals((long)stats.getNumOfDeadDatanodes(), (long)json.getLong("numOfDeadDatanodes"));
            Assert.assertEquals((long)stats.getNumOfDecommissioningDatanodes(), (long)json.getLong("numOfDecommissioningDatanodes"));
            Assert.assertEquals((long)stats.getNumOfDecomActiveDatanodes(), (long)json.getLong("numOfDecomActiveDatanodes"));
            Assert.assertEquals((long)stats.getNumOfDecomDeadDatanodes(), (long)json.getLong("numOfDecomDeadDatanodes"));
            ++nameservicesFound;
        }
        Assert.assertEquals((long)this.getNameservices().size(), (long)nameservicesFound);
    }

    private void assertNotNullAndNotEmpty(String field) {
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((field.length() > 0 ? 1 : 0) != 0);
    }

    private void validateClusterStatsBean(FederationMBean bean) throws IOException {
        long numBlocks = 0L;
        long numLive = 0L;
        long numDead = 0L;
        long numDecom = 0L;
        long numDecomLive = 0L;
        long numDecomDead = 0L;
        long numFiles = 0L;
        for (MembershipState mock : this.getActiveMemberships()) {
            MembershipStats stats = mock.getStats();
            numBlocks += stats.getNumOfBlocks();
            numLive += (long)stats.getNumOfActiveDatanodes();
            numDead += (long)stats.getNumOfDeadDatanodes();
            numDecom += (long)stats.getNumOfDecommissioningDatanodes();
            numDecomLive += (long)stats.getNumOfDecomActiveDatanodes();
            numDecomDead += (long)stats.getNumOfDecomDeadDatanodes();
        }
        Assert.assertEquals((long)numBlocks, (long)bean.getNumBlocks());
        Assert.assertEquals((long)numLive, (long)bean.getNumLiveNodes());
        Assert.assertEquals((long)numDead, (long)bean.getNumDeadNodes());
        Assert.assertEquals((long)numDecom, (long)bean.getNumDecommissioningNodes());
        Assert.assertEquals((long)numDecomLive, (long)bean.getNumDecomLiveNodes());
        Assert.assertEquals((long)numDecomDead, (long)bean.getNumDecomDeadNodes());
        Assert.assertEquals((long)numFiles, (long)bean.getNumFiles());
        Assert.assertEquals((long)(this.getActiveMemberships().size() + this.getStandbyMemberships().size()), (long)bean.getNumNamenodes());
        Assert.assertEquals((long)this.getNameservices().size(), (long)bean.getNumNameservices());
        Assert.assertTrue((bean.getVersion().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((bean.getCompiledDate().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((bean.getCompileInfo().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((bean.getRouterStarted().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((bean.getHostAndPort().length() > 0 ? 1 : 0) != 0);
    }
}

