/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSStripedOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DataStreamer;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedDataStreamer;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.SecurityTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;

@Ignore(value="TODO: Fix and re-enable these flaky tests.")
public class TestDFSStripedOutputStreamWithFailure {
    public static final Log LOG = LogFactory.getLog(TestDFSStripedOutputStreamWithFailure.class);
    private final int cellSize = 65536;
    private final int stripesPerBlock = 4;
    private ErasureCodingPolicy ecPolicy;
    private int dataBlocks;
    private int parityBlocks;
    private int blockSize;
    private int blockGroupSize;
    private static final int FLUSH_POS = 4609;
    private int[][] dnIndexSuite;
    private List<Integer> lengths;
    private static final Random RANDOM;
    private MiniDFSCluster cluster;
    private DistributedFileSystem dfs;
    private final Path dir = new Path("/" + TestDFSStripedOutputStreamWithFailure.class.getSimpleName());

    public ECSchema getEcSchema() {
        return StripedFileTestUtil.getDefaultECPolicy().getSchema();
    }

    @Before
    public void init() {
        this.ecPolicy = new ErasureCodingPolicy(this.getEcSchema(), 65536);
        this.dataBlocks = this.ecPolicy.getNumDataUnits();
        this.parityBlocks = this.ecPolicy.getNumParityUnits();
        this.blockSize = 262144;
        this.blockGroupSize = this.blockSize * this.dataBlocks;
        this.dnIndexSuite = this.getDnIndexSuite();
        this.lengths = this.newLengths();
    }

    List<Integer> newLengths() {
        ArrayList<Integer> lens = new ArrayList<Integer>();
        lens.add(4611);
        for (int b = 0; b <= 2; ++b) {
            for (int c = 0; c < 4 * this.dataBlocks; ++c) {
                for (int delta = -1; delta <= 1; ++delta) {
                    int length = b * this.blockGroupSize + c * 65536 + delta;
                    System.out.println(lens.size() + ": length=" + length + ", (b, c, d) = (" + b + ", " + c + ", " + delta + ")");
                    lens.add(length);
                }
            }
        }
        return lens;
    }

    private int[][] getDnIndexSuite() {
        int maxNumLevel = 2;
        int maxPerLevel = 8;
        ArrayList<List<Integer>> allLists = new ArrayList<List<Integer>>();
        int numIndex = this.parityBlocks;
        for (int i = 0; i < 2 && numIndex > 1; --numIndex, ++i) {
            List<List<Integer>> lists = TestDFSStripedOutputStreamWithFailure.combinations(this.dataBlocks + this.parityBlocks, numIndex);
            if (lists.size() > 8) {
                Collections.shuffle(lists);
                lists = lists.subList(0, 8);
            }
            allLists.addAll(lists);
        }
        int[][] dnIndexArray = new int[allLists.size()][];
        for (int i = 0; i < dnIndexArray.length; ++i) {
            int[] list = new int[((List)allLists.get(i)).size()];
            for (int j = 0; j < list.length; ++j) {
                list[j] = (Integer)((List)allLists.get(i)).get(j);
            }
            dnIndexArray[i] = list;
        }
        return dnIndexArray;
    }

    private static List<List<Integer>> combinations(int n, int k) {
        LinkedList<List<Integer>> res = new LinkedList<List<Integer>>();
        if (k >= 1 && n >= k) {
            TestDFSStripedOutputStreamWithFailure.getComb(n, k, new Stack<Integer>(), res);
        }
        return res;
    }

    private static void getComb(int n, int k, Stack<Integer> stack, List<List<Integer>> res) {
        if (stack.size() == k) {
            ArrayList<Integer> list = new ArrayList<Integer>(stack);
            res.add(list);
        } else {
            int next;
            int n2 = next = stack.empty() ? 0 : stack.peek() + 1;
            while (next < n) {
                stack.push(next);
                TestDFSStripedOutputStreamWithFailure.getComb(n, k, stack, res);
                ++next;
            }
        }
        if (!stack.empty()) {
            stack.pop();
        }
    }

    private int[] getKillPositions(int fileLen, int num) {
        int[] positions = new int[num];
        for (int i = 0; i < num; ++i) {
            positions[i] = fileLen * (i + 1) / (num + 1);
        }
        return positions;
    }

    Integer getLength(int i) {
        return i >= 0 && i < this.lengths.size() ? this.lengths.get(i) : null;
    }

    private void setup(Configuration conf) throws IOException {
        System.out.println("NUM_DATA_BLOCKS  = " + this.dataBlocks);
        System.out.println("NUM_PARITY_BLOCKS= " + this.parityBlocks);
        System.out.println("CELL_SIZE        = 65536 (=" + StringUtils.TraditionalBinaryPrefix.long2String((long)65536L, (String)"B", (int)2) + ")");
        System.out.println("BLOCK_SIZE       = " + this.blockSize + " (=" + StringUtils.TraditionalBinaryPrefix.long2String((long)this.blockSize, (String)"B", (int)2) + ")");
        System.out.println("BLOCK_GROUP_SIZE = " + this.blockGroupSize + " (=" + StringUtils.TraditionalBinaryPrefix.long2String((long)this.blockGroupSize, (String)"B", (int)2) + ")");
        int numDNs = this.dataBlocks + this.parityBlocks;
        if (ErasureCodeNative.isNativeCodeLoaded()) {
            conf.set("io.erasurecode.codec.rs.rawcoders", "rs_native");
        }
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDNs).build();
        this.cluster.waitActive();
        this.dfs = this.cluster.getFileSystem();
        AddErasureCodingPolicyResponse[] res = this.dfs.addErasureCodingPolicies(new ErasureCodingPolicy[]{this.ecPolicy});
        this.ecPolicy = res[0].getPolicy();
        this.dfs.enableErasureCodingPolicy(this.ecPolicy.getName());
        DFSTestUtil.enableAllECPolicies(this.dfs);
        this.dfs.mkdirs(this.dir);
        this.dfs.setErasureCodingPolicy(this.dir, this.ecPolicy.getName());
    }

    private void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private HdfsConfiguration newHdfsConfiguration() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.namenode.replication.max-streams", 0);
        return conf;
    }

    @Test(timeout=300000L)
    public void testMultipleDatanodeFailure56() throws Exception {
        this.runTestWithMultipleFailure(this.getLength(56));
    }

    public void testMultipleDatanodeFailureRandomLength() throws Exception {
        int lenIndex = RANDOM.nextInt(this.lengths.size());
        LOG.info((Object)("run testMultipleDatanodeFailureRandomLength with length index: " + lenIndex));
        this.runTestWithMultipleFailure(this.getLength(lenIndex));
    }

    @Test(timeout=240000L)
    public void testBlockTokenExpired() throws Exception {
        int length = this.dataBlocks * 65536 * 3;
        HdfsConfiguration conf = this.newHdfsConfiguration();
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.setInt("ipc.client.connect.max.retries", 0);
        conf.setInt("dfs.client.retry.window.base", 10);
        for (int dn = 0; dn < this.dataBlocks + this.parityBlocks; dn += 2) {
            try {
                this.setup((Configuration)conf);
                this.runTest(length, new int[]{length / 2}, new int[]{dn}, true);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)("failed, dn=" + dn + ", length=" + length));
                throw e;
            }
            finally {
                this.tearDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=90000L)
    public void testAddBlockWhenNoSufficientDataBlockNumOfNodes() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        try {
            int numDatanodes;
            this.setup((Configuration)conf);
            ArrayList<DataNode> dataNodes = this.cluster.getDataNodes();
            for (numDatanodes = dataNodes.size(); numDatanodes >= this.dataBlocks; --numDatanodes) {
                this.cluster.stopDataNode(0);
            }
            this.cluster.restartNameNodes();
            this.cluster.triggerHeartbeats();
            DatanodeInfo[] info = this.dfs.getClient().datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            Assert.assertEquals((String)"Mismatches number of live Dns", (long)numDatanodes, (long)info.length);
            Path dirFile = new Path(this.dir, "ecfile");
            LambdaTestUtils.intercept(IOException.class, (String)("File " + dirFile + " could only be written to " + numDatanodes + " of the " + this.dataBlocks + " required nodes for " + this.ecPolicy.getName()), () -> {
                try (FSDataOutputStream out = this.dfs.create(dirFile, true);){
                    out.write("something".getBytes());
                    out.flush();
                }
                return 0;
            });
        }
        finally {
            this.tearDown();
        }
    }

    private void testCloseWithExceptionsInStreamer(int numFailures, boolean shouldFail) throws Exception {
        Assert.assertTrue((numFailures <= this.ecPolicy.getNumDataUnits() + this.ecPolicy.getNumParityUnits() ? 1 : 0) != 0);
        Path dirFile = new Path(this.dir, "ecfile-" + numFailures);
        try (FSDataOutputStream out = this.dfs.create(dirFile, true);){
            out.write("idempotent close".getBytes());
            LambdaTestUtils.intercept(IOException.class, () -> ((FSDataOutputStream)out).close());
            Assert.assertTrue((boolean)(out.getWrappedStream() instanceof DFSStripedOutputStream));
            DFSStripedOutputStream stripedOut = (DFSStripedOutputStream)out.getWrappedStream();
            for (int i = 0; i < numFailures; ++i) {
                stripedOut.getStripedDataStreamer(i).getLastException().set((Throwable)new IOException("injected failure"));
            }
            if (shouldFail) {
                LambdaTestUtils.intercept(IOException.class, () -> ((FSDataOutputStream)out).close());
            }
            out.close();
        }
    }

    @Test
    public void testIdempotentCloseWithFailedStreams() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        try {
            this.setup((Configuration)conf);
            while (this.cluster.getDataNodes().size() >= this.dataBlocks) {
                this.cluster.stopDataNode(0);
            }
            this.cluster.restartNameNodes();
            this.cluster.triggerHeartbeats();
            this.testCloseWithExceptionsInStreamer(1, false);
            this.testCloseWithExceptionsInStreamer(this.ecPolicy.getNumParityUnits(), false);
            this.testCloseWithExceptionsInStreamer(this.ecPolicy.getNumParityUnits() + 1, true);
            this.testCloseWithExceptionsInStreamer(this.ecPolicy.getNumDataUnits(), true);
        }
        finally {
            this.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseAfterAbort() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        try {
            this.setup((Configuration)conf);
            Path dirFile = new Path(this.dir, "ecfile");
            FSDataOutputStream out = this.dfs.create(dirFile, true);
            Assert.assertTrue((boolean)(out.getWrappedStream() instanceof DFSStripedOutputStream));
            DFSStripedOutputStream stripedOut = (DFSStripedOutputStream)out.getWrappedStream();
            stripedOut.abort();
            LambdaTestUtils.intercept(IOException.class, (String)"Lease timeout", () -> ((DFSStripedOutputStream)stripedOut).close());
        }
        finally {
            this.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=90000L)
    public void testAddBlockWhenNoSufficientParityNumOfNodes() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", (long)this.blockSize);
        try {
            this.setup((Configuration)conf);
            ArrayList<DataNode> dataNodes = this.cluster.getDataNodes();
            int killDns = this.parityBlocks - 1;
            int numDatanodes = dataNodes.size() - killDns;
            for (int i = 0; i < killDns; ++i) {
                this.cluster.stopDataNode(i);
            }
            this.cluster.restartNameNodes();
            this.cluster.triggerHeartbeats();
            DatanodeInfo[] info = this.dfs.getClient().datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            Assert.assertEquals((String)"Mismatches number of live Dns", (long)numDatanodes, (long)info.length);
            Path srcPath = new Path(this.dir, "testAddBlockWhenNoSufficientParityNodes");
            int fileLength = 64536;
            byte[] expected = StripedFileTestUtil.generateBytes(fileLength);
            DFSTestUtil.writeFile((FileSystem)this.dfs, srcPath, new String(expected));
            LOG.info((Object)"writing finished. Seek and read the file to verify.");
            StripedFileTestUtil.verifySeek((FileSystem)this.dfs, srcPath, fileLength, this.ecPolicy, this.blockGroupSize);
        }
        finally {
            this.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTest(int length) {
        HdfsConfiguration conf = this.newHdfsConfiguration();
        for (int dn = 0; dn < this.dataBlocks + this.parityBlocks; ++dn) {
            try {
                LOG.info((Object)("runTest: dn=" + dn + ", length=" + length));
                this.setup((Configuration)conf);
                this.runTest(length, new int[]{length / 2}, new int[]{dn}, false);
                continue;
            }
            catch (Throwable e) {
                String err = "failed, dn=" + dn + ", length=" + length + StringUtils.stringifyException((Throwable)e);
                LOG.error((Object)err);
                Assert.fail((String)err);
                continue;
            }
            finally {
                this.tearDown();
            }
        }
    }

    void runTestWithMultipleFailure(int length) throws Exception {
        HdfsConfiguration conf = this.newHdfsConfiguration();
        for (int[] dnIndex : this.dnIndexSuite) {
            int[] killPos = this.getKillPositions(length, dnIndex.length);
            try {
                LOG.info((Object)("runTestWithMultipleFailure: length==" + length + ", killPos=" + Arrays.toString(killPos) + ", dnIndex=" + Arrays.toString(dnIndex)));
                this.setup((Configuration)conf);
                this.runTest(length, killPos, dnIndex, false);
            }
            catch (Throwable e) {
                String err = "failed, killPos=" + Arrays.toString(killPos) + ", dnIndex=" + Arrays.toString(dnIndex) + ", length=" + length;
                LOG.error((Object)err);
                throw e;
            }
            finally {
                this.tearDown();
            }
        }
    }

    @Test
    public void runTestWithDifferentLengths() throws Exception {
        Assume.assumeTrue((String)"Skip this test case in the subclasses. Once is enough.", (boolean)this.getClass().equals(TestDFSStripedOutputStreamWithFailure.class));
        HdfsConfiguration conf = this.newHdfsConfiguration();
        int[] fileLengths = new int[]{65536 * (this.dataBlocks * 2 - 2), 65536 * this.dataBlocks + 123};
        int[] dnIndex = null;
        dnIndex = this.parityBlocks > 1 ? new int[]{this.dataBlocks - 2, this.dataBlocks - 1} : new int[]{this.dataBlocks - 1};
        for (int length : fileLengths) {
            int[] killPos = this.getKillPositions(length, dnIndex.length);
            try {
                LOG.info((Object)("runTestWithMultipleFailure2: length==" + length + ", killPos=" + Arrays.toString(killPos) + ", dnIndex=" + Arrays.toString(dnIndex)));
                this.setup((Configuration)conf);
                this.runTest(length, killPos, dnIndex, false);
            }
            catch (Throwable e) {
                String err = "failed, killPos=" + Arrays.toString(killPos) + ", dnIndex=" + Arrays.toString(dnIndex) + ", length=" + length;
                LOG.error((Object)err);
                throw e;
            }
            finally {
                this.tearDown();
            }
        }
    }

    @Test
    public void runTestWithShortStripe() throws Exception {
        Assume.assumeTrue((String)"Skip this test case in the subclasses. Once is enough.", (boolean)this.getClass().equals(TestDFSStripedOutputStreamWithFailure.class));
        HdfsConfiguration conf = this.newHdfsConfiguration();
        int length = 65413;
        int[] dnIndex = new int[this.dataBlocks + this.parityBlocks - 1];
        for (int i = 0; i < dnIndex.length; ++i) {
            dnIndex[i] = i;
        }
        int[] killPos = this.getKillPositions(65413, dnIndex.length);
        try {
            LOG.info((Object)("runTestWithShortStripe: length==65413, killPos=" + Arrays.toString(killPos) + ", dnIndex=" + Arrays.toString(dnIndex)));
            this.setup((Configuration)conf);
            this.runTest(65413, killPos, dnIndex, false);
        }
        catch (Throwable e) {
            String err = "failed, killPos=" + Arrays.toString(killPos) + ", dnIndex=" + Arrays.toString(dnIndex) + ", length=" + 65413;
            LOG.error((Object)err);
            throw e;
        }
        finally {
            this.tearDown();
        }
    }

    private void runTest(int length, int[] killPos, int[] dnIndex, boolean tokenExpire) throws Exception {
        if (killPos[0] <= 4609) {
            LOG.warn((Object)("killPos=" + Arrays.toString(killPos) + " <= FLUSH_POS=" + 4609 + ", length=" + length + ", dnIndex=" + Arrays.toString(dnIndex)));
            return;
        }
        Preconditions.checkArgument((length > killPos[0] ? 1 : 0) != 0, (String)"length=%s <= killPos=%s", (Object[])new Object[]{length, killPos});
        Preconditions.checkArgument((killPos.length == dnIndex.length ? 1 : 0) != 0);
        Path p = new Path(this.dir, "dn" + Arrays.toString(dnIndex) + "len" + length + "kill" + Arrays.toString(killPos));
        String fullPath = p.toString();
        LOG.info((Object)("fullPath=" + fullPath));
        if (tokenExpire) {
            NameNode nn = this.cluster.getNameNode();
            BlockManager bm = nn.getNamesystem().getBlockManager();
            BlockTokenSecretManager sm = bm.getBlockTokenSecretManager();
            SecurityTestUtil.setBlockTokenLifetime(sm, 6000L);
        }
        AtomicInteger pos = new AtomicInteger();
        FSDataOutputStream out = this.dfs.create(p);
        DFSStripedOutputStream stripedOut = (DFSStripedOutputStream)out.getWrappedStream();
        long firstGS = -1L;
        long oldGS = -1L;
        ArrayList<Long> gsList = new ArrayList<Long>();
        ArrayList<DatanodeInfo> killedDN = new ArrayList<DatanodeInfo>();
        int numKilled = 0;
        while (pos.get() < length) {
            int i = pos.getAndIncrement();
            if (numKilled < killPos.length && i == killPos[numKilled]) {
                Assert.assertTrue((firstGS != -1L ? 1 : 0) != 0);
                long gs = TestDFSStripedOutputStreamWithFailure.getGenerationStamp(stripedOut);
                if (numKilled == 0) {
                    Assert.assertEquals((long)firstGS, (long)gs);
                } else {
                    Assert.assertTrue((gs >= oldGS ? 1 : 0) != 0);
                }
                oldGS = gs;
                if (tokenExpire) {
                    DFSTestUtil.flushInternal(stripedOut);
                    this.waitTokenExpires(out);
                }
                killedDN.add(TestDFSStripedOutputStreamWithFailure.killDatanode(this.cluster, stripedOut, dnIndex[numKilled], pos));
                ++numKilled;
            }
            TestDFSStripedOutputStreamWithFailure.write(out, i);
            if (i % this.blockGroupSize == 4609) {
                oldGS = firstGS = TestDFSStripedOutputStreamWithFailure.getGenerationStamp(stripedOut);
            }
            if (i <= 0 || (i + 1) % this.blockGroupSize != 0) continue;
            gsList.add(oldGS);
        }
        gsList.add(oldGS);
        out.close();
        Assert.assertEquals((long)dnIndex.length, (long)numKilled);
        StripedFileTestUtil.waitBlockGroupsReported(this.dfs, fullPath, numKilled);
        this.cluster.triggerBlockReports();
        StripedFileTestUtil.checkData(this.dfs, p, length, killedDN, gsList, this.blockGroupSize);
    }

    static void write(FSDataOutputStream out, int i) throws IOException {
        try {
            out.write((int)StripedFileTestUtil.getByte(i));
        }
        catch (IOException ioe) {
            throw new IOException("Failed at i=" + i, ioe);
        }
    }

    static long getGenerationStamp(DFSStripedOutputStream out) throws IOException {
        long gs = out.getBlock().getGenerationStamp();
        LOG.info((Object)("getGenerationStamp returns " + gs));
        return gs;
    }

    static DatanodeInfo getDatanodes(StripedDataStreamer streamer) {
        while (true) {
            LocatedBlock lb;
            DatanodeInfo[] datanodes;
            if ((datanodes = streamer.getNodes()) == null && (lb = streamer.peekFollowingBlock()) != null) {
                datanodes = lb.getLocations();
            }
            if (datanodes != null) {
                Assert.assertEquals((long)1L, (long)datanodes.length);
                Assert.assertNotNull((Object)datanodes[0]);
                return datanodes[0];
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                Assert.fail((String)StringUtils.stringifyException((Throwable)ie));
                return null;
            }
        }
    }

    static DatanodeInfo killDatanode(MiniDFSCluster cluster, DFSStripedOutputStream out, int dnIndex, AtomicInteger pos) {
        StripedDataStreamer s = out.getStripedDataStreamer(dnIndex);
        DatanodeInfo datanode = TestDFSStripedOutputStreamWithFailure.getDatanodes(s);
        LOG.info((Object)("killDatanode " + dnIndex + ": " + datanode + ", pos=" + pos));
        if (datanode != null) {
            cluster.stopDataNode(datanode.getXferAddr());
        }
        return datanode;
    }

    private void waitTokenExpires(FSDataOutputStream out) throws IOException {
        Token<BlockTokenIdentifier> token = DFSTestUtil.getBlockToken(out);
        while (!SecurityTestUtil.isBlockTokenExpired(token)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    int getBase() {
        int i;
        String name = this.getClass().getSimpleName();
        for (i = name.length() - 1; i >= 0 && Character.isDigit(name.charAt(i)); --i) {
        }
        String number = name.substring(i + 1);
        try {
            return Integer.parseInt(number);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private void run(int offset) {
        int base = this.getBase();
        Assume.assumeTrue((base >= 0 ? 1 : 0) != 0);
        int i = offset + base;
        Integer length = this.getLength(i);
        if (length == null) {
            System.out.println("Skip test " + i + " since length=null.");
            return;
        }
        if (RANDOM.nextInt(16) != 0) {
            System.out.println("Test " + i + ", length=" + length + ", is not chosen to run.");
            return;
        }
        System.out.println("Run test " + i + ", length=" + length);
        this.runTest(length);
    }

    @Test(timeout=240000L)
    public void test0() {
        this.run(0);
    }

    @Test(timeout=240000L)
    public void test1() {
        this.run(1);
    }

    @Test(timeout=240000L)
    public void test2() {
        this.run(2);
    }

    @Test(timeout=240000L)
    public void test3() {
        this.run(3);
    }

    @Test(timeout=240000L)
    public void test4() {
        this.run(4);
    }

    @Test(timeout=240000L)
    public void test5() {
        this.run(5);
    }

    @Test(timeout=240000L)
    public void test6() {
        this.run(6);
    }

    @Test(timeout=240000L)
    public void test7() {
        this.run(7);
    }

    @Test(timeout=240000L)
    public void test8() {
        this.run(8);
    }

    @Test(timeout=240000L)
    public void test9() {
        this.run(9);
    }

    static {
        GenericTestUtils.setLogLevel((Logger)DFSOutputStream.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)DataStreamer.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.ALL);
        ((Log4JLogger)LogFactory.getLog(BlockPlacementPolicy.class)).getLogger().setLevel(Level.ALL);
        RANDOM = new Random();
    }
}

