/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInotifyEventInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.inotify.Event;
import org.apache.hadoop.hdfs.inotify.EventBatch;
import org.apache.hadoop.hdfs.inotify.MissingEventsException;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.util.ExitUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSInotifyEventInputStream {
    private static final int BLOCK_SIZE = 1024;
    private static final Log LOG = LogFactory.getLog(TestDFSInotifyEventInputStream.class);

    public static EventBatch waitForNextEvents(DFSInotifyEventInputStream eis) throws IOException, MissingEventsException {
        EventBatch batch = null;
        while ((batch = eis.poll()) == null) {
        }
        return batch;
    }

    private static long checkTxid(EventBatch batch, long prevTxid) {
        Assert.assertTrue((String)("Previous txid " + prevTxid + " was not less than new txid " + batch.getTxid()), (prevTxid < batch.getTxid() ? 1 : 0) != 0);
        return batch.getTxid();
    }

    @Test
    public void testOpcodeCount() {
        Assert.assertEquals((long)54L, (long)FSEditLogOpCodes.values().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testBasic() throws IOException, URISyntaxException, InterruptedException, MissingEventsException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setLong("dfs.namenode.accesstime.precision", 1L);
        MiniQJMHACluster.Builder builder = new MiniQJMHACluster.Builder((Configuration)conf);
        builder.getDfsBuilder().numDataNodes(2);
        MiniQJMHACluster cluster = builder.build();
        try {
            cluster.getDfsCluster().waitActive();
            cluster.getDfsCluster().transitionToActive(0);
            DFSClient client = new DFSClient(cluster.getDfsCluster().getNameNode(0).getNameNodeAddress(), (Configuration)conf);
            DistributedFileSystem fs = cluster.getDfsCluster().getFileSystem(0);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/file"), 1024L, (short)1, 0L);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/file3"), 1024L, (short)1, 0L);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/file5"), 1024L, (short)1, 0L);
            DFSTestUtil.createFile((FileSystem)fs, new Path("/truncate_file"), 2048L, (short)1, 0L);
            DFSInotifyEventInputStream eis = client.getInotifyEventStream();
            client.rename("/file", "/file4", null);
            client.rename("/file4", "/file2");
            OutputStream os = client.create("/file2", true, (short)2, 1024L);
            os.write(new byte[1024]);
            os.close();
            os = client.append("/file2", 1024, EnumSet.of(CreateFlag.APPEND), null, null);
            os.write(new byte[1024]);
            os.close();
            Thread.sleep(10L);
            client.open("/file2").read(new byte[1]);
            client.setReplication("/file2", (short)1);
            client.concat("/file2", new String[]{"/file3"});
            client.delete("/file2", false);
            client.mkdirs("/dir", null, false);
            client.setPermission("/dir", FsPermission.valueOf((String)"-rw-rw-rw-"));
            client.setOwner("/dir", "username", "groupname");
            client.createSymlink("/dir", "/dir2", false);
            client.setXAttr("/file5", "user.field", "value".getBytes(), EnumSet.of(XAttrSetFlag.CREATE));
            client.removeXAttr("/file5", "user.field");
            client.setAcl("/file5", AclEntry.parseAclSpec((String)"user::rwx,user:foo:rw-,group::r--,other::---", (boolean)true));
            client.removeAcl("/file5");
            client.rename("/file5", "/dir");
            client.truncate("/truncate_file", 1024L);
            client.create("/file_ec_test1", false);
            EventBatch batch = null;
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            long txid = batch.getTxid();
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.RENAME ? 1 : 0) != 0);
            Event.RenameEvent re = (Event.RenameEvent)batch.getEvents()[0];
            Assert.assertEquals((Object)"/file4", (Object)re.getDstPath());
            Assert.assertEquals((Object)"/file", (Object)re.getSrcPath());
            Assert.assertTrue((re.getTimestamp() > 0L ? 1 : 0) != 0);
            LOG.info((Object)re.toString());
            Assert.assertTrue((boolean)re.toString().startsWith("RenameEvent [srcPath="));
            long eventsBehind = eis.getTxidsBehindEstimate();
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.RENAME ? 1 : 0) != 0);
            Event.RenameEvent re2 = (Event.RenameEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)re2.getDstPath().equals("/file2"));
            Assert.assertTrue((boolean)re2.getSrcPath().equals("/file4"));
            Assert.assertTrue((re2.getTimestamp() > 0L ? 1 : 0) != 0);
            LOG.info((Object)re2.toString());
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
            Event.CreateEvent ce = (Event.CreateEvent)batch.getEvents()[0];
            Assert.assertTrue((ce.getiNodeType() == Event.CreateEvent.INodeType.FILE ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce.getPath().equals("/file2"));
            Assert.assertTrue((ce.getCtime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((ce.getReplication() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((ce.getSymlinkTarget() == null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce.getOverwrite());
            Assert.assertEquals((long)1024L, (long)ce.getDefaultBlockSize());
            Assert.assertTrue((boolean)ce.isErasureCoded().isPresent());
            Assert.assertFalse((boolean)((Boolean)ce.isErasureCoded().get()));
            LOG.info((Object)ce.toString());
            Assert.assertTrue((boolean)ce.toString().startsWith("CreateEvent [INodeType="));
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CLOSE ? 1 : 0) != 0);
            Event.CloseEvent ce2 = (Event.CloseEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)ce2.getPath().equals("/file2"));
            Assert.assertTrue((ce2.getFileSize() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((ce2.getTimestamp() > 0L ? 1 : 0) != 0);
            LOG.info((Object)ce2.toString());
            Assert.assertTrue((boolean)ce2.toString().startsWith("CloseEvent [path="));
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.APPEND ? 1 : 0) != 0);
            Event.AppendEvent append2 = (Event.AppendEvent)batch.getEvents()[0];
            Assert.assertEquals((Object)"/file2", (Object)append2.getPath());
            Assert.assertFalse((boolean)append2.toNewBlock());
            LOG.info((Object)append2.toString());
            Assert.assertTrue((boolean)append2.toString().startsWith("AppendEvent [path="));
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CLOSE ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Event.CloseEvent)batch.getEvents()[0]).getPath().equals("/file2"));
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue = (Event.MetadataUpdateEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)mue.getPath().equals("/file2"));
            Assert.assertTrue((mue.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.TIMES ? 1 : 0) != 0);
            LOG.info((Object)mue.toString());
            Assert.assertTrue((boolean)mue.toString().startsWith("MetadataUpdateEvent [path="));
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue2 = (Event.MetadataUpdateEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)mue2.getPath().equals("/file2"));
            Assert.assertTrue((mue2.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.REPLICATION ? 1 : 0) != 0);
            Assert.assertTrue((mue2.getReplication() == 1 ? 1 : 0) != 0);
            LOG.info((Object)mue2.toString());
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)3L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.APPEND ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Event.AppendEvent)batch.getEvents()[0]).getPath().equals("/file2"));
            Assert.assertTrue((batch.getEvents()[1].getEventType() == Event.EventType.UNLINK ? 1 : 0) != 0);
            Event.UnlinkEvent ue2 = (Event.UnlinkEvent)batch.getEvents()[1];
            Assert.assertTrue((boolean)ue2.getPath().equals("/file3"));
            Assert.assertTrue((ue2.getTimestamp() > 0L ? 1 : 0) != 0);
            LOG.info((Object)ue2.toString());
            Assert.assertTrue((boolean)ue2.toString().startsWith("UnlinkEvent [path="));
            Assert.assertTrue((batch.getEvents()[2].getEventType() == Event.EventType.CLOSE ? 1 : 0) != 0);
            Event.CloseEvent ce3 = (Event.CloseEvent)batch.getEvents()[2];
            Assert.assertTrue((boolean)ce3.getPath().equals("/file2"));
            Assert.assertTrue((ce3.getTimestamp() > 0L ? 1 : 0) != 0);
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.UNLINK ? 1 : 0) != 0);
            Event.UnlinkEvent ue = (Event.UnlinkEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)ue.getPath().equals("/file2"));
            Assert.assertTrue((ue.getTimestamp() > 0L ? 1 : 0) != 0);
            LOG.info((Object)ue.toString());
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
            Event.CreateEvent ce4 = (Event.CreateEvent)batch.getEvents()[0];
            Assert.assertTrue((ce4.getiNodeType() == Event.CreateEvent.INodeType.DIRECTORY ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce4.getPath().equals("/dir"));
            Assert.assertTrue((ce4.getCtime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((ce4.getReplication() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((ce4.getSymlinkTarget() == null ? 1 : 0) != 0);
            LOG.info((Object)ce4.toString());
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue3 = (Event.MetadataUpdateEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)mue3.getPath().equals("/dir"));
            Assert.assertTrue((mue3.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.PERMS ? 1 : 0) != 0);
            Assert.assertTrue((boolean)mue3.getPerms().toString().contains("rw-rw-rw-"));
            LOG.info((Object)mue3.toString());
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue4 = (Event.MetadataUpdateEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)mue4.getPath().equals("/dir"));
            Assert.assertTrue((mue4.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.OWNER ? 1 : 0) != 0);
            Assert.assertTrue((boolean)mue4.getOwnerName().equals("username"));
            Assert.assertTrue((boolean)mue4.getGroupName().equals("groupname"));
            LOG.info((Object)mue4.toString());
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
            Event.CreateEvent ce5 = (Event.CreateEvent)batch.getEvents()[0];
            Assert.assertTrue((ce5.getiNodeType() == Event.CreateEvent.INodeType.SYMLINK ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce5.getPath().equals("/dir2"));
            Assert.assertTrue((ce5.getCtime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((ce5.getReplication() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce5.getSymlinkTarget().equals("/dir"));
            LOG.info((Object)ce5.toString());
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue5 = (Event.MetadataUpdateEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)mue5.getPath().equals("/file5"));
            Assert.assertTrue((mue5.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.XATTRS ? 1 : 0) != 0);
            Assert.assertTrue((mue5.getxAttrs().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((XAttr)mue5.getxAttrs().get(0)).getName().contains("field"));
            Assert.assertTrue((!mue5.isxAttrsRemoved() ? 1 : 0) != 0);
            LOG.info((Object)mue5.toString());
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue6 = (Event.MetadataUpdateEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)mue6.getPath().equals("/file5"));
            Assert.assertTrue((mue6.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.XATTRS ? 1 : 0) != 0);
            Assert.assertTrue((mue6.getxAttrs().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((XAttr)mue6.getxAttrs().get(0)).getName().contains("field"));
            Assert.assertTrue((boolean)mue6.isxAttrsRemoved());
            LOG.info((Object)mue6.toString());
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue7 = (Event.MetadataUpdateEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)mue7.getPath().equals("/file5"));
            Assert.assertTrue((mue7.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.ACLS ? 1 : 0) != 0);
            Assert.assertTrue((boolean)mue7.getAcls().contains(AclEntry.parseAclEntry((String)"user::rwx", (boolean)true)));
            LOG.info((Object)mue7.toString());
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.METADATA ? 1 : 0) != 0);
            Event.MetadataUpdateEvent mue8 = (Event.MetadataUpdateEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)mue8.getPath().equals("/file5"));
            Assert.assertTrue((mue8.getMetadataType() == Event.MetadataUpdateEvent.MetadataType.ACLS ? 1 : 0) != 0);
            Assert.assertTrue((mue8.getAcls() == null ? 1 : 0) != 0);
            LOG.info((Object)mue8.toString());
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.RENAME ? 1 : 0) != 0);
            Event.RenameEvent re3 = (Event.RenameEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)re3.getDstPath().equals("/dir/file5"));
            Assert.assertTrue((boolean)re3.getSrcPath().equals("/file5"));
            Assert.assertTrue((re3.getTimestamp() > 0L ? 1 : 0) != 0);
            LOG.info((Object)re3.toString());
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.TRUNCATE ? 1 : 0) != 0);
            Event.TruncateEvent et = (Event.TruncateEvent)batch.getEvents()[0];
            Assert.assertTrue((boolean)et.getPath().equals("/truncate_file"));
            Assert.assertTrue((et.getFileSize() == 1024L ? 1 : 0) != 0);
            Assert.assertTrue((et.getTimestamp() > 0L ? 1 : 0) != 0);
            LOG.info((Object)et.toString());
            Assert.assertTrue((boolean)et.toString().startsWith("TruncateEvent [path="));
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
            ce = (Event.CreateEvent)batch.getEvents()[0];
            Assert.assertTrue((ce.getiNodeType() == Event.CreateEvent.INodeType.FILE ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce.getPath().equals("/file_ec_test1"));
            Assert.assertTrue((ce.getCtime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((ce.getReplication() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((ce.getSymlinkTarget() == null ? 1 : 0) != 0);
            Assert.assertFalse((boolean)ce.getOverwrite());
            Assert.assertEquals((long)1024L, (long)ce.getDefaultBlockSize());
            Assert.assertTrue((boolean)ce.isErasureCoded().isPresent());
            Assert.assertFalse((boolean)((Boolean)ce.isErasureCoded().get()));
            LOG.info((Object)ce.toString());
            Assert.assertTrue((boolean)ce.toString().startsWith("CreateEvent [INodeType="));
            Assert.assertTrue((eis.poll() == null ? 1 : 0) != 0);
            Assert.assertTrue((eis.getTxidsBehindEstimate() == eventsBehind ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testErasureCodedFiles() throws Exception {
        ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
        int dataUnits = ecPolicy.getNumDataUnits();
        int parityUnits = ecPolicy.getNumParityUnits();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", (long)ecPolicy.getCellSize());
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setLong("dfs.namenode.accesstime.precision", 1L);
        MiniQJMHACluster.Builder builder = new MiniQJMHACluster.Builder((Configuration)conf);
        builder.getDfsBuilder().numDataNodes(dataUnits + parityUnits);
        MiniQJMHACluster cluster = builder.build();
        try {
            cluster.getDfsCluster().waitActive();
            cluster.getDfsCluster().transitionToActive(0);
            DFSClient client = new DFSClient(cluster.getDfsCluster().getNameNode(0).getNameNodeAddress(), (Configuration)conf);
            DistributedFileSystem fs = cluster.getDfsCluster().getFileSystem(0);
            Path ecDir = new Path("/ecdir");
            fs.mkdirs(ecDir);
            fs.setErasureCodingPolicy(ecDir, ecPolicy.getName());
            DFSInotifyEventInputStream eis = client.getInotifyEventStream();
            int sz = ecPolicy.getNumDataUnits() * ecPolicy.getCellSize();
            byte[] contents = new byte[sz];
            DFSTestUtil.writeFile((FileSystem)fs, new Path("/ecdir/file_ec_test2"), contents);
            EventBatch batch = null;
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            long txid = batch.getTxid();
            long eventsBehind = eis.getTxidsBehindEstimate();
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
            Event.CreateEvent ce = (Event.CreateEvent)batch.getEvents()[0];
            Assert.assertTrue((ce.getiNodeType() == Event.CreateEvent.INodeType.FILE ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce.getPath().equals("/ecdir/file_ec_test2"));
            Assert.assertTrue((ce.getCtime() > 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)ce.getReplication());
            Assert.assertTrue((ce.getSymlinkTarget() == null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)ce.getOverwrite());
            Assert.assertEquals((long)ecPolicy.getCellSize(), (long)ce.getDefaultBlockSize());
            Assert.assertTrue((boolean)ce.isErasureCoded().isPresent());
            Assert.assertTrue((boolean)((Boolean)ce.isErasureCoded().get()));
            LOG.info((Object)ce.toString());
            Assert.assertTrue((boolean)ce.toString().startsWith("CreateEvent [INodeType="));
            batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            txid = TestDFSInotifyEventInputStream.checkTxid(batch, txid);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CLOSE ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Event.CloseEvent)batch.getEvents()[0]).getPath().equals("/ecdir/file_ec_test2"));
            Assert.assertTrue((eis.poll() == null ? 1 : 0) != 0);
            Assert.assertTrue((eis.getTxidsBehindEstimate() == eventsBehind ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testNNFailover() throws IOException, URISyntaxException, MissingEventsException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniQJMHACluster cluster = new MiniQJMHACluster.Builder((Configuration)conf).build();
        try {
            cluster.getDfsCluster().waitActive();
            cluster.getDfsCluster().transitionToActive(0);
            DFSClient client = HATestUtil.configureFailoverFs((MiniDFSCluster)cluster.getDfsCluster(), (Configuration)conf).dfs;
            DFSInotifyEventInputStream eis = client.getInotifyEventStream();
            for (int i = 0; i < 10; ++i) {
                client.mkdirs("/dir" + i, null, false);
            }
            cluster.getDfsCluster().shutdownNameNode(0);
            cluster.getDfsCluster().transitionToActive(1);
            EventBatch batch = null;
            for (int i = 0; i < 10; ++i) {
                batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
                Assert.assertEquals((long)1L, (long)batch.getEvents().length);
                Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
                Assert.assertTrue((boolean)((Event.CreateEvent)batch.getEvents()[0]).getPath().equals("/dir" + i));
            }
            Assert.assertTrue((eis.poll() == null ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testTwoActiveNNs() throws IOException, MissingEventsException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniQJMHACluster cluster = new MiniQJMHACluster.Builder((Configuration)conf).build();
        try {
            int i;
            cluster.getDfsCluster().waitActive();
            cluster.getDfsCluster().transitionToActive(0);
            DFSClient client0 = new DFSClient(cluster.getDfsCluster().getNameNode(0).getNameNodeAddress(), (Configuration)conf);
            DFSClient client1 = new DFSClient(cluster.getDfsCluster().getNameNode(1).getNameNodeAddress(), (Configuration)conf);
            DFSInotifyEventInputStream eis = client0.getInotifyEventStream();
            for (i = 0; i < 10; ++i) {
                client0.mkdirs("/dir" + i, null, false);
            }
            cluster.getDfsCluster().transitionToActive(1);
            for (i = 10; i < 20; ++i) {
                client1.mkdirs("/dir" + i, null, false);
            }
            EventBatch batch = null;
            for (int i2 = 0; i2 < 10; ++i2) {
                batch = TestDFSInotifyEventInputStream.waitForNextEvents(eis);
                Assert.assertEquals((long)1L, (long)batch.getEvents().length);
                Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
                Assert.assertTrue((boolean)((Event.CreateEvent)batch.getEvents()[0]).getPath().equals("/dir" + i2));
            }
            Assert.assertTrue((eis.poll() == null ? 1 : 0) != 0);
        }
        finally {
            try {
                cluster.shutdown();
            }
            catch (ExitUtil.ExitException exitException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testReadEventsWithTimeout() throws IOException, InterruptedException, MissingEventsException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniQJMHACluster cluster = new MiniQJMHACluster.Builder((Configuration)conf).build();
        try {
            cluster.getDfsCluster().waitActive();
            cluster.getDfsCluster().transitionToActive(0);
            final DFSClient client = new DFSClient(cluster.getDfsCluster().getNameNode(0).getNameNodeAddress(), (Configuration)conf);
            DFSInotifyEventInputStream eis = client.getInotifyEventStream();
            ScheduledExecutorService ex = Executors.newSingleThreadScheduledExecutor();
            ex.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        client.mkdirs("/dir", null, false);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Unable to create /dir", (Throwable)e);
                    }
                }
            }, 1L, TimeUnit.SECONDS);
            EventBatch batch = eis.poll(5L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)batch);
            Assert.assertEquals((long)1L, (long)batch.getEvents().length);
            Assert.assertTrue((batch.getEvents()[0].getEventType() == Event.EventType.CREATE ? 1 : 0) != 0);
            Assert.assertEquals((Object)"/dir", (Object)((Event.CreateEvent)batch.getEvents()[0]).getPath());
        }
        finally {
            cluster.shutdown();
        }
    }
}

