/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.tools.HadoopArchiveLogsRunner;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.applications.distributedshell.ApplicationMaster;
import org.apache.hadoop.yarn.applications.distributedshell.Client;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;

public class HadoopArchiveLogs
implements Tool {
    private static final Log LOG = LogFactory.getLog(HadoopArchiveLogs.class);
    private static final String HELP_OPTION = "help";
    private static final String MAX_ELIGIBLE_APPS_OPTION = "maxEligibleApps";
    private static final String MIN_NUM_LOG_FILES_OPTION = "minNumberLogFiles";
    private static final String MAX_TOTAL_LOGS_SIZE_OPTION = "maxTotalLogsSize";
    private static final String MEMORY_OPTION = "memory";
    private static final String VERBOSE_OPTION = "verbose";
    private static final String FORCE_OPTION = "force";
    private static final String NO_PROXY_OPTION = "noProxy";
    private static final int DEFAULT_MAX_ELIGIBLE = -1;
    private static final int DEFAULT_MIN_NUM_LOG_FILES = 20;
    private static final long DEFAULT_MAX_TOTAL_LOGS_SIZE = 1024L;
    private static final long DEFAULT_MEMORY = 1024L;
    @VisibleForTesting
    int maxEligible = -1;
    @VisibleForTesting
    int minNumLogFiles = 20;
    @VisibleForTesting
    long maxTotalLogsSize = 0x40000000L;
    @VisibleForTesting
    long memory = 1024L;
    private boolean verbose = false;
    @VisibleForTesting
    boolean force = false;
    @VisibleForTesting
    boolean proxy = true;
    @VisibleForTesting
    Set<AppInfo> eligibleApplications;
    private JobConf conf;

    public HadoopArchiveLogs(Configuration conf) {
        this.setConf(conf);
        this.eligibleApplications = new HashSet<AppInfo>();
    }

    public static void main(String[] args) {
        JobConf job = new JobConf(HadoopArchiveLogs.class);
        HadoopArchiveLogs hal = new HadoopArchiveLogs((Configuration)job);
        int ret = 0;
        try {
            ret = ToolRunner.run((Tool)hal, (String[])args);
        }
        catch (Exception e) {
            LOG.debug((Object)"Exception", (Throwable)e);
            System.err.println(e.getClass().getSimpleName());
            String s = e.getLocalizedMessage();
            if (s != null) {
                System.err.println(s);
            } else {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
        System.exit(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        int exitCode = 1;
        this.handleOpts(args);
        FileSystem fs = null;
        Path remoteRootLogDir = new Path(this.conf.get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        String suffix = LogAggregationUtils.getRemoteNodeLogDirSuffix((Configuration)this.conf);
        Path workingDir = new Path(remoteRootLogDir, "archive-logs-work");
        if (this.verbose) {
            LOG.info((Object)("Remote Log Dir Root: " + remoteRootLogDir));
            LOG.info((Object)("Log Suffix: " + suffix));
            LOG.info((Object)("Working Dir: " + workingDir));
        }
        try {
            fs = FileSystem.get((Configuration)this.conf);
            if (this.prepareWorkingDir(fs, workingDir)) {
                this.checkFilesAndSeedApps(fs, remoteRootLogDir, suffix);
                this.filterAppsByAggregatedStatus();
                this.checkMaxEligible();
                if (this.eligibleApplications.isEmpty()) {
                    LOG.info((Object)"No eligible applications to process");
                    exitCode = 0;
                } else {
                    StringBuilder sb = new StringBuilder("Will process the following applications:");
                    for (AppInfo app : this.eligibleApplications) {
                        sb.append("\n\t").append(app.getAppId());
                    }
                    LOG.info((Object)sb.toString());
                    File localScript = File.createTempFile("hadoop-archive-logs-", ".sh");
                    this.generateScript(localScript, workingDir, remoteRootLogDir, suffix);
                    exitCode = this.runDistributedShell(localScript) ? 0 : 1;
                }
            }
        }
        finally {
            if (fs != null) {
                fs.delete(workingDir, true);
                fs.close();
            }
        }
        return exitCode;
    }

    private void handleOpts(String[] args) throws ParseException {
        Options opts = new Options();
        Option helpOpt = new Option(HELP_OPTION, false, "Prints this message");
        Option maxEligibleOpt = new Option(MAX_ELIGIBLE_APPS_OPTION, true, "The maximum number of eligible apps to process (default: -1 (all))");
        maxEligibleOpt.setArgName("n");
        Option minNumLogFilesOpt = new Option(MIN_NUM_LOG_FILES_OPTION, true, "The minimum number of log files required to be eligible (default: 20)");
        minNumLogFilesOpt.setArgName("n");
        Option maxTotalLogsSizeOpt = new Option(MAX_TOTAL_LOGS_SIZE_OPTION, true, "The maximum total logs size (in megabytes) required to be eligible (default: 1024)");
        maxTotalLogsSizeOpt.setArgName("megabytes");
        Option memoryOpt = new Option(MEMORY_OPTION, true, "The amount of memory (in megabytes) for each container (default: 1024)");
        memoryOpt.setArgName("megabytes");
        Option verboseOpt = new Option(VERBOSE_OPTION, false, "Print more details.");
        Option forceOpt = new Option(FORCE_OPTION, false, "Force recreating the working directory if an existing one is found. This should only be used if you know that another instance is not currently running");
        Option noProxyOpt = new Option(NO_PROXY_OPTION, false, "When specified, all processing will be done as the user running this command (or the Yarn user if DefaultContainerExecutor is in use). When not specified, all processing will be done as the user who owns that application; if the user running this command is not allowed to impersonate that user, it will fail");
        opts.addOption(helpOpt);
        opts.addOption(maxEligibleOpt);
        opts.addOption(minNumLogFilesOpt);
        opts.addOption(maxTotalLogsSizeOpt);
        opts.addOption(memoryOpt);
        opts.addOption(verboseOpt);
        opts.addOption(forceOpt);
        opts.addOption(noProxyOpt);
        try {
            GnuParser parser = new GnuParser();
            CommandLine commandLine = parser.parse(opts, args);
            if (commandLine.hasOption(HELP_OPTION)) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("mapred archive-logs", opts);
                System.exit(0);
            }
            if (commandLine.hasOption(MAX_ELIGIBLE_APPS_OPTION)) {
                this.maxEligible = Integer.parseInt(commandLine.getOptionValue(MAX_ELIGIBLE_APPS_OPTION));
                if (this.maxEligible == 0) {
                    LOG.info((Object)"Setting maxEligibleApps to 0 accomplishes nothing. Please either set it to a negative value (default, all) or a more reasonable value.");
                    System.exit(0);
                }
            }
            if (commandLine.hasOption(MIN_NUM_LOG_FILES_OPTION)) {
                this.minNumLogFiles = Integer.parseInt(commandLine.getOptionValue(MIN_NUM_LOG_FILES_OPTION));
            }
            if (commandLine.hasOption(MAX_TOTAL_LOGS_SIZE_OPTION)) {
                this.maxTotalLogsSize = Long.parseLong(commandLine.getOptionValue(MAX_TOTAL_LOGS_SIZE_OPTION));
                this.maxTotalLogsSize *= 0x100000L;
            }
            if (commandLine.hasOption(MEMORY_OPTION)) {
                this.memory = Long.parseLong(commandLine.getOptionValue(MEMORY_OPTION));
            }
            if (commandLine.hasOption(VERBOSE_OPTION)) {
                this.verbose = true;
            }
            if (commandLine.hasOption(FORCE_OPTION)) {
                this.force = true;
            }
            if (commandLine.hasOption(NO_PROXY_OPTION)) {
                this.proxy = false;
            }
        }
        catch (ParseException pe) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("mapred archive-logs", opts);
            throw pe;
        }
    }

    @VisibleForTesting
    boolean prepareWorkingDir(FileSystem fs, Path workingDir) throws IOException {
        if (fs.exists(workingDir)) {
            if (this.force) {
                LOG.info((Object)"Existing Working Dir detected: -force specified -> recreating Working Dir");
                fs.delete(workingDir, true);
            } else {
                LOG.info((Object)"Existing Working Dir detected: -force not specified -> exiting");
                return false;
            }
        }
        fs.mkdirs(workingDir);
        fs.setPermission(workingDir, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL, true));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void filterAppsByAggregatedStatus() throws IOException, YarnException {
        YarnClient client = YarnClient.createYarnClient();
        try {
            client.init(this.getConf());
            client.start();
            Iterator<AppInfo> it = this.eligibleApplications.iterator();
            while (it.hasNext()) {
                AppInfo app = it.next();
                try {
                    ApplicationReport report = client.getApplicationReport(ApplicationId.fromString((String)app.getAppId()));
                    LogAggregationStatus aggStatus = report.getLogAggregationStatus();
                    if (aggStatus.equals((Object)LogAggregationStatus.RUNNING) || aggStatus.equals((Object)LogAggregationStatus.RUNNING_WITH_FAILURE) || aggStatus.equals((Object)LogAggregationStatus.NOT_START) || aggStatus.equals((Object)LogAggregationStatus.DISABLED) || aggStatus.equals((Object)LogAggregationStatus.FAILED)) {
                        if (this.verbose) {
                            LOG.info((Object)("Skipping " + app.getAppId() + " due to aggregation status being " + aggStatus));
                        }
                        it.remove();
                        continue;
                    }
                    if (this.verbose) {
                        LOG.info((Object)(app.getAppId() + " has aggregation status " + aggStatus));
                    }
                    app.setFinishTime(report.getFinishTime());
                }
                catch (ApplicationNotFoundException e) {
                    if (!this.verbose) continue;
                    LOG.info((Object)(app.getAppId() + " not in the ResourceManager"));
                }
            }
        }
        finally {
            if (client != null) {
                client.stop();
            }
        }
    }

    @VisibleForTesting
    void checkFilesAndSeedApps(FileSystem fs, Path remoteRootLogDir, String suffix) throws IOException {
        RemoteIterator userIt = fs.listStatusIterator(remoteRootLogDir);
        while (userIt.hasNext()) {
            Path userLogPath = ((FileStatus)userIt.next()).getPath();
            try {
                RemoteIterator appIt = fs.listStatusIterator(new Path(userLogPath, suffix));
                while (appIt.hasNext()) {
                    Path appLogPath = ((FileStatus)appIt.next()).getPath();
                    try {
                        FileStatus[] files = fs.listStatus(appLogPath);
                        if (files.length >= this.minNumLogFiles) {
                            boolean eligible = true;
                            long totalFileSize = 0L;
                            for (FileStatus file : files) {
                                if (file.getPath().getName().equals(appLogPath.getName() + ".har")) {
                                    eligible = false;
                                    if (!this.verbose) break;
                                    LOG.info((Object)("Skipping " + appLogPath.getName() + " due to existing .har file"));
                                    break;
                                }
                                if ((totalFileSize += file.getLen()) <= this.maxTotalLogsSize) continue;
                                eligible = false;
                                if (!this.verbose) break;
                                LOG.info((Object)("Skipping " + appLogPath.getName() + " due to total file size being too large (" + totalFileSize + " > " + this.maxTotalLogsSize + ")"));
                                break;
                            }
                            if (!eligible) continue;
                            if (this.verbose) {
                                LOG.info((Object)("Adding " + appLogPath.getName() + " for user " + userLogPath.getName()));
                            }
                            this.eligibleApplications.add(new AppInfo(appLogPath.getName(), userLogPath.getName()));
                            continue;
                        }
                        if (!this.verbose) continue;
                        LOG.info((Object)("Skipping " + appLogPath.getName() + " due to not having enough log files (" + files.length + " < " + this.minNumLogFiles + ")"));
                    }
                    catch (IOException ioe) {
                        if (!this.verbose) continue;
                        LOG.info((Object)("Skipping logs under " + appLogPath + " due to " + ioe.getMessage()));
                    }
                }
            }
            catch (IOException ioe) {
                if (!this.verbose) continue;
                LOG.info((Object)("Skipping all logs under " + userLogPath + " due to " + ioe.getMessage()));
            }
        }
    }

    @VisibleForTesting
    void checkMaxEligible() {
        if (this.maxEligible > 0 && this.eligibleApplications.size() > this.maxEligible) {
            if (this.verbose) {
                LOG.info((Object)("Too many applications (" + this.eligibleApplications.size() + " > " + this.maxEligible + ")"));
            }
            ArrayList<AppInfo> sortedApplications = new ArrayList<AppInfo>(this.eligibleApplications);
            Collections.sort(sortedApplications, new Comparator<AppInfo>(){

                @Override
                public int compare(AppInfo o1, AppInfo o2) {
                    int lCompare = Long.compare(o1.getFinishTime(), o2.getFinishTime());
                    if (lCompare == 0) {
                        return o1.getAppId().compareTo(o2.getAppId());
                    }
                    return lCompare;
                }
            });
            for (int i = this.maxEligible; i < sortedApplications.size(); ++i) {
                if (this.verbose) {
                    LOG.info((Object)("Removing " + sortedApplications.get(i)));
                }
                this.eligibleApplications.remove(sortedApplications.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void generateScript(File localScript, Path workingDir, Path remoteRootLogDir, String suffix) throws IOException {
        if (this.verbose) {
            LOG.info((Object)("Generating script at: " + localScript.getAbsolutePath()));
        }
        String halrJarPath = HadoopArchiveLogsRunner.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String harJarPath = HadoopArchives.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String classpath = halrJarPath + File.pathSeparator + harJarPath;
        try (FileWriterWithEncoding fw = null;){
            fw = new FileWriterWithEncoding(localScript, "UTF-8");
            fw.write("#!/bin/bash\nset -e\nset -x\n");
            int containerCount = 1;
            for (AppInfo app : this.eligibleApplications) {
                fw.write("if [ \"$YARN_SHELL_ID\" == \"");
                fw.write(Integer.toString(containerCount));
                fw.write("\" ]; then\n\tappId=\"");
                fw.write(app.getAppId());
                fw.write("\"\n\tuser=\"");
                fw.write(app.getUser());
                fw.write("\"\nel");
                ++containerCount;
            }
            fw.write("se\n\techo \"Unknown Mapping!\"\n\texit 1\nfi\n");
            fw.write("export HADOOP_CLIENT_OPTS=\"-Xmx");
            fw.write(Long.toString(this.memory));
            fw.write("m\"\n");
            fw.write("export HADOOP_CLASSPATH=");
            fw.write(classpath);
            fw.write("\n\"$HADOOP_HOME\"/bin/hadoop ");
            fw.write(HadoopArchiveLogsRunner.class.getName());
            fw.write(" -appId \"$appId\" -user \"$user\" -workingDir ");
            fw.write(workingDir.toString());
            fw.write(" -remoteRootLogDir ");
            fw.write(remoteRootLogDir.toString());
            fw.write(" -suffix ");
            fw.write(suffix);
            if (!this.proxy) {
                fw.write(" -noProxy\n");
            }
            fw.write("\n");
        }
    }

    private boolean runDistributedShell(File localScript) throws Exception {
        Object[] dsArgs = new String[]{"--appname", "ArchiveLogs", "--jar", ApplicationMaster.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "--num_containers", Integer.toString(this.eligibleApplications.size()), "--container_memory", Long.toString(this.memory), "--shell_script", localScript.getAbsolutePath()};
        if (this.verbose) {
            LOG.info((Object)("Running Distributed Shell with arguments: " + Arrays.toString(dsArgs)));
        }
        Client dsClient = new Client(new Configuration((Configuration)this.conf));
        dsClient.init((String[])dsArgs);
        return dsClient.run();
    }

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf, HadoopArchiveLogs.class);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @VisibleForTesting
    static class AppInfo {
        private String appId;
        private String user;
        private long finishTime;

        AppInfo(String appId, String user) {
            this.appId = appId;
            this.user = user;
            this.finishTime = 0L;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getUser() {
            return this.user;
        }

        public long getFinishTime() {
            return this.finishTime;
        }

        public void setFinishTime(long finishTime) {
            this.finishTime = finishTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppInfo appInfo = (AppInfo)o;
            if (this.appId != null ? !this.appId.equals(appInfo.appId) : appInfo.appId != null) {
                return false;
            }
            return !(this.user == null ? appInfo.user != null : !this.user.equals(appInfo.user));
        }

        public int hashCode() {
            int result = this.appId != null ? this.appId.hashCode() : 0;
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            return result;
        }
    }
}

