/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;

public class ResourceInformation
implements Comparable<ResourceInformation> {
    private String name;
    private String units;
    private ResourceTypes resourceType;
    private long value;
    private long minimumAllocation;
    private long maximumAllocation;
    public static final String MEMORY_URI = "memory-mb";
    public static final String VCORES_URI = "vcores";
    public static final String GPU_URI = "yarn.io/gpu";
    public static final ResourceInformation MEMORY_MB = ResourceInformation.newInstance("memory-mb", "Mi");
    public static final ResourceInformation VCORES = ResourceInformation.newInstance("vcores");
    public static final ResourceInformation GPUS = ResourceInformation.newInstance("yarn.io/gpu");
    public static final Map<String, ResourceInformation> MANDATORY_RESOURCES = ImmutableMap.of((Object)"memory-mb", (Object)MEMORY_MB, (Object)"vcores", (Object)VCORES, (Object)"yarn.io/gpu", (Object)GPUS);

    public String getName() {
        return this.name;
    }

    public void setName(String rName) {
        this.name = rName;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String rUnits) {
        if (!UnitsConversionUtil.KNOWN_UNITS.contains(rUnits)) {
            throw new IllegalArgumentException("Unknown unit '" + rUnits + "'. Known units are " + UnitsConversionUtil.KNOWN_UNITS);
        }
        this.units = rUnits;
    }

    @InterfaceAudience.Private
    public void setUnitsWithoutValidation(String rUnits) {
        this.units = rUnits;
    }

    public ResourceTypes getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypes type) {
        this.resourceType = type;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long rValue) {
        this.value = rValue;
    }

    public long getMinimumAllocation() {
        return this.minimumAllocation;
    }

    public void setMinimumAllocation(long minimumAllocation) {
        this.minimumAllocation = minimumAllocation;
    }

    public long getMaximumAllocation() {
        return this.maximumAllocation;
    }

    public void setMaximumAllocation(long maximumAllocation) {
        this.maximumAllocation = maximumAllocation;
    }

    public static ResourceInformation newInstance(ResourceInformation other) {
        ResourceInformation ret = new ResourceInformation();
        ResourceInformation.copy(other, ret);
        return ret;
    }

    public static ResourceInformation newInstance(String name, String units, long value, ResourceTypes type, long minimumAllocation, long maximumAllocation) {
        ResourceInformation ret = new ResourceInformation();
        ret.setName(name);
        ret.setResourceType(type);
        ret.setUnitsWithoutValidation(units);
        ret.setValue(value);
        ret.setMinimumAllocation(minimumAllocation);
        ret.setMaximumAllocation(maximumAllocation);
        return ret;
    }

    public static ResourceInformation newInstance(String name, String units, long value) {
        return ResourceInformation.newInstance(name, units, value, ResourceTypes.COUNTABLE, 0L, Long.MAX_VALUE);
    }

    public static ResourceInformation newInstance(String name, String units) {
        return ResourceInformation.newInstance(name, units, 0L, ResourceTypes.COUNTABLE, 0L, Long.MAX_VALUE);
    }

    public static ResourceInformation newInstance(String name, String units, ResourceTypes resourceType) {
        return ResourceInformation.newInstance(name, units, 0L, resourceType, 0L, Long.MAX_VALUE);
    }

    public static ResourceInformation newInstance(String name, long value) {
        return ResourceInformation.newInstance(name, "", value, ResourceTypes.COUNTABLE, 0L, Long.MAX_VALUE);
    }

    public static ResourceInformation newInstance(String name) {
        return ResourceInformation.newInstance(name, "");
    }

    public static ResourceInformation newInstance(String name, String units, long minRes, long maxRes) {
        return ResourceInformation.newInstance(name, units, 0L, ResourceTypes.COUNTABLE, minRes, maxRes);
    }

    public static void copy(ResourceInformation src, ResourceInformation dst) {
        dst.setName(src.getName());
        dst.setResourceType(src.getResourceType());
        dst.setUnits(src.getUnits());
        dst.setValue(src.getValue());
        dst.setMinimumAllocation(src.getMinimumAllocation());
        dst.setMaximumAllocation(src.getMaximumAllocation());
    }

    public String toString() {
        return "name: " + this.name + ", units: " + this.units + ", type: " + (Object)((Object)this.resourceType) + ", value: " + this.value + ", minimum allocation: " + this.minimumAllocation + ", maximum allocation: " + this.maximumAllocation;
    }

    public String getShorthandRepresentation() {
        return "" + this.value + this.units;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceInformation)) {
            return false;
        }
        ResourceInformation r = (ResourceInformation)obj;
        if (!this.name.equals(r.getName()) || !this.resourceType.equals((Object)r.getResourceType())) {
            return false;
        }
        if (this.units.equals(r.units)) {
            return this.value == r.value;
        }
        return UnitsConversionUtil.compare(this.units, this.value, r.units, r.value) == 0;
    }

    public int hashCode() {
        int prime = 263167;
        int result = 939769357 + this.name.hashCode();
        result = 263167 * result + this.resourceType.hashCode();
        result = 263167 * result + this.units.hashCode();
        result = 263167 * result + Long.hashCode(this.value);
        return result;
    }

    @Override
    public int compareTo(ResourceInformation other) {
        int diff = this.name.compareTo(other.name);
        if (diff == 0 && (diff = UnitsConversionUtil.compare(this.units, this.value, other.units, other.value)) == 0) {
            diff = this.resourceType.compareTo(other.resourceType);
        }
        return diff;
    }
}

