/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSUtils;

public class AliyunOSSInputStream
extends FSInputStream {
    public static final Log LOG = LogFactory.getLog(AliyunOSSInputStream.class);
    private final long downloadPartSize;
    private AliyunOSSFileSystemStore store;
    private final String key;
    private FileSystem.Statistics statistics;
    private boolean closed;
    private InputStream wrappedStream = null;
    private long contentLength;
    private long position;
    private long partRemaining;

    public AliyunOSSInputStream(Configuration conf, AliyunOSSFileSystemStore store, String key, Long contentLength, FileSystem.Statistics statistics) throws IOException {
        this.store = store;
        this.key = key;
        this.statistics = statistics;
        this.contentLength = contentLength;
        this.downloadPartSize = conf.getLong("fs.oss.multipart.download.size", 102400L);
        this.reopen(0L);
        this.closed = false;
    }

    private synchronized void reopen(long pos) throws IOException {
        if (pos < 0L) {
            throw new EOFException("Cannot seek at negative position:" + pos);
        }
        if (pos > this.contentLength) {
            throw new EOFException("Cannot seek after EOF, contentLength:" + this.contentLength + " position:" + pos);
        }
        long partSize = pos + this.downloadPartSize > this.contentLength ? this.contentLength - pos : this.downloadPartSize;
        if (this.wrappedStream != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Aborting old stream to open at pos " + pos));
            }
            this.wrappedStream.close();
        }
        this.wrappedStream = this.store.retrieve(this.key, pos, pos + partSize - 1L);
        if (this.wrappedStream == null) {
            throw new IOException("Null IO stream");
        }
        this.position = pos;
        this.partRemaining = partSize;
    }

    public synchronized int read() throws IOException {
        boolean retry;
        this.checkNotClosed();
        if (this.partRemaining <= 0L && this.position < this.contentLength) {
            this.reopen(this.position);
        }
        int tries = 10;
        int byteRead = -1;
        do {
            retry = false;
            try {
                byteRead = this.wrappedStream.read();
            }
            catch (Exception e) {
                this.handleReadException(e, --tries);
                retry = true;
            }
        } while (retry);
        if (byteRead >= 0) {
            ++this.position;
            --this.partRemaining;
        }
        if (this.statistics != null && byteRead >= 0) {
            this.statistics.incrementBytesRead((long)byteRead);
        }
        return byteRead;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        this.checkNotClosed();
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > buf.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int bytesRead = 0;
        while (this.position < this.contentLength && bytesRead < len) {
            boolean retry;
            if (this.partRemaining == 0L) {
                this.reopen(this.position);
            }
            int tries = 10;
            int bytes = -1;
            do {
                retry = false;
                try {
                    bytes = this.wrappedStream.read(buf, off + bytesRead, len - bytesRead);
                }
                catch (Exception e) {
                    this.handleReadException(e, --tries);
                    retry = true;
                }
            } while (retry);
            if (bytes > 0) {
                bytesRead += bytes;
                this.position += (long)bytes;
                this.partRemaining -= (long)bytes;
                continue;
            }
            if (this.partRemaining == 0L) continue;
            throw new IOException("Failed to read from stream. Remaining:" + this.partRemaining);
        }
        if (this.statistics != null && bytesRead > 0) {
            this.statistics.incrementBytesRead((long)bytesRead);
        }
        if (bytesRead == 0 && len > 0) {
            return -1;
        }
        return bytesRead;
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.wrappedStream != null) {
            this.wrappedStream.close();
        }
    }

    public synchronized int available() throws IOException {
        this.checkNotClosed();
        long remaining = this.contentLength - this.position;
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    public synchronized void seek(long pos) throws IOException {
        this.checkNotClosed();
        if (this.position == pos) {
            return;
        }
        if (pos > this.position && pos < this.position + this.partRemaining) {
            long len = pos - this.position;
            AliyunOSSUtils.skipFully(this.wrappedStream, len);
            this.position = pos;
            this.partRemaining -= len;
        } else {
            this.reopen(pos);
        }
    }

    public synchronized long getPos() throws IOException {
        this.checkNotClosed();
        return this.position;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        this.checkNotClosed();
        return false;
    }

    private void handleReadException(Exception e, int tries) throws IOException {
        if (tries == 0) {
            throw new IOException(e);
        }
        LOG.warn((Object)("Some exceptions occurred in oss connection, try to reopen oss connection at position '" + this.position + "', " + e.getMessage()));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e2) {
            LOG.warn((Object)e2.getMessage());
        }
        this.reopen(this.position);
    }
}

