/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.applications.distributedshell.ApplicationMaster;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineEntityGroupPlugin;

public class DistributedShellTimelinePlugin
extends TimelineEntityGroupPlugin {
    public Set<TimelineEntityGroupId> getTimelineEntityGroupId(String entityType, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilters) {
        if (ApplicationMaster.DSEntity.DS_CONTAINER.toString().equals(entityType)) {
            if (primaryFilter == null) {
                return null;
            }
            return this.toEntityGroupId(primaryFilter.getValue().toString());
        }
        return null;
    }

    public Set<TimelineEntityGroupId> getTimelineEntityGroupId(String entityId, String entityType) {
        if (ApplicationMaster.DSEntity.DS_CONTAINER.toString().equals(entityId)) {
            ContainerId containerId = ContainerId.fromString((String)entityId);
            ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
            return this.toEntityGroupId(appId.toString());
        }
        return null;
    }

    public Set<TimelineEntityGroupId> getTimelineEntityGroupId(String entityType, SortedSet<String> entityIds, Set<String> eventTypes) {
        return null;
    }

    private Set<TimelineEntityGroupId> toEntityGroupId(String strAppId) {
        ApplicationId appId = ApplicationId.fromString((String)strAppId);
        TimelineEntityGroupId groupId = TimelineEntityGroupId.newInstance((ApplicationId)appId, (String)"CONTAINERS");
        HashSet<TimelineEntityGroupId> result = new HashSet<TimelineEntityGroupId>();
        result.add(groupId);
        return result;
    }
}

